/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.table.marker.MarkerOperation;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.dto.BaseFileDTO;
import org.apache.hudi.common.table.timeline.dto.ClusteringOpDTO;
import org.apache.hudi.common.table.timeline.dto.CompactionOpDTO;
import org.apache.hudi.common.table.timeline.dto.FileGroupDTO;
import org.apache.hudi.common.table.timeline.dto.FileSliceDTO;
import org.apache.hudi.common.table.timeline.dto.InstantDTO;
import org.apache.hudi.common.table.timeline.dto.TimelineDTO;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.RemoteHoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.handlers.BaseFileHandler;
import org.apache.hudi.timeline.service.handlers.FileSliceHandler;
import org.apache.hudi.timeline.service.handlers.MarkerHandler;
import org.apache.hudi.timeline.service.handlers.TimelineHandler;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RequestHandler {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOG = LogManager.getLogger(RequestHandler.class);
    private final TimelineService.Config timelineServiceConfig;
    private final FileSystemViewManager viewManager;
    private final Javalin app;
    private final TimelineHandler instantHandler;
    private final FileSliceHandler sliceHandler;
    private final BaseFileHandler dataFileHandler;
    private final MarkerHandler markerHandler;
    private final Registry metricsRegistry = Registry.getRegistry("TimelineService");
    private ScheduledExecutorService asyncResultService = Executors.newSingleThreadScheduledExecutor();

    public RequestHandler(Javalin app, Configuration conf, TimelineService.Config timelineServiceConfig, HoodieEngineContext hoodieEngineContext, FileSystem fileSystem2, FileSystemViewManager viewManager) throws IOException {
        this.timelineServiceConfig = timelineServiceConfig;
        this.viewManager = viewManager;
        this.app = app;
        this.instantHandler = new TimelineHandler(conf, timelineServiceConfig, fileSystem2, viewManager);
        this.sliceHandler = new FileSliceHandler(conf, timelineServiceConfig, fileSystem2, viewManager);
        this.dataFileHandler = new BaseFileHandler(conf, timelineServiceConfig, fileSystem2, viewManager);
        this.markerHandler = timelineServiceConfig.enableMarkerRequests ? new MarkerHandler(conf, timelineServiceConfig, hoodieEngineContext, fileSystem2, viewManager, this.metricsRegistry) : null;
        if (timelineServiceConfig.async) {
            this.asyncResultService = Executors.newSingleThreadScheduledExecutor();
        }
    }

    public static String jsonifyResult(Context ctx, Object obj, Registry metricsRegistry, ObjectMapper objectMapper, Logger logger) throws JsonProcessingException {
        HoodieTimer timer = HoodieTimer.start();
        boolean prettyPrint = ctx.queryParam("pretty") != null;
        String result = prettyPrint ? objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj) : objectMapper.writeValueAsString(obj);
        long jsonifyTime = timer.endTimer();
        metricsRegistry.add("WRITE_VALUE_CNT", 1L);
        metricsRegistry.add("WRITE_VALUE_TIME", jsonifyTime);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Jsonify TimeTaken=" + jsonifyTime));
        }
        return result;
    }

    private static boolean isRefreshCheckDisabledInQuery(Context ctxt) {
        return Boolean.parseBoolean(ctxt.queryParam("refreshoff"));
    }

    public void register() {
        this.registerDataFilesAPI();
        this.registerFileSlicesAPI();
        this.registerTimelineAPI();
        if (this.markerHandler != null) {
            this.registerMarkerAPI();
        }
    }

    public void stop() {
        if (this.markerHandler != null) {
            this.markerHandler.stop();
        }
    }

    private boolean isLocalViewBehind(Context ctx) {
        String basePath = ctx.queryParam("basepath");
        String lastKnownInstantFromClient = ctx.queryParamAsClass("lastinstantts", String.class).getOrDefault("0");
        String timelineHashFromClient = ctx.queryParamAsClass("timelinehash", String.class).getOrDefault("");
        HoodieTimeline localTimeline = this.viewManager.getFileSystemView(basePath).getTimeline().filterCompletedOrMajorOrMinorCompactionInstants();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Client [ LastTs=" + lastKnownInstantFromClient + ", TimelineHash=" + timelineHashFromClient + "], localTimeline=" + localTimeline.getInstants()));
        }
        if (!localTimeline.getInstantsAsStream().findAny().isPresent() && "0".equals(lastKnownInstantFromClient)) {
            return false;
        }
        String localTimelineHash = localTimeline.getTimelineHash();
        if (!localTimelineHash.equals(timelineHashFromClient)) {
            return true;
        }
        return !localTimeline.containsOrBeforeTimelineStarts(lastKnownInstantFromClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncIfLocalViewBehind(Context ctx) {
        if (this.isLocalViewBehind(ctx)) {
            SyncableFileSystemView view;
            String basePath = ctx.queryParam("basepath");
            String lastKnownInstantFromClient = ctx.queryParamAsClass("lastinstantts", String.class).getOrDefault("0");
            SyncableFileSystemView syncableFileSystemView = view = this.viewManager.getFileSystemView(basePath);
            synchronized (syncableFileSystemView) {
                if (this.isLocalViewBehind(ctx)) {
                    HoodieTimeline localTimeline = this.viewManager.getFileSystemView(basePath).getTimeline();
                    LOG.info((Object)("Syncing view as client passed last known instant " + lastKnownInstantFromClient + " as last known instant but server has the following last instant on timeline :" + localTimeline.lastInstant()));
                    view.sync();
                    return true;
                }
            }
        }
        return false;
    }

    private void writeValueAsString(Context ctx, Object obj) throws JsonProcessingException {
        if (this.timelineServiceConfig.async) {
            this.writeValueAsStringAsync(ctx, obj);
        } else {
            this.writeValueAsStringSync(ctx, obj);
        }
    }

    private void writeValueAsStringSync(Context ctx, Object obj) throws JsonProcessingException {
        String result = RequestHandler.jsonifyResult(ctx, obj, this.metricsRegistry, OBJECT_MAPPER, LOG);
        ctx.result(result);
    }

    private void writeValueAsStringAsync(Context ctx, Object obj) {
        ctx.future(CompletableFuture.supplyAsync(() -> {
            try {
                return RequestHandler.jsonifyResult(ctx, obj, this.metricsRegistry, OBJECT_MAPPER, LOG);
            }
            catch (JsonProcessingException e) {
                throw new HoodieException("Failed to JSON encode the value", e);
            }
        }, this.asyncResultService));
    }

    private void registerTimelineAPI() {
        this.app.get(RemoteHoodieTableFileSystemView.LAST_INSTANT, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LAST_INSTANT", 1L);
            List<InstantDTO> dtos = this.instantHandler.getLastInstant(ctx.queryParamAsClass("basepath", String.class).get());
            this.writeValueAsString(ctx, dtos);
        }, false));
        this.app.get(RemoteHoodieTableFileSystemView.TIMELINE, new ViewHandler(ctx -> {
            this.metricsRegistry.add("TIMELINE", 1L);
            TimelineDTO dto = this.instantHandler.getTimeline(ctx.queryParamAsClass("basepath", String.class).get());
            this.writeValueAsString(ctx, dto);
        }, false));
    }

    private void registerDataFilesAPI() {
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_DATA_FILES_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_DATA_FILES", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFiles(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_DATA_FILE_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_DATA_FILE", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFile(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""), ctx.queryParamAsClass("fileid", String.class).getOrThrow(e -> new HoodieException("FILEID is invalid")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_ALL_DATA_FILES, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_ALL_DATA_FILES", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFiles(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_DATA_FILES_BEFORE_ON_INSTANT_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_DATA_FILES_BEFORE_ON_INSTANT", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFilesBeforeOrOn(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""), ctx.queryParamAsClass("maxinstant", String.class).getOrThrow(e -> new HoodieException("MAX_INSTANT_PARAM is invalid")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_LATEST_BASE_FILES_BEFORE_ON_INSTANT_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_LATEST_BASE_FILES_BEFORE_ON_INSTANT", 1L);
            Map<String, List<BaseFileDTO>> dtos = this.dataFileHandler.getAllLatestDataFilesBeforeOrOn(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("maxinstant", String.class).getOrThrow(e -> new HoodieException("MAX_INSTANT_PARAM is invalid")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_DATA_FILE_ON_INSTANT_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_DATA_FILE_ON_INSTANT", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFileOn(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""), ctx.queryParamAsClass("instant", String.class).get(), ctx.queryParamAsClass("fileid", String.class).getOrThrow(e -> new HoodieException("FILEID is invalid")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_DATA_FILES, new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_DATA_FILES", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getAllDataFiles(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_DATA_FILES_RANGE_INSTANT_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_DATA_FILES_RANGE_INSTANT", 1L);
            List<BaseFileDTO> dtos = this.dataFileHandler.getLatestDataFilesInRange(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), Arrays.asList(ctx.queryParamAsClass("instants", String.class).getOrThrow(e -> new HoodieException("INSTANTS_PARAM is invalid")).split(",")));
            this.writeValueAsString(ctx, dtos);
        }, true));
    }

    private void registerFileSlicesAPI() {
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_SLICES_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_SLICES", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlices(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_SLICE_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_SLICE", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlice(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""), ctx.queryParamAsClass("fileid", String.class).getOrThrow(e -> new HoodieException("FILEID is invalid")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_PARTITION_UNCOMPACTED_SLICES_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_PARTITION_UNCOMPACTED_SLICES", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestUnCompactedFileSlices(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_SLICES_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_SLICES", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getAllFileSlices(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_SLICES_RANGE_INSTANT_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_SLICE_RANGE_INSTANT", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSliceInRange(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), Arrays.asList(ctx.queryParamAsClass("instants", String.class).getOrThrow(e -> new HoodieException("INSTANTS_PARAM is invalid")).split(",")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_SLICES_MERGED_BEFORE_ON_INSTANT_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_SLICES_MERGED_BEFORE_ON_INSTANT", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestMergedFileSlicesBeforeOrOn(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""), ctx.queryParamAsClass("maxinstant", String.class).getOrThrow(e -> new HoodieException("MAX_INSTANT_PARAM is invalid")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.LATEST_SLICES_BEFORE_ON_INSTANT_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("LATEST_SLICES_BEFORE_ON_INSTANT", 1L);
            List<FileSliceDTO> dtos = this.sliceHandler.getLatestFileSlicesBeforeOrOn(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""), ctx.queryParamAsClass("maxinstant", String.class).getOrThrow(e -> new HoodieException("MAX_INSTANT_PARAM is invalid")), Boolean.parseBoolean(ctx.queryParamAsClass("includependingcompaction", String.class).getOrThrow(e -> new HoodieException("INCLUDE_FILES_IN_PENDING_COMPACTION_PARAM is invalid"))));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.PENDING_COMPACTION_OPS, new ViewHandler(ctx -> {
            this.metricsRegistry.add("PEDING_COMPACTION_OPS", 1L);
            List<CompactionOpDTO> dtos = this.sliceHandler.getPendingCompactionOperations(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.PENDING_LOG_COMPACTION_OPS, new ViewHandler(ctx -> {
            this.metricsRegistry.add("PEDING_LOG_COMPACTION_OPS", 1L);
            List<CompactionOpDTO> dtos = this.sliceHandler.getPendingLogCompactionOperations(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_FILEGROUPS_FOR_PARTITION_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_FILEGROUPS_FOR_PARTITION", 1L);
            List<FileGroupDTO> dtos = this.sliceHandler.getAllFileGroups(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.post(RemoteHoodieTableFileSystemView.REFRESH_TABLE, new ViewHandler(ctx -> {
            this.metricsRegistry.add("REFRESH_TABLE", 1L);
            boolean success = this.sliceHandler.refreshTable(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")));
            this.writeValueAsString(ctx, success);
        }, false));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_REPLACED_FILEGROUPS_BEFORE_OR_ON, new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_REPLACED_FILEGROUPS_BEFORE_OR_ON", 1L);
            List<FileGroupDTO> dtos = this.sliceHandler.getReplacedFileGroupsBeforeOrOn(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("maxinstant", String.class).getOrDefault(""), ctx.queryParamAsClass("partition", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_REPLACED_FILEGROUPS_BEFORE, new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_REPLACED_FILEGROUPS_BEFORE", 1L);
            List<FileGroupDTO> dtos = this.sliceHandler.getReplacedFileGroupsBefore(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("maxinstant", String.class).getOrDefault(""), ctx.queryParamAsClass("partition", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.ALL_REPLACED_FILEGROUPS_PARTITION, new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_REPLACED_FILEGROUPS_PARTITION", 1L);
            List<FileGroupDTO> dtos = this.sliceHandler.getAllReplacedFileGroups(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")), ctx.queryParamAsClass("partition", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, dtos);
        }, true));
        this.app.get(RemoteHoodieTableFileSystemView.PENDING_CLUSTERING_FILEGROUPS, new ViewHandler(ctx -> {
            this.metricsRegistry.add("PENDING_CLUSTERING_FILEGROUPS", 1L);
            List<ClusteringOpDTO> dtos = this.sliceHandler.getFileGroupsInPendingClustering(ctx.queryParamAsClass("basepath", String.class).getOrThrow(e -> new HoodieException("Basepath is invalid")));
            this.writeValueAsString(ctx, dtos);
        }, true));
    }

    private void registerMarkerAPI() {
        this.app.get(MarkerOperation.ALL_MARKERS_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("ALL_MARKERS", 1L);
            Set<String> markers = this.markerHandler.getAllMarkers(ctx.queryParamAsClass("markerdirpath", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, markers);
        }, false));
        this.app.get(MarkerOperation.CREATE_AND_MERGE_MARKERS_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("CREATE_AND_MERGE_MARKERS", 1L);
            Set<String> markers = this.markerHandler.getCreateAndMergeMarkers(ctx.queryParamAsClass("markerdirpath", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, markers);
        }, false));
        this.app.get(MarkerOperation.MARKERS_DIR_EXISTS_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("MARKERS_DIR_EXISTS", 1L);
            boolean exist = this.markerHandler.doesMarkerDirExist(ctx.queryParamAsClass("markerdirpath", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, exist);
        }, false));
        this.app.post(MarkerOperation.CREATE_MARKER_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("CREATE_MARKER", 1L);
            ctx.future(this.markerHandler.createMarker(ctx, ctx.queryParamAsClass("markerdirpath", String.class).getOrDefault(""), ctx.queryParamAsClass("markername", String.class).getOrDefault(""), ctx.queryParamAsClass("basepath", String.class).getOrDefault("")));
        }, false));
        this.app.post(MarkerOperation.DELETE_MARKER_DIR_URL, new ViewHandler(ctx -> {
            this.metricsRegistry.add("DELETE_MARKER_DIR", 1L);
            boolean success = this.markerHandler.deleteMarkers(ctx.queryParamAsClass("markerdirpath", String.class).getOrDefault(""));
            this.writeValueAsString(ctx, success);
        }, false));
    }

    private boolean shouldThrowExceptionIfLocalViewBehind(HoodieTimeline localTimeline, String timelineHashFromClient) {
        Option<HoodieInstant> lastInstant = localTimeline.lastInstant();
        return !lastInstant.isPresent() || !lastInstant.get().getAction().equals("clean") || !localTimeline.findInstantsBefore(lastInstant.get().getTimestamp()).getTimelineHash().equals(timelineHashFromClient);
    }

    private class ViewHandler
    implements Handler {
        private final Handler handler;
        private final boolean performRefreshCheck;

        ViewHandler(Handler handler, boolean performRefreshCheck) {
            this.handler = handler;
            this.performRefreshCheck = performRefreshCheck;
        }

        @Override
        public void handle(@NotNull Context context) throws Exception {
            boolean success = true;
            long beginTs = System.currentTimeMillis();
            boolean synced = false;
            boolean refreshCheck = this.performRefreshCheck && !RequestHandler.isRefreshCheckDisabledInQuery(context);
            long refreshCheckTimeTaken = 0L;
            long handleTimeTaken = 0L;
            long finalCheckTimeTaken = 0L;
            try {
                if (refreshCheck) {
                    long beginRefreshCheck = System.currentTimeMillis();
                    synced = RequestHandler.this.syncIfLocalViewBehind(context);
                    long endRefreshCheck = System.currentTimeMillis();
                    refreshCheckTimeTaken = endRefreshCheck - beginRefreshCheck;
                }
                long handleBeginMs = System.currentTimeMillis();
                this.handler.handle(context);
                long handleEndMs = System.currentTimeMillis();
                handleTimeTaken = handleEndMs - handleBeginMs;
                if (refreshCheck) {
                    long beginFinalCheck = System.currentTimeMillis();
                    if (RequestHandler.this.isLocalViewBehind(context)) {
                        String lastKnownInstantFromClient = context.queryParamAsClass("lastinstantts", String.class).getOrDefault("0");
                        String timelineHashFromClient = context.queryParamAsClass("timelinehash", String.class).getOrDefault("");
                        HoodieTimeline localTimeline = RequestHandler.this.viewManager.getFileSystemView(context.queryParam("basepath")).getTimeline();
                        if (RequestHandler.this.shouldThrowExceptionIfLocalViewBehind(localTimeline, timelineHashFromClient)) {
                            String errMsg = "Last known instant from client was " + lastKnownInstantFromClient + " but server has the following timeline " + localTimeline.getInstants();
                            throw new BadRequestResponse(errMsg);
                        }
                    }
                    long endFinalCheck = System.currentTimeMillis();
                    finalCheckTimeTaken = endFinalCheck - beginFinalCheck;
                }
            }
            catch (RuntimeException re) {
                try {
                    success = false;
                    if (re instanceof BadRequestResponse) {
                        LOG.warn((Object)("Bad request response due to client view behind server view. " + re.getMessage()));
                    } else {
                        LOG.error((Object)("Got runtime exception servicing request " + context.queryString()), (Throwable)re);
                    }
                    throw re;
                }
                catch (Throwable throwable) {
                    long endTs = System.currentTimeMillis();
                    long timeTakenMillis = endTs - beginTs;
                    RequestHandler.this.metricsRegistry.add("TOTAL_API_TIME", timeTakenMillis);
                    RequestHandler.this.metricsRegistry.add("TOTAL_REFRESH_TIME", refreshCheckTimeTaken);
                    RequestHandler.this.metricsRegistry.add("TOTAL_HANDLE_TIME", handleTimeTaken);
                    RequestHandler.this.metricsRegistry.add("TOTAL_CHECK_TIME", finalCheckTimeTaken);
                    RequestHandler.this.metricsRegistry.add("TOTAL_API_CALLS", 1L);
                    LOG.debug((Object)String.format("TimeTakenMillis[Total=%d, Refresh=%d, handle=%d, Check=%d], Success=%s, Query=%s, Host=%s, synced=%s", timeTakenMillis, refreshCheckTimeTaken, handleTimeTaken, finalCheckTimeTaken, success, context.queryString(), context.host(), synced));
                    throw throwable;
                }
            }
            long endTs = System.currentTimeMillis();
            long timeTakenMillis = endTs - beginTs;
            RequestHandler.this.metricsRegistry.add("TOTAL_API_TIME", timeTakenMillis);
            RequestHandler.this.metricsRegistry.add("TOTAL_REFRESH_TIME", refreshCheckTimeTaken);
            RequestHandler.this.metricsRegistry.add("TOTAL_HANDLE_TIME", handleTimeTaken);
            RequestHandler.this.metricsRegistry.add("TOTAL_CHECK_TIME", finalCheckTimeTaken);
            RequestHandler.this.metricsRegistry.add("TOTAL_API_CALLS", 1L);
            LOG.debug((Object)String.format("TimeTakenMillis[Total=%d, Refresh=%d, handle=%d, Check=%d], Success=%s, Query=%s, Host=%s, synced=%s", timeTakenMillis, refreshCheckTimeTaken, handleTimeTaken, finalCheckTimeTaken, success, context.queryString(), context.host(), synced));
        }
    }
}

