/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.helpers.ProtoConversionUtil;
import org.apache.spark.api.java.JavaSparkContext;

public class ProtoClassBasedSchemaProvider
extends SchemaProvider {
    private final String schemaString;
    private transient Schema schema;

    public ProtoClassBasedSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        DataSourceUtils.checkRequiredProperties(props, Collections.singletonList(Config.PROTO_SCHEMA_CLASS_NAME.key()));
        String className = this.config.getString(Config.PROTO_SCHEMA_CLASS_NAME.key());
        boolean wrappedPrimitivesAsRecords = props.getBoolean(Config.PROTO_SCHEMA_WRAPPED_PRIMITIVES_AS_RECORDS.key(), Config.PROTO_SCHEMA_WRAPPED_PRIMITIVES_AS_RECORDS.defaultValue());
        int maxRecursionDepth = props.getInteger(Config.PROTO_SCHEMA_MAX_RECURSION_DEPTH.key(), Config.PROTO_SCHEMA_MAX_RECURSION_DEPTH.defaultValue());
        boolean timestampsAsRecords = props.getBoolean(Config.PROTO_SCHEMA_TIMESTAMPS_AS_RECORDS.key(), false);
        ProtoConversionUtil.SchemaConfig schemaConfig = new ProtoConversionUtil.SchemaConfig(wrappedPrimitivesAsRecords, maxRecursionDepth, timestampsAsRecords);
        try {
            this.schemaString = ProtoConversionUtil.getAvroSchemaForMessageClass(ReflectionUtils.getClass(className), schemaConfig).toString();
        }
        catch (Exception e) {
            throw new HoodieSchemaException(String.format("Error reading proto source schema for class: %s", className), e);
        }
    }

    @Override
    public Schema getSourceSchema() {
        if (this.schema == null) {
            Schema.Parser parser = new Schema.Parser();
            this.schema = parser.parse(this.schemaString);
        }
        return this.schema;
    }

    @Override
    public Schema getTargetSchema() {
        return this.getSourceSchema();
    }

    public static class Config {
        private static final String PROTO_SCHEMA_PROVIDER_PREFIX = "hoodie.deltastreamer.schemaprovider.proto";
        public static final ConfigProperty<String> PROTO_SCHEMA_CLASS_NAME = ConfigProperty.key("hoodie.deltastreamer.schemaprovider.proto.class.name").noDefaultValue().sinceVersion("0.13.0").withDocumentation("The Protobuf Message class used as the source for the schema.");
        public static final ConfigProperty<Boolean> PROTO_SCHEMA_WRAPPED_PRIMITIVES_AS_RECORDS = ConfigProperty.key("hoodie.deltastreamer.schemaprovider.proto.flatten.wrappers").defaultValue(false).sinceVersion("0.13.0").withDocumentation("When set to true wrapped primitives like Int64Value are translated to a record with a single 'value' field. By default, the value is false and the wrapped primitives are treated as a nullable value");
        public static final ConfigProperty<Boolean> PROTO_SCHEMA_TIMESTAMPS_AS_RECORDS = ConfigProperty.key("hoodie.deltastreamer.schemaprovider.proto.timestamps.as.records").defaultValue(false).sinceVersion("0.13.0").withDocumentation("When set to true Timestamp fields are translated to a record with a seconds and nanos field. By default, the value is false and the timestamp is converted to a long with the timestamp-micros logical type");
        public static final ConfigProperty<Integer> PROTO_SCHEMA_MAX_RECURSION_DEPTH = ConfigProperty.key("hoodie.deltastreamer.schemaprovider.proto.max.recursion.depth").defaultValue(5).sinceVersion("0.13.0").withDocumentation("The max depth to unravel the Proto schema when translating into an Avro schema. Setting this depth allows the user to convert a schema that is recursive in proto into something that can be represented in their lake format like Parquet. After a given class has been seen N times within a single branch, the schema provider will create a record with a byte array to hold the remaining proto data and a string to hold the message descriptor's name for context.");
    }
}

