/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.Collections;
import org.apache.hudi.DataSourceReadOptions;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hive.SlashEncodedDayPartitionValueExtractor;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.RowSource;
import org.apache.hudi.utilities.sources.helpers.IncrSourceHelper;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class HoodieIncrSource
extends RowSource {
    private static final Logger LOG = LogManager.getLogger(HoodieIncrSource.class);

    public HoodieIncrSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
    }

    @Override
    public Pair<Option<Dataset<Row>>, String> fetchNextBatch(Option<String> lastCkptStr, long sourceLimit) {
        IncrSourceHelper.MissingCheckpointStrategy missingCheckpointStrategy;
        DataSourceUtils.checkRequiredProperties(this.props, Collections.singletonList("hoodie.deltastreamer.source.hoodieincr.path"));
        String srcPath = this.props.getString("hoodie.deltastreamer.source.hoodieincr.path");
        int numInstantsPerFetch = this.props.getInteger("hoodie.deltastreamer.source.hoodieincr.num_instants", Config.DEFAULT_NUM_INSTANTS_PER_FETCH);
        boolean readLatestOnMissingCkpt = this.props.getBoolean("hoodie.deltastreamer.source.hoodieincr.read_latest_on_missing_ckpt", Config.DEFAULT_READ_LATEST_INSTANT_ON_MISSING_CKPT);
        IncrSourceHelper.MissingCheckpointStrategy missingCheckpointStrategy2 = missingCheckpointStrategy = this.props.containsKey("hoodie.deltastreamer.source.hoodieincr.missing.checkpoint.strategy") ? IncrSourceHelper.MissingCheckpointStrategy.valueOf(this.props.getString("hoodie.deltastreamer.source.hoodieincr.missing.checkpoint.strategy")) : null;
        if (readLatestOnMissingCkpt) {
            missingCheckpointStrategy = IncrSourceHelper.MissingCheckpointStrategy.READ_LATEST;
        }
        Option<String> beginInstant = lastCkptStr.isPresent() ? (lastCkptStr.get().isEmpty() ? Option.empty() : lastCkptStr) : Option.empty();
        Pair<String, Pair<String, String>> queryTypeAndInstantEndpts = IncrSourceHelper.calculateBeginAndEndInstants(this.sparkContext, srcPath, numInstantsPerFetch, beginInstant, missingCheckpointStrategy);
        if (queryTypeAndInstantEndpts.getValue().getKey().equals(queryTypeAndInstantEndpts.getValue().getValue())) {
            LOG.warn((Object)("Already caught up. Begin Checkpoint was :" + queryTypeAndInstantEndpts.getValue().getKey()));
            return Pair.of(Option.empty(), queryTypeAndInstantEndpts.getValue().getKey());
        }
        Dataset source = null;
        source = queryTypeAndInstantEndpts.getKey().equals(DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL()) ? this.sparkSession.read().format("org.apache.hudi").option(DataSourceReadOptions.QUERY_TYPE().key(), DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions.BEGIN_INSTANTTIME().key(), queryTypeAndInstantEndpts.getValue().getLeft()).option(DataSourceReadOptions.END_INSTANTTIME().key(), queryTypeAndInstantEndpts.getValue().getRight()).option(DataSourceReadOptions.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN_FOR_NON_EXISTING_FILES().key(), this.props.getString(DataSourceReadOptions.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN_FOR_NON_EXISTING_FILES().key(), DataSourceReadOptions.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN_FOR_NON_EXISTING_FILES().defaultValue())).load(srcPath) : this.sparkSession.read().format("org.apache.hudi").option(DataSourceReadOptions.QUERY_TYPE().key(), DataSourceReadOptions.QUERY_TYPE_SNAPSHOT_OPT_VAL()).load(srcPath).filter(String.format("%s > '%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, queryTypeAndInstantEndpts.getRight().getLeft())).filter(String.format("%s <= '%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, queryTypeAndInstantEndpts.getRight().getRight()));
        HoodieRecord.HoodieRecordType recordType = UtilHelpers.createRecordMerger(this.props).getRecordType();
        boolean shouldDropMetaFields = this.props.getBoolean("hoodie.deltastreamer.source.hoodieincr.drop.all.meta.fields.from.source", Config.DEFAULT_HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE) || recordType == HoodieRecord.HoodieRecordType.SPARK;
        String[] colsToDrop = shouldDropMetaFields ? (String[])HoodieRecord.HOODIE_META_COLUMNS.stream().toArray(String[]::new) : (String[])HoodieRecord.HOODIE_META_COLUMNS.stream().filter(x -> !x.equals(HoodieRecord.PARTITION_PATH_METADATA_FIELD)).toArray(String[]::new);
        Dataset src = source.drop(colsToDrop);
        return Pair.of(Option.of(src), queryTypeAndInstantEndpts.getRight().getRight());
    }

    public static class Config {
        static final String HOODIE_SRC_BASE_PATH = "hoodie.deltastreamer.source.hoodieincr.path";
        static final String NUM_INSTANTS_PER_FETCH = "hoodie.deltastreamer.source.hoodieincr.num_instants";
        static final Integer DEFAULT_NUM_INSTANTS_PER_FETCH = 5;
        static final String HOODIE_SRC_PARTITION_FIELDS = "hoodie.deltastreamer.source.hoodieincr.partition.fields";
        static final String HOODIE_SRC_PARTITION_EXTRACTORCLASS = "hoodie.deltastreamer.source.hoodieincr.partition.extractor.class";
        static final String DEFAULT_HOODIE_SRC_PARTITION_EXTRACTORCLASS = SlashEncodedDayPartitionValueExtractor.class.getCanonicalName();
        @Deprecated
        public static final String READ_LATEST_INSTANT_ON_MISSING_CKPT = "hoodie.deltastreamer.source.hoodieincr.read_latest_on_missing_ckpt";
        public static final Boolean DEFAULT_READ_LATEST_INSTANT_ON_MISSING_CKPT = false;
        public static final String MISSING_CHECKPOINT_STRATEGY = "hoodie.deltastreamer.source.hoodieincr.missing.checkpoint.strategy";
        static final String SOURCE_FILE_FORMAT = "hoodie.deltastreamer.source.hoodieincr.file.format";
        static final String DEFAULT_SOURCE_FILE_FORMAT = "parquet";
        static final String HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE = "hoodie.deltastreamer.source.hoodieincr.drop.all.meta.fields.from.source";
        public static final Boolean DEFAULT_HOODIE_DROP_ALL_META_FIELDS_FROM_SOURCE = false;
    }
}

