/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamerMetrics;
import org.apache.hudi.utilities.exception.HoodieSourcePostProcessException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.KafkaSource;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.sources.helpers.KafkaOffsetGen;
import org.apache.hudi.utilities.sources.processor.JsonKafkaSourcePostProcessor;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.kafka010.KafkaUtils;
import org.apache.spark.streaming.kafka010.LocationStrategies;
import org.apache.spark.streaming.kafka010.OffsetRange;

public class JsonKafkaSource
extends KafkaSource<String> {
    public JsonKafkaSource(TypedProperties properties, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, HoodieDeltaStreamerMetrics metrics) {
        super(properties, sparkContext, sparkSession, schemaProvider, Source.SourceType.JSON, metrics);
        properties.put("key.deserializer", StringDeserializer.class.getName());
        properties.put("value.deserializer", StringDeserializer.class.getName());
        this.offsetGen = new KafkaOffsetGen(this.props);
    }

    @Override
    JavaRDD<String> toRDD(OffsetRange[] offsetRanges) {
        JavaRDD jsonStringRDD = KafkaUtils.createRDD(this.sparkContext, this.offsetGen.getKafkaParams(), offsetRanges, LocationStrategies.PreferConsistent()).filter((Function & Serializable)x -> !StringUtils.isNullOrEmpty((String)x.value())).map((Function & Serializable)x -> x.value().toString());
        return this.postProcess((JavaRDD<String>)jsonStringRDD);
    }

    private JavaRDD<String> postProcess(JavaRDD<String> jsonStringRDD) {
        JsonKafkaSourcePostProcessor processor;
        String postProcessorClassName = this.props.getString(KafkaOffsetGen.Config.JSON_KAFKA_PROCESSOR_CLASS_OPT.key(), null);
        if (StringUtils.isNullOrEmpty(postProcessorClassName)) {
            return jsonStringRDD;
        }
        try {
            processor = UtilHelpers.createJsonKafkaSourcePostProcessor(postProcessorClassName, this.props);
        }
        catch (IOException e) {
            throw new HoodieSourcePostProcessException("Could not init " + postProcessorClassName, e);
        }
        return processor.process(jsonStringRDD);
    }
}

