/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamerMetrics;
import org.apache.hudi.utilities.exception.HoodieSourceTimeoutException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.Source;
import org.apache.hudi.utilities.sources.helpers.KafkaOffsetGen;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.kafka010.OffsetRange;

abstract class KafkaSource<T>
extends Source<JavaRDD<T>> {
    private static final Logger LOG = LogManager.getLogger(KafkaSource.class);
    protected static final String NATIVE_KAFKA_KEY_DESERIALIZER_PROP = "key.deserializer";
    protected static final String NATIVE_KAFKA_VALUE_DESERIALIZER_PROP = "value.deserializer";
    protected final HoodieDeltaStreamerMetrics metrics;
    protected final SchemaProvider schemaProvider;
    protected KafkaOffsetGen offsetGen;

    protected KafkaSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, Source.SourceType sourceType, HoodieDeltaStreamerMetrics metrics) {
        super(props, sparkContext, sparkSession, schemaProvider, sourceType);
        this.schemaProvider = schemaProvider;
        this.metrics = metrics;
    }

    @Override
    protected InputBatch<JavaRDD<T>> fetchNewData(Option<String> lastCheckpointStr, long sourceLimit) {
        try {
            OffsetRange[] offsetRanges = this.offsetGen.getNextOffsetRanges(lastCheckpointStr, sourceLimit, this.metrics);
            long totalNewMsgs = KafkaOffsetGen.CheckpointUtils.totalNewMessages(offsetRanges);
            LOG.info((Object)("About to read " + totalNewMsgs + " from Kafka for topic :" + this.offsetGen.getTopicName()));
            if (totalNewMsgs <= 0L) {
                this.metrics.updateDeltaStreamerKafkaMessageInCount(0L);
                return new InputBatch<JavaRDD<T>>(Option.empty(), KafkaOffsetGen.CheckpointUtils.offsetsToStr(offsetRanges));
            }
            this.metrics.updateDeltaStreamerKafkaMessageInCount(totalNewMsgs);
            JavaRDD<T> newDataRDD = this.toRDD(offsetRanges);
            return new InputBatch<JavaRDD<T>>(Option.of(newDataRDD), KafkaOffsetGen.CheckpointUtils.offsetsToStr(offsetRanges));
        }
        catch (TimeoutException e) {
            throw new HoodieSourceTimeoutException("Kafka Source timed out " + e.getMessage());
        }
    }

    abstract JavaRDD<T> toRDD(OffsetRange[] var1);

    @Override
    public void onCommit(String lastCkptStr) {
        if (this.props.getBoolean(KafkaOffsetGen.Config.ENABLE_KAFKA_COMMIT_OFFSET.key(), KafkaOffsetGen.Config.ENABLE_KAFKA_COMMIT_OFFSET.defaultValue())) {
            this.offsetGen.commitOffsetToKafka(lastCkptStr);
        }
    }
}

