/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.google.protobuf.Message;
import com.twitter.bijection.Injection;
import com.twitter.bijection.avro.GenericAvroCodecs;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.utilities.sources.helpers.ProtoConversionUtil;

public class AvroConvertor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Schema schema;
    private final String schemaStr;
    private transient MercifulJsonConverter jsonConverter;
    private transient Injection<GenericRecord, byte[]> recordInjection;

    public AvroConvertor(String schemaStr) {
        this.schemaStr = schemaStr;
    }

    public AvroConvertor(Schema schema2) {
        this.schemaStr = schema2.toString();
        this.schema = schema2;
    }

    private void initSchema() {
        if (this.schema == null) {
            Schema.Parser parser = new Schema.Parser();
            this.schema = parser.parse(this.schemaStr);
        }
    }

    private void initInjection() {
        if (this.recordInjection == null) {
            this.recordInjection = GenericAvroCodecs.toBinary(this.schema);
        }
    }

    private void initJsonConvertor() {
        if (this.jsonConverter == null) {
            this.jsonConverter = new MercifulJsonConverter();
        }
    }

    public GenericRecord fromJson(String json) {
        this.initSchema();
        this.initJsonConvertor();
        return this.jsonConverter.convert(json, this.schema);
    }

    public Schema getSchema() {
        return new Schema.Parser().parse(this.schemaStr);
    }

    public GenericRecord fromAvroBinary(byte[] avroBinary) {
        this.initSchema();
        this.initInjection();
        return (GenericRecord)this.recordInjection.invert(avroBinary).get();
    }

    public GenericRecord fromProtoMessage(Message message) {
        this.initSchema();
        return ProtoConversionUtil.convertToAvro(this.schema, message);
    }
}

