/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Row;

public class CloudObjectsSelectorCommon {
    private static final Logger LOG = LogManager.getLogger(CloudObjectsSelectorCommon.class);

    public static FlatMapFunction<Iterator<Row>, String> getCloudFilesPerPartition(String storageUrlSchemePrefix, SerializableConfiguration serializableConfiguration, boolean checkIfExists) {
        return (FlatMapFunction & Serializable)rows -> {
            ArrayList cloudFilesPerPartition = new ArrayList();
            rows.forEachRemaining(row2 -> {
                Option<String> filePathUrl = CloudObjectsSelectorCommon.getUrlForFile(row2, storageUrlSchemePrefix, serializableConfiguration, checkIfExists);
                filePathUrl.ifPresent(url2 -> {
                    LOG.info((Object)("Adding file: " + url2));
                    cloudFilesPerPartition.add(url2);
                });
            });
            return cloudFilesPerPartition.iterator();
        };
    }

    private static Option<String> getUrlForFile(Row row2, String storageUrlSchemePrefix, SerializableConfiguration serializableConfiguration, boolean checkIfExists) {
        Configuration configuration = serializableConfiguration.newCopy();
        String bucket = row2.getString(0);
        String filePath = storageUrlSchemePrefix + bucket + "/" + row2.getString(1);
        try {
            String filePathUrl = URLDecoder.decode(filePath, StandardCharsets.UTF_8.name());
            if (!checkIfExists) {
                return Option.of(filePathUrl);
            }
            boolean exists = CloudObjectsSelectorCommon.checkIfFileExists(storageUrlSchemePrefix, bucket, filePathUrl, configuration);
            return exists ? Option.of(filePathUrl) : Option.empty();
        }
        catch (Exception exception) {
            LOG.warn((Object)String.format("Failed to generate path to cloud file %s", filePath), (Throwable)exception);
            throw new HoodieException(String.format("Failed to generate path to cloud file %s", filePath), exception);
        }
    }

    private static boolean checkIfFileExists(String storageUrlSchemePrefix, String bucket, String filePathUrl, Configuration configuration) {
        try {
            FileSystem fs = FSUtils.getFs(storageUrlSchemePrefix + bucket, configuration);
            return fs.exists(new Path(filePathUrl));
        }
        catch (IOException ioe) {
            String errMsg = String.format("Error while checking path exists for %s ", filePathUrl);
            LOG.error((Object)errMsg, (Throwable)ioe);
            throw new HoodieIOException(errMsg, ioe);
        }
    }
}

