/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers.gcs;

import java.io.Serializable;
import java.util.List;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.utilities.sources.helpers.CloudObjectsSelectorCommon;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class FilePathsFetcher
implements Serializable {
    private final String fileFormat;
    private final TypedProperties props;
    private static final String GCS_PREFIX = "gs://";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(FilePathsFetcher.class);

    public FilePathsFetcher(TypedProperties props, String fileFormat) {
        this.props = props;
        this.fileFormat = fileFormat;
    }

    public List<String> getGcsFilePaths(JavaSparkContext jsc, Dataset<Row> sourceForFilenames, boolean checkIfExists) {
        String filter = this.createFilter();
        LOG.info((Object)("Adding filter string to Dataset: " + filter));
        SerializableConfiguration serializableConfiguration = new SerializableConfiguration(jsc.hadoopConfiguration());
        return sourceForFilenames.filter(filter).select("bucket", new String[]{"name"}).distinct().rdd().toJavaRDD().mapPartitions(CloudObjectsSelectorCommon.getCloudFilesPerPartition(GCS_PREFIX, serializableConfiguration, checkIfExists)).collect();
    }

    private String createFilter() {
        StringBuilder filter = new StringBuilder("size > 0");
        this.getPropVal("hoodie.deltastreamer.source.cloud.data.select.relpath.prefix").ifPresent(val -> filter.append(" and name like '" + val + "%'"));
        this.getPropVal("hoodie.deltastreamer.source.cloud.data.ignore.relpath.prefix").ifPresent(val -> filter.append(" and name not like '" + val + "%'"));
        this.getPropVal("hoodie.deltastreamer.source.cloud.data.ignore.relpath.substring").ifPresent(val -> filter.append(" and name not like '%" + val + "%'"));
        this.getPropVal("hoodie.deltastreamer.source.cloud.data.select.file.extension").or(() -> Option.of(this.fileFormat)).map(val -> filter.append(" and name like '%" + val + "'"));
        return filter.toString();
    }

    private Option<String> getPropVal(String propName) {
        if (!StringUtils.isNullOrEmpty(this.props.getString(propName, null))) {
            return Option.of(this.props.getString(propName));
        }
        return Option.empty();
    }
}

