/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers.gcs;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.ReceivedMessage;
import java.io.IOException;
import java.util.List;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PubsubMessagesFetcher {
    private final String googleProjectId;
    private final String pubsubSubscriptionId;
    private final int batchSize;
    private final SubscriberStubSettings subscriberStubSettings;
    private static final Logger LOG = LogManager.getLogger(PubsubMessagesFetcher.class);

    public PubsubMessagesFetcher(String googleProjectId, String pubsubSubscriptionId, int batchSize) {
        this.googleProjectId = googleProjectId;
        this.pubsubSubscriptionId = pubsubSubscriptionId;
        this.batchSize = batchSize;
        try {
            this.subscriberStubSettings = ((SubscriberStubSettings.Builder)SubscriberStubSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)SubscriberStubSettings.defaultGrpcTransportProviderBuilder().setMaxInboundMessageSize(Integer.valueOf(0x1400000)).build())).build();
        }
        catch (IOException e) {
            throw new HoodieException("Error creating subscriber stub settings", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ReceivedMessage> fetchMessages() {
        try (GrpcSubscriberStub subscriber = this.createSubscriber();){
            String subscriptionName = this.getSubscriptionName();
            PullResponse pullResponse = this.makePullRequest((SubscriberStub)subscriber, subscriptionName);
            List list = pullResponse.getReceivedMessagesList();
            return list;
        }
        catch (IOException e) {
            throw new HoodieException("Error when fetching metadata", e);
        }
    }

    public void sendAcks(List<String> messagesToAck) throws IOException {
        String subscriptionName = this.getSubscriptionName();
        try (GrpcSubscriberStub subscriber = this.createSubscriber();){
            AcknowledgeRequest acknowledgeRequest = AcknowledgeRequest.newBuilder().setSubscription(subscriptionName).addAllAckIds(messagesToAck).build();
            subscriber.acknowledgeCallable().call((Object)acknowledgeRequest);
            LOG.info((Object)("Acknowledged messages: " + messagesToAck));
        }
    }

    private PullResponse makePullRequest(SubscriberStub subscriber, String subscriptionName) {
        PullRequest pullRequest = PullRequest.newBuilder().setMaxMessages(this.batchSize).setSubscription(subscriptionName).build();
        return (PullResponse)subscriber.pullCallable().call((Object)pullRequest);
    }

    private GrpcSubscriberStub createSubscriber() throws IOException {
        return GrpcSubscriberStub.create((SubscriberStubSettings)this.subscriberStubSettings);
    }

    private String getSubscriptionName() {
        return ProjectSubscriptionName.format((String)this.googleProjectId, (String)this.pubsubSubscriptionId);
    }
}

