/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers.gcs;

import org.apache.hudi.DataSourceReadOptions;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class QueryInfo {
    private final String queryType;
    private final String startInstant;
    private final String endInstant;
    private static final Logger LOG = LogManager.getLogger(QueryInfo.class);

    public QueryInfo(String queryType, String startInstant, String endInstant) {
        this.queryType = queryType;
        this.startInstant = startInstant;
        this.endInstant = endInstant;
    }

    public Dataset<Row> initializeSourceForFilenames(String srcPath, SparkSession sparkSession) {
        if (this.isIncremental()) {
            return this.incrementalQuery(sparkSession).load(srcPath);
        }
        return this.snapshotQuery(sparkSession).load(srcPath).filter(String.format("%s > '%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, this.getStartInstant())).filter(String.format("%s <= '%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, this.getEndInstant()));
    }

    public boolean areStartAndEndInstantsEqual() {
        return this.getStartInstant().equals(this.getEndInstant());
    }

    private DataFrameReader snapshotQuery(SparkSession sparkSession) {
        return sparkSession.read().format("org.apache.hudi").option(DataSourceReadOptions.QUERY_TYPE().key(), DataSourceReadOptions.QUERY_TYPE_SNAPSHOT_OPT_VAL());
    }

    private DataFrameReader incrementalQuery(SparkSession sparkSession) {
        return sparkSession.read().format("org.apache.hudi").option(DataSourceReadOptions.QUERY_TYPE().key(), DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions.BEGIN_INSTANTTIME().key(), this.getStartInstant()).option(DataSourceReadOptions.END_INSTANTTIME().key(), this.getEndInstant());
    }

    public boolean isIncremental() {
        return DataSourceReadOptions.QUERY_TYPE_INCREMENTAL_OPT_VAL().equals(this.queryType);
    }

    public String getStartInstant() {
        return this.startInstant;
    }

    public String getEndInstant() {
        return this.endInstant;
    }

    public void logDetails() {
        LOG.debug((Object)("queryType: " + this.queryType + ", startInstant: " + this.startInstant + ", endInstant: " + this.endInstant));
    }
}

