/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;

public class Protocol {
    private static String indentString(int size) {
        StringBuilder b = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    private static void schemaToBnfHtml(Schema schema2, StringBuilder b, int indentSize) {
        String indentStr = Protocol.indentString(indentSize);
        LinkedHashMap<String, Type> subTypes = new LinkedHashMap<String, Type>();
        for (BoundField field : schema2.fields()) {
            if (field.def.type instanceof ArrayOf) {
                b.append("[");
                b.append(field.def.name);
                b.append("] ");
                Type innerType = ((ArrayOf)field.def.type).type();
                if (subTypes.containsKey(field.def.name)) continue;
                subTypes.put(field.def.name, innerType);
                continue;
            }
            b.append(field.def.name);
            b.append(" ");
            if (subTypes.containsKey(field.def.name)) continue;
            subTypes.put(field.def.name, field.def.type);
        }
        b.append("\n");
        for (Map.Entry entry : subTypes.entrySet()) {
            if (entry.getValue() instanceof Schema) {
                b.append(indentStr);
                b.append((String)entry.getKey());
                b.append(" => ");
                Protocol.schemaToBnfHtml((Schema)entry.getValue(), b, indentSize + 2);
                continue;
            }
            b.append(indentStr);
            b.append((String)entry.getKey());
            b.append(" => ");
            b.append(entry.getValue());
            b.append("\n");
        }
    }

    private static void populateSchemaFields(Schema schema2, Set<BoundField> fields) {
        for (BoundField field : schema2.fields()) {
            fields.add(field);
            if (field.def.type instanceof ArrayOf) {
                Type innerType = ((ArrayOf)field.def.type).type();
                if (!(innerType instanceof Schema)) continue;
                Protocol.populateSchemaFields((Schema)innerType, fields);
                continue;
            }
            if (!(field.def.type instanceof Schema)) continue;
            Protocol.populateSchemaFields((Schema)field.def.type, fields);
        }
    }

    private static void schemaToFieldTableHtml(Schema schema2, StringBuilder b) {
        LinkedHashSet<BoundField> fields = new LinkedHashSet<BoundField>();
        Protocol.populateSchemaFields(schema2, fields);
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>");
        b.append("<th>Field</th>\n");
        b.append("<th>Description</th>\n");
        b.append("</tr>");
        for (BoundField field : fields) {
            b.append("<tr>\n");
            b.append("<td>");
            b.append(field.def.name);
            b.append("</td>");
            b.append("<td>");
            b.append(field.def.docString);
            b.append("</td>");
            b.append("</tr>\n");
        }
        b.append("</table>\n");
    }

    public static String toHtml() {
        StringBuilder b = new StringBuilder();
        b.append("<h5>Headers:</h5>\n");
        b.append("<pre>");
        b.append("Request Header => ");
        Protocol.schemaToBnfHtml(RequestHeader.SCHEMA, b, 2);
        b.append("</pre>\n");
        Protocol.schemaToFieldTableHtml(RequestHeader.SCHEMA, b);
        b.append("<pre>");
        b.append("Response Header => ");
        Protocol.schemaToBnfHtml(ResponseHeader.SCHEMA, b, 2);
        b.append("</pre>\n");
        Protocol.schemaToFieldTableHtml(ResponseHeader.SCHEMA, b);
        for (ApiKeys key : ApiKeys.values()) {
            b.append("<h5>");
            b.append("<a name=\"The_Messages_" + key.name + "\">");
            b.append(key.name);
            b.append(" API (Key: ");
            b.append(key.id);
            b.append("):</a></h5>\n\n");
            b.append("<b>Requests:</b><br>\n");
            Schema[] requests = key.requestSchemas;
            for (int i = 0; i < requests.length; ++i) {
                Schema schema2 = requests[i];
                if (schema2 != null) {
                    b.append("<p>");
                    b.append("<pre>");
                    b.append(key.name);
                    b.append(" Request (Version: ");
                    b.append(i);
                    b.append(") => ");
                    Protocol.schemaToBnfHtml(requests[i], b, 2);
                    b.append("</pre>");
                    Protocol.schemaToFieldTableHtml(requests[i], b);
                }
                b.append("</p>\n");
            }
            b.append("<b>Responses:</b><br>\n");
            Schema[] responses = key.responseSchemas;
            for (int i = 0; i < responses.length; ++i) {
                Schema schema3 = responses[i];
                if (schema3 != null) {
                    b.append("<p>");
                    b.append("<pre>");
                    b.append(key.name);
                    b.append(" Response (Version: ");
                    b.append(i);
                    b.append(") => ");
                    Protocol.schemaToBnfHtml(responses[i], b, 2);
                    b.append("</pre>");
                    Protocol.schemaToFieldTableHtml(responses[i], b);
                }
                b.append("</p>\n");
            }
        }
        return b.toString();
    }

    public static void main(String[] args2) {
        System.out.println(Protocol.toHtml());
    }
}

