/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class CreatePartitionsResponse
extends AbstractResponse {
    private static final String TOPIC_ERRORS_KEY_NAME = "topic_errors";
    private static final Schema CREATE_PARTITIONS_RESPONSE_V0;
    private static final Schema CREATE_PARTITIONS_RESPONSE_V1;
    private final int throttleTimeMs;
    private final Map<String, ApiError> errors;

    public static Schema[] schemaVersions() {
        return new Schema[]{CREATE_PARTITIONS_RESPONSE_V0, CREATE_PARTITIONS_RESPONSE_V1};
    }

    public CreatePartitionsResponse(int throttleTimeMs, Map<String, ApiError> errors2) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors2;
    }

    public CreatePartitionsResponse(Struct struct) {
        Object[] topicErrorsArray = struct.getArray(TOPIC_ERRORS_KEY_NAME);
        HashMap<String, ApiError> errors2 = new HashMap<String, ApiError>(topicErrorsArray.length);
        for (Object topicErrorObj : topicErrorsArray) {
            Struct topicErrorStruct = (Struct)topicErrorObj;
            String topic = topicErrorStruct.get(CommonFields.TOPIC_NAME);
            ApiError error = new ApiError(topicErrorStruct);
            errors2.put(topic, error);
        }
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.errors = errors2;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.CREATE_PARTITIONS.responseSchema(version));
        ArrayList<Struct> topicErrors = new ArrayList<Struct>(this.errors.size());
        for (Map.Entry<String, ApiError> error : this.errors.entrySet()) {
            Struct errorStruct = struct.instance(TOPIC_ERRORS_KEY_NAME);
            errorStruct.set(CommonFields.TOPIC_NAME, error.getKey());
            error.getValue().write(errorStruct);
            topicErrors.add(errorStruct);
        }
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        struct.set(TOPIC_ERRORS_KEY_NAME, (Object)topicErrors.toArray(new Object[topicErrors.size()]));
        return struct;
    }

    public Map<String, ApiError> errors() {
        return this.errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.apiErrorCounts(this.errors);
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public static CreatePartitionsResponse parse(ByteBuffer buffer, short version) {
        return new CreatePartitionsResponse(ApiKeys.CREATE_PARTITIONS.parseResponse(version, buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    static {
        CREATE_PARTITIONS_RESPONSE_V1 = CREATE_PARTITIONS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(TOPIC_ERRORS_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE)), "Per topic results for the create partitions request"));
    }
}

