/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.util.Locale;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceOptionsHelper$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001B\u0001\u0003\u0001=\u0011!\u0003S8pI&,7)\u0019;bY><G+\u00192mK*\u00111\u0001B\u0001\bG\u0006$\u0018\r\\8h\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005mA\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0013\u0001\u0011)\u0019!C\u0001;U\ta\u0004\u0005\u0002 A5\ta!\u0003\u0002\"\r\ta1\u000b]1sWN+7o]5p]\"A1\u0005\u0001B\u0001B\u0003%a$\u0001\u0004ta\u0006\u00148\u000e\t\u0005\tK\u0001\u0011\t\u0019!C\u0001M\u0005)A/\u00192mKV\tq\u0005\u0005\u0002)S5\t!!\u0003\u0002+\u0005\ta1)\u0019;bY><G+\u00192mK\"AA\u0006\u0001BA\u0002\u0013\u0005Q&A\u0005uC\ndWm\u0018\u0013fcR\u0011a&\r\t\u0003#=J!\u0001\r\n\u0003\tUs\u0017\u000e\u001e\u0005\be-\n\t\u00111\u0001(\u0003\rAH%\r\u0005\ti\u0001\u0011\t\u0011)Q\u0005O\u00051A/\u00192mK\u0002BQA\u000e\u0001\u0005\u0002]\na\u0001P5oSRtDc\u0001\u001d:uA\u0011\u0001\u0006\u0001\u0005\u0006\u0013U\u0002\rA\b\u0005\u0006KU\u0002\ra\n\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0003)A\u0017\rZ8pa\u000e{gNZ\u000b\u0002}A\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005G>tgM\u0003\u0002D\u0015\u00051\u0001.\u00193p_BL!!\u0012!\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u00199\u0005\u0001)A\u0005}\u0005Y\u0001.\u00193p_B\u001cuN\u001c4!\u0011\u001dI\u0005A1A\u0005\u0002)\u000b\u0001cY1uC2|w\rV1cY\u0016t\u0015-\\3\u0016\u0003-\u0003\"\u0001T(\u000f\u0005Ei\u0015B\u0001(\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\u0013\u0002BB*\u0001A\u0003%1*A\tdCR\fGn\\4UC\ndWMT1nK\u0002Bq!\u0016\u0001C\u0002\u0013\u0005a+A\tdCR\fGn\\4Qe>\u0004XM\u001d;jKN,\u0012a\u0016\t\u0005\u0019b[5*\u0003\u0002Z#\n\u0019Q*\u00199\t\rm\u0003\u0001\u0015!\u0003X\u0003I\u0019\u0017\r^1m_\u001e\u0004&o\u001c9feRLWm\u001d\u0011\t\u000fu\u0003!\u0019!C\u0001\u0015\u0006iA/\u00192mK2{7-\u0019;j_:Daa\u0018\u0001!\u0002\u0013Y\u0015A\u0004;bE2,Gj\\2bi&|g\u000e\t\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0003EAwn\u001c3jKR\u000b'\r\\3Fq&\u001cHo]\u000b\u0002GB\u0011\u0011\u0003Z\u0005\u0003KJ\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004h\u0001\u0001\u0006IaY\u0001\u0013Q>|G-[3UC\ndW-\u0012=jgR\u001c\b\u0005\u0003\u0005j\u0001!\u0015\r\u0011\"\u0001k\u0003)iW\r^1DY&,g\u000e^\u000b\u0002WB\u0011AN]\u0007\u0002[*\u0011QE\u001c\u0006\u0003_B\faaY8n[>t'BA9\u000b\u0003\u0011AW\u000fZ5\n\u0005Ml'!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e\u001e\u0005\tk\u0002A\t\u0011)Q\u0005W\u0006YQ.\u001a;b\u00072LWM\u001c;!\u0011!9\b\u0001#b\u0001\n\u0003A\u0018a\u0003;bE2,7i\u001c8gS\u001e,\u0012!\u001f\t\u0003YjL!a_7\u0003#!{w\u000eZ5f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0005~\u0001!\u0005\t\u0015)\u0003z\u00031!\u0018M\u00197f\u0007>tg-[4!\u0011!y\b\u0001#b\u0001\n\u0003Q\u0015!\u0003;bE2,g*Y7f\u0011%\t\u0019\u0001\u0001E\u0001B\u0003&1*\u0001\u0006uC\ndWMT1nK\u0002B\u0011\"a\u0002\u0001\u0011\u000b\u0007I\u0011\u0001&\u0002\u0019\u0011\fG/\u00192bg\u0016t\u0015-\\3\t\u0013\u0005-\u0001\u0001#A!B\u0013Y\u0015!\u00043bi\u0006\u0014\u0017m]3OC6,\u0007\u0005\u0003\u0006\u0002\u0010\u0001A)\u0019!C\u0001\u0003#\t\u0011\u0002^1cY\u0016$\u0016\u0010]3\u0016\u0005\u0005M\u0001\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005ea.A\u0003n_\u0012,G.\u0003\u0003\u0002\u001e\u0005]!a\u0004%p_\u0012LW\rV1cY\u0016$\u0016\u0010]3\t\u0015\u0005\u0005\u0002\u0001#A!B\u0013\t\u0019\"\u0001\u0006uC\ndW\rV=qK\u0002B\u0011\"!\n\u0001\u0011\u000b\u0007I\u0011\u0001&\u0002\u001bQ\f'\r\\3UsB,g*Y7f\u0011%\tI\u0003\u0001E\u0001B\u0003&1*\u0001\buC\ndW\rV=qK:\u000bW.\u001a\u0011\t\u0015\u00055\u0002\u0001#b\u0001\n\u0003\ty#A\u0006qe&l\u0017M]=LKf\u001cXCAA\u0019!\u0011\t\u00121G&\n\u0007\u0005U\"CA\u0003BeJ\f\u0017\u0010\u0003\u0006\u0002:\u0001A\t\u0011)Q\u0005\u0003c\tA\u0002\u001d:j[\u0006\u0014\u0018pS3zg\u0002B!\"!\u0010\u0001\u0011\u000b\u0007I\u0011AA \u00035\u0001(/Z\"p[\nLg.Z&fsV\u0011\u0011\u0011\t\t\u0005#\u0005\r3*C\u0002\u0002FI\u0011aa\u00149uS>t\u0007BCA%\u0001!\u0005\t\u0015)\u0003\u0002B\u0005q\u0001O]3D_6\u0014\u0017N\\3LKf\u0004\u0003BCA'\u0001!\u0015\r\u0011\"\u0001\u00020\u0005y\u0001/\u0019:uSRLwN\u001c$jK2$7\u000f\u0003\u0006\u0002R\u0001A\t\u0011)Q\u0005\u0003c\t\u0001\u0003]1si&$\u0018n\u001c8GS\u0016dGm\u001d\u0011\t\u0013\u0005U\u0003\u0001#b\u0001\n\u0003Q\u0015A\u00042bg\u00164\u0015\u000e\\3G_Jl\u0017\r\u001e\u0005\n\u00033\u0002\u0001\u0012!Q!\n-\u000bqBY1tK\u001aKG.\u001a$pe6\fG\u000f\t\u0005\u000b\u0003;\u0002\u0001R1A\u0005\u0002\u0005}\u0013a\u0003;bE2,7k\u00195f[\u0006,\"!!\u0019\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a\u0007\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY'!\u001a\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0006\u0002p\u0001A\t\u0011)Q\u0005\u0003C\nA\u0002^1cY\u0016\u001c6\r[3nC\u0002B!\"a\u001d\u0001\u0011\u000b\u0007I\u0011AA0\u0003q!\u0018M\u00197f'\u000eDW-\\1XSRDw.\u001e;NKR\fg)[3mIND!\"a\u001e\u0001\u0011\u0003\u0005\u000b\u0015BA1\u0003u!\u0018M\u00197f'\u000eDW-\\1XSRDw.\u001e;NKR\fg)[3mIN\u0004\u0003BCA>\u0001!\u0015\r\u0011\"\u0001\u0002`\u0005QA-\u0019;b'\u000eDW-\\1\t\u0015\u0005}\u0004\u0001#A!B\u0013\t\t'A\u0006eCR\f7k\u00195f[\u0006\u0004\u0003BCAB\u0001!\u0015\r\u0011\"\u0001\u0002`\u0005YB-\u0019;b'\u000eDW-\\1XSRDw.\u001e;NKR\fg)[3mIND!\"a\"\u0001\u0011\u0003\u0005\u000b\u0015BA1\u0003q!\u0017\r^1TG\",W.Y,ji\"|W\u000f^'fi\u00064\u0015.\u001a7eg\u0002B!\"a#\u0001\u0011\u000b\u0007I\u0011AA0\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007BCAH\u0001!\u0005\t\u0015)\u0003\u0002b\u0005\u0001\u0002/\u0019:uSRLwN\\*dQ\u0016l\u0017\r\t\u0005\b\u0003'\u0003A\u0011AAK\u0003E9W\r\u001e)beRLG/[8o!\u0006$\bn]\u000b\u0003\u0003/\u0003R!!'\u0002*.sA!a'\u0002&:!\u0011QTAR\u001b\t\tyJC\u0002\u0002\":\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0007\u0005\u001d&#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0016Q\u0016\u0002\u0004'\u0016\f(bAAT%!1\u0011\u0011\u0017\u0001\u0005\u0002\t\f!#[:QCJ$\u0018\u000e^5p]\u0016$G+\u00192mK\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0016aD5oSRDun\u001c3jKR\u000b'\r\\3\u0015\u00039Bq!a/\u0001\t\u0013\ti,A\u000bqCJ\u001cXmU2iK6\f\u0017I\u001c3D_:4\u0017nZ:\u0015\u0005\u0005}\u0006CB\t\u0002B\u0006\u0005t+C\u0002\u0002DJ\u0011a\u0001V;qY\u0016\u0014\u0004bBAd\u0001\u0011%\u0011\u0011Z\u0001\u0011Kb$(/\u0019+bE2,7i\u001c8gS\u001e$RaVAf\u0003\u001fDq!!4\u0002F\u0002\u00071-A\u0006uC\ndW-\u0012=jgR\u001c\b\"CAi\u0003\u000b\u0004\n\u00111\u0001X\u0003Ey'/[4j]R\u000b'\r\\3D_:4\u0017n\u001a\u0005\b\u0003+\u0004A\u0011BAl\u0003maw.\u00193UC\ndWmU2iK6\f')_'fi\u0006\u001cE.[3oiR\u0011\u0011\u0011\u001c\t\u0006#\u0005\r\u0013\u0011\r\u0005\b\u0003;\u0004A\u0011BAp\u0003A1XM]5gs\u0012\u000bG/Y*dQ\u0016l\u0017\rF\u0004/\u0003C\fi/!>\t\u0011\u0005\r\u00181\u001ca\u0001\u0003K\fq\u0002^1cY\u0016LE-\u001a8uS\u001aLWM\u001d\t\u0005\u0003O\fI/D\u0001\u0005\u0013\r\tY\u000f\u0002\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"A\u0011qBAn\u0001\u0004\ty\u000fE\u0002)\u0003cL1!a=\u0003\u0005A\u0019\u0015\r^1m_\u001e$\u0016M\u00197f)f\u0004X\r\u0003\u0005\u0002|\u0005m\u0007\u0019AA|!\u0019\tI*!+\u0002zB!\u00111MA~\u0013\u0011\ti0!\u001a\u0003\u0017M#(/^2u\r&,G\u000e\u001a\u0005\n\u0005\u0003\u0001\u0011\u0013!C\u0005\u0005\u0007\t!$\u001a=ue\u0006$\u0016M\u00197f\u0007>tg-[4%I\u00164\u0017-\u001e7uII*\"A!\u0002+\u0007]\u00139a\u000b\u0002\u0003\nA!!1\u0002B\u000b\u001b\t\u0011iA\u0003\u0003\u0003\u0010\tE\u0011!C;oG\",7m[3e\u0015\r\u0011\u0019BE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\f\u0005\u001b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f\u001d\u0011YB\u0001E\u0001\u0005;\t!\u0003S8pI&,7)\u0019;bY><G+\u00192mKB\u0019\u0001Fa\b\u0007\r\u0005\u0011\u0001\u0012\u0001B\u0011'\r\u0011y\u0002\u0005\u0005\bm\t}A\u0011\u0001B\u0013)\t\u0011i\u0002\u0003\u0006\u0003*\t}!\u0019!C\u0001\u0005W\tqB\\3fI\u001aKG\u000e^3s!J|\u0007o]\u000b\u0003\u0005[\u0001R!!'\u00030-KAA!\r\u0002.\n!A*[:u\u0011%\u0011)Da\b!\u0002\u0013\u0011i#\u0001\toK\u0016$g)\u001b7uKJ\u0004&o\u001c9tA!A!\u0011\bB\u0010\t\u0003\u0011Y$A\u0003baBd\u0017\u0010F\u00039\u0005{\u0011\t\u0005C\u0004\u0003@\t]\u0002\u0019\u0001\u0010\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\t\u0011\u0005\r(q\u0007a\u0001\u0003KD\u0001B!\u000f\u0003 \u0011\u0005!Q\t\u000b\u0006q\t\u001d#\u0011\n\u0005\b\u0005\u007f\u0011\u0019\u00051\u0001\u001f\u0011\u001d\u0011YEa\u0011A\u0002\u001d\nAbY1uC2|w\rV1cY\u0016\u0004")
public class HoodieCatalogTable
implements Logging {
    private final SparkSession spark;
    private CatalogTable table;
    private final Configuration hadoopConf;
    private final String catalogTableName;
    private final scala.collection.immutable.Map<String, String> catalogProperties;
    private final String tableLocation;
    private final boolean hoodieTableExists;
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private String tableName;
    private String databaseName;
    private HoodieTableType tableType;
    private String tableTypeName;
    private String[] primaryKeys;
    private Option<String> preCombineKey;
    private String[] partitionFields;
    private String baseFileFormat;
    private StructType tableSchema;
    private StructType tableSchemaWithoutMetaFields;
    private StructType dataSchema;
    private StructType dataSchemaWithoutMetaFields;
    private StructType partitionSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public static HoodieCatalogTable apply(SparkSession sparkSession, CatalogTable catalogTable) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
    }

    public static HoodieCatalogTable apply(SparkSession sparkSession, TableIdentifier tableIdentifier) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
    }

    public static List<String> needFilterProps() {
        return HoodieCatalogTable$.MODULE$.needFilterProps();
    }

    private HoodieTableMetaClient metaClient$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.tableLocation()).setConf(this.hadoopConf()).build();
                this.bitmap$0 |= 1;
            }
            return this.metaClient;
        }
    }

    private HoodieTableConfig tableConfig$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tableConfig = this.metaClient().getTableConfig();
                this.bitmap$0 |= 2;
            }
            return this.tableConfig;
        }
    }

    private String tableName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tableName = this.tableConfig().getTableName();
                this.bitmap$0 |= 4;
            }
            return this.tableName;
        }
    }

    private String databaseName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 8) == 0) {
                this.databaseName = this.tableConfig().getDatabaseName();
                this.bitmap$0 |= 8;
            }
            return this.databaseName;
        }
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableType = this.tableConfig().getTableType();
                this.bitmap$0 |= 0x10;
            }
            return this.tableType;
        }
    }

    private String tableTypeName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.tableTypeName = this.tableType().name();
                this.bitmap$0 |= 0x20;
            }
            return this.tableTypeName;
        }
    }

    private String[] primaryKeys$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.primaryKeys = this.tableConfig().getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x40;
            }
            return this.primaryKeys;
        }
    }

    private Option preCombineKey$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.preCombineKey = Option$.MODULE$.apply((Object)this.tableConfig().getPreCombineField());
                this.bitmap$0 |= 0x80;
            }
            return this.preCombineKey;
        }
    }

    private String[] partitionFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.partitionFields = this.tableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x100;
            }
            return this.partitionFields;
        }
    }

    private String baseFileFormat$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.baseFileFormat = this.metaClient().getTableConfig().getBaseFileFormat().name();
                this.bitmap$0 |= 0x200;
            }
            return this.baseFileFormat;
        }
    }

    private StructType tableSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.tableSchema = this.table().schema();
                this.bitmap$0 |= 0x400;
            }
            return this.tableSchema;
        }
    }

    private StructType tableSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.tableSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.tableSchema());
                this.bitmap$0 |= 0x800;
            }
            return this.tableSchemaWithoutMetaFields;
        }
    }

    private StructType dataSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.dataSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HoodieCatalogTable $outer;

                    public final boolean apply(StructField f) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.partitionFields()).contains((Object)f.name());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                this.bitmap$0 |= 0x1000;
            }
            return this.dataSchema;
        }
    }

    private StructType dataSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.dataSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.dataSchema());
                this.bitmap$0 |= 0x2000;
            }
            return this.dataSchemaWithoutMetaFields;
        }
    }

    private StructType partitionSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.partitionSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HoodieCatalogTable $outer;

                    public final boolean apply(StructField f) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.partitionFields()).contains((Object)f.name());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                this.bitmap$0 |= 0x4000;
            }
            return this.partitionSchema;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public CatalogTable table() {
        return this.table;
    }

    public void table_$eq(CatalogTable x$1) {
        this.table = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String catalogTableName() {
        return this.catalogTableName;
    }

    public scala.collection.immutable.Map<String, String> catalogProperties() {
        return this.catalogProperties;
    }

    public String tableLocation() {
        return this.tableLocation;
    }

    public boolean hoodieTableExists() {
        return this.hoodieTableExists;
    }

    public HoodieTableMetaClient metaClient() {
        return (this.bitmap$0 & 1) == 0 ? this.metaClient$lzycompute() : this.metaClient;
    }

    public HoodieTableConfig tableConfig() {
        return (this.bitmap$0 & 2) == 0 ? this.tableConfig$lzycompute() : this.tableConfig;
    }

    public String tableName() {
        return (this.bitmap$0 & 4) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    public String databaseName() {
        return (this.bitmap$0 & 8) == 0 ? this.databaseName$lzycompute() : this.databaseName;
    }

    public HoodieTableType tableType() {
        return (this.bitmap$0 & 0x10) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    public String tableTypeName() {
        return (this.bitmap$0 & 0x20) == 0 ? this.tableTypeName$lzycompute() : this.tableTypeName;
    }

    public String[] primaryKeys() {
        return (this.bitmap$0 & 0x40) == 0 ? this.primaryKeys$lzycompute() : this.primaryKeys;
    }

    public Option<String> preCombineKey() {
        return (this.bitmap$0 & 0x80) == 0 ? this.preCombineKey$lzycompute() : this.preCombineKey;
    }

    public String[] partitionFields() {
        return (this.bitmap$0 & 0x100) == 0 ? this.partitionFields$lzycompute() : this.partitionFields;
    }

    public String baseFileFormat() {
        return (this.bitmap$0 & 0x200) == 0 ? this.baseFileFormat$lzycompute() : this.baseFileFormat;
    }

    public StructType tableSchema() {
        return (this.bitmap$0 & 0x400) == 0 ? this.tableSchema$lzycompute() : this.tableSchema;
    }

    public StructType tableSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x800) == 0 ? this.tableSchemaWithoutMetaFields$lzycompute() : this.tableSchemaWithoutMetaFields;
    }

    public StructType dataSchema() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.dataSchema$lzycompute() : this.dataSchema;
    }

    public StructType dataSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.dataSchemaWithoutMetaFields$lzycompute() : this.dataSchemaWithoutMetaFields;
    }

    public StructType partitionSchema() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    public Seq<String> getPartitionPaths() {
        return HoodieSqlCommonUtils$.MODULE$.getAllPartitionPaths(this.spark(), this.table());
    }

    public boolean isPartitionedTable() {
        return this.table().partitionColumnNames().nonEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public void initHoodieTable() {
        block5: {
            block8: {
                block7: {
                    block6: {
                        this.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ HoodieCatalogTable $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Init hoodie.properties for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.table().identifier().unquotedString()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        var2_1 = this.parseSchemaAndConfigs();
                        if (var2_1 == null) break block5;
                        finalSchema = (StructType)var2_1._1();
                        tableConfigs = (scala.collection.immutable.Map)var2_1._2();
                        var1_5 = var5_4 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
                        finalSchema = (StructType)var1_5._1();
                        tableConfigs = (scala.collection.immutable.Map)var1_5._2();
                        qual$1 = this.table();
                        x$6 = finalSchema;
                        x$7 = qual$1.copy$default$1();
                        x$8 = qual$1.copy$default$2();
                        x$9 = qual$1.copy$default$3();
                        x$10 = qual$1.copy$default$5();
                        x$11 = qual$1.copy$default$6();
                        x$12 = qual$1.copy$default$7();
                        x$13 = qual$1.copy$default$8();
                        x$14 = qual$1.copy$default$9();
                        x$15 = qual$1.copy$default$10();
                        x$16 = qual$1.copy$default$11();
                        x$17 = qual$1.copy$default$12();
                        x$18 = qual$1.copy$default$13();
                        x$19 = qual$1.copy$default$14();
                        x$20 = qual$1.copy$default$15();
                        x$21 = qual$1.copy$default$16();
                        x$22 = qual$1.copy$default$17();
                        x$23 = qual$1.copy$default$18();
                        x$24 = qual$1.copy$default$19();
                        this.table_$eq(qual$1.copy(x$7, x$8, x$9, x$6, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24));
                        properties = new Properties();
                        properties.putAll((java.util.Map<?, ?>)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableConfigs).asJava()));
                        catalogDatabaseName = HoodieSqlCommonUtils$.MODULE$.formatName(this.spark(), (String)this.table().identifier().database().getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ HoodieCatalogTable $outer;

                            public final String apply() {
                                return this.$outer.spark().sessionState().catalog().getCurrentDatabase();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }));
                        if (!this.hoodieTableExists()) break block6;
                        if (StringUtils.isNullOrEmpty(this.databaseName())) ** GOTO lbl-1000
                        v0 = this.databaseName();
                        var32_30 = catalogDatabaseName;
                        if (!(v0 != null ? v0.equals(var32_30) == false : var32_30 != null)) lbl-1000:
                        // 2 sources

                        {
                            v1 = true;
                        } else {
                            v1 = false;
                        }
                        Predef$.MODULE$.assert(v1, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "The database names from this hoodie path and this catalog table is not same.";
                            }
                        });
                        HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setDatabaseName(catalogDatabaseName).setTableCreateSchema(SchemaConverters$.MODULE$.toAvroType((DataType)finalSchema, SchemaConverters$.MODULE$.toAvroType$default$2(), SchemaConverters$.MODULE$.toAvroType$default$3(), SchemaConverters$.MODULE$.toAvroType$default$4()).toString()).initTable(this.hadoopConf(), this.tableLocation());
                        break block7;
                    }
                    var34_31 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.table().identifier().table());
                    if (var34_31 == null) break block8;
                    recordName = (String)var34_31._1();
                    namespace = (String)var34_31._2();
                    var33_35 = var37_34 = new Tuple2((Object)recordName, (Object)namespace);
                    recordName = (String)var33_35._1();
                    namespace = (String)var33_35._2();
                    schema = SchemaConverters$.MODULE$.toAvroType((DataType)finalSchema, false, recordName, namespace);
                    partitionColumns = this.table().partitionColumnNames().isEmpty() != false ? null : this.table().partitionColumnNames().mkString(",");
                    HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setDatabaseName(catalogDatabaseName).setTableName(this.table().identifier().table()).setTableCreateSchema(schema.toString()).setPartitionFields(partitionColumns).initTable(this.hadoopConf(), this.tableLocation());
                }
                return;
            }
            throw new MatchError(var34_31);
        }
        throw new MatchError(var2_1);
    }

    private Tuple2<StructType, scala.collection.immutable.Map<String, String>> parseSchemaAndConfigs() {
        Tuple2 tuple2;
        block11: {
            Tuple2 tuple22;
            block10: {
                boolean bl;
                scala.collection.immutable.Map<String, String> sqlOptions;
                scala.collection.immutable.Map<String, String> globalTableConfigs;
                block6: {
                    block9: {
                        StructType structType;
                        scala.collection.immutable.Map options;
                        block8: {
                            block7: {
                                scala.collection.immutable.Map globalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                                globalTableConfigs = HoodieWriterUtils$.MODULE$.mappingSparkDatasourceConfigsToTableConfigs((scala.collection.immutable.Map<String, String>)globalProps);
                                scala.collection.immutable.Map<String, String> globalSqlOptions = HoodieOptionConfig$.MODULE$.mapTableConfigsToSqlOptions(globalTableConfigs);
                                sqlOptions = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions((scala.collection.immutable.Map<String, String>)globalSqlOptions.$plus$plus(HoodieOptionConfig$.MODULE$.mapDataSourceWriteOptionsToSqlOptions(this.catalogProperties())).$plus$plus(this.catalogProperties()));
                                tuple2 = new Tuple2((Object)this.table().tableType(), (Object)BoxesRunTime.boxToBoolean((boolean)this.hoodieTableExists()));
                                if (tuple2 == null) break block6;
                                CatalogTableType catalogTableType = (CatalogTableType)tuple2._1();
                                boolean bl2 = tuple2._2$mcZ$sp();
                                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
                                CatalogTableType catalogTableType3 = catalogTableType;
                                if ((catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) || !bl2) break block6;
                                scala.collection.immutable.Map existingTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                                scala.collection.immutable.Map currentTableConfig = globalTableConfigs.$plus$plus((GenTraversableOnce)existingTableConfig);
                                scala.collection.immutable.Map<String, String> catalogTableProps = HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(this.catalogProperties());
                                HoodieWriterUtils$.MODULE$.validateTableConfig(this.spark(), catalogTableProps, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)existingTableConfig));
                                options = this.extraTableConfig(this.hoodieTableExists(), (scala.collection.immutable.Map<String, String>)currentTableConfig).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions)).$plus$plus((GenTraversableOnce)currentTableConfig);
                                Option<StructType> schemaFromMetaOpt = this.loadTableSchemaByMetaClient();
                                if (!schemaFromMetaOpt.nonEmpty()) break block7;
                                structType = (StructType)schemaFromMetaOpt.get();
                                break block8;
                            }
                            if (!this.table().schema().nonEmpty()) break block9;
                            structType = HoodieSqlCommonUtils$.MODULE$.addMetaFields(this.table().schema());
                        }
                        StructType schema2 = structType;
                        tuple22 = new Tuple2((Object)schema2, (Object)options);
                        break block10;
                    }
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing schema fields when applying CREATE TABLE clause for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalogTableName()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (tuple2 == null || (bl = tuple2._2$mcZ$sp())) break block11;
                ValidationUtils.checkArgument(this.table().schema().nonEmpty(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing schema for Create Table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalogTableName()})));
                StructType schema3 = this.table().schema();
                scala.collection.immutable.Map options = this.extraTableConfig(false, globalTableConfigs).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions));
                tuple22 = new Tuple2((Object)HoodieSqlCommonUtils$.MODULE$.addMetaFields(schema3), (Object)options);
            }
            Tuple2 tuple23 = tuple22;
            if (tuple23 != null) {
                Tuple2 tuple24;
                StructType finalSchema = (StructType)tuple23._1();
                scala.collection.immutable.Map tableConfigs = (scala.collection.immutable.Map)tuple23._2();
                Tuple2 tuple25 = tuple24 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
                StructType finalSchema2 = (StructType)tuple25._1();
                scala.collection.immutable.Map tableConfigs2 = (scala.collection.immutable.Map)tuple25._2();
                HoodieOptionConfig$.MODULE$.validateTable(this.spark(), finalSchema2, HoodieOptionConfig$.MODULE$.mapTableConfigsToSqlOptions((scala.collection.immutable.Map<String, String>)tableConfigs2));
                Function2 resolver2 = this.spark().sessionState().conf().resolver();
                Seq dataSchema2 = (Seq)finalSchema2.filterNot((Function1)new Serializable(this, resolver2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HoodieCatalogTable $outer;
                    public final Function2 resolver$1;

                    public final boolean apply(StructField f) {
                        return this.$outer.table().partitionColumnNames().exists((Function1)new Serializable(this, f){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4 $outer;
                            private final StructField f$1;

                            public final boolean apply(String x$5) {
                                return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$1.apply((Object)x$5, (Object)this.f$1.name()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.f$1 = f$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.resolver$1 = resolver$1;
                    }
                });
                this.verifyDataSchema(this.table().identifier(), this.table().tableType(), (Seq<StructField>)dataSchema2);
                return new Tuple2((Object)finalSchema2, (Object)tableConfigs2);
            }
            throw new MatchError((Object)tuple23);
        }
        if (tuple2 != null) {
            CatalogTableType catalogTableType = (CatalogTableType)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.MANAGED();
            CatalogTableType catalogTableType5 = catalogTableType;
            if (!(catalogTableType4 != null ? !catalogTableType4.equals(catalogTableType5) : catalogTableType5 != null) && bl) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not create the managed table('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalogTableName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". The associated location('", "') already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableLocation()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig(boolean tableExists, scala.collection.immutable.Map<String, String> originTableConfig) {
        scala.collection.mutable.Map extraConfig = Map$.MODULE$.empty();
        if (tableExists) {
            Seq<String> allPartitionPaths = this.getPartitionPaths();
            if (originTableConfig.contains((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key())) {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), originTableConfig.apply((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isHiveStyledPartitioning(allPartitionPaths, this.table())));
            }
            if (originTableConfig.contains((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key())) {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), originTableConfig.apply((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isUrlEncodeEnabled(allPartitionPaths, this.table())));
            }
        } else {
            extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
            extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.defaultValue());
        }
        if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())));
        } else {
            String primaryKeys = this.table().properties().getOrElse((Object)HoodieOptionConfig$.MODULE$.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HoodieCatalogTable $outer;

                public final Option<String> apply() {
                    return this.$outer.table().storage().properties().get((Object)HoodieOptionConfig$.MODULE$.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).toString();
            String partitions = this.table().partitionColumnNames().mkString(",");
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)DataSourceOptionsHelper$.MODULE$.inferKeyGenClazz(primaryKeys, partitions));
        }
        return extraConfig.toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private Option<StructType> loadTableSchemaByMetaClient() {
        Function2 resolver2 = this.spark().sessionState().conf().resolver();
        return HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(this.metaClient(), true).map((Function1)new Serializable(this, resolver2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieCatalogTable $outer;
            public final Function2 resolver$2;

            public final StructType apply(StructType originSchema) {
                StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])originSchema.fields()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$loadTableSchemaByMetaClient$1 $outer;

                    public final StructField apply(StructField f) {
                        boolean x$25 = true;
                        String x$26 = f.copy$default$1();
                        DataType x$27 = f.copy$default$2();
                        Metadata x$28 = f.copy$default$4();
                        StructField nullableField = f.copy(x$26, x$27, x$25, x$28);
                        Option<StructField> catalogField = HoodieSqlCommonUtils$.MODULE$.findColumnByName(this.$outer.org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$anonfun$$$outer().table().schema(), nullableField.name(), (Function2<String, String, Object>)this.$outer.resolver$2);
                        return catalogField.isDefined() ? (StructField)((StructField)catalogField.get()).getComment().map((Function1)new Serializable(this, nullableField){
                            public static final long serialVersionUID = 0L;
                            private final StructField nullableField$1;

                            public final StructField apply(String comment) {
                                return this.nullableField$1.withComment(comment);
                            }
                            {
                                this.nullableField$1 = nullableField$1;
                            }
                        }).getOrElse((Function0)new Serializable(this, nullableField){
                            public static final long serialVersionUID = 0L;
                            private final StructField nullableField$1;

                            public final StructField apply() {
                                return this.nullableField$1;
                            }
                            {
                                this.nullableField$1 = nullableField$1;
                            }
                        }) : nullableField;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
                return new StructType(fields);
            }

            public /* synthetic */ HoodieCatalogTable org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolver$2 = resolver$2;
            }
        });
    }

    private void verifyDataSchema(TableIdentifier tableIdentifier, CatalogTableType tableType, Seq<StructField> dataSchema2) {
        CatalogTableType catalogTableType = tableType;
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2)) {
            Seq invalidChars = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", ":", ";"}));
            dataSchema2.foreach((Function1)new Serializable(this, tableIdentifier, invalidChars){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HoodieCatalogTable $outer;
                private final TableIdentifier tableIdentifier$1;
                private final Seq invalidChars$1;

                public final void apply(StructField f) {
                    DataType dataType = f.dataType();
                    if (f.name().contains(",")) {
                        throw new AnalysisException(new StringBuilder().append((Object)"Cannot create a table having a column whose name ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"contains commas in Hive metastore. Table: ", "; Column: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdentifier$1, f.name()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    if (dataType instanceof StructType) {
                        StructType structType = (StructType)dataType;
                        this.$outer.org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$verifyNestedColumnNames$1(structType, this.tableIdentifier$1, this.invalidChars$1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tableIdentifier$1 = tableIdentifier$1;
                    this.invalidChars$1 = invalidChars$1;
                }
            });
        }
    }

    public final void org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$verifyNestedColumnNames$1(StructType schema2, TableIdentifier tableIdentifier$1, Seq invalidChars$1) {
        schema2.foreach((Function1)new Serializable(this, tableIdentifier$1, invalidChars$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieCatalogTable $outer;
            private final TableIdentifier tableIdentifier$1;
            private final Seq invalidChars$1;

            public final void apply(StructField f) {
                DataType dataType = f.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    this.$outer.org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$verifyNestedColumnNames$1(structType, this.tableIdentifier$1, this.invalidChars$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (this.invalidChars$1.exists((Function1)new Serializable(this, f){
                        public static final long serialVersionUID = 0L;
                        private final StructField f$2;

                        public final boolean apply(CharSequence x$1) {
                            return this.f$2.name().contains(x$1);
                        }
                        {
                            this.f$2 = f$2;
                        }
                    })) {
                        String invalidCharsString = ((TraversableOnce)this.invalidChars$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String c) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c}));
                            }
                        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                        String errMsg = new StringBuilder().append((Object)"Cannot create a table having a nested column whose name contains ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid characters (", ") in Hive metastore. Table: ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidCharsString, this.tableIdentifier$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name()}))).toString();
                        throw new AnalysisException(errMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableIdentifier$1 = tableIdentifier$1;
                this.invalidChars$1 = invalidChars$1;
            }
        });
    }

    public HoodieCatalogTable(SparkSession spark, CatalogTable table) {
        this.spark = spark;
        this.table = table;
        Logging.class.$init$((Logging)this);
        Object object = this.table().provider().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.toLowerCase(Locale.ROOT);
            }
        }).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string) : string != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "It's not a Hudi table";
            }
        });
        this.hadoopConf = spark.sessionState().newHadoopConf();
        this.catalogTableName = this.table().qualifiedName();
        this.catalogProperties = this.table().storage().properties().$plus$plus((GenTraversableOnce)this.table().properties());
        this.tableLocation = HoodieSqlCommonUtils$.MODULE$.getTableLocation(this.table(), spark);
        this.hoodieTableExists = HoodieSqlCommonUtils$.MODULE$.tableExistsInPath(this.tableLocation(), this.hadoopConf());
    }
}

