/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hudi.client.utils.SparkInternalSchemaConverter;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class Spark24HoodieVectorizedParquetRecordReader
extends VectorizedParquetRecordReader {
    private Map<Integer, Pair<DataType, DataType>> typeChangeInfos;
    private ColumnarBatch columnarBatch;
    private Map<Integer, WritableColumnVector> idToColumnVectors;
    private WritableColumnVector[] columnVectors;
    private int capacity;
    private boolean returnColumnarBatch;
    private final MemoryMode memoryMode;
    private int batchIdx = 0;
    private int numBatched = 0;

    public Spark24HoodieVectorizedParquetRecordReader(TimeZone convertTz, boolean useOffHeap, int capacity, Map<Integer, Pair<DataType, DataType>> typeChangeInfos) {
        super(convertTz, useOffHeap, capacity);
        this.memoryMode = useOffHeap ? MemoryMode.OFF_HEAP : MemoryMode.ON_HEAP;
        this.typeChangeInfos = typeChangeInfos;
        this.capacity = capacity;
    }

    public void initBatch(StructType partitionColumns, InternalRow partitionValues) {
        super.initBatch(partitionColumns, partitionValues);
        if (this.columnVectors == null) {
            this.columnVectors = new WritableColumnVector[this.sparkSchema.length() + partitionColumns.length()];
        }
        if (this.idToColumnVectors == null) {
            this.idToColumnVectors = new HashMap<Integer, WritableColumnVector>();
            this.typeChangeInfos.entrySet().stream().forEach(f -> {
                OffHeapColumnVector vector = this.memoryMode == MemoryMode.OFF_HEAP ? new OffHeapColumnVector(this.capacity, (DataType)((Pair)f.getValue()).getLeft()) : new OnHeapColumnVector(this.capacity, (DataType)((Pair)f.getValue()).getLeft());
                this.idToColumnVectors.put((Integer)f.getKey(), (WritableColumnVector)vector);
            });
        }
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException, UnsupportedOperationException {
        super.initialize(inputSplit, taskAttemptContext);
    }

    public void close() throws IOException {
        super.close();
        for (Map.Entry<Integer, WritableColumnVector> e : this.idToColumnVectors.entrySet()) {
            e.getValue().close();
        }
        this.idToColumnVectors = null;
        this.columnarBatch = null;
        this.columnVectors = null;
    }

    public ColumnarBatch resultBatch() {
        ColumnarBatch currentColumnBatch = super.resultBatch();
        boolean changed = false;
        for (Map.Entry<Integer, Pair<DataType, DataType>> entry : this.typeChangeInfos.entrySet()) {
            boolean rewrite = SparkInternalSchemaConverter.convertColumnVectorType((WritableColumnVector)currentColumnBatch.column(entry.getKey().intValue()), this.idToColumnVectors.get(entry.getKey()), currentColumnBatch.numRows());
            if (!rewrite) continue;
            changed = true;
            this.columnVectors[entry.getKey().intValue()] = this.idToColumnVectors.get(entry.getKey());
        }
        if (changed) {
            if (this.columnarBatch == null) {
                for (int i = 0; i < this.columnVectors.length; ++i) {
                    if (this.columnVectors[i] != null) continue;
                    this.columnVectors[i] = (WritableColumnVector)currentColumnBatch.column(i);
                }
                this.columnarBatch = new ColumnarBatch((ColumnVector[])this.columnVectors);
            }
            this.columnarBatch.setNumRows(currentColumnBatch.numRows());
            return this.columnarBatch;
        }
        return currentColumnBatch;
    }

    public boolean nextBatch() throws IOException {
        boolean result = super.nextBatch();
        if (this.idToColumnVectors != null) {
            this.idToColumnVectors.entrySet().stream().forEach(e -> ((WritableColumnVector)e.getValue()).reset());
        }
        this.numBatched = this.resultBatch().numRows();
        this.batchIdx = 0;
        return result;
    }

    public void enableReturningBatches() {
        this.returnColumnarBatch = true;
        super.enableReturningBatches();
    }

    public Object getCurrentValue() {
        if (this.typeChangeInfos == null || this.typeChangeInfos.isEmpty()) {
            return super.getCurrentValue();
        }
        if (this.returnColumnarBatch) {
            return this.columnarBatch == null ? super.getCurrentValue() : this.columnarBatch;
        }
        return this.columnarBatch == null ? super.getCurrentValue() : this.columnarBatch.getRow(this.batchIdx - 1);
    }

    public boolean nextKeyValue() throws IOException {
        this.resultBatch();
        if (this.returnColumnarBatch) {
            return this.nextBatch();
        }
        if (this.batchIdx >= this.numBatched && !this.nextBatch()) {
            return false;
        }
        ++this.batchIdx;
        return true;
    }
}

