/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.util.TablePathUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.BaseRelation;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public abstract class SparkAdapter$class {
    public static void injectTableFunctions(SparkAdapter $this, SparkSessionExtensions extensions) {
    }

    public static Option createExtendedSparkParser(SparkAdapter $this) {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHoodieTable(SparkAdapter $this, LogicalPlan table, SparkSession spark) {
        boolean bl = false;
        LogicalRelation logicalRelation = null;
        LogicalPlan logicalPlan = $this.unfoldSubqueryAliases(table);
        if (logicalPlan instanceof LogicalRelation) {
            bl = true;
            logicalRelation = (LogicalRelation)logicalPlan;
            Option option2 = logicalRelation.catalogTable();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                CatalogTable table2 = (CatalogTable)some.x();
                return $this.isHoodieTable(table2);
            }
        }
        if (!bl) return false;
        BaseRelation fsr = logicalRelation.relation();
        if (!(fsr instanceof HadoopFsRelation)) return false;
        HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsr;
        return BoxesRunTime.unboxToBoolean((Object)hadoopFsRelation.options().get((Object)"path").map((Function1)new Serializable($this, spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final boolean apply(String pathStr) {
                Path path = new Path(pathStr);
                return TablePathUtils.isHoodieTablePath(path.getFileSystem(this.spark$1.sparkContext().hadoopConfiguration()), path);
            }
            {
                this.spark$1 = spark$1;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    public static boolean isHoodieTable(SparkAdapter $this, Map map) {
        return map.getOrDefault("provider", "").equals("hudi");
    }

    public static boolean isHoodieTable(SparkAdapter $this, CatalogTable table) {
        Object object = table.provider().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.toLowerCase(Locale.ROOT);
            }
        }).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static boolean isHoodieTable(SparkAdapter $this, TableIdentifier tableId, SparkSession spark) {
        CatalogTable table = spark.sessionState().catalog().getTableMetadata(tableId);
        return $this.isHoodieTable(table);
    }

    public static LogicalPlan unfoldSubqueryAliases(SparkAdapter $this, LogicalPlan plan) {
        LogicalPlan logicalPlan;
        SubqueryAlias subqueryAlias;
        LogicalPlan relation;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof SubqueryAlias && (relation = (subqueryAlias = (SubqueryAlias)logicalPlan2).child()) != null) {
            LogicalPlan logicalPlan3 = relation;
            logicalPlan = $this.unfoldSubqueryAliases(logicalPlan3);
        } else {
            logicalPlan = logicalPlan2;
        }
        return logicalPlan;
    }

    public static Seq createHoodieFileScanRDD$default$5(SparkAdapter $this) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static LogicalPlan getQueryParserFromExtendedSqlParser(SparkAdapter $this, SparkSession session, ParserInterface delegate, String sqlText) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported parseQuery method in Spark earlier than Spark 3.3.0"})).s((Seq)Nil$.MODULE$));
    }

    public static void $init$(SparkAdapter $this) {
    }
}

