/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u001b\tY1\u000b]1sW\"+G\u000e]3s\u0015\t\u0019A!\u0001\u0003ik\u0012L'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"a\u0006\r\u000e\u0003\u0011I!!\u0007\u0003\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\t17\u000f\u0005\u0002\u001eC5\taD\u0003\u0002\u001c?)\u0011\u0001\u0005C\u0001\u0007Q\u0006$wn\u001c9\n\u0005\tr\"A\u0003$jY\u0016\u001c\u0016p\u001d;f[\")A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"2A\n\u0015*!\t9\u0003!D\u0001\u0003\u0011\u0015)2\u00051\u0001\u0017\u0011\u0015Y2\u00051\u0001\u001d\u0011\u0015Y\u0003\u0001\"\u0001-\u0003E\u0001(/\u001b8u\u0017\u0016L8O\u0012:p[\u001aKG.\u001a\u000b\u0003[A\u0002\"a\u0004\u0018\n\u0005=\u0002\"\u0001B+oSRDQ!\r\u0016A\u0002I\nAAZ5mKB\u00111G\u000e\b\u0003\u001fQJ!!\u000e\t\u0002\rA\u0013X\rZ3g\u0013\t9\u0004H\u0001\u0004TiJLgn\u001a\u0006\u0003kAAQA\u000f\u0001\u0005\u0002m\n1bZ3u%><8*Z=E\rR\u0011AH\u0014\t\u0003{-s!AP%\u000f\u0005}BeB\u0001!H\u001d\t\teI\u0004\u0002C\u000b6\t1I\u0003\u0002E\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011B\u0001&\u0005\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001&\u0005\u0011\u0015\t\u0014\b1\u00013\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003EI7OR5mK\u000e{g\u000e^1j]N\\U-\u001f\u000b\u0004%V;\u0006CA\bT\u0013\t!\u0006CA\u0004C_>dW-\u00198\t\u000bY{\u0005\u0019\u0001\u001a\u0002\rI|woS3z\u0011\u0015\tt\n1\u00013\u0011\u0015I\u0006\u0001\"\u0001[\u0003-9W\r^&fs\u000e{WO\u001c;\u0015\u0007msv\f\u0005\u0002\u00109&\u0011Q\f\u0005\u0002\u0004\u0013:$\b\"B\u0019Y\u0001\u0004\u0011\u0004\"B\u000bY\u0001\u00041\u0002\"B1\u0001\t\u0003\u0011\u0017!\u00054jY\u0016\\U-_:BO\u0006Lgn\u001d;C\rR!!k\u00196l\u0011\u0015!\u0007\r1\u0001f\u0003\u0011\u0019wN\u001c4\u0011\u0005\u0019DW\"A4\u000b\u0005\u0011|\u0012BA5h\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")Q\u0003\u0019a\u0001-!)\u0011\u0007\u0019a\u0001e!)Q\u000e\u0001C\u0001]\u0006\u0001r-\u001a;ESN$\u0018N\\2u\u0017\u0016LHI\u0012\u000b\u0003y=DQ\u0001\u001d7A\u0002E\fQ\u0001]1uQN\u00042A\u001d<3\u001d\t\u0019XO\u0004\u0002Ci&\t\u0011#\u0003\u0002K!%\u0011q\u000f\u001f\u0002\u0005\u0019&\u001cHO\u0003\u0002K!\u0001")
public class SparkHelper {
    private final SQLContext sqlContext;

    public void printKeysFromFile(String file) {
        Predef$.MODULE$.refArrayOps((Object[])this.getRowKeyDF(file).collect()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Row x$1) {
                Predef$.MODULE$.println((Object)x$1);
            }
        });
    }

    public Dataset<Row> getRowKeyDF(String file) {
        return this.sqlContext.read().parquet(file).select(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieRecord.RECORD_KEY_METADATA_FIELD})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    public boolean isFileContainsKey(String rowKey, String file) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking ", " for key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, rowKey})));
        Dataset ff = this.getRowKeyDF(file).filter(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "` = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieRecord.RECORD_KEY_METADATA_FIELD, rowKey})));
        return ff.count() > 0L;
    }

    /*
     * WARNING - void declaration
     */
    public int getKeyCount(String file, SQLContext sqlContext) {
        void var3_3;
        int keyCount = ((Row[])this.getRowKeyDF(file).collect()).length;
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)keyCount));
        return (int)var3_3;
    }

    public boolean fileKeysAgainstBF(Configuration conf, SQLContext sqlContext, String file) {
        BloomFilter bf = BaseFileUtils.getInstance(HoodieFileFormat.PARQUET).readBloomFilterFromMetadata(conf, new Path(file));
        int foundCount = Predef$.MODULE$.refArrayOps((Object[])sqlContext.parquetFile((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file})).select(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieRecord.RECORD_KEY_METADATA_FIELD})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()).count((Function1)new Serializable(this, bf){
            public static final long serialVersionUID = 0L;
            private final BloomFilter bf$1;

            public final boolean apply(Row r) {
                return !this.bf$1.mightContain(r.getString(0));
            }
            {
                this.bf$1 = bf$1;
            }
        });
        int totalCount = this.getKeyCount(file, sqlContext);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"totalCount: ", ", foundCount: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)totalCount), BoxesRunTime.boxToInteger((int)foundCount)})));
        return totalCount == foundCount;
    }

    public Dataset<Row> getDistinctKeyDF(List<String> paths) {
        return this.sqlContext.read().parquet(paths).select(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieRecord.RECORD_KEY_METADATA_FIELD})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct();
    }

    public SparkHelper(SQLContext sqlContext, FileSystem fs) {
        this.sqlContext = sqlContext;
    }
}

