/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.client.SparkTaskContextSupplier;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.io.storage.HoodieAvroParquetWriter;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;

public final class SparkHelpers$ {
    public static final SparkHelpers$ MODULE$;

    static {
        new SparkHelpers$();
    }

    public void skipKeysAndWriteNewFile(String instantTime, FileSystem fs, Path sourceFile, Path destinationFile, Set<String> keysToSkip) throws Exception {
        List<GenericRecord> sourceRecords = BaseFileUtils.getInstance(HoodieFileFormat.PARQUET).readAvroRecords(fs.getConf(), sourceFile);
        Schema schema2 = ((GenericContainer)sourceRecords.get(0)).getSchema();
        BloomFilter filter = BloomFilterFactory.createBloomFilter(new StringOps(Predef$.MODULE$.augmentString(HoodieIndexConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE.defaultValue())).toInt(), new StringOps(Predef$.MODULE$.augmentString(HoodieIndexConfig.BLOOM_FILTER_FPP_VALUE.defaultValue())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(HoodieIndexConfig.BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES.defaultValue())).toInt(), HoodieIndexConfig.BLOOM_FILTER_TYPE.defaultValue());
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter(fs.getConf()).convert(schema2), schema2, Option.of(filter));
        HoodieParquetConfig<HoodieAvroWriteSupport> parquetConfig = new HoodieParquetConfig<HoodieAvroWriteSupport>(writeSupport, CompressionCodecName.GZIP, new StringOps(Predef$.MODULE$.augmentString(HoodieStorageConfig.PARQUET_BLOCK_SIZE.defaultValue())).toInt(), new StringOps(Predef$.MODULE$.augmentString(HoodieStorageConfig.PARQUET_PAGE_SIZE.defaultValue())).toInt(), new StringOps(Predef$.MODULE$.augmentString(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.defaultValue())).toInt(), fs.getConf(), new StringOps(Predef$.MODULE$.augmentString(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION.defaultValue())).toDouble(), Predef$.MODULE$.Boolean2boolean(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED.defaultValue()));
        parquetConfig.getHadoopConf().setClassLoader(Thread.currentThread().getContextClassLoader());
        HoodieAvroParquetWriter writer = new HoodieAvroParquetWriter(destinationFile, parquetConfig, instantTime, new SparkTaskContextSupplier(), true);
        JavaConversions$.MODULE$.asScalaBuffer(sourceRecords).foreach((Function1)new Serializable(keysToSkip, writer){
            public static final long serialVersionUID = 0L;
            private final Set keysToSkip$1;
            private final HoodieAvroParquetWriter writer$1;

            public final void apply(GenericRecord rec) {
                String key = rec.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
                if (!this.keysToSkip$1.contains((Object)key)) {
                    this.writer$1.writeAvro(key, (IndexedRecord)rec);
                }
            }
            {
                this.keysToSkip$1 = keysToSkip$1;
                this.writer$1 = writer$1;
            }
        });
        writer.close();
    }

    private SparkHelpers$() {
        MODULE$ = this;
    }
}

