/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkAdapterSupport$class;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.HoodieCatalystPlansUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig$class;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.InsertIntoHoodieTableCommand;
import org.apache.spark.sql.hudi.command.InsertIntoHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.InsertIntoHoodieTableCommand$$anonfun$createStaticPartitionValuesExpressions$2$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class InsertIntoHoodieTableCommand$
implements ProvidesHoodieConfig,
SparkAdapterSupport,
Serializable {
    public static final InsertIntoHoodieTableCommand$ MODULE$;
    private final SparkAdapter sparkAdapter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new InsertIntoHoodieTableCommand$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        InsertIntoHoodieTableCommand$ insertIntoHoodieTableCommand$ = this;
        synchronized (insertIntoHoodieTableCommand$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport$class.sparkAdapter(this);
                this.bitmap$0 = true;
            }
            return this.sparkAdapter;
        }
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return this.bitmap$0 ? this.sparkAdapter : this.sparkAdapter$lzycompute();
    }

    @Override
    public Map<String, String> buildHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig$class.buildHoodieConfig(this, hoodieCatalogTable);
    }

    @Override
    public Map<String, String> buildHoodieInsertConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession, boolean isOverwritePartition, boolean isOverwriteTable, Map<String, Option<String>> insertPartitions, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig$class.buildHoodieInsertConfig(this, hoodieCatalogTable, sparkSession, isOverwritePartition, isOverwriteTable, insertPartitions, extraOptions);
    }

    @Override
    public Map<String, String> buildHoodieDropPartitionsConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, String partitionsToDrop) {
        return ProvidesHoodieConfig$class.buildHoodieDropPartitionsConfig(this, sparkSession, hoodieCatalogTable, partitionsToDrop);
    }

    @Override
    public Map<String, String> buildHoodieDeleteTableConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        return ProvidesHoodieConfig$class.buildHoodieDeleteTableConfig(this, hoodieCatalogTable, sparkSession);
    }

    @Override
    public HiveSyncConfig buildHiveSyncConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, HoodieTableConfig tableConfig, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig$class.buildHiveSyncConfig(this, sparkSession, hoodieCatalogTable, tableConfig, extraOptions);
    }

    @Override
    public Map<String, String> buildHiveSyncConfig$default$4() {
        return ProvidesHoodieConfig$class.buildHiveSyncConfig$default$4(this);
    }

    @Override
    public Map<String, Option<String>> buildHoodieInsertConfig$default$5() {
        return ProvidesHoodieConfig$class.buildHoodieInsertConfig$default$5(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public boolean run(SparkSession sparkSession, CatalogTable table, LogicalPlan query, Map<String, Option<String>> partitionSpec, boolean overwrite, boolean refreshTable, Map<String, String> extraOptions) {
        HoodieCatalogTable catalogTable = new HoodieCatalogTable(sparkSession, table);
        SaveMode mode = SaveMode.Append;
        boolean isOverWriteTable = false;
        boolean isOverWritePartition = false;
        if (overwrite && partitionSpec.isEmpty()) {
            mode = SaveMode.Overwrite;
            isOverWriteTable = true;
        } else {
            mode = SaveMode.Append;
            isOverWritePartition = overwrite;
        }
        Map<String, String> config = this.buildHoodieInsertConfig(catalogTable, sparkSession, isOverWritePartition, isOverWriteTable, partitionSpec, extraOptions);
        LogicalPlan alignedQuery = this.alignQueryOutput(query, catalogTable, partitionSpec, sparkSession.sessionState().conf());
        Tuple6<Object, org.apache.hudi.common.util.Option<String>, org.apache.hudi.common.util.Option<String>, org.apache.hudi.common.util.Option<String>, SparkRDDWriteClient<?>, HoodieTableConfig> tuple6 = HoodieSparkSqlWriter$.MODULE$.write(sparkSession.sqlContext(), mode, config, (Dataset<Row>)Dataset$.MODULE$.ofRows(sparkSession, alignedQuery), HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8(), HoodieSparkSqlWriter$.MODULE$.write$default$9());
        if (tuple6 != null) {
            boolean success = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
            boolean bl = success;
            boolean success2 = bl;
            if (success2) {
                if (success2 && refreshTable) {
                    sparkSession.catalog().refreshTable(table.identifier().unquotedString());
                }
                return success2;
            }
            throw new HoodieException("Insert Into to Hudi table failed");
        }
        throw new MatchError(tuple6);
    }

    public boolean run$default$6() {
        return true;
    }

    public Map<String, String> run$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    private LogicalPlan alignQueryOutput(LogicalPlan query, HoodieCatalogTable catalogTable, Map<String, Option<String>> partitionsSpec, SQLConf conf) {
        StructType targetPartitionSchema = catalogTable.partitionSchema();
        Map<String, String> staticPartitionValues = this.filterStaticPartitionValues(partitionsSpec);
        LogicalPlan cleanedQuery = this.stripMetaFields(query);
        Seq expectedQueryColumns = (Seq)catalogTable.tableSchemaWithoutMetaFields().filterNot((Function1)new Serializable(staticPartitionValues){
            public static final long serialVersionUID = 0L;
            private final Map staticPartitionValues$1;

            public final boolean apply(StructField f) {
                return this.staticPartitionValues$1.contains((Object)f.name());
            }
            {
                this.staticPartitionValues$1 = staticPartitionValues$1;
            }
        });
        LogicalPlan coercedQueryOutput = this.coerceQueryOutputColumns(StructType$.MODULE$.apply(expectedQueryColumns), cleanedQuery, catalogTable, conf);
        this.validate(HoodieSqlCommonUtils$.MODULE$.removeMetaFields(coercedQueryOutput.schema()), partitionsSpec, catalogTable);
        Seq<NamedExpression> staticPartitionValuesExprs = this.createStaticPartitionValuesExpressions(staticPartitionValues, targetPartitionSchema, conf);
        return new Project((Seq)coercedQueryOutput.output().$plus$plus(staticPartitionValuesExprs, Seq$.MODULE$.canBuildFrom()), coercedQueryOutput);
    }

    private LogicalPlan coerceQueryOutputColumns(StructType expectedSchema, LogicalPlan query, HoodieCatalogTable catalogTable, SQLConf conf) {
        Throwable throwable2;
        block2: {
            LogicalPlan logicalPlan;
            HoodieCatalystPlansUtils planUtils = this.sparkAdapter().getCatalystPlanUtils();
            try {
                logicalPlan = planUtils.resolveOutputColumns(catalogTable.catalogTableName(), (Seq<Attribute>)expectedSchema.toAttributes(), query, true, conf);
            }
            catch (Throwable throwable2) {
                LogicalPlan logicalPlan2;
                AnalysisException analysisException;
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof AnalysisException) || !(analysisException = (AnalysisException)throwable3).getMessage().startsWith("Cannot write incompatible data to table")) break block2;
                logicalPlan = logicalPlan2 = planUtils.resolveOutputColumns(catalogTable.catalogTableName(), (Seq<Attribute>)expectedSchema.toAttributes(), query, false, conf);
            }
            return logicalPlan;
        }
        throw throwable2;
    }

    private void validate(StructType queryOutputSchema, Map<String, Option<String>> partitionsSpec, HoodieCatalogTable catalogTable) {
        if (partitionsSpec.nonEmpty() && partitionsSpec.size() != catalogTable.partitionSchema().size()) {
            throw new HoodieException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Required partition schema is: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])catalogTable.partitionSchema().fieldNames()).mkString("[", ", ", "]")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition spec is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsSpec.mkString("[", ", ", "]")}))).toString());
        }
        Map<String, String> staticPartitionValues = this.filterStaticPartitionValues(partitionsSpec);
        StructType fullQueryOutputSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])queryOutputSchema.fields()).$plus$plus((GenTraversableOnce)staticPartitionValues.keys().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String x$1) {
                return new StructField(x$1, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
        }, Iterable$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        if (this.conforms(fullQueryOutputSchema, catalogTable.tableSchemaWithoutMetaFields())) {
            return;
        }
        throw new HoodieException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected table's schema: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])catalogTable.tableSchemaWithoutMetaFields().fields()).mkString("[", ", ", "]")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"query's output (including static partition values): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])fullQueryOutputSchema.fields()).mkString("[", ", ", "]")}))).toString());
    }

    private Seq<NamedExpression> createStaticPartitionValuesExpressions(Map<String, String> staticPartitionValues, StructType partitionSchema2, SQLConf conf) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionSchema2.fields()).filter((Function1)new Serializable(staticPartitionValues){
            public static final long serialVersionUID = 0L;
            private final Map staticPartitionValues$2;

            public final boolean apply(StructField pf) {
                return this.staticPartitionValues$2.contains((Object)pf.name());
            }
            {
                this.staticPartitionValues$2 = staticPartitionValues$2;
            }
        })).map((Function1)new Serializable(staticPartitionValues, conf){
            public static final long serialVersionUID = 0L;
            private final Map staticPartitionValues$2;
            private final SQLConf conf$1;

            public final Alias apply(StructField pf) {
                Expression castExpr;
                String staticPartitionValue = (String)this.staticPartitionValues$2.apply((Object)pf.name());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(InsertIntoHoodieTableCommand$.MODULE$.getClass().getClassLoader());
                public final class Org_apache_spark_sql_hudi_command_InsertIntoHoodieTableCommand$$anonfun$createStaticPartitionValuesExpressions$2$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                    }

                    public Org_apache_spark_sql_hudi_command_InsertIntoHoodieTableCommand$$anonfun$createStaticPartitionValuesExpressions$2$$typecreator1$1(anonfun.createStaticPartitionValuesExpressions.2 $outer) {
                    }
                }
                Expression x$3 = castExpr = HoodieSqlCommonUtils$.MODULE$.castIfNeeded((Expression)Literal$.MODULE$.create((Object)staticPartitionValue, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_InsertIntoHoodieTableCommand$$anonfun$createStaticPartitionValuesExpressions$2$$typecreator1$1(this))), pf.dataType(), this.conf$1);
                String x$4 = pf.name();
                ExprId x$5 = Alias$.MODULE$.apply$default$3(x$3, x$4);
                Seq x$6 = Alias$.MODULE$.apply$default$4(x$3, x$4);
                Option x$7 = Alias$.MODULE$.apply$default$5(x$3, x$4);
                return new Alias(x$3, x$4, x$5, x$6, x$7);
            }
            {
                this.staticPartitionValues$2 = staticPartitionValues$2;
                this.conf$1 = conf$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private boolean conforms(StructType sourceSchema, StructType targetSchema) {
        return sourceSchema.fields().length != targetSchema.fields().length ? false : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])targetSchema.fields()).zip((GenIterable)sourceSchema, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<StructField, StructField> x0$1) {
                Tuple2<StructField, StructField> tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField targetColumn = (StructField)tuple2._1();
                    StructField sourceColumn = (StructField)tuple2._2();
                    boolean bl = Cast$.MODULE$.canCast(sourceColumn.dataType(), targetColumn.dataType());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public LogicalPlan stripMetaFields(LogicalPlan query) {
        Seq filteredOutput;
        Seq seq = filteredOutput = (Seq)query.output().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Attribute attr) {
                return HoodieSqlCommonUtils$.MODULE$.isMetaField(attr.name());
            }
        });
        Seq seq2 = query.output();
        return !(seq != null ? !seq.equals(seq2) : seq2 != null) ? query : new Project(filteredOutput, query);
    }

    private Map<String, String> filterStaticPartitionValues(Map<String, Option<String>> partitionsSpec) {
        return ((MapLike)partitionsSpec.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Option<String>> p) {
                return ((Option)p._2()).isDefined();
            }
        })).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Option<String> x$2) {
                return (String)x$2.get();
            }
        });
    }

    public InsertIntoHoodieTableCommand apply(LogicalRelation logicalRelation, LogicalPlan query, Map<String, Option<String>> partitionSpec, boolean overwrite) {
        return new InsertIntoHoodieTableCommand(logicalRelation, query, partitionSpec, overwrite);
    }

    public Option<Tuple4<LogicalRelation, LogicalPlan, Map<String, Option<String>>, Object>> unapply(InsertIntoHoodieTableCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.logicalRelation(), (Object)x$0.query(), x$0.partitionSpec(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.overwrite())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private InsertIntoHoodieTableCommand$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        ProvidesHoodieConfig$class.$init$(this);
        SparkAdapterSupport$class.$init$(this);
    }
}

