/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.payload;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroDeserializer;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroSerializer;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SafeProjection$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.hudi.command.payload.ExpressionPayload$Serializer$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;

public final class ExpressionPayload$
implements Serializable {
    public static final ExpressionPayload$ MODULE$;
    private final String PAYLOAD_DELETE_CONDITION;
    private final String PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS;
    private final String PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS;
    private final String PAYLOAD_RECORD_AVRO_SCHEMA;
    private final ThreadLocal<Cache<Tuple2<String, Schema>, Seq<Tuple2<package.Projection, package.Projection>>>> projectionsCache;
    private final ThreadLocal<Cache<Schema, HoodieAvroDeserializer>> avroDeserializerCache;
    private final ThreadLocal<Cache<Schema, HoodieAvroSerializer>> avroSerializerCache;
    private final Cache<String, Schema> schemaCache;
    private final Cache<Tuple2<Schema, Schema>, Schema> mergedSchemaCache;

    static {
        new ExpressionPayload$();
    }

    public String PAYLOAD_DELETE_CONDITION() {
        return this.PAYLOAD_DELETE_CONDITION;
    }

    public String PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS() {
        return this.PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS;
    }

    public String PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS() {
        return this.PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS;
    }

    public String PAYLOAD_RECORD_AVRO_SCHEMA() {
        return this.PAYLOAD_RECORD_AVRO_SCHEMA;
    }

    private ThreadLocal<Cache<Tuple2<String, Schema>, Seq<Tuple2<package.Projection, package.Projection>>>> projectionsCache() {
        return this.projectionsCache;
    }

    private ThreadLocal<Cache<Schema, HoodieAvroDeserializer>> avroDeserializerCache() {
        return this.avroDeserializerCache;
    }

    private ThreadLocal<Cache<Schema, HoodieAvroSerializer>> avroSerializerCache() {
        return this.avroSerializerCache;
    }

    private Cache<String, Schema> schemaCache() {
        return this.schemaCache;
    }

    private Cache<Tuple2<Schema, Schema>, Schema> mergedSchemaCache() {
        return this.mergedSchemaCache;
    }

    private Schema parseSchema(String schemaStr) {
        return this.schemaCache().get(schemaStr, new Function<String, Schema>(){

            public Schema apply(String t) {
                return new Schema.Parser().parse(t);
            }
        });
    }

    public Schema org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getRecordSchema(Properties props) {
        ValidationUtils.checkArgument(props.containsKey(this.PAYLOAD_RECORD_AVRO_SCHEMA()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing ", " property"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.PAYLOAD_RECORD_AVRO_SCHEMA()})));
        return this.parseSchema(props.getProperty(this.PAYLOAD_RECORD_AVRO_SCHEMA()));
    }

    public Schema org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getWriterSchema(Properties props) {
        ValidationUtils.checkArgument(props.containsKey(HoodieWriteConfig.WRITE_SCHEMA_OVERRIDE.key()), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing ", " property"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieWriteConfig.WRITE_SCHEMA_OVERRIDE.key()})));
        return this.parseSchema(props.getProperty(HoodieWriteConfig.WRITE_SCHEMA_OVERRIDE.key()));
    }

    public HoodieAvroDeserializer org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getAvroDeserializerFor(Schema schema2) {
        return this.avroDeserializerCache().get().get(schema2, new Function<Schema, HoodieAvroDeserializer>(schema2){
            private final Schema schema$2;

            public HoodieAvroDeserializer apply(Schema t) {
                return SparkAdapterSupport$.MODULE$.sparkAdapter().createAvroDeserializer(this.schema$2, (DataType)AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(this.schema$2));
            }
            {
                this.schema$2 = schema$2;
            }
        });
    }

    public HoodieAvroSerializer org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getAvroSerializerFor(Schema schema2) {
        return this.avroSerializerCache().get().get(schema2, new Function<Schema, HoodieAvroSerializer>(schema2){
            private final Schema schema$1;

            public HoodieAvroSerializer apply(Schema t) {
                return SparkAdapterSupport$.MODULE$.sparkAdapter().createAvroSerializer((DataType)AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(this.schema$1), this.schema$1, AvroSchemaUtils.isNullable(this.schema$1));
            }
            {
                this.schema$1 = schema$1;
            }
        });
    }

    public Seq<Tuple2<package.Projection, package.Projection>> org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getEvaluator(String serializedConditionAssignments, Schema inputSchema) {
        return this.projectionsCache().get().get((Tuple2<String, Schema>)new Tuple2((Object)serializedConditionAssignments, (Object)inputSchema), new Function<Tuple2<String, Schema>, Seq<Tuple2<package.Projection, package.Projection>>>(){

            public Seq<Tuple2<package.Projection, package.Projection>> apply(Tuple2<String, Schema> key) {
                Tuple2<String, Schema> tuple2 = key;
                if (tuple2 != null) {
                    String encodedConditionalAssignments;
                    String string;
                    String encodedConditionalAssignments2 = string = (encodedConditionalAssignments = (String)tuple2._1());
                    byte[] serializedBytes = Base64.getDecoder().decode(encodedConditionalAssignments2);
                    Map conditionAssignments = (Map)ExpressionPayload$Serializer$.MODULE$.toObject(serializedBytes);
                    return (Seq)conditionAssignments.toSeq().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<package.Projection, package.Projection> apply(Tuple2<Expression, Seq<Expression>> x0$1) {
                            Tuple2<Expression, Seq<Expression>> tuple2 = x0$1;
                            if (tuple2 != null) {
                                Expression condition = (Expression)tuple2._1();
                                Seq assignments = (Seq)tuple2._2();
                                package.Projection conditionEvaluator = SafeProjection$.MODULE$.create((Seq<Expression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{condition}))));
                                package.Projection assignmentEvaluator = SafeProjection$.MODULE$.create((Seq<Expression>)assignments);
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)conditionEvaluator), (Object)assignmentEvaluator);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public Schema org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$getMergedSchema(Schema source, Schema target) {
        return this.mergedSchemaCache().get((Tuple2<Schema, Schema>)new Tuple2((Object)source, (Object)target), new Function<Tuple2<Schema, Schema>, Schema>(){

            public Schema apply(Tuple2<Schema, Schema> t) {
                Schema rightSchema = HoodieAvroUtils.removeMetadataFields((Schema)t._2());
                return ExpressionPayload$.MODULE$.org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$mergeSchema((Schema)t._1(), rightSchema);
            }
        });
    }

    public Schema org$apache$spark$sql$hudi$command$payload$ExpressionPayload$$mergeSchema(Schema a, Schema b) {
        Buffer mergedFields = ((BufferLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(a.getFields()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Schema.Field apply(Schema.Field field) {
                return new Schema.Field(new StringBuilder().append((Object)"a_").append((Object)field.name()).toString(), field.schema(), field.doc(), field.defaultVal(), field.order());
            }
        }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(b.getFields()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Schema.Field apply(Schema.Field field) {
                return new Schema.Field(new StringBuilder().append((Object)"b_").append((Object)field.name()).toString(), field.schema(), field.doc(), field.defaultVal(), field.order());
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        return Schema.createRecord((String)a.getName(), (String)a.getDoc(), (String)a.getNamespace(), (boolean)a.isError(), (List)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(mergedFields).asJava()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExpressionPayload$() {
        MODULE$ = this;
        this.PAYLOAD_DELETE_CONDITION = "hoodie.payload.delete.condition";
        this.PAYLOAD_UPDATE_CONDITION_AND_ASSIGNMENTS = "hoodie.payload.update.condition.assignments";
        this.PAYLOAD_INSERT_CONDITION_AND_ASSIGNMENTS = "hoodie.payload.insert.condition.assignments";
        this.PAYLOAD_RECORD_AVRO_SCHEMA = "hoodie.payload.record.schema";
        this.projectionsCache = ThreadLocal.withInitial(new Supplier<Cache<Tuple2<String, Schema>, Seq<Tuple2<package.Projection, package.Projection>>>>(){

            public Cache<Tuple2<String, Schema>, Seq<Tuple2<package.Projection, package.Projection>>> get() {
                return Caffeine.newBuilder().maximumSize(1024L).build();
            }
        });
        this.avroDeserializerCache = ThreadLocal.withInitial(new Supplier<Cache<Schema, HoodieAvroDeserializer>>(){

            public Cache<Schema, HoodieAvroDeserializer> get() {
                return Caffeine.newBuilder().maximumSize(16L).build();
            }
        });
        this.avroSerializerCache = ThreadLocal.withInitial(new Supplier<Cache<Schema, HoodieAvroSerializer>>(){

            public Cache<Schema, HoodieAvroSerializer> get() {
                return Caffeine.newBuilder().maximumSize(16L).build();
            }
        });
        this.schemaCache = Caffeine.newBuilder().maximumSize(16L).build();
        this.mergedSchemaCache = Caffeine.newBuilder().maximumSize(16L).build();
    }
}

