/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.function.Supplier;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.HelpProcedure$;
import org.apache.spark.sql.hudi.command.procedures.HoodieProcedures$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001E\u0011Q\u0002S3maB\u0013xnY3ekJ,'BA\u0002\u0005\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003\u000b\u0019\tqaY8n[\u0006tGM\u0003\u0002\b\u0011\u0005!\u0001.\u001e3j\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\u0011\u0001!CF\r\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJ\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\u0006\u0002\u0011%tG/\u001a:oC2L!AH\u000e\u0003\u000f1{wmZ5oO\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003'\u0001Aq\u0001\n\u0001C\u0002\u0013%Q%\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012A\n\t\u0004O)bS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Mi\u0013B\u0001\u0018\u0003\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\t\rA\u0002\u0001\u0015!\u0003'\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\t\u000fI\u0002!\u0019!C\u0005g\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005!\u0004CA\u001b9\u001b\u00051$BA\u001c\t\u0003\u0015!\u0018\u0010]3t\u0013\tIdG\u0001\u0006TiJ,8\r\u001e+za\u0016Daa\u000f\u0001!\u0002\u0013!\u0014\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0003\"B\u001f\u0001\t\u0003r\u0014a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:,\u0012a\u0010\t\u0003\u0001\u000es!aJ!\n\u0005\tC\u0013A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n11\u000b\u001e:j]\u001eT!A\u0011\u0015\t\u000b\u001d\u0003A\u0011A\u0013\u0002\u0015A\f'/Y7fi\u0016\u00148\u000fC\u0003J\u0001\u0011\u00051'\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016DQa\u0013\u0001\u0005B1\u000bAaY1mYR\u0011Q*\u0018\t\u0004\u001dZKfBA(U\u001d\t\u00016+D\u0001R\u0015\t\u0011\u0006#\u0001\u0004=e>|GOP\u0005\u0002S%\u0011Q\u000bK\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006LA\u0002TKFT!!\u0016\u0015\u0011\u0005i[V\"\u0001\u0005\n\u0005qC!a\u0001*po\")aL\u0013a\u0001?\u0006!\u0011M]4t!\t\u0019\u0002-\u0003\u0002b\u0005\ti\u0001K]8dK\u0012,(/Z!sONDQa\u0019\u0001\u0005\u0002\u0011\fA\u0002\\3oORDgi\u001c:nCR$\"aP3\t\u000b\u0019\u0014\u0007\u0019A \u0002\rM$(/\u001b8h\u0011\u0015A\u0007\u0001\"\u0011j\u0003\u0015\u0011W/\u001b7e+\u0005\u0011s!B6\u0003\u0011\u0003a\u0017!\u0004%fYB\u0004&o\\2fIV\u0014X\r\u0005\u0002\u0014[\u001a)\u0011A\u0001E\u0001]N\u0011Qn\u001c\t\u0003OAL!!\u001d\u0015\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0001S\u000e\"\u0001t)\u0005a\u0007bB;n\u0005\u0004%\tA^\u0001\u0005\u001d\u0006kU)F\u0001x!\tAX0D\u0001z\u0015\tQ80\u0001\u0003mC:<'\"\u0001?\u0002\t)\fg/Y\u0005\u0003\tfDaa`7!\u0002\u00139\u0018!\u0002(B\u001b\u0016\u0003\u0003bBA\u0002[\u0012\u0005\u0011QA\u0001\bEVLG\u000eZ3s+\t\t9\u0001E\u0003\u0002\n\u0005Ma#\u0004\u0002\u0002\f)!\u0011QBA\b\u0003!1WO\\2uS>t'bAA\tw\u0006!Q\u000f^5m\u0013\u0011\t)\"a\u0003\u0003\u0011M+\b\u000f\u001d7jKJ\u0004")
public class HelpProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return HelpProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return HelpProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public String description() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The procedure help command allows you to view all the commands currently provided, as well as their parameters and output fields."})).s((Seq)Nil$.MODULE$);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        Seq seq;
        super.checkArgs(this.PARAMETERS(), args2);
        String line = "\n";
        String tab = "\t";
        if (args2.map().isEmpty()) {
            Map<String, Supplier<ProcedureBuilder>> procedures = HoodieProcedures$.MODULE$.procedures();
            StringBuilder result = new StringBuilder();
            result.append("synopsis").append(line).append(tab).append("call [command]([key1]=>[value1],[key2]=>[value2])").append(line);
            result.append("commands and description").append(line);
            procedures.keySet().foreach((Function1)new Serializable(this, line, tab, procedures, result){
                public static final long serialVersionUID = 0L;
                private final String line$1;
                private final String tab$1;
                private final Map procedures$1;
                private final StringBuilder result$1;

                public final Object apply(String name) {
                    BoxedUnit boxedUnit;
                    Option builderSupplier = this.procedures$1.get((Object)name);
                    if (builderSupplier.isDefined()) {
                        Procedure procedure = ((ProcedureBuilder)((Supplier)builderSupplier.get()).get()).build();
                        boxedUnit = this.result$1.append(this.tab$1).append(name).append(this.tab$1).append(procedure.description()).append(this.line$1);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                {
                    this.line$1 = line$1;
                    this.tab$1 = tab$1;
                    this.procedures$1 = procedures$1;
                    this.result$1 = result$1;
                }
            });
            result.append("You can use 'call help(cmd=>[command])' to view the detailed parameters of the command").append(line);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result.toString()}))}));
        } else {
            Option<Object> cmdOpt = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
            Predef$.MODULE$.assert(cmdOpt.isDefined(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The cmd parameter is required";
                }
            });
            String cmd = (String)cmdOpt.get();
            Map<String, Supplier<ProcedureBuilder>> procedures = HoodieProcedures$.MODULE$.procedures();
            Option builderSupplier = procedures.get((Object)cmd.trim());
            if (builderSupplier.isEmpty()) {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"can not find ", " command in procedures."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cmd})));
            }
            Procedure procedure = ((ProcedureBuilder)((Supplier)builderSupplier.get()).get()).build();
            StringBuilder result = new StringBuilder();
            result.append("parameters:").append(line);
            result.append(tab).append(this.lengthFormat("param")).append(tab).append(this.lengthFormat("type_name")).append(tab).append(this.lengthFormat("default_value")).append(tab).append(this.lengthFormat("required")).append(line);
            Predef$.MODULE$.refArrayOps((Object[])procedure.parameters()).foreach((Function1)new Serializable(this, line, tab, result){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HelpProcedure $outer;
                private final String line$1;
                private final String tab$1;
                private final StringBuilder result$2;

                public final StringBuilder apply(ProcedureParameter param) {
                    return this.result$2.append(this.tab$1).append(this.$outer.lengthFormat(param.name())).append(this.tab$1).append(this.$outer.lengthFormat(param.dataType().typeName())).append(this.tab$1).append(this.$outer.lengthFormat(param.default().toString())).append(this.tab$1).append(this.$outer.lengthFormat(((Object)BoxesRunTime.boxToBoolean((boolean)param.required())).toString())).append(this.line$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.line$1 = line$1;
                    this.tab$1 = tab$1;
                    this.result$2 = result$2;
                }
            });
            result.append("outputType:").append(line);
            result.append(tab).append(this.lengthFormat("name")).append(tab).append(this.lengthFormat("type_name")).append(tab).append(this.lengthFormat("nullable")).append(tab).append(this.lengthFormat("metadata")).append(line);
            procedure.outputType().map((Function1)new Serializable(this, line, tab, result){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HelpProcedure $outer;
                private final String line$1;
                private final String tab$1;
                private final StringBuilder result$2;

                public final StringBuilder apply(StructField field) {
                    return this.result$2.append(this.tab$1).append(this.$outer.lengthFormat(field.name())).append(this.tab$1).append(this.$outer.lengthFormat(field.dataType().typeName())).append(this.tab$1).append(this.$outer.lengthFormat(((Object)BoxesRunTime.boxToBoolean((boolean)field.nullable())).toString())).append(this.tab$1).append(this.$outer.lengthFormat(field.metadata().toString())).append(this.line$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.line$1 = line$1;
                    this.tab$1 = tab$1;
                    this.result$2 = result$2;
                }
            }, Seq$.MODULE$.canBuildFrom());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result.toString()}))}));
        }
        return seq;
    }

    public String lengthFormat(String string) {
        return String.format("%-30s", string);
    }

    @Override
    public HelpProcedure build() {
        return new HelpProcedure();
    }

    public HelpProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "cmd", DataTypes.StringType, None$.MODULE$)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

