/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.BaseHoodieTableFileIndex;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RunClusteringProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0001E\u0011aCU;o\u00072,8\u000f^3sS:<\u0007K]8dK\u0012,(/\u001a\u0006\u0003\u0007\u0011\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t)a!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u001dA\u0011\u0001\u00025vI&T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\n\u00173\u0005\u0002\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t\u0019r#\u0003\u0002\u0019\u0005\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM\u001d\t\u00035}i\u0011a\u0007\u0006\u00039u\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011a\u0004C\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0001e\u0007\u0002\u0010!J,G-[2bi\u0016DU\r\u001c9feB\u0011!%J\u0007\u0002G)\u0011AEC\u0001\tS:$XM\u001d8bY&\u0011ae\t\u0002\b\u0019><w-\u001b8h\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002\u0014\u0001!9A\u0006\u0001b\u0001\n\u0013i\u0013A\u0003)B%\u0006kU\tV#S'V\ta\u0006E\u00020eQj\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003'UJ!A\u000e\u0002\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM\u001d\u0005\u0007q\u0001\u0001\u000b\u0011\u0002\u0018\u0002\u0017A\u000b%+Q'F)\u0016\u00136\u000b\t\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0003-yU\u000b\u0016)V)~#\u0016\fU#\u0016\u0003q\u0002\"!\u0010!\u000e\u0003yR!a\u0010\u0005\u0002\u000bQL\b/Z:\n\u0005\u0005s$AC*ueV\u001cG\u000fV=qK\"11\t\u0001Q\u0001\nq\nAbT+U!V#v\fV-Q\u000b\u0002BQ!\u0012\u0001\u0005\u00025\n!\u0002]1sC6,G/\u001a:t\u0011\u00159\u0005\u0001\"\u0001<\u0003)yW\u000f\u001e9viRK\b/\u001a\u0005\u0006\u0013\u0002!\tES\u0001\u0005G\u0006dG\u000e\u0006\u0002L7B\u0019A\nV,\u000f\u00055\u0013fB\u0001(R\u001b\u0005y%B\u0001)\u0011\u0003\u0019a$o\\8u}%\t\u0011'\u0003\u0002Ta\u00059\u0001/Y2lC\u001e,\u0017BA+W\u0005\r\u0019V-\u001d\u0006\u0003'B\u0002\"\u0001W-\u000e\u0003!I!A\u0017\u0005\u0003\u0007I{w\u000fC\u0003]\u0011\u0002\u0007Q,\u0001\u0003be\u001e\u001c\bCA\n_\u0013\ty&AA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm\u001d\u0005\u0006C\u0002!\tEY\u0001\u0006EVLG\u000eZ\u000b\u0002GB\u00111\u0003Z\u0005\u0003K\n\u0011\u0011\u0002\u0015:pG\u0016$WO]3\t\u000b\u001d\u0004A\u0011\u00015\u0002\u001dA\u0014XO\\3QCJ$\u0018\u000e^5p]R\u0019\u0011\u000e]>\u0011\u0005)lgBA\u0018l\u0013\ta\u0007'\u0001\u0004Qe\u0016$WMZ\u0005\u0003]>\u0014aa\u0015;sS:<'B\u000171\u0011\u0015\th\r1\u0001s\u0003)iW\r^1DY&,g\u000e\u001e\t\u0003gfl\u0011\u0001\u001e\u0006\u0003kZ\fQ\u0001^1cY\u0016T!a\u001e=\u0002\r\r|W.\\8o\u0015\t9A\"\u0003\u0002{i\n)\u0002j\\8eS\u0016$\u0016M\u00197f\u001b\u0016$\u0018m\u00117jK:$\b\"\u0002?g\u0001\u0004I\u0017!\u00039sK\u0012L7-\u0019;f\u0011\u0015q\b\u0001\"\u0003\u0000\u0003Q1\u0018\r\\5eCR,wJ\u001d3fe\u000e{G.^7ogR1\u0011\u0011AA\u0004\u0003\u0017\u00012aLA\u0002\u0013\r\t)\u0001\r\u0002\u0005+:LG\u000f\u0003\u0004\u0002\nu\u0004\r![\u0001\r_J$WM]\"pYVlgn\u001d\u0005\u0006cv\u0004\rA\u001d\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0003u\u0019\u0007.Z2l\u0003:$g)\u001b7uKJ\u0004VM\u001c3j]\u001eLen\u001d;b]R\u001cHCBA\n\u0003+\tI\u0002E\u0002M)&D\u0001\"a\u0006\u0002\u000e\u0001\u0007\u00111C\u0001\u0010a\u0016tG-\u001b8h\u0013:\u001cH/\u00198ug\"9\u00111DA\u0007\u0001\u0004I\u0017AC5ogR\fg\u000e^*ue\u001e9\u0011q\u0004\u0002\t\u0002\u0005\u0005\u0012A\u0006*v]\u000ecWo\u001d;fe&tw\r\u0015:pG\u0016$WO]3\u0011\u0007M\t\u0019C\u0002\u0004\u0002\u0005!\u0005\u0011QE\n\u0005\u0003G\t9\u0003E\u00020\u0003SI1!a\u000b1\u0005\u0019\te.\u001f*fM\"9\u0001&a\t\u0005\u0002\u0005=BCAA\u0011\u0011)\t\u0019$a\tC\u0002\u0013\u0005\u0011QG\u0001\u0005\u001d\u0006kU)\u0006\u0002\u00028A!\u0011\u0011HA\"\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012\u0001\u00027b]\u001eT!!!\u0011\u0002\t)\fg/Y\u0005\u0004]\u0006m\u0002\"CA$\u0003G\u0001\u000b\u0011BA\u001c\u0003\u0015q\u0015)T#!\u0011!\tY%a\t\u0005\u0002\u00055\u0013a\u00022vS2$WM]\u000b\u0003\u0003\u001f\u0002R!!\u0015\u0002\\Yi!!a\u0015\u000b\t\u0005U\u0013qK\u0001\tMVt7\r^5p]*!\u0011\u0011LA \u0003\u0011)H/\u001b7\n\t\u0005u\u00131\u000b\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class RunClusteringProcedure
extends BaseProcedure
implements ProcedureBuilder,
PredicateHelper,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RunClusteringProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RunClusteringProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitConjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitDisjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.class.replaceAlias((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.class.canEvaluate((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.class.canEvaluateWithinJoin((PredicateHelper)this, (Expression)expr);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        Seq<String> seq;
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        Option<Object> tablePath = this.getArgValueOrDefault(args2, this.PARAMETERS()[1]);
        Option<Object> predicate = this.getArgValueOrDefault(args2, this.PARAMETERS()[2]);
        Option<Object> orderColumns = this.getArgValueOrDefault(args2, this.PARAMETERS()[3]);
        boolean showInvolvedPartitions = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[4]).get());
        Option<Object> op = this.getArgValueOrDefault(args2, this.PARAMETERS()[5]);
        Option<Object> orderStrategy = this.getArgValueOrDefault(args2, this.PARAMETERS()[6]);
        Option<Object> options = this.getArgValueOrDefault(args2, this.PARAMETERS()[7]);
        Option<Object> instantsStr = this.getArgValueOrDefault(args2, this.PARAMETERS()[8]);
        String basePath = this.getBasePath(tableName, tablePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        ObjectRef conf = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        Option<Object> option2 = predicate;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Object p = some.x();
            String prunedPartitions = this.prunePartition(metaClient, (String)p);
            conf.elem = ((Map)conf.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME.key()), (Object)"SELECTED_PARTITIONS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.PARTITION_SELECTED.key()), (Object)prunedPartitions)})));
            this.logInfo((Function0<String>)new Serializable(this, p, prunedPartitions){
                public static final long serialVersionUID = 0L;
                private final Object p$1;
                private final String prunedPartitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition predicates: ", ", partition selected: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.p$1, this.prunedPartitions$1}));
                }
                {
                    this.p$1 = p$1;
                    this.prunedPartitions$1 = prunedPartitions$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No partition predicates";
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Option<Object> option3 = orderColumns;
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            Object o = some.x();
            this.validateOrderColumns((String)o, metaClient);
            conf.elem = ((Map)conf.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key()), (Object)((String)o))})));
            this.logInfo((Function0<String>)new Serializable(this, o){
                public static final long serialVersionUID = 0L;
                private final Object o$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Order columns: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.o$1}));
                }
                {
                    this.o$1 = o$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No order columns";
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Option<Object> option4 = orderStrategy;
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            Object o = some.x();
            HoodieClusteringConfig.LayoutOptimizationStrategy strategy = HoodieClusteringConfig.LayoutOptimizationStrategy.fromValue((String)o);
            conf.elem = ((Map)conf.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.LAYOUT_OPTIMIZE_STRATEGY.key()), (Object)strategy.getValue())})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No order strategy";
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Option<Object> option5 = options;
        if (option5 instanceof Some) {
            Some some = (Some)option5;
            Object p = some.x();
            Buffer paramPairs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(StringUtils.split((String)p, ",")).asScala();
            paramPairs.foreach((Function1)new Serializable(this, conf){
                public static final long serialVersionUID = 0L;
                private final ObjectRef conf$1;

                public final void apply(String pair) {
                    List<String> values2 = StringUtils.split(pair, "=");
                    this.conf$1.elem = ((Map)this.conf$1.elem).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)values2.get(0)), (Object)values2.get(1))})));
                }
                {
                    this.conf$1 = conf$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No options";
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ObjectRef pendingClustering = ObjectRef.create((Object)((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ClusteringUtils.getAllPendingClusteringPlans(metaClient).iterator()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Pair<HoodieInstant, HoodieClusteringPlan> x$1) {
                return x$1.getLeft().getTimestamp();
            }
        }).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String f) {
                return f;
            }
        }, (Ordering)Ordering.String$.MODULE$)));
        HoodieClusteringConfig.ClusteringOperator operator = HoodieClusteringConfig.ClusteringOperator.SCHEDULE_AND_EXECUTE;
        Option<Object> option6 = instantsStr;
        if (option6 instanceof Some) {
            Some some = (Some)option6;
            Object inst = some.x();
            Option<Object> option7 = op;
            if (option7 instanceof Some) {
                Some some2 = (Some)option7;
                Object o = some2.x();
                if (!HoodieClusteringConfig.ClusteringOperator.EXECUTE.name().equalsIgnoreCase((String)o)) throw new HoodieClusteringException("specific instants only can be used in 'execute' op or not specific op");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No op and set it to EXECUTE with instants specified.";
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            operator = HoodieClusteringConfig.ClusteringOperator.EXECUTE;
            seq = this.checkAndFilterPendingInstants((Seq<String>)((Seq)pendingClustering.elem), (String)inst);
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No specific instants";
                }
            });
            Option<Object> option8 = op;
            if (option8 instanceof Some) {
                Some some = (Some)option8;
                Object o = some.x();
                operator = HoodieClusteringConfig.ClusteringOperator.fromValue(((String)o).toLowerCase(Locale.ROOT));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No op, use default scheduleAndExecute";
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            seq = (Seq<String>)pendingClustering.elem;
        }
        pendingClustering.elem = seq;
        this.logInfo((Function0<String>)new Serializable(this, pendingClustering){
            public static final long serialVersionUID = 0L;
            private final ObjectRef pendingClustering$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pending clustering instants: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Seq)this.pendingClustering$1.elem).mkString(",")}));
            }
            {
                this.pendingClustering$1 = pendingClustering$1;
            }
        });
        ObjectRef client = ObjectRef.create(null);
        try {
            String instantTime;
            client.elem = HoodieCLIUtils$.MODULE$.createHoodieClientFromPath(this.sparkSession(), basePath, (Map<String, String>)((Map)conf.elem));
            if (operator.isSchedule() && ((SparkRDDWriteClient)client.elem).scheduleClusteringAtInstant(instantTime = HoodieActiveTimeline.createNewInstantTime(), org.apache.hudi.common.util.Option.empty())) {
                pendingClustering.elem = (Seq)((Seq)pendingClustering.elem).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{instantTime})), Seq$.MODULE$.canBuildFrom());
            }
            this.logInfo((Function0<String>)new Serializable(this, pendingClustering){
                public static final long serialVersionUID = 0L;
                private final ObjectRef pendingClustering$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Clustering instants to run: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Seq)this.pendingClustering$1.elem).mkString(",")}));
                }
                {
                    this.pendingClustering$1 = pendingClustering$1;
                }
            });
            if (operator.isExecute()) {
                long startTs = System.currentTimeMillis();
                ((Seq)pendingClustering.elem).foreach((Function1)new Serializable(this, client){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef client$1;

                    public final HoodieWriteMetadata<JavaRDD<WriteStatus>> apply(String x$2) {
                        return ((SparkRDDWriteClient)this.client$1.elem).cluster(x$2, true);
                    }
                    {
                        this.client$1 = client$1;
                    }
                });
                this.logInfo((Function0<String>)new Serializable(this, pendingClustering, startTs){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef pendingClustering$1;
                    private final long startTs$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finish clustering all the instants: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Seq)this.pendingClustering$1.elem).mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" time cost: ", "ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.startTs$1))}))).toString();
                    }
                    {
                        this.pendingClustering$1 = pendingClustering$1;
                        this.startTs$1 = startTs$1;
                    }
                });
            }
            Seq clusteringInstants = (Seq)((SeqLike)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metaClient.reloadActiveTimeline().getInstants().iterator()).asScala()).filter((Function1)new Serializable(this, pendingClustering){
                public static final long serialVersionUID = 0L;
                private final ObjectRef pendingClustering$1;

                public final boolean apply(HoodieInstant p) {
                    String string = p.getAction();
                    String string2 = "replacecommit";
                    return !(string != null ? !string.equals(string2) : string2 != null) && ((Seq)this.pendingClustering$1.elem).contains((Object)p.getTimestamp());
                }
                {
                    this.pendingClustering$1 = pendingClustering$1;
                }
            }).toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(HoodieInstant f) {
                    return f.getTimestamp();
                }
            }, (Ordering)Ordering.String$.MODULE$)).reverse();
            Seq clusteringPlans = (Seq)clusteringInstants.map((Function1)new Serializable(this, metaClient){
                public static final long serialVersionUID = 0L;
                private final HoodieTableMetaClient metaClient$1;

                public final org.apache.hudi.common.util.Option<Pair<HoodieInstant, HoodieClusteringPlan>> apply(HoodieInstant instant) {
                    return ClusteringUtils.getClusteringPlan(this.metaClient$1, instant);
                }
                {
                    this.metaClient$1 = metaClient$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq seq2 = showInvolvedPartitions ? (Seq)clusteringPlans.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Row apply(org.apache.hudi.common.util.Option<Pair<HoodieInstant, HoodieClusteringPlan>> p) {
                    return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p.get().getLeft().getTimestamp(), BoxesRunTime.boxToInteger((int)p.get().getRight().getInputGroups().size()), p.get().getLeft().getState().name(), HoodieCLIUtils$.MODULE$.extractPartitions((Seq<HoodieClusteringGroup>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(p.get().getRight().getInputGroups()).asScala()))}));
                }
            }, Seq$.MODULE$.canBuildFrom()) : (Seq)clusteringPlans.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Row apply(org.apache.hudi.common.util.Option<Pair<HoodieInstant, HoodieClusteringPlan>> p) {
                    return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p.get().getLeft().getTimestamp(), BoxesRunTime.boxToInteger((int)p.get().getRight().getInputGroups().size()), p.get().getLeft().getState().name(), "*"}));
                }
            }, Seq$.MODULE$.canBuildFrom());
            return seq2;
        }
        finally {
            if ((SparkRDDWriteClient)client.elem != null) {
                ((SparkRDDWriteClient)client.elem).close();
            }
        }
    }

    @Override
    public Procedure build() {
        return new RunClusteringProcedure();
    }

    public String prunePartition(HoodieTableMetaClient metaClient, String predicate) {
        Map options = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)metaClient.getBasePath())}));
        HoodieFileIndex hoodieFileIndex = new HoodieFileIndex(this.sparkSession(), metaClient, (Option<StructType>)None$.MODULE$, (Map<String, String>)options, FileStatusCache$.MODULE$.getOrCreate(this.sparkSession()));
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        StructType tableSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schemaResolver.getTableAvroSchema());
        Expression condition = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr(this.sparkSession(), predicate, tableSchema);
        String[] partitionColumns = metaClient.getTableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        Tuple2<Expression[], Expression[]> tuple2 = HoodieCatalystExpressionUtils$.MODULE$.splitPartitionAndDataPredicates(this.sparkSession(), (Expression[])this.splitConjunctivePredicates(condition).toArray(ClassTag$.MODULE$.apply(Expression.class)), partitionColumns);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Expression[] partitionPredicates = (Expression[])tuple2._1();
            Expression[] dataPredicates = (Expression[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionPredicates, (Object)dataPredicates);
            Expression[] partitionPredicates2 = (Expression[])tuple23._1();
            Expression[] dataPredicates2 = (Expression[])tuple23._2();
            ValidationUtils.checkArgument(Predef$.MODULE$.refArrayOps((Object[])dataPredicates2).isEmpty(), "Only partition predicates are allowed");
            Seq<BaseHoodieTableFileIndex.PartitionPath> prunedPartitions = hoodieFileIndex.getPartitionPaths((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])partitionPredicates2));
            return ((TraversableOnce)prunedPartitions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(BaseHoodieTableFileIndex.PartitionPath partitionPath) {
                    return partitionPath.getPath();
                }
            }, Seq$.MODULE$.canBuildFrom())).toSet().mkString(",");
        }
        throw new MatchError(tuple2);
    }

    private void validateOrderColumns(String orderColumns, HoodieTableMetaClient metaClient) {
        if (orderColumns == null) {
            throw new HoodieClusteringException("Order columns is null");
        }
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(metaClient);
        Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableSchemaResolver.getTableAvroSchema(false).getFields()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Schema.Field x$4) {
                return x$4.name().toLowerCase();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.refArrayOps((Object[])orderColumns.split(",")).foreach((Function1)new Serializable(this, fields){
            public static final long serialVersionUID = 0L;
            private final Buffer fields$1;

            public final void apply(String col) {
                if (this.fields$1.contains((Object)col.toLowerCase())) {
                    return;
                }
                throw new HoodieClusteringException(new StringBuilder().append((Object)"Order column not exist:").append((Object)col).toString());
            }
            {
                this.fields$1 = fields$1;
            }
        });
    }

    private Seq<String> checkAndFilterPendingInstants(Seq<String> pendingInstants, String instantStr) {
        Set pendingSet;
        Buffer instants = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(StringUtils.split(instantStr, ",")).asScala();
        Buffer noneInstants = (Buffer)instants.filter((Function1)new Serializable(this, pendingSet = pendingInstants.toSet()){
            public static final long serialVersionUID = 0L;
            private final Set pendingSet$1;

            public final boolean apply(String ins) {
                return !this.pendingSet$1.contains((Object)ins);
            }
            {
                this.pendingSet$1 = pendingSet$1;
            }
        });
        if (noneInstants.nonEmpty()) {
            throw new HoodieClusteringException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"specific ", " instants is not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{noneInstants.mkString(",")})));
        }
        return (Seq)instants.sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String f) {
                return f;
            }
        }, (Ordering)Ordering.String$.MODULE$);
    }

    public RunClusteringProcedure() {
        PredicateHelper.class.$init$((PredicateHelper)this);
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "path", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(2, "predicate", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(3, "order", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(4, "show_involved_partition", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(5, "op", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(6, "order_strategy", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(7, "options", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(8, "instants", DataTypes.StringType, None$.MODULE$)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("timestamp", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("input_group_size", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("state", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("involved_partitions", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

