/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitPartitionsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u0001E\u0011Qd\u00155po\u000e{W.\\5u!\u0006\u0014H/\u001b;j_:\u001c\bK]8dK\u0012,(/\u001a\u0006\u0003\u0007\u0011\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t)a!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u001dA\u0011\u0001\u00025vI&T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\b\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\t\u0019\u0002\u0001C\u0004\u001f\u0001\t\u0007I\u0011B\u0010\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u0001!!\r\tCEJ\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t)\u0011I\u001d:bsB\u00111cJ\u0005\u0003Q\t\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\"1!\u0006\u0001Q\u0001\n\u0001\n1\u0002U!S\u00036+E+\u0012*TA!9A\u0006\u0001b\u0001\n\u0013i\u0013aC(V)B+Fk\u0018+Z!\u0016+\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0003c!\tQ\u0001^=qKNL!a\r\u0019\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u00046\u0001\u0001\u0006IAL\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\t\t\u0005\u0006o\u0001!\taH\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\"B\u001d\u0001\t\u0003i\u0013AC8viB,H\u000fV=qK\")1\b\u0001C!y\u0005!1-\u00197m)\tiT\nE\u0002?\r&s!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\t\u0003\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\t)%%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%aA*fc*\u0011QI\t\t\u0003\u0015.k\u0011\u0001C\u0005\u0003\u0019\"\u00111AU8x\u0011\u0015q%\b1\u0001P\u0003\u0011\t'oZ:\u0011\u0005M\u0001\u0016BA)\u0003\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\")1\u000b\u0001C!)\u0006)!-^5mIV\tQ\u000b\u0005\u0002\u0014-&\u0011qK\u0001\u0002\n!J|7-\u001a3ve\u0016DQ!\u0017\u0001\u0005\ni\u000b1cZ3u\u0007>lW.\u001b;G_JLen\u001d;b]R$2aW5n!\r\tCLX\u0005\u0003;\n\u0012aa\u00149uS>t\u0007CA0h\u001b\u0005\u0001'BA1c\u0003!!\u0018.\\3mS:,'BA2e\u0003\u0015!\u0018M\u00197f\u0015\t)g-\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f1I!\u0001\u001b1\u0003\u001b!{w\u000eZ5f\u0013:\u001cH/\u00198u\u0011\u0015\t\u0007\f1\u0001k!\ty6.\u0003\u0002mA\nq\u0001j\\8eS\u0016$\u0016.\\3mS:,\u0007\"\u00028Y\u0001\u0004y\u0017aC5ogR\fg\u000e\u001e+j[\u0016\u0004\"\u0001]:\u000f\u0005\u0005\n\u0018B\u0001:#\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u0014\u0003\"B<\u0001\t\u0013A\u0018aF4fi\"{w\u000eZ5f\u0007>lW.\u001b;NKR\fG-\u0019;b)\u0015I\u0018\u0011AA\u0002!\r\tCL\u001f\t\u0003wzl\u0011\u0001 \u0006\u0003{\u0012\fQ!\\8eK2L!a ?\u0003)!{w\u000eZ5f\u0007>lW.\u001b;NKR\fG-\u0019;b\u0011\u0015\tg\u000f1\u0001k\u0011\u0019\t)A\u001ea\u00017\u0006i\u0001n\\8eS\u0016Len\u001d;b]R<q!!\u0003\u0003\u0011\u0003\tY!A\u000fTQ><8i\\7nSR\u0004\u0016M\u001d;ji&|gn\u001d)s_\u000e,G-\u001e:f!\r\u0019\u0012Q\u0002\u0004\u0007\u0003\tA\t!a\u0004\u0014\t\u00055\u0011\u0011\u0003\t\u0004C\u0005M\u0011bAA\u000bE\t1\u0011I\\=SK\u001aDqAGA\u0007\t\u0003\tI\u0002\u0006\u0002\u0002\f!Q\u0011QDA\u0007\u0005\u0004%\t!a\b\u0002\t9\u000bU*R\u000b\u0003\u0003C\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0003mC:<'BAA\u0016\u0003\u0011Q\u0017M^1\n\u0007Q\f)\u0003C\u0005\u00022\u00055\u0001\u0015!\u0003\u0002\"\u0005)a*Q'FA!A\u0011QGA\u0007\t\u0003\t9$A\u0004ck&dG-\u001a:\u0016\u0005\u0005e\u0002#BA\u001e\u0003\u000b2RBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u0011\u0019,hn\u0019;j_:TA!a\u0011\u0002*\u0005!Q\u000f^5m\u0013\u0011\t9%!\u0010\u0003\u0011M+\b\u000f\u001d7jKJ\u0004")
public class ShowCommitPartitionsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(2, "instant_time", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_files_added", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_inserted", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitPartitionsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitPartitionsProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        String table = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get());
        String instantTime = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[2]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieInstant> hoodieInstantOption = this.getCommitForInstant(timeline, instantTime);
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption);
        if (commitMetadataOptional.isEmpty()) {
            throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Commit ", " not found in Commits ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instantTime, timeline})));
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        ArrayList rows = new ArrayList();
        JavaConversions$.MODULE$.asScalaSet(meta.getPartitionToWriteStats().entrySet()).foreach((Function1)new Serializable(this, hoodieInstantOption, rows){
            public static final long serialVersionUID = 0L;
            private final Option hoodieInstantOption$1;
            private final ArrayList rows$1;

            public final boolean apply(Map.Entry<String, List<HoodieWriteStat>> entry) {
                String action = ((HoodieInstant)this.hoodieInstantOption$1.get()).getAction();
                String path = entry.getKey();
                List<HoodieWriteStat> stats = entry.getValue();
                LongRef totalFilesAdded = LongRef.create((long)0L);
                LongRef totalFilesUpdated = LongRef.create((long)0L);
                LongRef totalRecordsUpdated = LongRef.create((long)0L);
                LongRef totalRecordsInserted = LongRef.create((long)0L);
                LongRef totalBytesWritten = LongRef.create((long)0L);
                LongRef totalWriteErrors = LongRef.create((long)0L);
                JavaConversions$.MODULE$.asScalaBuffer(stats).foreach((Function1)new Serializable(this, totalFilesAdded, totalFilesUpdated, totalRecordsUpdated, totalRecordsInserted, totalBytesWritten, totalWriteErrors){
                    public static final long serialVersionUID = 0L;
                    private final LongRef totalFilesAdded$1;
                    private final LongRef totalFilesUpdated$1;
                    private final LongRef totalRecordsUpdated$1;
                    private final LongRef totalRecordsInserted$1;
                    private final LongRef totalBytesWritten$1;
                    private final LongRef totalWriteErrors$1;

                    public final void apply(HoodieWriteStat stat) {
                        String string = stat.getPrevCommit();
                        String string2 = "null";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            ++this.totalFilesAdded$1.elem;
                        } else {
                            ++this.totalFilesUpdated$1.elem;
                            this.totalRecordsUpdated$1.elem += stat.getNumUpdateWrites();
                        }
                        this.totalRecordsInserted$1.elem += stat.getNumInserts();
                        this.totalBytesWritten$1.elem += stat.getTotalWriteBytes();
                        this.totalWriteErrors$1.elem += stat.getTotalWriteErrors();
                    }
                    {
                        this.totalFilesAdded$1 = totalFilesAdded$1;
                        this.totalFilesUpdated$1 = totalFilesUpdated$1;
                        this.totalRecordsUpdated$1 = totalRecordsUpdated$1;
                        this.totalRecordsInserted$1 = totalRecordsInserted$1;
                        this.totalBytesWritten$1 = totalBytesWritten$1;
                        this.totalWriteErrors$1 = totalWriteErrors$1;
                    }
                });
                return this.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, path, BoxesRunTime.boxToLong((long)totalFilesAdded.elem), BoxesRunTime.boxToLong((long)totalFilesUpdated.elem), BoxesRunTime.boxToLong((long)totalRecordsInserted.elem), BoxesRunTime.boxToLong((long)totalRecordsUpdated.elem), BoxesRunTime.boxToLong((long)totalBytesWritten.elem), BoxesRunTime.boxToLong((long)totalWriteErrors.elem)})));
            }
            {
                this.hoodieInstantOption$1 = hoodieInstantOption$1;
                this.rows$1 = rows$1;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return (Row)r;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowCommitPartitionsProcedure();
    }

    private Option<HoodieInstant> getCommitForInstant(HoodieTimeline timeline, String instantTime) {
        List<Object> instants = Arrays.asList((Object[])new HoodieInstant[]{new HoodieInstant(false, "commit", instantTime), new HoodieInstant(false, "replacecommit", instantTime), new HoodieInstant(false, "deltacommit", instantTime)});
        Option hoodieInstant = JavaConversions$.MODULE$.asScalaBuffer(instants).find((Function1)new Serializable(this, timeline){
            public static final long serialVersionUID = 0L;
            private final HoodieTimeline timeline$1;

            public final boolean apply(HoodieInstant i) {
                return this.timeline$1.containsInstant(i);
            }
            {
                this.timeline$1 = timeline$1;
            }
        });
        return hoodieInstant;
    }

    private Option<HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTimeline timeline, Option<HoodieInstant> hoodieInstant) {
        Option option2;
        if (hoodieInstant.isDefined()) {
            String string = ((HoodieInstant)hoodieInstant.get()).getAction();
            String string2 = "replacecommit";
            option2 = !(string != null ? !string.equals(string2) : string2 != null) ? Option$.MODULE$.apply((Object)HoodieReplaceCommitMetadata.fromBytes(timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get(), HoodieReplaceCommitMetadata.class)) : Option$.MODULE$.apply((Object)HoodieCommitMetadata.fromBytes(timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get(), HoodieCommitMetadata.class));
        } else {
            option2 = Option$.MODULE$.empty();
        }
        return option2;
    }
}

