/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieMemoryConfig;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowHoodieLogFileRecordsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001#\t\t3\u000b[8x\u0011>|G-[3M_\u001e4\u0015\u000e\\3SK\u000e|'\u000fZ:Qe>\u001cW\rZ;sK*\u00111\u0001B\u0001\u000baJ|7-\u001a3ve\u0016\u001c(BA\u0003\u0007\u0003\u001d\u0019w.\\7b]\u0012T!a\u0002\u0005\u0002\t!,H-\u001b\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001I1\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u00111cF\u0005\u00031\t\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\n\u0001\u0011\u0015q\u0002\u0001\"\u0011 \u0003)\u0001\u0018M]1nKR,'o]\u000b\u0002AA\u0019\u0011\u0005\n\u0014\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012Q!\u0011:sCf\u0004\"aE\u0014\n\u0005!\u0012!A\u0005)s_\u000e,G-\u001e:f!\u0006\u0014\u0018-\\3uKJDQA\u000b\u0001\u0005B-\n!b\\;uaV$H+\u001f9f+\u0005a\u0003CA\u00171\u001b\u0005q#BA\u0018\t\u0003\u0015!\u0018\u0010]3t\u0013\t\tdF\u0001\u0006TiJ,8\r\u001e+za\u0016DQa\r\u0001\u0005BQ\nAaY1mYR\u0011Q'\u0012\t\u0004my\neBA\u001c=\u001d\tA4(D\u0001:\u0015\tQ\u0004#\u0001\u0004=e>|GOP\u0005\u0002G%\u0011QHI\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0004IA\u0002TKFT!!\u0010\u0012\u0011\u0005\t\u001bU\"\u0001\u0005\n\u0005\u0011C!a\u0001*po\")aI\ra\u0001\u000f\u0006!\u0011M]4t!\t\u0019\u0002*\u0003\u0002J\u0005\ti\u0001K]8dK\u0012,(/Z!sONDQa\u0013\u0001\u0005B1\u000bQAY;jY\u0012,\u0012!\u0014\t\u0003'9K!a\u0014\u0002\u0003\u0013A\u0013xnY3ekJ,w!B)\u0003\u0011\u0003\u0011\u0016!I*i_^Dun\u001c3jK2{wMR5mKJ+7m\u001c:egB\u0013xnY3ekJ,\u0007CA\nT\r\u0015\t!\u0001#\u0001U'\t\u0019V\u000b\u0005\u0002\"-&\u0011qK\t\u0002\u0007\u0003:L(+\u001a4\t\u000bi\u0019F\u0011A-\u0015\u0003ICqaW*C\u0002\u0013\u0005A,\u0001\u0003O\u00036+U#A/\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017\u0001\u00027b]\u001eT\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e?\n11\u000b\u001e:j]\u001eDaAZ*!\u0002\u0013i\u0016!\u0002(B\u001b\u0016\u0003\u0003\"\u00025T\t\u0003I\u0017a\u00022vS2$WM]\u000b\u0002UB\u00191\u000e\u001d\f\u000e\u00031T!!\u001c8\u0002\u0011\u0019,hn\u0019;j_:T!a\\1\u0002\tU$\u0018\u000e\\\u0005\u0003c2\u0014\u0001bU;qa2LWM\u001d")
public class ShowHoodieLogFileRecordsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    public static Supplier<ProcedureBuilder> builder() {
        return ShowHoodieLogFileRecordsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowHoodieLogFileRecordsProcedure$.MODULE$.NAME();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "log_file_path_pattern", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(2, "merge", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(3, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
    }

    @Override
    public StructType outputType() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("records", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        this.checkArgs(this.parameters(), args2);
        Option<Object> table = this.getArgValueOrDefault(args2, this.parameters()[0]);
        String logFilePathPattern = (String)this.getArgValueOrDefault(args2, this.parameters()[1]).get();
        boolean merge2 = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.parameters()[2]).get());
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args2, this.parameters()[3]).get());
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient client = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieWrapperFileSystem fs = client.getFs();
        List logFilePaths = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(FSUtils.getGlobStatusExcludingMetaFolder(fs, new Path(logFilePathPattern)).iterator()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$1) {
                return x$1.getPath().toString();
            }
        }).toList();
        ValidationUtils.checkArgument(logFilePaths.nonEmpty(), "There is no log file");
        AvroSchemaConverter converter = new AvroSchemaConverter();
        ArrayList allRecords = new ArrayList();
        if (merge2) {
            Schema schema2 = converter.convert(Objects.requireNonNull(TableSchemaResolver.readSchemaFromLogFile(fs, new Path((String)logFilePaths.last()))));
            HoodieMergedLogRecordScanner scanner = ((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withFileSystem(fs).withBasePath(basePath).withLogFilePaths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)logFilePaths).asJava())).withReaderSchema(schema2).withLatestInstantTime(client.getActiveTimeline().getCommitTimeline().lastInstant().get().getTimestamp()).withReadBlocksLazily(Boolean.parseBoolean(HoodieCompactionConfig.COMPACTION_LAZY_BLOCK_READ_ENABLE.defaultValue())).withReverseReader(Boolean.parseBoolean(HoodieCompactionConfig.COMPACTION_REVERSE_LOG_READ_ENABLE.defaultValue())).withBufferSize(Predef$.MODULE$.Integer2int(HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE.defaultValue())).withMaxMemorySizeInBytes(Predef$.MODULE$.long2Long(0x40000000L)).withSpillableMapBasePath(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.defaultValue()).withDiskMapType(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue()).withBitCaskDiskMapCompressionEnabled(Predef$.MODULE$.Boolean2boolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue())).withRecordMerger(HoodieRecordUtils.loadRecordMerger(HoodieAvroRecordMerger.class.getName())).build();
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)scanner).asScala()).foreach((Function1)new Serializable(this, limit, allRecords, schema2){
                public static final long serialVersionUID = 0L;
                private final int limit$1;
                private final java.util.List allRecords$1;
                private final Schema schema$1;

                public final Object apply(HoodieRecord<?> hoodieRecord) {
                    IndexedRecord record = ((HoodieRecordPayload)hoodieRecord.getData()).getInsertValue(this.schema$1).get();
                    return this.allRecords$1.size() < this.limit$1 ? BoxesRunTime.boxToBoolean((boolean)this.allRecords$1.add(record)) : BoxedUnit.UNIT;
                }
                {
                    this.limit$1 = limit$1;
                    this.allRecords$1 = allRecords$1;
                    this.schema$1 = schema$1;
                }
            });
        } else {
            logFilePaths.toStream().takeWhile((Function1)new Serializable(this, limit, allRecords){
                public static final long serialVersionUID = 0L;
                private final int limit$1;
                private final java.util.List allRecords$1;

                public final boolean apply(String x$2) {
                    return this.allRecords$1.size() < this.limit$1;
                }
                {
                    this.limit$1 = limit$1;
                    this.allRecords$1 = allRecords$1;
                }
            }).foreach((Function1)new Serializable(this, limit, fs, converter, allRecords){
                public static final long serialVersionUID = 0L;
                public final int limit$1;
                private final HoodieWrapperFileSystem fs$1;
                private final AvroSchemaConverter converter$1;
                public final java.util.List allRecords$1;

                public final void apply(String logFilePath) {
                    Schema schema2 = this.converter$1.convert(Objects.requireNonNull(TableSchemaResolver.readSchemaFromLogFile(this.fs$1, new Path(logFilePath))));
                    HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(this.fs$1, new HoodieLogFile(logFilePath), schema2);
                    while (reader.hasNext()) {
                        HoodieLogBlock block = (HoodieLogBlock)reader.next();
                        HoodieLogBlock hoodieLogBlock = block;
                        if (hoodieLogBlock instanceof HoodieDataBlock) {
                            HoodieDataBlock hoodieDataBlock = (HoodieDataBlock)hoodieLogBlock;
                            ClosableIterator<HoodieRecord<T>> recordItr = hoodieDataBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(recordItr).asScala()).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$call$3 $outer;

                                public final Object apply(HoodieRecord<Nothing$> record) {
                                    return this.$outer.allRecords$1.size() < this.$outer.limit$1 ? BoxesRunTime.boxToBoolean((boolean)this.$outer.allRecords$1.add((IndexedRecord)record.getData())) : BoxedUnit.UNIT;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            recordItr.close();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        throw new MatchError((Object)hoodieLogBlock);
                    }
                    reader.close();
                }
                {
                    this.limit$1 = limit$1;
                    this.fs$1 = fs$1;
                    this.converter$1 = converter$1;
                    this.allRecords$1 = allRecords$1;
                }
            });
        }
        ArrayList rows = new ArrayList(allRecords.size());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(allRecords).asScala()).foreach((Function1)new Serializable(this, rows){
            public static final long serialVersionUID = 0L;
            private final java.util.List rows$1;

            public final boolean apply(IndexedRecord record) {
                return this.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record.toString()})));
            }
            {
                this.rows$1 = rows$1;
            }
        });
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(rows).asScala();
    }

    @Override
    public Procedure build() {
        return new ShowHoodieLogFileRecordsProcedure();
    }
}

