/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowMetadataTableFilesProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001E\u0011qd\u00155po6+G/\u00193bi\u0006$\u0016M\u00197f\r&dWm\u001d)s_\u000e,G-\u001e:f\u0015\t\u0019A!\u0001\u0006qe>\u001cW\rZ;sKNT!!\u0002\u0004\u0002\u000f\r|W.\\1oI*\u0011q\u0001C\u0001\u0005QV$\u0017N\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001%YI\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u00111cF\u0005\u00031\t\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\u0011\u0005iiR\"A\u000e\u000b\u0005qQ\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005yY\"a\u0002'pO\u001eLgn\u001a\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\u0005\u0001\t\u000f\u0011\u0002!\u0019!C\u0005K\u0005Q\u0001+\u0011*B\u001b\u0016#VIU*\u0016\u0003\u0019\u00022a\n\u0016-\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#!B!se\u0006L\bCA\n.\u0013\tq#A\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\bB\u0002\u0019\u0001A\u0003%a%A\u0006Q\u0003J\u000bU*\u0012+F%N\u0003\u0003b\u0002\u001a\u0001\u0005\u0004%IaM\u0001\f\u001fV#\u0006+\u0016+`)f\u0003V)F\u00015!\t)\u0004(D\u00017\u0015\t9\u0004\"A\u0003usB,7/\u0003\u0002:m\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\rm\u0002\u0001\u0015!\u00035\u00031yU\u000b\u0016)V)~#\u0016\fU#!\u0011\u0015i\u0004\u0001\"\u0001&\u0003)\u0001\u0018M]1nKR,'o\u001d\u0005\u0006\u007f\u0001!\taM\u0001\u000b_V$\b/\u001e;UsB,\u0007\"B!\u0001\t\u0003\u0012\u0015\u0001B2bY2$\"aQ*\u0011\u0007\u0011cuJ\u0004\u0002F\u0015:\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nE\u0001\u0007yI|w\u000e\u001e \n\u0003%J!a\u0013\u0015\u0002\u000fA\f7m[1hK&\u0011QJ\u0014\u0002\u0004'\u0016\f(BA&)!\t\u0001\u0016+D\u0001\t\u0013\t\u0011\u0006BA\u0002S_^DQ\u0001\u0016!A\u0002U\u000bA!\u0019:hgB\u00111CV\u0005\u0003/\n\u0011Q\u0002\u0015:pG\u0016$WO]3Be\u001e\u001c\b\"B-\u0001\t\u0003R\u0016!\u00022vS2$W#A.\u0011\u0005Ma\u0016BA/\u0003\u0005%\u0001&o\\2fIV\u0014XmB\u0003`\u0005!\u0005\u0001-A\u0010TQ><X*\u001a;bI\u0006$\u0018\rV1cY\u00164\u0015\u000e\\3t!J|7-\u001a3ve\u0016\u0004\"aE1\u0007\u000b\u0005\u0011\u0001\u0012\u00012\u0014\u0005\u0005\u001c\u0007CA\u0014e\u0013\t)\u0007F\u0001\u0004B]f\u0014VM\u001a\u0005\u0006A\u0005$\ta\u001a\u000b\u0002A\"9\u0011.\u0019b\u0001\n\u0003Q\u0017\u0001\u0002(B\u001b\u0016+\u0012a\u001b\t\u0003YFl\u0011!\u001c\u0006\u0003]>\fA\u0001\\1oO*\t\u0001/\u0001\u0003kCZ\f\u0017B\u0001:n\u0005\u0019\u0019FO]5oO\"1A/\u0019Q\u0001\n-\fQAT!N\u000b\u0002BQA^1\u0005\u0002]\fqAY;jY\u0012,'/F\u0001y!\rIhPF\u0007\u0002u*\u00111\u0010`\u0001\tMVt7\r^5p]*\u0011Qp\\\u0001\u0005kRLG.\u0003\u0002\u0000u\nA1+\u001e9qY&,'\u000f")
public class ShowMetadataTableFilesProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowMetadataTableFilesProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowMetadataTableFilesProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> table = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        String partition = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get();
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metaReader = new HoodieBackedTableMetadata(new HoodieLocalEngineContext(metaClient.getHadoopConf()), config, basePath, "/tmp");
        if (metaReader.enabled()) {
            Path partitionPath = new Path(basePath);
            if (!StringUtils.isNullOrEmpty(partition)) {
                partitionPath = new Path(basePath, partition);
            }
            HoodieTimer timer = HoodieTimer.start();
            FileStatus[] statuses = metaReader.getAllFilesInPartition(partitionPath);
            this.logDebug((Function0<String>)new Serializable(this, timer){
                public static final long serialVersionUID = 0L;
                private final HoodieTimer timer$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Took ").append((Object)BoxesRunTime.boxToLong((long)this.timer$1.endTimer())).append((Object)" ms").toString();
                }
                {
                    this.timer$1 = timer$1;
                }
            });
            ArrayList rows = new ArrayList();
            ((Stream)Predef$.MODULE$.refArrayOps((Object[])statuses).toStream().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus p) {
                    return p.getPath().getName();
                }
            }, (Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable(this, rows){
                public static final long serialVersionUID = 0L;
                private final ArrayList rows$1;

                public final boolean apply(FileStatus f) {
                    return this.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.getPath().getName()})));
                }
                {
                    this.rows$1 = rows$1;
                }
            });
            return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().toArray()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Row apply(Object r) {
                    return (Row)r;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
        }
        throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metadata Table not enabled/initialized."})).s((Seq)Nil$.MODULE$));
    }

    @Override
    public Procedure build() {
        return new ShowMetadataTableFilesProcedure();
    }

    public ShowMetadataTableFilesProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "partition", DataTypes.StringType, "")});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("file_path", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

