/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowMetadataTablePartitionsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001E\u0011Ae\u00155po6+G/\u00193bi\u0006$\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bK]8dK\u0012,(/\u001a\u0006\u0003\u0007\u0011\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t)a!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u001dA\u0011\u0001\u00025vI&T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u00173A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u000e\u0005\u0006\u001cX\r\u0015:pG\u0016$WO]3\u0011\u0005M9\u0012B\u0001\r\u0003\u0005A\u0001&o\\2fIV\u0014XMQ;jY\u0012,'\u000f\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u0015\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001f7\t9Aj\\4hS:<\u0007\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0002\u0001C\u0004%\u0001\t\u0007I\u0011B\u0013\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u0001'!\r9#\u0006L\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t)\u0011I\u001d:bsB\u00111#L\u0005\u0003]\t\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\"1\u0001\u0007\u0001Q\u0001\n\u0019\n1\u0002U!S\u00036+E+\u0012*TA!9!\u0007\u0001b\u0001\n\u0013\u0019\u0014aC(V)B+Fk\u0018+Z!\u0016+\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003o!\tQ\u0001^=qKNL!!\u000f\u001c\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0004<\u0001\u0001\u0006I\u0001N\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\t\t\u0005\u0006{\u0001!\t!J\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\"B \u0001\t\u0003\u0019\u0014AC8viB,H\u000fV=qK\")\u0011\t\u0001C!\u0005\u0006!1-\u00197m)\t\u00195\u000bE\u0002E\u0019>s!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!\u0003\u0012A\u0002\u001fs_>$h(C\u0001*\u0013\tY\u0005&A\u0004qC\u000e\\\u0017mZ3\n\u00055s%aA*fc*\u00111\n\u000b\t\u0003!Fk\u0011\u0001C\u0005\u0003%\"\u00111AU8x\u0011\u0015!\u0006\t1\u0001V\u0003\u0011\t'oZ:\u0011\u0005M1\u0016BA,\u0003\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\")\u0011\f\u0001C!5\u0006)!-^5mIV\t1\f\u0005\u0002\u00149&\u0011QL\u0001\u0002\n!J|7-\u001a3ve\u0016<Qa\u0018\u0002\t\u0002\u0001\fAe\u00155po6+G/\u00193bi\u0006$\u0016M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bK]8dK\u0012,(/\u001a\t\u0003'\u00054Q!\u0001\u0002\t\u0002\t\u001c\"!Y2\u0011\u0005\u001d\"\u0017BA3)\u0005\u0019\te.\u001f*fM\")\u0001%\u0019C\u0001OR\t\u0001\rC\u0004jC\n\u0007I\u0011\u00016\u0002\t9\u000bU*R\u000b\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\u0005Y\u0006twMC\u0001q\u0003\u0011Q\u0017M^1\n\u0005Il'AB*ue&tw\r\u0003\u0004uC\u0002\u0006Ia[\u0001\u0006\u001d\u0006kU\t\t\u0005\u0006m\u0006$\ta^\u0001\bEVLG\u000eZ3s+\u0005A\bcA=\u007f-5\t!P\u0003\u0002|y\u0006Aa-\u001e8di&|gN\u0003\u0002~_\u0006!Q\u000f^5m\u0013\ty(P\u0001\u0005TkB\u0004H.[3s\u0001")
public class ShowMetadataTablePartitionsProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowMetadataTablePartitionsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowMetadataTablePartitionsProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> table = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metadata = new HoodieBackedTableMetadata(new HoodieSparkEngineContext(this.jsc()), config, basePath, "/tmp");
        if (metadata.enabled()) {
            HoodieTimer timer = HoodieTimer.start();
            List<String> partitions = metadata.getAllPartitionPaths();
            Collections.sort(partitions);
            this.logDebug((Function0<String>)new Serializable(this, timer){
                public static final long serialVersionUID = 0L;
                private final HoodieTimer timer$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Took ").append((Object)BoxesRunTime.boxToLong((long)this.timer$1.endTimer())).append((Object)" ms").toString();
                }
                {
                    this.timer$1 = timer$1;
                }
            });
            ArrayList rows = new ArrayList();
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(partitions.stream().iterator()).asScala()).foreach((Function1)new Serializable(this, rows){
                public static final long serialVersionUID = 0L;
                private final ArrayList rows$1;

                public final boolean apply(String p) {
                    return this.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p})));
                }
                {
                    this.rows$1 = rows$1;
                }
            });
            return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().toArray()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Row apply(Object r) {
                    return (Row)r;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
        }
        throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metadata Table not enabled/initialized."})).s((Seq)Nil$.MODULE$));
    }

    @Override
    public Procedure build() {
        return new ShowMetadataTablePartitionsProcedure();
    }

    public ShowMetadataTablePartitionsProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

