/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Supplier;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ValidateHoodieSyncProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\tEa\u0001B\u0001\u0003\u0001E\u00111DV1mS\u0012\fG/\u001a%p_\u0012LWmU=oGB\u0013xnY3ekJ,'BA\u0002\u0005\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003\u000b\u0019\tqaY8n[\u0006tGM\u0003\u0002\b\u0011\u0005!\u0001.\u001e3j\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\u0011\u0001!CF\r\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJ\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\u0006\u0002\u0011%tG/\u001a:oC2L!AH\u000e\u0003\u000f1{wmZ5oO\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003'\u0001Aq\u0001\n\u0001C\u0002\u0013%Q%\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012A\n\t\u0004O)bS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Mi\u0013B\u0001\u0018\u0003\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\t\rA\u0002\u0001\u0015!\u0003'\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\t\u000fI\u0002!\u0019!C\u0005g\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005!\u0004CA\u001b9\u001b\u00051$BA\u001c\t\u0003\u0015!\u0018\u0010]3t\u0013\tIdG\u0001\u0006TiJ,8\r\u001e+za\u0016Daa\u000f\u0001!\u0002\u0013!\u0014\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0003\"B\u001f\u0001\t\u0003r\u0014!\u00022vS2$W#A \u0011\u0005M\u0001\u0015BA!\u0003\u0005%\u0001&o\\2fIV\u0014X\rC\u0003D\u0001\u0011\u0005S%\u0001\u0006qCJ\fW.\u001a;feNDQ!\u0012\u0001\u0005BM\n!b\\;uaV$H+\u001f9f\u0011\u00159\u0005\u0001\"\u0011I\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005%K\u0006c\u0001&S+:\u00111\n\u0015\b\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dB\ta\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0005EC\u0013a\u00029bG.\fw-Z\u0005\u0003'R\u00131aU3r\u0015\t\t\u0006\u0006\u0005\u0002W/6\t\u0001\"\u0003\u0002Y\u0011\t\u0019!k\\<\t\u000bi3\u0005\u0019A.\u0002\t\u0005\u0014xm\u001d\t\u0003'qK!!\u0018\u0002\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0011\u0015y\u0006\u0001\"\u0001a\u0003%9W\r^*ue&tw\rF\u0005bQN\\X0!\u0002\u0002\nA\u0011!-\u001a\b\u0003O\rL!\u0001\u001a\u0015\u0002\rA\u0013X\rZ3g\u0013\t1wM\u0001\u0004TiJLgn\u001a\u0006\u0003I\"BQ!\u001b0A\u0002)\fa\u0001^1sO\u0016$\bCA6r\u001b\u0005a'BA7o\u0003\u0015!\u0018M\u00197f\u0015\ty\u0007/\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f1I!A\u001d7\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\")AO\u0018a\u0001k\u0006qA/\u0019:hKR$\u0016.\\3mS:,\u0007C\u0001<z\u001b\u00059(B\u0001=m\u0003!!\u0018.\\3mS:,\u0017B\u0001>x\u00059Aun\u001c3jKRKW.\u001a7j]\u0016DQ\u0001 0A\u0002)\faa]8ve\u000e,\u0007\"\u0002@_\u0001\u0004y\u0018aC:pkJ\u001cWmQ8v]R\u00042aJA\u0001\u0013\r\t\u0019\u0001\u000b\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\by\u0003\ra`\u0001\fi\u0006\u0014x-\u001a;D_VtG\u000f\u0003\u0004\u0002\fy\u0003\r!Y\u0001\u0013g>,(oY3MCR,7\u000f^\"p[6LG\u000fC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u0019\r|WO\u001c;SK\u000e|'\u000fZ:\u0015\u0017}\f\u0019\"a\u0006\u0002\u001a\u0005u\u0011\u0011\u0005\u0005\b\u0003+\ti\u00011\u0001b\u0003\u001dQGMY2Ve2Da\u0001`A\u0007\u0001\u0004Q\u0007bBA\u000e\u0003\u001b\u0001\r!Y\u0001\u0007I\nt\u0015-\\3\t\u000f\u0005}\u0011Q\u0002a\u0001C\u0006!Qo]3s\u0011\u001d\t\u0019#!\u0004A\u0002\u0005\fA\u0001]1tg\"9\u0011q\u0002\u0001\u0005\u0002\u0005\u001dB#D@\u0002*\u0005-\u0012QFA\u0019\u0003w\ti\u0004C\u0004\u0002\u0016\u0005\u0015\u0002\u0019A1\t\rq\f)\u00031\u0001k\u0011\u001d\ty#!\nA\u0002\u0005\fQa\u001d:d\t\nD\u0001\"a\r\u0002&\u0001\u0007\u0011QG\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bcA\u0014\u00028%\u0019\u0011\u0011\b\u0015\u0003\u0007%sG\u000fC\u0004\u0002 \u0005\u0015\u0002\u0019A1\t\u000f\u0005\r\u0012Q\u0005a\u0001C\"2\u0011QEA!\u0003+\u0002RaJA\"\u0003\u000fJ1!!\u0012)\u0005\u0019!\bN]8xgB!\u0011\u0011JA)\u001b\t\tYEC\u0002\n\u0003\u001bR!!a\u0014\u0002\t)\fg/Y\u0005\u0005\u0003'\nYE\u0001\u0007T#2+\u0005pY3qi&|g.\r\u0004\u001fC\u0006]\u00131Q\u0019\nG\u0005e\u0013\u0011MA=\u0003G*B!a\u0017\u0002^U\t\u0011\rB\u0004\u0002`A\u0011\r!!\u001b\u0003\u0003QKA!a\u0019\u0002f\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!a\u001a)\u0003\u0019!\bN]8xgF!\u00111NA9!\r9\u0013QN\u0005\u0004\u0003_B#a\u0002(pi\"Lgn\u001a\t\u0005\u0003g\n)H\u0004\u0002(!&\u0019\u0011q\u000f+\u0003\u0013QC'o\\<bE2,\u0017'C\u0012\u0002|\u0005u\u0014qPA4\u001d\r9\u0013QP\u0005\u0004\u0003OB\u0013'\u0002\u0012(Q\u0005\u0005%!B:dC2\f\u0017g\u0001\u0014\u0002H!9\u0011q\u0002\u0001\u0005\n\u0005\u001dEcD@\u0002\n\u0006-\u0015QRAH\u0003'\u000b9*!'\t\u000f\u0005U\u0011Q\u0011a\u0001C\"1A0!\"A\u0002)Dq!a\f\u0002\u0006\u0002\u0007\u0011\rC\u0004\u0002\u0012\u0006\u0015\u0005\u0019A1\u0002\u0019M$\u0018M\u001d;ECR,7\u000b\u001e:\t\u000f\u0005U\u0015Q\u0011a\u0001C\u0006QQM\u001c3ECR,7\u000b\u001e:\t\u000f\u0005}\u0011Q\u0011a\u0001C\"9\u00111EAC\u0001\u0004\t\u0007FBAC\u0003\u0003\ni*\r\u0004\u001fC\u0006}\u0015QU\u0019\nG\u0005e\u0013\u0011MAQ\u0003G\n\u0014bIA>\u0003{\n\u0019+a\u001a2\u000b\t:\u0003&!!2\u0007\u0019\n9\u0005C\u0004\u0002*\u0002!\t!a+\u0002\u001f\r|WO\u001c;OK^\u0014VmY8sIN$Ra`AW\u0003_Ca![AT\u0001\u0004Q\u0007\u0002CAY\u0003O\u0003\r!a-\u0002!\r|W.\\5ugR{7)\u0019;dQV\u0004\b\u0003\u0002&\u00026\u0006L1!a.U\u0005\u0011a\u0015n\u001d;)\r\u0005\u001d\u00161XAe!\u00159\u00131IA_!\u0011\ty,!2\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u001b\n!![8\n\t\u0005\u001d\u0017\u0011\u0019\u0002\f\u0013>+\u0005pY3qi&|g.\r\u0004\u001fC\u0006-\u0017\u0011[\u0019\nG\u0005e\u0013\u0011MAg\u0003G\n\u0014bIA>\u0003{\ny-a\u001a2\u000b\t:\u0003&!!2\u0007\u0019\nilB\u0004\u0002V\nA\t!a6\u00027Y\u000bG.\u001b3bi\u0016Dun\u001c3jKNKhn\u0019)s_\u000e,G-\u001e:f!\r\u0019\u0012\u0011\u001c\u0004\u0007\u0003\tA\t!a7\u0014\t\u0005e\u0017Q\u001c\t\u0004O\u0005}\u0017bAAqQ\t1\u0011I\\=SK\u001aDq\u0001IAm\t\u0003\t)\u000f\u0006\u0002\u0002X\"Q\u0011\u0011^Am\u0005\u0004%\t!a;\u0002\t9\u000bU*R\u000b\u0003\u0003[\u0004B!a<\u0002v6\u0011\u0011\u0011\u001f\u0006\u0005\u0003g\fi%\u0001\u0003mC:<\u0017b\u00014\u0002r\"I\u0011\u0011`AmA\u0003%\u0011Q^\u0001\u0006\u001d\u0006kU\t\t\u0005\t\u0003{\fI\u000e\"\u0001\u0002\u0000\u00069!-^5mI\u0016\u0014XC\u0001B\u0001!\u0015\u0011\u0019A!\u0004\u0017\u001b\t\u0011)A\u0003\u0003\u0003\b\t%\u0011\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\t\t-\u0011QJ\u0001\u0005kRLG.\u0003\u0003\u0003\u0010\t\u0015!\u0001C*vaBd\u0017.\u001a:")
public class ValidateHoodieSyncProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return ValidateHoodieSyncProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ValidateHoodieSyncProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public Procedure build() {
        return new ValidateHoodieSyncProcedure();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> srcTable = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        Option<Object> dstTable = this.getArgValueOrDefault(args2, this.PARAMETERS()[1]);
        String mode = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[2]).get();
        String hiveServerUrl = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[3]).get();
        String hivePass = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[4]).get();
        String srcDb = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[5]).get();
        String tgtDb = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[6]).get();
        Integer partitionCount = (Integer)this.getArgValueOrDefault(args2, this.PARAMETERS()[7]).get();
        String hiveUser = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[8]).get();
        String srcBasePath = this.getBasePath(srcTable, (Option<Object>)Option$.MODULE$.empty());
        String dstBasePath = this.getBasePath(dstTable, (Option<Object>)Option$.MODULE$.empty());
        HoodieTableMetaClient srcMetaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(srcBasePath).build();
        HoodieTableMetaClient targetMetaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(dstBasePath).build();
        HoodieTimeline targetTimeline = targetMetaClient.getActiveTimeline().getCommitsTimeline();
        HoodieTimeline sourceTimeline = srcMetaClient.getActiveTimeline().getCommitsTimeline();
        long sourceCount = 0L;
        long targetCount = 0L;
        if ("complete".equals(mode)) {
            sourceCount = this.countRecords(hiveServerUrl, srcMetaClient, srcDb, hiveUser, hivePass);
            targetCount = this.countRecords(hiveServerUrl, targetMetaClient, tgtDb, hiveUser, hivePass);
        } else if ("latestPartitions".equals(mode)) {
            sourceCount = this.countRecords(hiveServerUrl, srcMetaClient, srcDb, Predef$.MODULE$.Integer2int(partitionCount), hiveUser, hivePass);
            targetCount = this.countRecords(hiveServerUrl, targetMetaClient, tgtDb, Predef$.MODULE$.Integer2int(partitionCount), hiveUser, hivePass);
        } else {
            this.logError((Function0<String>)new Serializable(this, mode){
                public static final long serialVersionUID = 0L;
                private final String mode$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupport mode ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.mode$1}));
                }
                {
                    this.mode$1 = mode$1;
                }
            });
        }
        String targetLatestCommit = targetTimeline.getInstants().iterator().hasNext() ? targetTimeline.lastInstant().get().getTimestamp() : "0";
        String sourceLatestCommit = sourceTimeline.getInstants().iterator().hasNext() ? sourceTimeline.lastInstant().get().getTimestamp() : "0";
        return sourceLatestCommit != null && HoodieTimeline.compareTimestamps(targetLatestCommit, HoodieTimeline.GREATER_THAN, sourceLatestCommit) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getString(targetMetaClient, targetTimeline, srcMetaClient, sourceCount, targetCount, sourceLatestCommit)}))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getString(srcMetaClient, sourceTimeline, targetMetaClient, targetCount, sourceCount, targetLatestCommit)}))}));
    }

    public String getString(HoodieTableMetaClient target, HoodieTimeline targetTimeline, HoodieTableMetaClient source, long sourceCount, long targetCount, String sourceLatestCommit) {
        String string;
        List commitsToCatchup = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(targetTimeline.findInstantsAfter(sourceLatestCommit, Integer.MAX_VALUE).getInstantsAsStream().iterator()).asScala()).toList();
        if (commitsToCatchup.isEmpty()) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Count difference now is count(", ") - count(", ") == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{target.getTableConfig().getTableName(), source.getTableConfig().getTableName(), BoxesRunTime.boxToLong((long)(targetCount - sourceCount))}));
        } else {
            long newInserts = this.countNewRecords(target, (List<String>)((List)commitsToCatchup.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(HoodieInstant elem) {
                    return elem.getTimestamp();
                }
            }, List$.MODULE$.canBuildFrom())));
            string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Count difference now is count(", ") - count(", ") == ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{target.getTableConfig().getTableName(), source.getTableConfig().getTableName(), BoxesRunTime.boxToLong((long)(targetCount - sourceCount))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Catach up count is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newInserts)}))).toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public long countRecords(String jdbcUrl, HoodieTableMetaClient source, String dbName, String user, String pass) {
        Connection conn = null;
        ResultSet rs = null;
        long count2 = -1L;
        try {
            conn = DriverManager.getConnection(jdbcUrl, user, pass);
            Statement stmt = conn.createStatement();
            stmt.execute("set hive.input.format=org.apache.hadoop.hive.ql.io.HiveInputFormat");
            stmt.execute("set hive.stats.autogather=false");
            rs = stmt.executeQuery(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select count(`_hoodie_commit_time`) as cnt from ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName, source.getTableConfig().getTableName()})));
            if (rs.next()) {
                count2 = rs.getLong("cnt");
            }
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total records in ", " is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source.getTableConfig().getTableName(), BoxesRunTime.boxToLong((long)count2)})));
        }
        catch (Throwable throwable) {
            void var7_7;
            void var6_6;
            var6_6.close();
            if (var7_7 != null) {
                var7_7.close();
            }
            throw throwable;
        }
        conn.close();
        if (rs != null) {
            rs.close();
        }
        return count2;
    }

    public long countRecords(String jdbcUrl, HoodieTableMetaClient source, String srcDb, int partitions, String user, String pass) throws SQLException {
        DateTime dateTime = DateTime.now();
        String endDateStr = this.getDate$1(dateTime);
        dateTime = dateTime.minusDays(partitions);
        String startDateStr = this.getDate$1(dateTime);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Start date ").append((Object)startDateStr).append((Object)" and end date ").append((Object)endDateStr).toString());
        return this.countRecords(jdbcUrl, source, srcDb, startDateStr, endDateStr, user, pass);
    }

    private long countRecords(String jdbcUrl, HoodieTableMetaClient source, String srcDb, String startDateStr, String endDateStr, String user, String pass) throws SQLException {
        ResultSet rs = null;
        Connection conn = DriverManager.getConnection(jdbcUrl, user, pass);
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("set hive.input.format=org.apache.hadoop.hive.ql.io.HiveInputFormat");
            stmt.execute("set hive.stats.autogather=false");
            rs = stmt.executeQuery(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select count(`_hoodie_commit_time`) as cnt from ", ".", " where datestr>'", "' and datestr<='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcDb, source.getTableConfig().getTableName(), startDateStr, endDateStr})));
            long l = rs.next() ? rs.getLong("cnt") : -1L;
            return l;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (conn != null) {
                conn.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public long countNewRecords(HoodieTableMetaClient target, List<String> commitsToCatchup) throws IOException {
        LongRef totalNew = LongRef.create((long)0L);
        HoodieTimeline timeline = target.reloadActiveTimeline().getCommitTimeline().filterCompletedInstants();
        commitsToCatchup.foreach((Function1)new Serializable(this, totalNew, timeline){
            public static final long serialVersionUID = 0L;
            private final LongRef totalNew$1;
            private final HoodieTimeline timeline$1;

            public final void apply(String commit) {
                HoodieCommitMetadata c = HoodieCommitMetadata.fromBytes(this.timeline$1.getInstantDetails(new HoodieInstant(false, "commit", commit)).get(), HoodieCommitMetadata.class);
                this.totalNew$1.elem += c.fetchTotalRecordsWritten() - c.fetchTotalUpdateRecordsWritten();
            }
            {
                this.totalNew$1 = totalNew$1;
                this.timeline$1 = timeline$1;
            }
        });
        return totalNew.elem;
    }

    private final String getDate$1(DateTime dateTime) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "%02d-", "%02d"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dateTime.getYear()), BoxesRunTime.boxToInteger((int)dateTime.getMonthOfYear()), BoxesRunTime.boxToInteger((int)dateTime.getDayOfMonth())}));
    }

    public ValidateHoodieSyncProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "src_table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "dst_table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(2, "mode", DataTypes.StringType, "complete"), ProcedureParameter$.MODULE$.required(3, "hive_server_url", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(4, "hive_pass", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(5, "src_db", DataTypes.StringType, "rawdata"), ProcedureParameter$.MODULE$.optional(6, "target_db", DataTypes.StringType, "dwh_hoodie"), ProcedureParameter$.MODULE$.optional(7, "partition_cnt", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)5)), ProcedureParameter$.MODULE$.optional(8, "hive_user", DataTypes.StringType, "")});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

