/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ValidateMetadataTableFilesProcedure$;
import org.apache.spark.sql.hudi.command.procedures.ValidateMetadataTableFilesProcedure$$anonfun$call$5$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001E\u00111EV1mS\u0012\fG/Z'fi\u0006$\u0017\r^1UC\ndWMR5mKN\u0004&o\\2fIV\u0014XM\u0003\u0002\u0004\t\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005\u00151\u0011aB2p[6\fg\u000e\u001a\u0006\u0003\u000f!\tA\u0001[;eS*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\f\u001a!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\bC\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u000b\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0010\u001c\u0005\u001daunZ4j]\u001eDQ\u0001\t\u0001\u0005\u0002\u0005\na\u0001P5oSRtD#\u0001\u0012\u0011\u0005M\u0001\u0001b\u0002\u0013\u0001\u0005\u0004%I!J\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#\u0001\u0014\u0011\u0007\u001dRC&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0015\t%O]1z!\t\u0019R&\u0003\u0002/\u0005\t\u0011\u0002K]8dK\u0012,(/\u001a)be\u0006lW\r^3s\u0011\u0019\u0001\u0004\u0001)A\u0005M\u0005Y\u0001+\u0011*B\u001b\u0016#VIU*!\u0011\u001d\u0011\u0004A1A\u0005\nM\n1bT+U!V#v\fV-Q\u000bV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\u0011\u0005)A/\u001f9fg&\u0011\u0011H\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BB\u001e\u0001A\u0003%A'\u0001\u0007P+R\u0003V\u000bV0U3B+\u0005\u0005C\u0003>\u0001\u0011\u0005Q%\u0001\u0006qCJ\fW.\u001a;feNDQa\u0010\u0001\u0005\u0002M\n!b\\;uaV$H+\u001f9f\u0011\u0015\t\u0005\u0001\"\u0011C\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005\r\u001b\u0006c\u0001#M\u001f:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u0011B\ta\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0005-C\u0013a\u00029bG.\fw-Z\u0005\u0003\u001b:\u00131aU3r\u0015\tY\u0005\u0006\u0005\u0002Q#6\t\u0001\"\u0003\u0002S\u0011\t\u0019!k\\<\t\u000bQ\u0003\u0005\u0019A+\u0002\t\u0005\u0014xm\u001d\t\u0003'YK!a\u0016\u0002\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0011\u0015I\u0006\u0001\"\u0011[\u0003\u0015\u0011W/\u001b7e+\u0005Y\u0006CA\n]\u0013\ti&AA\u0005Qe>\u001cW\rZ;sK\u001e)qL\u0001E\u0001A\u0006\u0019c+\u00197jI\u0006$X-T3uC\u0012\fG/\u0019+bE2,g)\u001b7fgB\u0013xnY3ekJ,\u0007CA\nb\r\u0015\t!\u0001#\u0001c'\t\t7\r\u0005\u0002(I&\u0011Q\r\u000b\u0002\u0007\u0003:L(+\u001a4\t\u000b\u0001\nG\u0011A4\u0015\u0003\u0001Dq![1C\u0002\u0013\u0005!.\u0001\u0003O\u00036+U#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001\u00027b]\u001eT\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\n11\u000b\u001e:j]\u001eDa\u0001^1!\u0002\u0013Y\u0017!\u0002(B\u001b\u0016\u0003\u0003\"\u0002<b\t\u00039\u0018a\u00022vS2$WM]\u000b\u0002qB\u0019\u0011P \f\u000e\u0003iT!a\u001f?\u0002\u0011\u0019,hn\u0019;j_:T!!`8\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fj\u0014\u0001bU;qa2LWM\u001d")
public class ValidateMetadataTableFilesProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return ValidateMetadataTableFilesProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ValidateMetadataTableFilesProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> table = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        boolean verbose = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get());
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metadataReader = new HoodieBackedTableMetadata(new HoodieLocalEngineContext(metaClient.getHadoopConf()), config, basePath, "/tmp");
        if (metadataReader.enabled()) {
            HoodieMetadataConfig fsConfig = HoodieMetadataConfig.newBuilder().enable(false).build();
            HoodieBackedTableMetadata fsMetaReader = new HoodieBackedTableMetadata(new HoodieLocalEngineContext(metaClient.getHadoopConf()), fsConfig, basePath, "/tmp");
            HoodieTimer timer = HoodieTimer.start();
            List<String> metadataPartitions = metadataReader.getAllPartitionPaths();
            this.logDebug((Function0<String>)new Serializable(this, timer){
                public static final long serialVersionUID = 0L;
                private final HoodieTimer timer$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Listing partitions Took ").append((Object)BoxesRunTime.boxToLong((long)this.timer$1.endTimer())).append((Object)" ms").toString();
                }
                {
                    this.timer$1 = timer$1;
                }
            });
            List<String> fsPartitions = fsMetaReader.getAllPartitionPaths();
            Collections.sort(fsPartitions);
            Collections.sort(metadataPartitions);
            HashSet<String> allPartitions = new HashSet<String>();
            allPartitions.addAll(fsPartitions);
            allPartitions.addAll(metadataPartitions);
            if (!((Object)fsPartitions).equals(metadataPartitions)) {
                this.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "FS partition listing is not matching with metadata partition listing!";
                    }
                });
                this.logError((Function0<String>)new Serializable(this, fsPartitions){
                    public static final long serialVersionUID = 0L;
                    private final List fsPartitions$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"All FS partitions: ").append((Object)Arrays.toString(this.fsPartitions$1.toArray())).toString();
                    }
                    {
                        this.fsPartitions$1 = fsPartitions$1;
                    }
                });
                this.logError((Function0<String>)new Serializable(this, metadataPartitions){
                    public static final long serialVersionUID = 0L;
                    private final List metadataPartitions$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"All Metadata partitions: ").append((Object)Arrays.toString(this.metadataPartitions$1.toArray())).toString();
                    }
                    {
                        this.metadataPartitions$1 = metadataPartitions$1;
                    }
                });
            }
            ArrayList rows = new ArrayList();
            JavaConversions$.MODULE$.asScalaSet(allPartitions).foreach((Function1)new Serializable(this, verbose, basePath, metadataReader, fsMetaReader, rows){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ValidateMetadataTableFilesProcedure $outer;
                public final boolean verbose$1;
                private final String basePath$1;
                private final HoodieBackedTableMetadata metadataReader$1;
                private final HoodieBackedTableMetadata fsMetaReader$1;
                public final ArrayList rows$1;

                public final void apply(String partition) {
                    HashMap<K, V> fileStatusMap = new HashMap<K, V>();
                    HashMap<K, V> metadataFileStatusMap = new HashMap<K, V>();
                    FileStatus[] metadataStatuses = this.metadataReader$1.getAllFilesInPartition(new Path(this.basePath$1, partition));
                    ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Arrays.stream((Object[])metadataStatuses).iterator()).asScala()).foreach((Function1)new Serializable(this, metadataFileStatusMap){
                        public static final long serialVersionUID = 0L;
                        private final HashMap metadataFileStatusMap$1;

                        public final FileStatus apply(FileStatus entry) {
                            return this.metadataFileStatusMap$1.put(entry.getPath().getName(), entry);
                        }
                        {
                            this.metadataFileStatusMap$1 = metadataFileStatusMap$1;
                        }
                    });
                    FileStatus[] fsStatuses = this.fsMetaReader$1.getAllFilesInPartition(new Path(this.basePath$1, partition));
                    ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Arrays.stream((Object[])fsStatuses).iterator()).asScala()).foreach((Function1)new Serializable(this, fileStatusMap){
                        public static final long serialVersionUID = 0L;
                        private final HashMap fileStatusMap$1;

                        public final FileStatus apply(FileStatus entry) {
                            return this.fileStatusMap$1.put(entry.getPath().getName(), entry);
                        }
                        {
                            this.fileStatusMap$1 = fileStatusMap$1;
                        }
                    });
                    HashSet<K> allFiles2 = new HashSet<K>();
                    allFiles2.addAll(fileStatusMap.keySet());
                    allFiles2.addAll(metadataFileStatusMap.keySet());
                    JavaConversions$.MODULE$.asScalaSet(allFiles2).foreach((Function1)new Serializable(this, fileStatusMap, metadataFileStatusMap, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$call$5 $outer;
                        private final HashMap fileStatusMap$1;
                        private final HashMap metadataFileStatusMap$1;
                        private final String partition$1;

                        public final Object apply(String file) {
                            long metadataFileLength;
                            FileStatus fsFileStatus = (FileStatus)this.fileStatusMap$1.get(file);
                            FileStatus metaFileStatus = (FileStatus)this.metadataFileStatusMap$1.get(file);
                            boolean doesFsFileExists = fsFileStatus != null;
                            boolean doesMetadataFileExists = metaFileStatus != null;
                            long fsFileLength = doesFsFileExists ? fsFileStatus.getLen() : 0L;
                            long l = metadataFileLength = doesMetadataFileExists ? metaFileStatus.getLen() : 0L;
                            return this.$outer.verbose$1 ? BoxesRunTime.boxToBoolean((boolean)this.$outer.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$1, file, BoxesRunTime.boxToBoolean((boolean)doesFsFileExists), BoxesRunTime.boxToBoolean((boolean)doesMetadataFileExists), BoxesRunTime.boxToLong((long)fsFileLength), BoxesRunTime.boxToLong((long)metadataFileLength)})))) : (doesFsFileExists != doesMetadataFileExists || fsFileLength != metadataFileLength ? BoxesRunTime.boxToBoolean((boolean)this.$outer.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$1, file, BoxesRunTime.boxToBoolean((boolean)doesFsFileExists), BoxesRunTime.boxToBoolean((boolean)doesMetadataFileExists), BoxesRunTime.boxToLong((long)fsFileLength), BoxesRunTime.boxToLong((long)metadataFileLength)})))) : BoxedUnit.UNIT);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.fileStatusMap$1 = fileStatusMap$1;
                            this.metadataFileStatusMap$1 = metadataFileStatusMap$1;
                            this.partition$1 = partition$1;
                        }
                    });
                    if (metadataStatuses.length != fsStatuses.length) {
                        this.$outer.logError((Function0<String>)new Serializable(this, metadataStatuses, fsStatuses, partition){
                            public static final long serialVersionUID = 0L;
                            private final FileStatus[] metadataStatuses$1;
                            private final FileStatus[] fsStatuses$1;
                            private final String partition$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)" FS and metadata files count not matching for ").append((Object)this.partition$1).append((Object)". FS files count ").append((Object)BoxesRunTime.boxToInteger((int)this.fsStatuses$1.length)).append((Object)", metadata base files count ").append((Object)BoxesRunTime.boxToInteger((int)this.metadataStatuses$1.length)).toString();
                            }
                            {
                                this.metadataStatuses$1 = metadataStatuses$1;
                                this.fsStatuses$1 = fsStatuses$1;
                                this.partition$1 = partition$1;
                            }
                        });
                    }
                    JavaConversions$.MODULE$.asScalaSet(fileStatusMap.entrySet()).foreach((Function1)new Serializable(this, metadataFileStatusMap){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$call$5 $outer;
                        public final HashMap metadataFileStatusMap$1;

                        public final void apply(Map.Entry<String, FileStatus> entry) {
                            if (this.metadataFileStatusMap$1.containsKey(entry.getKey())) {
                                if (entry.getValue().getLen() != ((FileStatus)this.metadataFileStatusMap$1.get(entry.getKey())).getLen()) {
                                    this.$outer.org$apache$spark$sql$hudi$command$procedures$ValidateMetadataTableFilesProcedure$$anonfun$$$outer().logError((Function0<String>)new Serializable(this, entry){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$call$5$$anonfun$apply$5 $outer;
                                        private final Map.Entry entry$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)" FS file size mismatch ").append(this.entry$1.getKey()).append((Object)", size equality ").append((Object)BoxesRunTime.boxToBoolean((((FileStatus)this.entry$1.getValue()).getLen() == ((FileStatus)this.$outer.metadataFileStatusMap$1.get(this.entry$1.getKey())).getLen() ? 1 : 0) != 0)).append((Object)". FS size ").append((Object)BoxesRunTime.boxToLong((long)((FileStatus)this.entry$1.getValue()).getLen())).append((Object)", metadata size ").append((Object)BoxesRunTime.boxToLong((long)((FileStatus)this.$outer.metadataFileStatusMap$1.get(this.entry$1.getKey())).getLen())).toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.entry$1 = entry$1;
                                        }
                                    });
                                }
                            } else {
                                this.$outer.org$apache$spark$sql$hudi$command$procedures$ValidateMetadataTableFilesProcedure$$anonfun$$$outer().logError((Function0<String>)new Serializable(this, entry){
                                    public static final long serialVersionUID = 0L;
                                    private final Map.Entry entry$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"FS file not found in metadata ").append(this.entry$1.getKey()).toString();
                                    }
                                    {
                                        this.entry$1 = entry$1;
                                    }
                                });
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.metadataFileStatusMap$1 = metadataFileStatusMap$1;
                        }
                    });
                    JavaConversions$.MODULE$.asScalaSet(metadataFileStatusMap.entrySet()).foreach((Function1)new Serializable(this, fileStatusMap, metadataFileStatusMap){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$call$5 $outer;
                        public final HashMap fileStatusMap$1;
                        public final HashMap metadataFileStatusMap$1;

                        public final void apply(Map.Entry<String, FileStatus> entry) {
                            if (this.fileStatusMap$1.containsKey(entry.getKey())) {
                                if (entry.getValue().getLen() != ((FileStatus)this.fileStatusMap$1.get(entry.getKey())).getLen()) {
                                    this.$outer.org$apache$spark$sql$hudi$command$procedures$ValidateMetadataTableFilesProcedure$$anonfun$$$outer().logError((Function0<String>)new Serializable(this, entry){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$call$5$$anonfun$apply$8 $outer;
                                        private final Map.Entry entry$2;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)" Metadata file size mismatch ").append(this.entry$2.getKey()).append((Object)", size equality ").append((Object)BoxesRunTime.boxToBoolean((((FileStatus)this.entry$2.getValue()).getLen() == ((FileStatus)this.$outer.fileStatusMap$1.get(this.entry$2.getKey())).getLen() ? 1 : 0) != 0)).append((Object)". Metadata size ").append((Object)BoxesRunTime.boxToLong((long)((FileStatus)this.entry$2.getValue()).getLen())).append((Object)", FS size ").append((Object)BoxesRunTime.boxToLong((long)((FileStatus)this.$outer.metadataFileStatusMap$1.get(this.entry$2.getKey())).getLen())).toString();
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.entry$2 = entry$2;
                                        }
                                    });
                                }
                            } else {
                                this.$outer.org$apache$spark$sql$hudi$command$procedures$ValidateMetadataTableFilesProcedure$$anonfun$$$outer().logError((Function0<String>)new Serializable(this, entry){
                                    public static final long serialVersionUID = 0L;
                                    private final Map.Entry entry$2;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Metadata file not found in FS ").append(this.entry$2.getKey()).toString();
                                    }
                                    {
                                        this.entry$2 = entry$2;
                                    }
                                });
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.fileStatusMap$1 = fileStatusMap$1;
                            this.metadataFileStatusMap$1 = metadataFileStatusMap$1;
                        }
                    });
                }

                public /* synthetic */ ValidateMetadataTableFilesProcedure org$apache$spark$sql$hudi$command$procedures$ValidateMetadataTableFilesProcedure$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.verbose$1 = verbose$1;
                    this.basePath$1 = basePath$1;
                    this.metadataReader$1 = metadataReader$1;
                    this.fsMetaReader$1 = fsMetaReader$1;
                    this.rows$1 = rows$1;
                }
            });
            return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().toArray()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Row apply(Object r) {
                    return (Row)r;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
        }
        throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metadata Table not enabled/initialized."})).s((Seq)Nil$.MODULE$));
    }

    @Override
    public Procedure build() {
        return new ValidateMetadataTableFilesProcedure();
    }

    public ValidateMetadataTableFilesProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "verbose", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_name", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("is_present_in_fs", DataTypes.BooleanType, true, Metadata$.MODULE$.empty()), new StructField("is_resent_in_metadata", DataTypes.BooleanType, true, Metadata$.MODULE$.empty()), new StructField("fs_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("metadata_size", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
    }
}

