/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.hilbert;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import javax.imageio.ImageIO;
import org.davidmoten.hilbert.HilbertCurve;
import org.davidmoten.hilbert.exceptions.IORuntimeException;

public final class HilbertCurveRenderer {
    private HilbertCurveRenderer() {
    }

    public static void renderToFile(int bits, int width, String filename, Option ... options) {
        BufferedImage b = HilbertCurveRenderer.render(bits, width, options);
        try {
            ImageIO.write((RenderedImage)b, "PNG", new File(filename));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedImage render(int bits, int width, Option ... options) {
        int y2;
        int x2;
        long[] point;
        long i;
        int y;
        int x;
        int dimensions = 2;
        HilbertCurve c = HilbertCurve.bits(bits).dimensions(dimensions);
        int n = 1 << bits;
        int height = width;
        BufferedImage b = new BufferedImage(width, height, 2);
        Graphics2D g = b.createGraphics();
        g.setBackground(Color.white);
        g.fillRect(0, 0, width, height);
        g.setPaint(Color.black);
        g.setStroke(new BasicStroke(0.5f));
        int margin = 10;
        int cellSize = (width - 2 * margin) / n;
        if (HilbertCurveRenderer.contains(options, Option.COLORIZE)) {
            x = margin + cellSize / 2;
            y = margin + cellSize / 2;
            for (i = 0L; i < (long)(n * n); ++i) {
                HilbertCurveRenderer.fill(n, g, cellSize, x, y, i);
                point = c.point(BigInteger.valueOf(i));
                x2 = (int)Math.round((double)point[0] / (double)(n - 1) * (double)(width - 2 * margin - cellSize) + (double)margin) + cellSize / 2;
                y2 = (int)Math.round((double)point[1] / (double)(n - 1) * (double)(height - 2 * margin - cellSize) + (double)margin) + cellSize / 2;
                x = x2;
                y = y2;
            }
            HilbertCurveRenderer.fill(n, g, cellSize, x, y, n * n);
        }
        if (HilbertCurveRenderer.contains(options, Option.LABEL)) {
            x = margin + cellSize / 2;
            y = margin + cellSize / 2;
            x = margin + cellSize / 2;
            y = margin + cellSize / 2;
            g.setColor(Color.black);
            for (i = 0L; i < (long)(n * n); ++i) {
                point = c.point(BigInteger.valueOf(i));
                x2 = (int)Math.round((double)point[0] / (double)(n - 1) * (double)(width - 2 * margin - cellSize) + (double)margin) + cellSize / 2;
                y2 = (int)Math.round((double)point[1] / (double)(n - 1) * (double)(height - 2 * margin - cellSize) + (double)margin) + cellSize / 2;
                x = x2;
                y = y2;
                HilbertCurveRenderer.drawNumber(g, x, y, i);
            }
        }
        x = margin + cellSize / 2;
        y = margin + cellSize / 2;
        x = margin + cellSize / 2;
        y = margin + cellSize / 2;
        g.setColor(Color.black);
        for (i = 0L; i < (long)(n * n); ++i) {
            point = c.point(BigInteger.valueOf(i));
            x2 = (int)Math.round((double)point[0] / (double)(n - 1) * (double)(width - 2 * margin - cellSize) + (double)margin) + cellSize / 2;
            y2 = (int)Math.round((double)point[1] / (double)(n - 1) * (double)(height - 2 * margin - cellSize) + (double)margin) + cellSize / 2;
            g.drawLine(x, y, x2, y2);
            x = x2;
            y = y2;
        }
        return b;
    }

    private static boolean contains(Option[] options, Option option2) {
        for (Option o : options) {
            if (o != option2) continue;
            return true;
        }
        return false;
    }

    private static void drawNumber(Graphics2D g, int x, int y, long i) {
        g.drawString(i + "", x + 2, y - 2);
    }

    private static void fill(int n, Graphics2D g, int cellSize, int x, int y, long i) {
        Color color = Color.getHSBColor((float)i / (float)n / (float)n, 0.5f, 1.0f);
        g.setColor(color);
        g.fillRect(x - cellSize / 2, y - cellSize / 2, cellSize + 1, cellSize + 1);
    }

    public static enum Option {
        COLORIZE,
        LABEL;

    }
}

