/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.config;

import io.confluent.common.Configurable;
import io.confluent.common.config.ConfigDef;
import io.confluent.common.config.ConfigException;
import io.confluent.common.utils.Utils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConfig {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<String> used;
    private final Map<String, ?> originals;
    private final Map<String, Object> values;

    public AbstractConfig(ConfigDef definition, Map<?, ?> originals) {
        for (Object key : originals.keySet()) {
            if (key instanceof String) continue;
            throw new ConfigException(key.toString(), originals.get(key), "Key must be a string.");
        }
        this.originals = originals;
        this.values = definition.parse(this.originals);
        this.used = Collections.synchronizedSet(new HashSet());
        this.logAll();
    }

    protected Object get(String key) {
        if (!this.values.containsKey(key)) {
            throw new ConfigException(String.format("Unknown configuration '%s'", key));
        }
        this.used.add(key);
        return this.values.get(key);
    }

    public int getInt(String key) {
        return (Integer)this.get(key);
    }

    public long getLong(String key) {
        return (Long)this.get(key);
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    public List<String> getList(String key) {
        return (List)this.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public Class<?> getClass(String key) {
        return (Class)this.get(key);
    }

    public Set<String> unused() {
        HashSet<String> keys2 = new HashSet<String>(this.originals.keySet());
        keys2.removeAll(this.used);
        return keys2;
    }

    private void logAll() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append(" values: ");
        b.append(Utils.NL);
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            b.append('\t');
            b.append(entry.getKey());
            b.append(" = ");
            b.append(entry.getValue());
            b.append(Utils.NL);
        }
        this.log.info(b.toString());
    }

    public void logUnused() {
        for (String key : this.unused()) {
            this.log.warn("The configuration {} = {} was supplied but isn't a known config.", (Object)key, this.originals.get(key));
        }
    }

    public <T> T getConfiguredInstance(String key, Class<T> t) {
        Class<?> c = this.getClass(key);
        if (c == null) {
            return null;
        }
        Object o = Utils.newInstance(c);
        if (!t.isInstance(o)) {
            throw new RuntimeException(c.getName() + " is not an instance of " + t.getName());
        }
        if (o instanceof Configurable) {
            ((Configurable)o).configure(this.originals);
        }
        return t.cast(o);
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t) {
        List<String> klasses = this.getList(key);
        ArrayList<T> objects = new ArrayList<T>();
        for (String klass : klasses) {
            Class<?> c;
            try {
                c = Class.forName(klass);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException(key, klass, "Class " + klass + " could not be found.");
            }
            if (c == null) {
                return null;
            }
            Object o = Utils.newInstance(c);
            if (!t.isInstance(o)) {
                throw new RuntimeException(c.getName() + " is not an instance of " + t.getName());
            }
            if (o instanceof Configurable) {
                ((Configurable)o).configure(this.originals);
            }
            objects.add(t.cast(o));
        }
        return objects;
    }

    public static Properties getPropsFromFile(String propsFile) throws ConfigException {
        Properties props = new Properties();
        if (propsFile == null) {
            return props;
        }
        try {
            FileInputStream propStream = new FileInputStream(propsFile);
            props.load(propStream);
        }
        catch (IOException e) {
            throw new ConfigException("Couldn't load properties from " + propsFile, (Object)e);
        }
        return props;
    }
}

