/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.common.config.ConfigException;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerDe;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import kafka.utils.VerifiableProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractKafkaAvroSerializer
extends AbstractKafkaAvroSerDe {
    private final EncoderFactory encoderFactory = EncoderFactory.get();

    protected void configure(KafkaAvroSerializerConfig config) {
        this.configureClientProperties(config);
    }

    protected KafkaAvroSerializerConfig serializerConfig(Map<String, ?> props) {
        try {
            return new KafkaAvroSerializerConfig(props);
        }
        catch (ConfigException e) {
            throw new org.apache.kafka.common.config.ConfigException(e.getMessage());
        }
    }

    protected KafkaAvroSerializerConfig serializerConfig(VerifiableProperties props) {
        try {
            return new KafkaAvroSerializerConfig(props.props());
        }
        catch (ConfigException e) {
            throw new org.apache.kafka.common.config.ConfigException(e.getMessage());
        }
    }

    protected byte[] serializeImpl(String subject, Object object) throws SerializationException {
        Schema schema = null;
        if (object == null) {
            return null;
        }
        try {
            schema = this.getSchema(object);
            int id = this.schemaRegistry.register(subject, schema);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(ByteBuffer.allocate(4).putInt(id).array());
            if (object instanceof byte[]) {
                out.write((byte[])object);
            } else {
                BinaryEncoder encoder2 = this.encoderFactory.directBinaryEncoder((OutputStream)out, null);
                Object value = object instanceof NonRecordContainer ? ((NonRecordContainer)object).getValue() : object;
                Object writer = value instanceof SpecificRecord ? new SpecificDatumWriter(schema) : new GenericDatumWriter(schema);
                writer.write(value, (Encoder)encoder2);
                encoder2.flush();
            }
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("Error serializing Avro message", e);
        }
        catch (RestClientException e) {
            throw new SerializationException("Error registering Avro schema: " + schema, e);
        }
    }
}

