/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestChoreService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testInitialChorePrecedence() throws InterruptedException {
        ChoreService service2 = ChoreService.getInstance("testInitialChorePrecedence");
        int period = 100;
        int failureThreshold = 5;
        try {
            ScheduledChoreSamples.FailInitialChore chore = new ScheduledChoreSamples.FailInitialChore("chore", 100, 5);
            service2.scheduleChore(chore);
            int loopCount = 0;
            boolean brokeOutOfLoop = false;
            while (!chore.isInitialChoreComplete() && chore.isScheduled()) {
                Thread.sleep(500L);
                if (++loopCount <= 3) continue;
                brokeOutOfLoop = true;
                break;
            }
            Assert.assertFalse((boolean)brokeOutOfLoop);
        }
        finally {
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testCancelChore() throws InterruptedException {
        int period = 100;
        ScheduledChoreSamples.DoNothingChore chore1 = new ScheduledChoreSamples.DoNothingChore("chore1", 100);
        ChoreService service2 = ChoreService.getInstance("testCancelChore");
        try {
            service2.scheduleChore(chore1);
            Assert.assertTrue((boolean)chore1.isScheduled());
            chore1.cancel(true);
            Assert.assertFalse((boolean)chore1.isScheduled());
            Assert.assertTrue((service2.getNumberOfScheduledChores() == 0 ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(service2);
        }
    }

    @Test(timeout=20000L)
    public void testScheduledChoreConstruction() {
        String NAME = "chore";
        int PERIOD = 100;
        long VALID_DELAY = 0L;
        long INVALID_DELAY = -100L;
        TimeUnit UNIT = TimeUnit.NANOSECONDS;
        ScheduledChore chore1 = new ScheduledChore("chore", new ScheduledChoreSamples.SampleStopper(), 100, 0L, UNIT){

            @Override
            protected void chore() {
            }
        };
        Assert.assertEquals((String)"Name construction failed", (Object)chore1.getName(), (Object)"chore");
        Assert.assertEquals((String)"Period construction failed", (long)chore1.getPeriod(), (long)100L);
        Assert.assertEquals((String)"Initial Delay construction failed", (long)chore1.getInitialDelay(), (long)0L);
        Assert.assertEquals((String)"TimeUnit construction failed", (Object)((Object)chore1.getTimeUnit()), (Object)((Object)UNIT));
        ScheduledChore invalidDelayChore = new ScheduledChore("chore", new ScheduledChoreSamples.SampleStopper(), 100, -100L, UNIT){

            @Override
            protected void chore() {
            }
        };
        Assert.assertEquals((String)"Initial Delay should be set to 0 when invalid", (long)0L, (long)invalidDelayChore.getInitialDelay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testChoreServiceConstruction() throws InterruptedException {
        int corePoolSize = 10;
        boolean defaultCorePoolSize = true;
        ChoreService customInit = new ChoreService("testChoreServiceConstruction_custom", 10, false);
        try {
            Assert.assertEquals((long)10L, (long)customInit.getCorePoolSize());
        }
        finally {
            this.shutdownService(customInit);
        }
        ChoreService defaultInit = new ChoreService("testChoreServiceConstruction_default");
        try {
            Assert.assertEquals((long)1L, (long)defaultInit.getCorePoolSize());
        }
        finally {
            this.shutdownService(defaultInit);
        }
        ChoreService invalidInit = new ChoreService("testChoreServiceConstruction_invalid", -10, false);
        try {
            Assert.assertEquals((long)1L, (long)invalidInit.getCorePoolSize());
        }
        finally {
            this.shutdownService(invalidInit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testFrequencyOfChores() throws InterruptedException {
        int period = 100;
        int delta = 5;
        ChoreService service2 = ChoreService.getInstance("testFrequencyOfChores");
        ScheduledChoreSamples.CountingChore chore = new ScheduledChoreSamples.CountingChore("countingChore", 100);
        try {
            service2.scheduleChore(chore);
            Thread.sleep(1005L);
            Assert.assertTrue((chore.getCountOfChoreCalls() == 11 ? 1 : 0) != 0);
            Thread.sleep(1000L);
            Assert.assertTrue((chore.getCountOfChoreCalls() == 21 ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(service2);
        }
    }

    public void shutdownService(ChoreService service2) throws InterruptedException {
        service2.shutdown();
        while (!service2.isTerminated()) {
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testForceTrigger() throws InterruptedException {
        int period = 100;
        int delta = 5;
        ChoreService service2 = ChoreService.getInstance("testForceTrigger");
        ScheduledChoreSamples.CountingChore chore = new ScheduledChoreSamples.CountingChore("countingChore", 100);
        try {
            service2.scheduleChore(chore);
            Thread.sleep(1005L);
            Assert.assertTrue((chore.getCountOfChoreCalls() == 11 ? 1 : 0) != 0);
            chore.triggerNow();
            Thread.sleep(5L);
            chore.triggerNow();
            Thread.sleep(5L);
            chore.triggerNow();
            Thread.sleep(5L);
            chore.triggerNow();
            Thread.sleep(5L);
            chore.triggerNow();
            Thread.sleep(5L);
            Assert.assertTrue((String)("" + chore.getCountOfChoreCalls()), (chore.getCountOfChoreCalls() == 16 ? 1 : 0) != 0);
            Thread.sleep(1005L);
            Assert.assertTrue((String)("" + chore.getCountOfChoreCalls()), (chore.getCountOfChoreCalls() > 16 ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testCorePoolIncrease() throws InterruptedException {
        int initialCorePoolSize = 3;
        ChoreService service2 = new ChoreService("testCorePoolIncrease", 3, false);
        try {
            Assert.assertEquals((String)"Should have a core pool of size: 3", (long)3L, (long)service2.getCorePoolSize());
            int slowChorePeriod = 100;
            ScheduledChoreSamples.SlowChore slowChore1 = new ScheduledChoreSamples.SlowChore("slowChore1", 100);
            ScheduledChoreSamples.SlowChore slowChore2 = new ScheduledChoreSamples.SlowChore("slowChore2", 100);
            ScheduledChoreSamples.SlowChore slowChore3 = new ScheduledChoreSamples.SlowChore("slowChore3", 100);
            service2.scheduleChore(slowChore1);
            service2.scheduleChore(slowChore2);
            service2.scheduleChore(slowChore3);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Should not create more pools than scheduled chores", (long)3L, (long)service2.getCorePoolSize());
            ScheduledChoreSamples.SlowChore slowChore4 = new ScheduledChoreSamples.SlowChore("slowChore4", 100);
            service2.scheduleChore(slowChore4);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)4L, (long)service2.getCorePoolSize());
            ScheduledChoreSamples.SlowChore slowChore5 = new ScheduledChoreSamples.SlowChore("slowChore5", 100);
            service2.scheduleChore(slowChore5);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)5L, (long)service2.getCorePoolSize());
        }
        finally {
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCorePoolDecrease() throws InterruptedException {
        int initialCorePoolSize = 3;
        ChoreService service2 = new ChoreService("testCorePoolDecrease", 3, false);
        int chorePeriod = 100;
        try {
            ScheduledChoreSamples.SlowChore slowChore1 = new ScheduledChoreSamples.SlowChore("slowChore1", 100);
            ScheduledChoreSamples.SlowChore slowChore2 = new ScheduledChoreSamples.SlowChore("slowChore2", 100);
            ScheduledChoreSamples.SlowChore slowChore3 = new ScheduledChoreSamples.SlowChore("slowChore3", 100);
            service2.scheduleChore(slowChore1);
            service2.scheduleChore(slowChore2);
            service2.scheduleChore(slowChore3);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Should not create more pools than scheduled chores", (long)service2.getNumberOfScheduledChores(), (long)service2.getCorePoolSize());
            ScheduledChoreSamples.SlowChore slowChore4 = new ScheduledChoreSamples.SlowChore("slowChore4", 100);
            service2.scheduleChore(slowChore4);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)service2.getNumberOfScheduledChores(), (long)service2.getCorePoolSize());
            ScheduledChoreSamples.SlowChore slowChore5 = new ScheduledChoreSamples.SlowChore("slowChore5", 100);
            service2.scheduleChore(slowChore5);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Chores are missing their start time. Should expand core pool size", (long)service2.getNumberOfScheduledChores(), (long)service2.getCorePoolSize());
            Assert.assertEquals((long)service2.getNumberOfChoresMissingStartTime(), (long)5L);
            slowChore5.cancel();
            Thread.sleep(1000L);
            Assert.assertEquals((long)Math.max(1, service2.getNumberOfScheduledChores()), (long)service2.getCorePoolSize());
            Assert.assertEquals((long)service2.getNumberOfChoresMissingStartTime(), (long)4L);
            slowChore4.cancel();
            Thread.sleep(1000L);
            Assert.assertEquals((long)Math.max(1, service2.getNumberOfScheduledChores()), (long)service2.getCorePoolSize());
            Assert.assertEquals((long)service2.getNumberOfChoresMissingStartTime(), (long)3L);
            slowChore3.cancel();
            Thread.sleep(1000L);
            Assert.assertEquals((long)Math.max(1, service2.getNumberOfScheduledChores()), (long)service2.getCorePoolSize());
            Assert.assertEquals((long)service2.getNumberOfChoresMissingStartTime(), (long)2L);
            slowChore2.cancel();
            Thread.sleep(1000L);
            Assert.assertEquals((long)Math.max(1, service2.getNumberOfScheduledChores()), (long)service2.getCorePoolSize());
            Assert.assertEquals((long)service2.getNumberOfChoresMissingStartTime(), (long)1L);
            slowChore1.cancel();
            Thread.sleep(1000L);
            Assert.assertEquals((long)Math.max(1, service2.getNumberOfScheduledChores()), (long)service2.getCorePoolSize());
            Assert.assertEquals((long)service2.getNumberOfChoresMissingStartTime(), (long)0L);
        }
        finally {
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testNumberOfRunningChores() throws InterruptedException {
        ChoreService service2 = new ChoreService("testNumberOfRunningChores");
        int period = 100;
        int sleepTime = 5;
        try {
            ScheduledChoreSamples.DoNothingChore dn1 = new ScheduledChoreSamples.DoNothingChore("dn1", 100);
            ScheduledChoreSamples.DoNothingChore dn2 = new ScheduledChoreSamples.DoNothingChore("dn2", 100);
            ScheduledChoreSamples.DoNothingChore dn3 = new ScheduledChoreSamples.DoNothingChore("dn3", 100);
            ScheduledChoreSamples.DoNothingChore dn4 = new ScheduledChoreSamples.DoNothingChore("dn4", 100);
            ScheduledChoreSamples.DoNothingChore dn5 = new ScheduledChoreSamples.DoNothingChore("dn5", 100);
            service2.scheduleChore(dn1);
            service2.scheduleChore(dn2);
            service2.scheduleChore(dn3);
            service2.scheduleChore(dn4);
            service2.scheduleChore(dn5);
            Thread.sleep(5L);
            Assert.assertEquals((String)"Scheduled chore mismatch", (long)5L, (long)service2.getNumberOfScheduledChores());
            dn1.cancel();
            Thread.sleep(5L);
            Assert.assertEquals((String)"Scheduled chore mismatch", (long)4L, (long)service2.getNumberOfScheduledChores());
            dn2.cancel();
            dn3.cancel();
            dn4.cancel();
            Thread.sleep(5L);
            Assert.assertEquals((String)"Scheduled chore mismatch", (long)1L, (long)service2.getNumberOfScheduledChores());
            dn5.cancel();
            Thread.sleep(5L);
            Assert.assertEquals((String)"Scheduled chore mismatch", (long)0L, (long)service2.getNumberOfScheduledChores());
        }
        finally {
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testNumberOfChoresMissingStartTime() throws InterruptedException {
        ChoreService service2 = new ChoreService("testNumberOfChoresMissingStartTime");
        int period = 100;
        int sleepTime = 500;
        try {
            ScheduledChoreSamples.SlowChore sc1 = new ScheduledChoreSamples.SlowChore("sc1", 100);
            ScheduledChoreSamples.SlowChore sc2 = new ScheduledChoreSamples.SlowChore("sc2", 100);
            ScheduledChoreSamples.SlowChore sc3 = new ScheduledChoreSamples.SlowChore("sc3", 100);
            ScheduledChoreSamples.SlowChore sc4 = new ScheduledChoreSamples.SlowChore("sc4", 100);
            ScheduledChoreSamples.SlowChore sc5 = new ScheduledChoreSamples.SlowChore("sc5", 100);
            service2.scheduleChore(sc1);
            service2.scheduleChore(sc2);
            service2.scheduleChore(sc3);
            service2.scheduleChore(sc4);
            service2.scheduleChore(sc5);
            Thread.sleep(500L);
            Assert.assertEquals((long)5L, (long)service2.getNumberOfChoresMissingStartTime());
            sc1.cancel();
            Thread.sleep(500L);
            Assert.assertEquals((long)4L, (long)service2.getNumberOfChoresMissingStartTime());
            sc2.cancel();
            sc3.cancel();
            sc4.cancel();
            Thread.sleep(500L);
            Assert.assertEquals((long)1L, (long)service2.getNumberOfChoresMissingStartTime());
            sc5.cancel();
            Thread.sleep(500L);
            Assert.assertEquals((long)0L, (long)service2.getNumberOfChoresMissingStartTime());
        }
        finally {
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testMaximumChoreServiceThreads() throws InterruptedException {
        ChoreService service2 = new ChoreService("testMaximumChoreServiceThreads");
        int period = 100;
        int sleepTime = 500;
        try {
            ScheduledChoreSamples.SlowChore sc1 = new ScheduledChoreSamples.SlowChore("sc1", 100);
            ScheduledChoreSamples.SlowChore sc2 = new ScheduledChoreSamples.SlowChore("sc2", 100);
            ScheduledChoreSamples.SlowChore sc3 = new ScheduledChoreSamples.SlowChore("sc3", 100);
            ScheduledChoreSamples.SlowChore sc4 = new ScheduledChoreSamples.SlowChore("sc4", 100);
            ScheduledChoreSamples.SlowChore sc5 = new ScheduledChoreSamples.SlowChore("sc5", 100);
            service2.scheduleChore(sc1);
            service2.scheduleChore(sc2);
            service2.scheduleChore(sc3);
            service2.scheduleChore(sc4);
            service2.scheduleChore(sc5);
            Thread.sleep(500L);
            Assert.assertTrue((service2.getCorePoolSize() <= service2.getNumberOfScheduledChores() ? 1 : 0) != 0);
            ScheduledChoreSamples.SlowChore sc6 = new ScheduledChoreSamples.SlowChore("sc6", 100);
            ScheduledChoreSamples.SlowChore sc7 = new ScheduledChoreSamples.SlowChore("sc7", 100);
            ScheduledChoreSamples.SlowChore sc8 = new ScheduledChoreSamples.SlowChore("sc8", 100);
            ScheduledChoreSamples.SlowChore sc9 = new ScheduledChoreSamples.SlowChore("sc9", 100);
            ScheduledChoreSamples.SlowChore sc10 = new ScheduledChoreSamples.SlowChore("sc10", 100);
            service2.scheduleChore(sc6);
            service2.scheduleChore(sc7);
            service2.scheduleChore(sc8);
            service2.scheduleChore(sc9);
            service2.scheduleChore(sc10);
            Thread.sleep(500L);
            Assert.assertTrue((service2.getCorePoolSize() <= service2.getNumberOfScheduledChores() ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testChangingChoreServices() throws InterruptedException {
        int period = 100;
        int sleepTime = 10;
        ChoreService service1 = new ChoreService("testChangingChoreServices_1");
        ChoreService service2 = new ChoreService("testChangingChoreServices_2");
        ScheduledChoreSamples.DoNothingChore chore = new ScheduledChoreSamples.DoNothingChore("sample", 100);
        try {
            Assert.assertFalse((boolean)chore.isScheduled());
            Assert.assertFalse((boolean)service1.isChoreScheduled(chore));
            Assert.assertFalse((boolean)service2.isChoreScheduled(chore));
            Assert.assertTrue((chore.getChoreServicer() == null ? 1 : 0) != 0);
            service1.scheduleChore(chore);
            Thread.sleep(10L);
            Assert.assertTrue((boolean)chore.isScheduled());
            Assert.assertTrue((boolean)service1.isChoreScheduled(chore));
            Assert.assertFalse((boolean)service2.isChoreScheduled(chore));
            Assert.assertFalse((chore.getChoreServicer() == null ? 1 : 0) != 0);
            service2.scheduleChore(chore);
            Thread.sleep(10L);
            Assert.assertTrue((boolean)chore.isScheduled());
            Assert.assertFalse((boolean)service1.isChoreScheduled(chore));
            Assert.assertTrue((boolean)service2.isChoreScheduled(chore));
            Assert.assertFalse((chore.getChoreServicer() == null ? 1 : 0) != 0);
            chore.cancel();
            Assert.assertFalse((boolean)chore.isScheduled());
            Assert.assertFalse((boolean)service1.isChoreScheduled(chore));
            Assert.assertFalse((boolean)service2.isChoreScheduled(chore));
            Assert.assertTrue((chore.getChoreServicer() == null ? 1 : 0) != 0);
        }
        finally {
            this.shutdownService(service1);
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testTriggerNowFailsWhenNotScheduled() throws InterruptedException {
        int period = 100;
        int sleep = 5;
        ChoreService service2 = new ChoreService("testTriggerNowFailsWhenNotScheduled");
        ScheduledChoreSamples.CountingChore chore = new ScheduledChoreSamples.CountingChore("dn", 100);
        try {
            Assert.assertFalse((boolean)chore.triggerNow());
            Assert.assertTrue((chore.getCountOfChoreCalls() == 0 ? 1 : 0) != 0);
            service2.scheduleChore(chore);
            Thread.sleep(5L);
            Assert.assertEquals((long)1L, (long)chore.getCountOfChoreCalls());
            Thread.sleep(100L);
            Assert.assertEquals((long)2L, (long)chore.getCountOfChoreCalls());
            Assert.assertTrue((boolean)chore.triggerNow());
            Thread.sleep(5L);
            Assert.assertTrue((boolean)chore.triggerNow());
            Thread.sleep(5L);
            Assert.assertTrue((boolean)chore.triggerNow());
            Thread.sleep(5L);
            Assert.assertEquals((long)5L, (long)chore.getCountOfChoreCalls());
        }
        finally {
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testStopperForScheduledChores() throws InterruptedException {
        ChoreService service2 = ChoreService.getInstance("testStopperForScheduledChores");
        ScheduledChoreSamples.SampleStopper stopperForGroup1 = new ScheduledChoreSamples.SampleStopper();
        ScheduledChoreSamples.SampleStopper stopperForGroup2 = new ScheduledChoreSamples.SampleStopper();
        int period = 100;
        int delta = 10;
        try {
            ScheduledChoreSamples.DoNothingChore chore1_group1 = new ScheduledChoreSamples.DoNothingChore("c1g1", stopperForGroup1, 100);
            ScheduledChoreSamples.DoNothingChore chore2_group1 = new ScheduledChoreSamples.DoNothingChore("c2g1", stopperForGroup1, 100);
            ScheduledChoreSamples.DoNothingChore chore3_group1 = new ScheduledChoreSamples.DoNothingChore("c3g1", stopperForGroup1, 100);
            ScheduledChoreSamples.DoNothingChore chore1_group2 = new ScheduledChoreSamples.DoNothingChore("c1g2", stopperForGroup2, 100);
            ScheduledChoreSamples.DoNothingChore chore2_group2 = new ScheduledChoreSamples.DoNothingChore("c2g2", stopperForGroup2, 100);
            ScheduledChoreSamples.DoNothingChore chore3_group2 = new ScheduledChoreSamples.DoNothingChore("c3g2", stopperForGroup2, 100);
            service2.scheduleChore(chore1_group1);
            service2.scheduleChore(chore2_group1);
            service2.scheduleChore(chore3_group1);
            service2.scheduleChore(chore1_group2);
            service2.scheduleChore(chore2_group2);
            service2.scheduleChore(chore3_group2);
            Thread.sleep(10L);
            Thread.sleep(1000L);
            Assert.assertTrue((boolean)chore1_group1.isScheduled());
            Assert.assertTrue((boolean)chore2_group1.isScheduled());
            Assert.assertTrue((boolean)chore3_group1.isScheduled());
            Assert.assertTrue((boolean)chore1_group2.isScheduled());
            Assert.assertTrue((boolean)chore2_group2.isScheduled());
            Assert.assertTrue((boolean)chore3_group2.isScheduled());
            stopperForGroup1.stop("test stopping group 1");
            Thread.sleep(100L);
            Assert.assertFalse((boolean)chore1_group1.isScheduled());
            Assert.assertFalse((boolean)chore2_group1.isScheduled());
            Assert.assertFalse((boolean)chore3_group1.isScheduled());
            Assert.assertTrue((boolean)chore1_group2.isScheduled());
            Assert.assertTrue((boolean)chore2_group2.isScheduled());
            Assert.assertTrue((boolean)chore3_group2.isScheduled());
            stopperForGroup2.stop("test stopping group 2");
            Thread.sleep(100L);
            Assert.assertFalse((boolean)chore1_group1.isScheduled());
            Assert.assertFalse((boolean)chore2_group1.isScheduled());
            Assert.assertFalse((boolean)chore3_group1.isScheduled());
            Assert.assertFalse((boolean)chore1_group2.isScheduled());
            Assert.assertFalse((boolean)chore2_group2.isScheduled());
            Assert.assertFalse((boolean)chore3_group2.isScheduled());
        }
        finally {
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testShutdownCancelsScheduledChores() throws InterruptedException {
        int period = 100;
        ChoreService service2 = new ChoreService("testShutdownCancelsScheduledChores");
        ScheduledChoreSamples.DoNothingChore successChore1 = new ScheduledChoreSamples.DoNothingChore("sc1", 100);
        ScheduledChoreSamples.DoNothingChore successChore2 = new ScheduledChoreSamples.DoNothingChore("sc2", 100);
        ScheduledChoreSamples.DoNothingChore successChore3 = new ScheduledChoreSamples.DoNothingChore("sc3", 100);
        try {
            Assert.assertTrue((boolean)service2.scheduleChore(successChore1));
            Assert.assertTrue((boolean)successChore1.isScheduled());
            Assert.assertTrue((boolean)service2.scheduleChore(successChore2));
            Assert.assertTrue((boolean)successChore2.isScheduled());
            Assert.assertTrue((boolean)service2.scheduleChore(successChore3));
            Assert.assertTrue((boolean)successChore3.isScheduled());
        }
        finally {
            this.shutdownService(service2);
        }
        Assert.assertFalse((boolean)successChore1.isScheduled());
        Assert.assertFalse((boolean)successChore2.isScheduled());
        Assert.assertFalse((boolean)successChore3.isScheduled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testShutdownWorksWhileChoresAreExecuting() throws InterruptedException {
        int period = 100;
        int sleep = 500;
        ChoreService service2 = new ChoreService("testShutdownWorksWhileChoresAreExecuting");
        ScheduledChoreSamples.SleepingChore slowChore1 = new ScheduledChoreSamples.SleepingChore("sc1", 100, 500);
        ScheduledChoreSamples.SleepingChore slowChore2 = new ScheduledChoreSamples.SleepingChore("sc2", 100, 500);
        ScheduledChoreSamples.SleepingChore slowChore3 = new ScheduledChoreSamples.SleepingChore("sc3", 100, 500);
        try {
            Assert.assertTrue((boolean)service2.scheduleChore(slowChore1));
            Assert.assertTrue((boolean)service2.scheduleChore(slowChore2));
            Assert.assertTrue((boolean)service2.scheduleChore(slowChore3));
            Thread.sleep(250L);
            this.shutdownService(service2);
            Assert.assertFalse((boolean)slowChore1.isScheduled());
            Assert.assertFalse((boolean)slowChore2.isScheduled());
            Assert.assertFalse((boolean)slowChore3.isScheduled());
            Assert.assertTrue((boolean)service2.isShutdown());
            Thread.sleep(5L);
            Assert.assertTrue((boolean)service2.isTerminated());
        }
        finally {
            this.shutdownService(service2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testShutdownRejectsNewSchedules() throws InterruptedException {
        int period = 100;
        ChoreService service2 = new ChoreService("testShutdownRejectsNewSchedules");
        ScheduledChoreSamples.DoNothingChore successChore1 = new ScheduledChoreSamples.DoNothingChore("sc1", 100);
        ScheduledChoreSamples.DoNothingChore successChore2 = new ScheduledChoreSamples.DoNothingChore("sc2", 100);
        ScheduledChoreSamples.DoNothingChore successChore3 = new ScheduledChoreSamples.DoNothingChore("sc3", 100);
        ScheduledChoreSamples.DoNothingChore failChore1 = new ScheduledChoreSamples.DoNothingChore("fc1", 100);
        ScheduledChoreSamples.DoNothingChore failChore2 = new ScheduledChoreSamples.DoNothingChore("fc2", 100);
        ScheduledChoreSamples.DoNothingChore failChore3 = new ScheduledChoreSamples.DoNothingChore("fc3", 100);
        try {
            Assert.assertTrue((boolean)service2.scheduleChore(successChore1));
            Assert.assertTrue((boolean)successChore1.isScheduled());
            Assert.assertTrue((boolean)service2.scheduleChore(successChore2));
            Assert.assertTrue((boolean)successChore2.isScheduled());
            Assert.assertTrue((boolean)service2.scheduleChore(successChore3));
            Assert.assertTrue((boolean)successChore3.isScheduled());
        }
        finally {
            this.shutdownService(service2);
        }
        Assert.assertFalse((boolean)service2.scheduleChore(failChore1));
        Assert.assertFalse((boolean)failChore1.isScheduled());
        Assert.assertFalse((boolean)service2.scheduleChore(failChore2));
        Assert.assertFalse((boolean)failChore2.isScheduled());
        Assert.assertFalse((boolean)service2.scheduleChore(failChore3));
        Assert.assertFalse((boolean)failChore3.isScheduled());
    }

    public static class ScheduledChoreSamples {

        public static class FailInitialChore
        extends ScheduledChore {
            private int numberOfFailures = 0;
            private int failureThreshold;

            public FailInitialChore(String name, int period, int failThreshold) {
                this(name, (Stoppable)new SampleStopper(), period, failThreshold);
            }

            public FailInitialChore(String name, Stoppable stopper, int period, int failThreshold) {
                super(name, stopper, period);
                this.failureThreshold = failThreshold;
            }

            @Override
            protected boolean initialChore() {
                if (this.numberOfFailures < this.failureThreshold) {
                    ++this.numberOfFailures;
                    return false;
                }
                return true;
            }

            @Override
            protected void chore() {
                Assert.assertTrue((this.numberOfFailures == this.failureThreshold ? 1 : 0) != 0);
                this.cancel(false);
            }
        }

        public static class CountingChore
        extends ScheduledChore {
            private int countOfChoreCalls = 0;
            private boolean outputOnTicks = false;

            public CountingChore(String name, int period) {
                this(name, new SampleStopper(), period);
            }

            public CountingChore(String name, Stoppable stopper, int period) {
                this(name, stopper, period, false);
            }

            public CountingChore(String name, Stoppable stopper, int period, boolean outputOnTicks) {
                super(name, stopper, period);
                this.outputOnTicks = outputOnTicks;
            }

            @Override
            protected boolean initialChore() {
                ++this.countOfChoreCalls;
                if (this.outputOnTicks) {
                    this.outputTickCount();
                }
                return true;
            }

            @Override
            protected void chore() {
                ++this.countOfChoreCalls;
                if (this.outputOnTicks) {
                    this.outputTickCount();
                }
            }

            private void outputTickCount() {
                System.out.println("Chore: " + this.getName() + ". Count of chore calls: " + this.countOfChoreCalls);
            }

            public int getCountOfChoreCalls() {
                return this.countOfChoreCalls;
            }

            public boolean isOutputtingOnTicks() {
                return this.outputOnTicks;
            }

            public void setOutputOnTicks(boolean o) {
                this.outputOnTicks = o;
            }
        }

        public static class SleepingChore
        extends ScheduledChore {
            private int sleepTime;

            public SleepingChore(String name, int chorePeriod, int sleepTime) {
                this(name, (Stoppable)new SampleStopper(), chorePeriod, sleepTime);
            }

            public SleepingChore(String name, Stoppable stopper, int period, int sleepTime) {
                super(name, stopper, period);
                this.sleepTime = sleepTime;
            }

            @Override
            protected boolean initialChore() {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected void chore() {
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception e) {
                    System.err.println(e.getStackTrace());
                }
            }
        }

        public static class DoNothingChore
        extends ScheduledChore {
            public DoNothingChore(String name, int period) {
                super(name, new SampleStopper(), period);
            }

            public DoNothingChore(String name, Stoppable stopper, int period) {
                super(name, stopper, period);
            }

            @Override
            protected void chore() {
            }
        }

        public static class SlowChore
        extends ScheduledChore {
            public SlowChore(String name, int period) {
                this(name, new SampleStopper(), period);
            }

            public SlowChore(String name, Stoppable stopper, int period) {
                super(name, stopper, period);
            }

            @Override
            protected boolean initialChore() {
                try {
                    Thread.sleep(this.getPeriod() * 2);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }

            @Override
            protected void chore() {
                try {
                    Thread.sleep(this.getPeriod() * 2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public static class SampleStopper
        implements Stoppable {
            private boolean stopped = false;

            @Override
            public void stop(String why) {
                this.stopped = true;
            }

            @Override
            public boolean isStopped() {
                return this.stopped;
            }
        }
    }
}

