/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.LimitInputStream;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.DynamicClassLoader;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@SuppressWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="None. Address sometime.")
public final class ProtobufUtil {
    private static final Map<String, Class<?>> PRIMITIVES = new HashMap();
    private static final Cell[] EMPTY_CELL_ARRAY = new Cell[0];
    private static final Result EMPTY_RESULT = Result.create(EMPTY_CELL_ARRAY);
    private static final Result EMPTY_RESULT_EXISTS_TRUE = Result.create(null, true);
    private static final Result EMPTY_RESULT_EXISTS_FALSE = Result.create(null, false);
    private static final Result EMPTY_RESULT_STALE = Result.create(EMPTY_CELL_ARRAY, null, true);
    private static final Result EMPTY_RESULT_EXISTS_TRUE_STALE = Result.create((Cell[])null, (Boolean)true, true);
    private static final Result EMPTY_RESULT_EXISTS_FALSE_STALE = Result.create((Cell[])null, (Boolean)false, true);
    private static final ClientProtos.Result EMPTY_RESULT_PB;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_TRUE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_FALSE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_STALE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_TRUE_STALE;
    private static final ClientProtos.Result EMPTY_RESULT_PB_EXISTS_FALSE_STALE;
    private static final ClassLoader CLASS_LOADER;
    public static final byte[] PB_MAGIC;
    private static final String PB_MAGIC_STR;

    private ProtobufUtil() {
    }

    public static byte[] prependPBMagic(byte[] bytes) {
        return Bytes.add(PB_MAGIC, bytes);
    }

    public static boolean isPBMagicPrefix(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        return ProtobufUtil.isPBMagicPrefix(bytes, 0, bytes.length);
    }

    public static boolean isPBMagicPrefix(byte[] bytes, int offset, int len) {
        if (bytes == null || len < PB_MAGIC.length) {
            return false;
        }
        return Bytes.compareTo(PB_MAGIC, 0, PB_MAGIC.length, bytes, offset, PB_MAGIC.length) == 0;
    }

    public static void expectPBMagicPrefix(byte[] bytes) throws DeserializationException {
        if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
            throw new DeserializationException("Missing pb magic " + PB_MAGIC_STR + " prefix");
        }
    }

    public static int lengthOfPBMagic() {
        return PB_MAGIC.length;
    }

    public static IOException getRemoteException(ServiceException se) {
        Throwable e = se.getCause();
        if (e == null) {
            return new IOException(se);
        }
        if (ExceptionUtil.isInterrupt(e)) {
            return ExceptionUtil.asInterrupt(e);
        }
        if (e instanceof RemoteException) {
            e = ((RemoteException)e).unwrapRemoteException();
        }
        return e instanceof IOException ? (IOException)e : new IOException(se);
    }

    public static HBaseProtos.ServerName toServerName(ServerName serverName) {
        if (serverName == null) {
            return null;
        }
        HBaseProtos.ServerName.Builder builder = HBaseProtos.ServerName.newBuilder();
        builder.setHostName(serverName.getHostname());
        if (serverName.getPort() >= 0) {
            builder.setPort(serverName.getPort());
        }
        if (serverName.getStartcode() >= 0L) {
            builder.setStartCode(serverName.getStartcode());
        }
        return builder.build();
    }

    public static ServerName toServerName(HBaseProtos.ServerName proto) {
        if (proto == null) {
            return null;
        }
        String hostName = proto.getHostName();
        long startCode = -1L;
        int port = -1;
        if (proto.hasPort()) {
            port = proto.getPort();
        }
        if (proto.hasStartCode()) {
            startCode = proto.getStartCode();
        }
        return ServerName.valueOf(hostName, port, startCode);
    }

    public static HTableDescriptor[] getHTableDescriptorArray(MasterProtos.GetTableDescriptorsResponse proto) {
        if (proto == null) {
            return null;
        }
        HTableDescriptor[] ret = new HTableDescriptor[proto.getTableSchemaCount()];
        for (int i = 0; i < proto.getTableSchemaCount(); ++i) {
            ret[i] = HTableDescriptor.convert(proto.getTableSchema(i));
        }
        return ret;
    }

    public static byte[][] getSplitKeysArray(MasterProtos.CreateTableRequest proto) {
        byte[][] splitKeys = new byte[proto.getSplitKeysCount()][];
        for (int i = 0; i < proto.getSplitKeysCount(); ++i) {
            splitKeys[i] = proto.getSplitKeys(i).toByteArray();
        }
        return splitKeys;
    }

    public static Durability toDurability(ClientProtos.MutationProto.Durability proto) {
        switch (proto) {
            case USE_DEFAULT: {
                return Durability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return Durability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return Durability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return Durability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return Durability.FSYNC_WAL;
            }
        }
        return Durability.USE_DEFAULT;
    }

    public static ClientProtos.MutationProto.Durability toDurability(Durability d) {
        switch (d) {
            case USE_DEFAULT: {
                return ClientProtos.MutationProto.Durability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return ClientProtos.MutationProto.Durability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return ClientProtos.MutationProto.Durability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return ClientProtos.MutationProto.Durability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return ClientProtos.MutationProto.Durability.FSYNC_WAL;
            }
        }
        return ClientProtos.MutationProto.Durability.USE_DEFAULT;
    }

    public static Get toGet(ClientProtos.Get proto) throws IOException {
        if (proto == null) {
            return null;
        }
        byte[] row = proto.getRow().toByteArray();
        Get get2 = new Get(row);
        if (proto.hasCacheBlocks()) {
            get2.setCacheBlocks(proto.getCacheBlocks());
        }
        if (proto.hasMaxVersions()) {
            get2.setMaxVersions(proto.getMaxVersions());
        }
        if (proto.hasStoreLimit()) {
            get2.setMaxResultsPerColumnFamily(proto.getStoreLimit());
        }
        if (proto.hasStoreOffset()) {
            get2.setRowOffsetPerColumnFamily(proto.getStoreOffset());
        }
        if (proto.getCfTimeRangeCount() > 0) {
            for (HBaseProtos.ColumnFamilyTimeRange cftr : proto.getCfTimeRangeList()) {
                TimeRange timeRange = ProtobufUtil.protoToTimeRange(cftr.getTimeRange());
                get2.setColumnFamilyTimeRange(cftr.getColumnFamily().toByteArray(), timeRange.getMin(), timeRange.getMax());
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            get2.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        if (proto.hasFilter()) {
            FilterProtos.Filter filter = proto.getFilter();
            get2.setFilter(ProtobufUtil.toFilter(filter));
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            get2.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        if (proto.getColumnCount() > 0) {
            for (ClientProtos.Column column : proto.getColumnList()) {
                byte[] family = column.getFamily().toByteArray();
                if (column.getQualifierCount() > 0) {
                    for (ByteString qualifier : column.getQualifierList()) {
                        get2.addColumn(family, qualifier.toByteArray());
                    }
                    continue;
                }
                get2.addFamily(family);
            }
        }
        if (proto.hasExistenceOnly() && proto.getExistenceOnly()) {
            get2.setCheckExistenceOnly(true);
        }
        if (proto.hasClosestRowBefore() && proto.getClosestRowBefore()) {
            get2.setClosestRowBefore(true);
        }
        if (proto.hasConsistency()) {
            get2.setConsistency(ProtobufUtil.toConsistency(proto.getConsistency()));
        }
        return get2;
    }

    public static Consistency toConsistency(ClientProtos.Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return Consistency.STRONG;
            }
            case TIMELINE: {
                return Consistency.TIMELINE;
            }
        }
        return Consistency.STRONG;
    }

    public static ClientProtos.Consistency toConsistency(Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return ClientProtos.Consistency.STRONG;
            }
            case TIMELINE: {
                return ClientProtos.Consistency.TIMELINE;
            }
        }
        return ClientProtos.Consistency.STRONG;
    }

    public static Put toPut(ClientProtos.MutationProto proto) throws IOException {
        return ProtobufUtil.toPut(proto, null);
    }

    public static Put toPut(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.PUT) : type.name();
        long timestamp = proto.hasTimestamp() ? proto.getTimestamp() : Long.MAX_VALUE;
        Put put2 = proto.hasRow() ? new Put(proto.getRow().toByteArray(), timestamp) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + ProtobufUtil.toShortString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + ProtobufUtil.toShortString(proto));
                }
                Cell cell = cellScanner.current();
                if (put2 == null) {
                    put2 = new Put(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), timestamp);
                }
                put2.add(cell);
            }
        } else {
            if (put2 == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    ByteBuffer qualifier = qv.hasQualifier() ? qv.getQualifier().asReadOnlyByteBuffer() : null;
                    ByteBuffer value = qv.hasValue() ? qv.getValue().asReadOnlyByteBuffer() : null;
                    long ts = timestamp;
                    if (qv.hasTimestamp()) {
                        ts = qv.getTimestamp();
                    }
                    if (qv.hasTags()) {
                        byte[] tags = qv.getTags().toByteArray();
                        Object[] array2 = Tag.asList(tags, 0, (short)tags.length).toArray();
                        Tag[] tagArray = new Tag[array2.length];
                        for (int i = 0; i < array2.length; ++i) {
                            tagArray[i] = (Tag)array2[i];
                        }
                        if (qv.hasDeleteType()) {
                            byte[] qual = qv.hasQualifier() ? qv.getQualifier().toByteArray() : null;
                            put2.add(new KeyValue(proto.getRow().toByteArray(), family, qual, ts, ProtobufUtil.fromDeleteType(qv.getDeleteType()), null, tags));
                            continue;
                        }
                        put2.addImmutable(family, qualifier, ts, value, tagArray);
                        continue;
                    }
                    if (qv.hasDeleteType()) {
                        byte[] qual = qv.hasQualifier() ? qv.getQualifier().toByteArray() : null;
                        put2.add(new KeyValue(proto.getRow().toByteArray(), family, qual, ts, ProtobufUtil.fromDeleteType(qv.getDeleteType())));
                        continue;
                    }
                    put2.addImmutable(family, qualifier, ts, value);
                }
            }
        }
        put2.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            put2.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return put2;
    }

    public static Delete toDelete(ClientProtos.MutationProto proto) throws IOException {
        return ProtobufUtil.toDelete(proto, null);
    }

    public static Delete toDelete(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.DELETE) : type.name();
        long timestamp = proto.hasTimestamp() ? proto.getTimestamp() : Long.MAX_VALUE;
        Delete delete = proto.hasRow() ? new Delete(proto.getRow().toByteArray(), timestamp) : null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
                }
                Cell cell = cellScanner.current();
                if (delete == null) {
                    delete = new Delete(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), timestamp);
                }
                delete.addDeleteMarker(cell);
            }
        } else {
            if (delete == null) {
                throw new IllegalArgumentException("row cannot be null");
            }
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    ClientProtos.MutationProto.DeleteType deleteType = qv.getDeleteType();
                    byte[] qualifier = null;
                    if (qv.hasQualifier()) {
                        qualifier = qv.getQualifier().toByteArray();
                    }
                    long ts = Long.MAX_VALUE;
                    if (qv.hasTimestamp()) {
                        ts = qv.getTimestamp();
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION) {
                        delete.deleteColumn(family, qualifier, ts);
                        continue;
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS) {
                        delete.deleteColumns(family, qualifier, ts);
                        continue;
                    }
                    if (deleteType == ClientProtos.MutationProto.DeleteType.DELETE_FAMILY_VERSION) {
                        delete.deleteFamilyVersion(family, ts);
                        continue;
                    }
                    delete.deleteFamily(family, ts);
                }
            }
        }
        delete.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            delete.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return delete;
    }

    public static Append toAppend(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.APPEND) : type.name();
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Append append = null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + ProtobufUtil.toShortString(proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + ProtobufUtil.toShortString(proto));
                }
                Cell cell = cellScanner.current();
                if (append == null) {
                    append = new Append(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
                }
                append.add(cell);
            }
        } else {
            append = new Append(row);
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    byte[] value = qv.getValue().toByteArray();
                    byte[] tags = null;
                    if (qv.hasTags()) {
                        tags = qv.getTags().toByteArray();
                    }
                    append.add(CellUtil.createCell(row, family, qualifier, qv.getTimestamp(), KeyValue.Type.Put, value, tags));
                }
            }
        }
        append.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            append.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return append;
    }

    public static Mutation toMutation(ClientProtos.MutationProto proto) throws IOException {
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        if (type == ClientProtos.MutationProto.MutationType.APPEND) {
            return ProtobufUtil.toAppend(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.DELETE) {
            return ProtobufUtil.toDelete(proto, null);
        }
        if (type == ClientProtos.MutationProto.MutationType.PUT) {
            return ProtobufUtil.toPut(proto, null);
        }
        throw new IOException("Unknown mutation type " + (Object)((Object)type));
    }

    public static Increment toIncrement(ClientProtos.MutationProto proto, CellScanner cellScanner) throws IOException {
        int cellCount;
        ClientProtos.MutationProto.MutationType type = proto.getMutateType();
        assert (type == ClientProtos.MutationProto.MutationType.INCREMENT) : type.name();
        byte[] row = proto.hasRow() ? proto.getRow().toByteArray() : null;
        Increment increment = null;
        int n = cellCount = proto.hasAssociatedCellCount() ? proto.getAssociatedCellCount() : 0;
        if (cellCount > 0) {
            if (cellScanner == null) {
                throw new DoNotRetryIOException("Cell count of " + cellCount + " but no cellScanner: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
            }
            for (int i = 0; i < cellCount; ++i) {
                if (!cellScanner.advance()) {
                    throw new DoNotRetryIOException("Cell count of " + cellCount + " but at index " + i + " no cell returned: " + TextFormat.shortDebugString((MessageOrBuilder)proto));
                }
                Cell cell = cellScanner.current();
                if (increment == null) {
                    increment = new Increment(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
                }
                increment.add(cell);
            }
        } else {
            increment = new Increment(row);
            for (ClientProtos.MutationProto.ColumnValue column : proto.getColumnValueList()) {
                byte[] family = column.getFamily().toByteArray();
                for (ClientProtos.MutationProto.ColumnValue.QualifierValue qv : column.getQualifierValueList()) {
                    byte[] qualifier = qv.getQualifier().toByteArray();
                    if (!qv.hasValue()) {
                        throw new DoNotRetryIOException("Missing required field: qualifier value");
                    }
                    byte[] value = qv.getValue().toByteArray();
                    byte[] tags = null;
                    if (qv.hasTags()) {
                        tags = qv.getTags().toByteArray();
                    }
                    increment.add(CellUtil.createCell(row, family, qualifier, qv.getTimestamp(), KeyValue.Type.Put, value, tags));
                }
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            increment.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        increment.setDurability(ProtobufUtil.toDurability(proto.getDurability()));
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            increment.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        return increment;
    }

    public static ClientProtos.Scan toScan(Scan scan) throws IOException {
        byte[] stopRow;
        byte[] startRow;
        Map<String, byte[]> attributes;
        Boolean loadColumnFamiliesOnDemand;
        ClientProtos.Scan.Builder scanBuilder = ClientProtos.Scan.newBuilder();
        scanBuilder.setCacheBlocks(scan.getCacheBlocks());
        if (scan.getBatch() > 0) {
            scanBuilder.setBatchSize(scan.getBatch());
        }
        if (scan.getMaxResultSize() > 0L) {
            scanBuilder.setMaxResultSize(scan.getMaxResultSize());
        }
        if (scan.isSmall()) {
            scanBuilder.setSmall(scan.isSmall());
        }
        if (scan.getAllowPartialResults()) {
            scanBuilder.setAllowPartialResults(scan.getAllowPartialResults());
        }
        if ((loadColumnFamiliesOnDemand = scan.getLoadColumnFamiliesOnDemandValue()) != null) {
            scanBuilder.setLoadColumnFamiliesOnDemand(loadColumnFamiliesOnDemand);
        }
        scanBuilder.setMaxVersions(scan.getMaxVersions());
        for (Map.Entry<byte[], TimeRange> cftr : scan.getColumnFamilyTimeRange().entrySet()) {
            HBaseProtos.ColumnFamilyTimeRange.Builder b = HBaseProtos.ColumnFamilyTimeRange.newBuilder();
            b.setColumnFamily(ByteString.copyFrom((byte[])cftr.getKey()));
            b.setTimeRange(ProtobufUtil.timeRangeToProto(cftr.getValue()));
            scanBuilder.addCfTimeRange(b);
        }
        TimeRange timeRange = scan.getTimeRange();
        if (!timeRange.isAllTime()) {
            HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
            timeRangeBuilder.setFrom(timeRange.getMin());
            timeRangeBuilder.setTo(timeRange.getMax());
            scanBuilder.setTimeRange(timeRangeBuilder.build());
        }
        if (!(attributes = scan.getAttributesMap()).isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap(attribute.getValue()));
                scanBuilder.addAttribute(attributeBuilder.build());
            }
        }
        if ((startRow = scan.getStartRow()) != null && startRow.length > 0) {
            scanBuilder.setStartRow(ByteStringer.wrap(startRow));
        }
        if ((stopRow = scan.getStopRow()) != null && stopRow.length > 0) {
            scanBuilder.setStopRow(ByteStringer.wrap(stopRow));
        }
        if (scan.hasFilter()) {
            scanBuilder.setFilter(ProtobufUtil.toFilter(scan.getFilter()));
        }
        if (scan.hasFamilies()) {
            ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
            for (Map.Entry<byte[], NavigableSet<byte[]>> family : scan.getFamilyMap().entrySet()) {
                columnBuilder.setFamily(ByteStringer.wrap(family.getKey()));
                NavigableSet<byte[]> qualifiers = family.getValue();
                columnBuilder.clearQualifier();
                if (qualifiers != null && qualifiers.size() > 0) {
                    for (byte[] qualifier : qualifiers) {
                        columnBuilder.addQualifier(ByteStringer.wrap(qualifier));
                    }
                }
                scanBuilder.addColumn(columnBuilder.build());
            }
        }
        if (scan.getMaxResultsPerColumnFamily() >= 0) {
            scanBuilder.setStoreLimit(scan.getMaxResultsPerColumnFamily());
        }
        if (scan.getRowOffsetPerColumnFamily() > 0) {
            scanBuilder.setStoreOffset(scan.getRowOffsetPerColumnFamily());
        }
        if (scan.isReversed()) {
            scanBuilder.setReversed(scan.isReversed());
        }
        if (scan.getConsistency() == Consistency.TIMELINE) {
            scanBuilder.setConsistency(ProtobufUtil.toConsistency(scan.getConsistency()));
        }
        if (scan.getCaching() > 0) {
            scanBuilder.setCaching(scan.getCaching());
        }
        return scanBuilder.build();
    }

    public static Scan toScan(ClientProtos.Scan proto) throws IOException {
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] stopRow = HConstants.EMPTY_END_ROW;
        if (proto.hasStartRow()) {
            startRow = proto.getStartRow().toByteArray();
        }
        if (proto.hasStopRow()) {
            stopRow = proto.getStopRow().toByteArray();
        }
        Scan scan = new Scan(startRow, stopRow);
        if (proto.hasCacheBlocks()) {
            scan.setCacheBlocks(proto.getCacheBlocks());
        }
        if (proto.hasMaxVersions()) {
            scan.setMaxVersions(proto.getMaxVersions());
        }
        if (proto.hasStoreLimit()) {
            scan.setMaxResultsPerColumnFamily(proto.getStoreLimit());
        }
        if (proto.hasStoreOffset()) {
            scan.setRowOffsetPerColumnFamily(proto.getStoreOffset());
        }
        if (proto.hasLoadColumnFamiliesOnDemand()) {
            scan.setLoadColumnFamiliesOnDemand(proto.getLoadColumnFamiliesOnDemand());
        }
        if (proto.getCfTimeRangeCount() > 0) {
            for (HBaseProtos.ColumnFamilyTimeRange cftr : proto.getCfTimeRangeList()) {
                TimeRange timeRange = ProtobufUtil.protoToTimeRange(cftr.getTimeRange());
                scan.setColumnFamilyTimeRange(cftr.getColumnFamily().toByteArray(), timeRange.getMin(), timeRange.getMax());
            }
        }
        if (proto.hasTimeRange()) {
            TimeRange timeRange = ProtobufUtil.protoToTimeRange(proto.getTimeRange());
            scan.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        if (proto.hasFilter()) {
            FilterProtos.Filter filter = proto.getFilter();
            scan.setFilter(ProtobufUtil.toFilter(filter));
        }
        if (proto.hasBatchSize()) {
            scan.setBatch(proto.getBatchSize());
        }
        if (proto.hasMaxResultSize()) {
            scan.setMaxResultSize(proto.getMaxResultSize());
        }
        if (proto.hasSmall()) {
            scan.setSmall(proto.getSmall());
        }
        if (proto.hasAllowPartialResults()) {
            scan.setAllowPartialResults(proto.getAllowPartialResults());
        }
        for (HBaseProtos.NameBytesPair attribute : proto.getAttributeList()) {
            scan.setAttribute(attribute.getName(), attribute.getValue().toByteArray());
        }
        if (proto.getColumnCount() > 0) {
            for (ClientProtos.Column column : proto.getColumnList()) {
                byte[] family = column.getFamily().toByteArray();
                if (column.getQualifierCount() > 0) {
                    for (ByteString qualifier : column.getQualifierList()) {
                        scan.addColumn(family, qualifier.toByteArray());
                    }
                    continue;
                }
                scan.addFamily(family);
            }
        }
        if (proto.hasReversed()) {
            scan.setReversed(proto.getReversed());
        }
        if (proto.hasConsistency()) {
            scan.setConsistency(ProtobufUtil.toConsistency(proto.getConsistency()));
        }
        if (proto.hasCaching()) {
            scan.setCaching(proto.getCaching());
        }
        return scan;
    }

    public static ClientProtos.Get toGet(Get get2) throws IOException {
        Map<String, byte[]> attributes;
        ClientProtos.Get.Builder builder = ClientProtos.Get.newBuilder();
        builder.setRow(ByteStringer.wrap(get2.getRow()));
        builder.setCacheBlocks(get2.getCacheBlocks());
        builder.setMaxVersions(get2.getMaxVersions());
        if (get2.getFilter() != null) {
            builder.setFilter(ProtobufUtil.toFilter(get2.getFilter()));
        }
        for (Map.Entry<byte[], TimeRange> cftr : get2.getColumnFamilyTimeRange().entrySet()) {
            HBaseProtos.ColumnFamilyTimeRange.Builder b = HBaseProtos.ColumnFamilyTimeRange.newBuilder();
            b.setColumnFamily(ByteString.copyFrom((byte[])cftr.getKey()));
            b.setTimeRange(ProtobufUtil.timeRangeToProto(cftr.getValue()));
            builder.addCfTimeRange(b);
        }
        TimeRange timeRange = get2.getTimeRange();
        if (!timeRange.isAllTime()) {
            HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
            timeRangeBuilder.setFrom(timeRange.getMin());
            timeRangeBuilder.setTo(timeRange.getMax());
            builder.setTimeRange(timeRangeBuilder.build());
        }
        if (!(attributes = get2.getAttributesMap()).isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap(attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        if (get2.hasFamilies()) {
            ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
            Map<byte[], NavigableSet<byte[]>> families = get2.getFamilyMap();
            for (Map.Entry<byte[], NavigableSet<byte[]>> family : families.entrySet()) {
                NavigableSet<byte[]> qualifiers = family.getValue();
                columnBuilder.setFamily(ByteStringer.wrap(family.getKey()));
                columnBuilder.clearQualifier();
                if (qualifiers != null && qualifiers.size() > 0) {
                    for (byte[] qualifier : qualifiers) {
                        columnBuilder.addQualifier(ByteStringer.wrap(qualifier));
                    }
                }
                builder.addColumn(columnBuilder.build());
            }
        }
        if (get2.getMaxResultsPerColumnFamily() >= 0) {
            builder.setStoreLimit(get2.getMaxResultsPerColumnFamily());
        }
        if (get2.getRowOffsetPerColumnFamily() > 0) {
            builder.setStoreOffset(get2.getRowOffsetPerColumnFamily());
        }
        if (get2.isCheckExistenceOnly()) {
            builder.setExistenceOnly(true);
        }
        if (get2.isClosestRowBefore()) {
            builder.setClosestRowBefore(true);
        }
        if (get2.getConsistency() != null && get2.getConsistency() != Consistency.STRONG) {
            builder.setConsistency(ProtobufUtil.toConsistency(get2.getConsistency()));
        }
        return builder.build();
    }

    static void setTimeRange(ClientProtos.MutationProto.Builder builder, TimeRange timeRange) {
        if (!timeRange.isAllTime()) {
            HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
            timeRangeBuilder.setFrom(timeRange.getMin());
            timeRangeBuilder.setTo(timeRange.getMax());
            builder.setTimeRange(timeRangeBuilder.build());
        }
    }

    public static ClientProtos.MutationProto toMutation(Increment increment, ClientProtos.MutationProto.Builder builder, long nonce) {
        builder.setRow(ByteStringer.wrap(increment.getRow()));
        builder.setMutateType(ClientProtos.MutationProto.MutationType.INCREMENT);
        builder.setDurability(ProtobufUtil.toDurability(increment.getDurability()));
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        TimeRange timeRange = increment.getTimeRange();
        ProtobufUtil.setTimeRange(builder, timeRange);
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        for (Map.Entry family : increment.getFamilyCellMap().entrySet()) {
            columnBuilder.setFamily(ByteStringer.wrap((byte[])family.getKey()));
            columnBuilder.clearQualifierValue();
            List values2 = (List)family.getValue();
            if (values2 != null && values2.size() > 0) {
                for (Cell cell : values2) {
                    valueBuilder.clear();
                    valueBuilder.setQualifier(ByteStringer.wrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
                    valueBuilder.setValue(ByteStringer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
                    if (cell.getTagsLength() > 0) {
                        valueBuilder.setTags(ByteStringer.wrap(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength()));
                    }
                    columnBuilder.addQualifierValue(valueBuilder.build());
                }
            }
            builder.addColumnValue(columnBuilder.build());
        }
        Map<String, byte[]> attributes = increment.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap(attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        return builder.build();
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, 0L);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, long nonce) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, ClientProtos.MutationProto.newBuilder(), nonce);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) throws IOException {
        return ProtobufUtil.toMutation(type, mutation, builder, 0L);
    }

    public static ClientProtos.MutationProto toMutation(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder, long nonce) throws IOException {
        builder = ProtobufUtil.getMutationBuilderAndSetCommonFields(type, mutation, builder);
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        for (Map.Entry family : mutation.getFamilyCellMap().entrySet()) {
            columnBuilder.clear();
            columnBuilder.setFamily(ByteStringer.wrap((byte[])family.getKey()));
            for (Cell cell : (List)family.getValue()) {
                valueBuilder.clear();
                valueBuilder.setQualifier(ByteStringer.wrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
                valueBuilder.setValue(ByteStringer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
                valueBuilder.setTimestamp(cell.getTimestamp());
                if (type == ClientProtos.MutationProto.MutationType.DELETE || type == ClientProtos.MutationProto.MutationType.PUT && CellUtil.isDelete(cell)) {
                    KeyValue.Type keyValueType = KeyValue.Type.codeToType(cell.getTypeByte());
                    valueBuilder.setDeleteType(ProtobufUtil.toDeleteType(keyValueType));
                }
                columnBuilder.addQualifierValue(valueBuilder.build());
            }
            builder.addColumnValue(columnBuilder.build());
        }
        return builder.build();
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) throws IOException {
        return ProtobufUtil.toMutationNoData(type, mutation, builder, 0L);
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation) throws IOException {
        ClientProtos.MutationProto.Builder builder = ClientProtos.MutationProto.newBuilder();
        return ProtobufUtil.toMutationNoData(type, mutation, builder);
    }

    public static ClientProtos.MutationProto toMutationNoData(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder, long nonce) throws IOException {
        ProtobufUtil.getMutationBuilderAndSetCommonFields(type, mutation, builder);
        builder.setAssociatedCellCount(mutation.size());
        if (mutation instanceof Increment) {
            ProtobufUtil.setTimeRange(builder, ((Increment)mutation).getTimeRange());
        }
        if (nonce != 0L) {
            builder.setNonce(nonce);
        }
        return builder.build();
    }

    private static ClientProtos.MutationProto.Builder getMutationBuilderAndSetCommonFields(ClientProtos.MutationProto.MutationType type, Mutation mutation, ClientProtos.MutationProto.Builder builder) {
        builder.setRow(ByteStringer.wrap(mutation.getRow()));
        builder.setMutateType(type);
        builder.setDurability(ProtobufUtil.toDurability(mutation.getDurability()));
        builder.setTimestamp(mutation.getTimeStamp());
        Map<String, byte[]> attributes = mutation.getAttributesMap();
        if (!attributes.isEmpty()) {
            HBaseProtos.NameBytesPair.Builder attributeBuilder = HBaseProtos.NameBytesPair.newBuilder();
            for (Map.Entry<String, byte[]> attribute : attributes.entrySet()) {
                attributeBuilder.setName(attribute.getKey());
                attributeBuilder.setValue(ByteStringer.wrap(attribute.getValue()));
                builder.addAttribute(attributeBuilder.build());
            }
        }
        return builder;
    }

    public static ClientProtos.Result toResult(Result result) {
        if (result.getExists() != null) {
            return ProtobufUtil.toResult(result.getExists(), result.isStale());
        }
        Cell[] cells = result.rawCells();
        if (cells == null || cells.length == 0) {
            return result.isStale() ? EMPTY_RESULT_PB_STALE : EMPTY_RESULT_PB;
        }
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        for (Cell c : cells) {
            builder.addCell(ProtobufUtil.toCell(c));
        }
        builder.setStale(result.isStale());
        builder.setPartial(result.isPartial());
        return builder.build();
    }

    public static ClientProtos.Result toResult(boolean existence, boolean stale) {
        if (stale) {
            return existence ? EMPTY_RESULT_PB_EXISTS_TRUE_STALE : EMPTY_RESULT_PB_EXISTS_FALSE_STALE;
        }
        return existence ? EMPTY_RESULT_PB_EXISTS_TRUE : EMPTY_RESULT_PB_EXISTS_FALSE;
    }

    public static ClientProtos.Result toResultNoData(Result result) {
        if (result.getExists() != null) {
            return ProtobufUtil.toResult(result.getExists(), result.isStale());
        }
        int size = result.size();
        if (size == 0) {
            return result.isStale() ? EMPTY_RESULT_PB_STALE : EMPTY_RESULT_PB;
        }
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        builder.setAssociatedCellCount(size);
        builder.setStale(result.isStale());
        return builder.build();
    }

    public static Result toResult(ClientProtos.Result proto) {
        if (proto.hasExists()) {
            if (proto.getStale()) {
                return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE_STALE : EMPTY_RESULT_EXISTS_FALSE_STALE;
            }
            return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE : EMPTY_RESULT_EXISTS_FALSE;
        }
        List<CellProtos.Cell> values2 = proto.getCellList();
        if (values2.isEmpty()) {
            return proto.getStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT;
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(values2.size());
        for (CellProtos.Cell c : values2) {
            cells.add(ProtobufUtil.toCell(c));
        }
        return Result.create(cells, null, proto.getStale(), proto.getPartial());
    }

    public static Result toResult(ClientProtos.Result proto, CellScanner scanner) throws IOException {
        List<CellProtos.Cell> values2 = proto.getCellList();
        if (proto.hasExists()) {
            if (values2 != null && !values2.isEmpty() || proto.hasAssociatedCellCount() && proto.getAssociatedCellCount() > 0) {
                throw new IllegalArgumentException("bad proto: exists with cells is no allowed " + proto);
            }
            if (proto.getStale()) {
                return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE_STALE : EMPTY_RESULT_EXISTS_FALSE_STALE;
            }
            return proto.getExists() ? EMPTY_RESULT_EXISTS_TRUE : EMPTY_RESULT_EXISTS_FALSE;
        }
        ArrayList<Cell> cells = null;
        if (proto.hasAssociatedCellCount()) {
            int count2 = proto.getAssociatedCellCount();
            cells = new ArrayList<Cell>(count2 + values2.size());
            for (int i = 0; i < count2; ++i) {
                if (!scanner.advance()) {
                    throw new IOException("Failed get " + i + " of " + count2);
                }
                cells.add(scanner.current());
            }
        }
        if (!values2.isEmpty()) {
            if (cells == null) {
                cells = new ArrayList(values2.size());
            }
            for (CellProtos.Cell c : values2) {
                cells.add(ProtobufUtil.toCell(c));
            }
        }
        return cells == null || cells.isEmpty() ? (proto.getStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT) : Result.create(cells, null, proto.getStale());
    }

    public static ComparatorProtos.Comparator toComparator(ByteArrayComparable comparator) {
        ComparatorProtos.Comparator.Builder builder = ComparatorProtos.Comparator.newBuilder();
        builder.setName(comparator.getClass().getName());
        builder.setSerializedComparator(ByteStringer.wrap(comparator.toByteArray()));
        return builder.build();
    }

    public static ByteArrayComparable toComparator(ComparatorProtos.Comparator proto) throws IOException {
        String type = proto.getName();
        String funcName = "parseFrom";
        byte[] value = proto.getSerializedComparator().toByteArray();
        try {
            Class<?> c = Class.forName(type, true, CLASS_LOADER);
            Method parseFrom = c.getMethod(funcName, byte[].class);
            if (parseFrom == null) {
                throw new IOException("Unable to locate function: " + funcName + " in type: " + type);
            }
            return (ByteArrayComparable)parseFrom.invoke(null, new Object[]{value});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Filter toFilter(FilterProtos.Filter proto) throws IOException {
        String type = proto.getName();
        byte[] value = proto.getSerializedFilter().toByteArray();
        String funcName = "parseFrom";
        try {
            Class<?> c = Class.forName(type, true, CLASS_LOADER);
            Method parseFrom = c.getMethod(funcName, byte[].class);
            if (parseFrom == null) {
                throw new IOException("Unable to locate function: " + funcName + " in type: " + type);
            }
            return (Filter)parseFrom.invoke(c, new Object[]{value});
        }
        catch (Exception e) {
            throw new DoNotRetryIOException(e);
        }
    }

    public static FilterProtos.Filter toFilter(Filter filter) throws IOException {
        FilterProtos.Filter.Builder builder = FilterProtos.Filter.newBuilder();
        builder.setName(filter.getClass().getName());
        builder.setSerializedFilter(ByteStringer.wrap(filter.toByteArray()));
        return builder.build();
    }

    public static ClientProtos.MutationProto.DeleteType toDeleteType(KeyValue.Type type) throws IOException {
        switch (type) {
            case Delete: {
                return ClientProtos.MutationProto.DeleteType.DELETE_ONE_VERSION;
            }
            case DeleteColumn: {
                return ClientProtos.MutationProto.DeleteType.DELETE_MULTIPLE_VERSIONS;
            }
            case DeleteFamily: {
                return ClientProtos.MutationProto.DeleteType.DELETE_FAMILY;
            }
            case DeleteFamilyVersion: {
                return ClientProtos.MutationProto.DeleteType.DELETE_FAMILY_VERSION;
            }
        }
        throw new IOException("Unknown delete type: " + (Object)((Object)type));
    }

    public static KeyValue.Type fromDeleteType(ClientProtos.MutationProto.DeleteType type) throws IOException {
        switch (type) {
            case DELETE_ONE_VERSION: {
                return KeyValue.Type.Delete;
            }
            case DELETE_MULTIPLE_VERSIONS: {
                return KeyValue.Type.DeleteColumn;
            }
            case DELETE_FAMILY: {
                return KeyValue.Type.DeleteFamily;
            }
            case DELETE_FAMILY_VERSION: {
                return KeyValue.Type.DeleteFamilyVersion;
            }
        }
        throw new IOException("Unknown delete type: " + (Object)((Object)type));
    }

    public static Throwable toException(HBaseProtos.NameBytesPair parameter) throws IOException {
        if (parameter == null || !parameter.hasValue()) {
            return null;
        }
        String desc = parameter.getValue().toStringUtf8();
        String type = parameter.getName();
        try {
            Class<?> c = Class.forName(type, true, CLASS_LOADER);
            Constructor<?> cn = null;
            try {
                cn = c.getDeclaredConstructor(String.class);
                return (Throwable)cn.newInstance(desc);
            }
            catch (NoSuchMethodException e) {
                cn = c.getDeclaredConstructor(String.class, String.class);
                return (Throwable)cn.newInstance(type, desc);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public static Result getRowOrBefore(ClientProtos.ClientService.BlockingInterface client, byte[] regionName, byte[] row, byte[] family) throws IOException {
        ClientProtos.GetRequest request = RequestConverter.buildGetRowOrBeforeRequest(regionName, row, family);
        try {
            ClientProtos.GetResponse response = client.get(null, request);
            if (!response.hasResult()) {
                return null;
            }
            return ProtobufUtil.toResult(response.getResult());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static boolean bulkLoadHFile(ClientProtos.ClientService.BlockingInterface client, List<Pair<byte[], String>> familyPaths, byte[] regionName, boolean assignSeqNum) throws IOException {
        ClientProtos.BulkLoadHFileRequest request = RequestConverter.buildBulkLoadHFileRequest(familyPaths, regionName, assignSeqNum);
        try {
            ClientProtos.BulkLoadHFileResponse response = client.bulkLoadHFile(null, request);
            return response.getLoaded();
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.ClientService.BlockingInterface client, ClientProtos.CoprocessorServiceCall call, byte[] regionName) throws IOException {
        ClientProtos.CoprocessorServiceRequest request = ClientProtos.CoprocessorServiceRequest.newBuilder().setCall(call).setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName)).build();
        try {
            ClientProtos.CoprocessorServiceResponse response = client.execService(controller, request);
            return response;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static ClientProtos.CoprocessorServiceResponse execService(RpcController controller, MasterProtos.MasterService.BlockingInterface client, ClientProtos.CoprocessorServiceCall call) throws IOException {
        ClientProtos.CoprocessorServiceRequest request = ClientProtos.CoprocessorServiceRequest.newBuilder().setCall(call).setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, HConstants.EMPTY_BYTE_ARRAY)).build();
        try {
            ClientProtos.CoprocessorServiceResponse response = client.execMasterService(controller, request);
            return response;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.ClientService.BlockingInterface client, ClientProtos.CoprocessorServiceCall call) throws IOException {
        ClientProtos.CoprocessorServiceRequest request = ClientProtos.CoprocessorServiceRequest.newBuilder().setCall(call).setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, HConstants.EMPTY_BYTE_ARRAY)).build();
        try {
            ClientProtos.CoprocessorServiceResponse response = client.execRegionServerService(controller, request);
            return response;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static <T extends Service> T newServiceStub(Class<T> service2, RpcChannel channel) throws Exception {
        return (T)((Service)Methods.call(service2, null, "newStub", new Class[]{RpcChannel.class}, new Object[]{channel}));
    }

    public static HRegionInfo getRegionInfo(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, byte[] regionName) throws IOException {
        try {
            AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(regionName);
            AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo(controller, request);
            return HRegionInfo.convert(response.getRegionInfo());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static void closeRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, ServerName server, byte[] regionName, boolean transitionInZK) throws IOException {
        AdminProtos.CloseRegionRequest closeRegionRequest = RequestConverter.buildCloseRegionRequest(server, regionName, transitionInZK);
        try {
            admin.closeRegion(controller, closeRegionRequest);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static boolean closeRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, ServerName server, byte[] regionName, int versionOfClosingNode, ServerName destinationServer, boolean transitionInZK) throws IOException {
        AdminProtos.CloseRegionRequest closeRegionRequest = RequestConverter.buildCloseRegionRequest(server, regionName, versionOfClosingNode, destinationServer, transitionInZK);
        try {
            AdminProtos.CloseRegionResponse response = admin.closeRegion(controller, closeRegionRequest);
            return ResponseConverter.isClosed(response);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static void warmupRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, HRegionInfo regionInfo) throws IOException {
        try {
            AdminProtos.WarmupRegionRequest warmupRegionRequest = RequestConverter.buildWarmupRegionRequest(regionInfo);
            admin.warmupRegion(controller, warmupRegionRequest);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException(e);
        }
    }

    public static void openRegion(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, ServerName server, HRegionInfo region) throws IOException {
        AdminProtos.OpenRegionRequest request = RequestConverter.buildOpenRegionRequest(server, region, -1, null, null);
        try {
            admin.openRegion(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static List<HRegionInfo> getOnlineRegions(AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        return ProtobufUtil.getOnlineRegions(null, admin);
    }

    public static List<HRegionInfo> getOnlineRegions(RpcController controller, AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        AdminProtos.GetOnlineRegionRequest request = RequestConverter.buildGetOnlineRegionRequest();
        AdminProtos.GetOnlineRegionResponse response = null;
        try {
            response = admin.getOnlineRegion(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
        return ProtobufUtil.getRegionInfos(response);
    }

    static List<HRegionInfo> getRegionInfos(AdminProtos.GetOnlineRegionResponse proto) {
        if (proto == null) {
            return null;
        }
        ArrayList<HRegionInfo> regionInfos = new ArrayList<HRegionInfo>();
        for (HBaseProtos.RegionInfo regionInfo : proto.getRegionInfoList()) {
            regionInfos.add(HRegionInfo.convert(regionInfo));
        }
        return regionInfos;
    }

    public static AdminProtos.ServerInfo getServerInfo(RpcController controller, AdminProtos.AdminService.BlockingInterface admin) throws IOException {
        AdminProtos.GetServerInfoRequest request = RequestConverter.buildGetServerInfoRequest();
        try {
            AdminProtos.GetServerInfoResponse response = admin.getServerInfo(controller, request);
            return response.getServerInfo();
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static List<String> getStoreFiles(AdminProtos.AdminService.BlockingInterface admin, byte[] regionName, byte[] family) throws IOException {
        return ProtobufUtil.getStoreFiles(null, admin, regionName, family);
    }

    public static List<String> getStoreFiles(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, byte[] regionName, byte[] family) throws IOException {
        AdminProtos.GetStoreFileRequest request = RequestConverter.buildGetStoreFileRequest(regionName, family);
        try {
            AdminProtos.GetStoreFileResponse response = admin.getStoreFile(controller, request);
            return response.getStoreFileList();
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static void split(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, HRegionInfo hri, byte[] splitPoint) throws IOException {
        AdminProtos.SplitRegionRequest request = RequestConverter.buildSplitRegionRequest(hri.getRegionName(), splitPoint);
        try {
            admin.splitRegion(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static void mergeRegions(RpcController controller, AdminProtos.AdminService.BlockingInterface admin, HRegionInfo region_a, HRegionInfo region_b, boolean forcible) throws IOException {
        AdminProtos.MergeRegionsRequest request = RequestConverter.buildMergeRegionsRequest(region_a.getRegionName(), region_b.getRegionName(), forcible);
        try {
            admin.mergeRegions(controller, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public static long getTotalRequestsCount(ClusterStatusProtos.RegionLoad rl) {
        if (rl == null) {
            return 0L;
        }
        return rl.getReadRequestsCount() + rl.getWriteRequestsCount();
    }

    public static byte[] toDelimitedByteArray(Message m) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        baos.write(PB_MAGIC);
        m.writeDelimitedTo((OutputStream)baos);
        return baos.toByteArray();
    }

    public static Permission toPermission(AccessControlProtos.Permission proto) {
        if (proto.getType() != AccessControlProtos.Permission.Type.Global) {
            return ProtobufUtil.toTablePermission(proto);
        }
        List<Permission.Action> actions = ProtobufUtil.toPermissionActions(proto.getGlobalPermission().getActionList());
        return new Permission(actions.toArray(new Permission.Action[actions.size()]));
    }

    public static TablePermission toTablePermission(AccessControlProtos.Permission proto) {
        if (proto.getType() == AccessControlProtos.Permission.Type.Global) {
            AccessControlProtos.GlobalPermission perm = proto.getGlobalPermission();
            List<Permission.Action> actions = ProtobufUtil.toPermissionActions(perm.getActionList());
            return new TablePermission(null, null, null, actions.toArray(new Permission.Action[actions.size()]));
        }
        if (proto.getType() == AccessControlProtos.Permission.Type.Namespace) {
            AccessControlProtos.NamespacePermission perm = proto.getNamespacePermission();
            List<Permission.Action> actions = ProtobufUtil.toPermissionActions(perm.getActionList());
            if (!proto.hasNamespacePermission()) {
                throw new IllegalStateException("Namespace must not be empty in NamespacePermission");
            }
            String namespace = perm.getNamespaceName().toStringUtf8();
            return new TablePermission(namespace, actions.toArray(new Permission.Action[actions.size()]));
        }
        if (proto.getType() == AccessControlProtos.Permission.Type.Table) {
            AccessControlProtos.TablePermission perm = proto.getTablePermission();
            List<Permission.Action> actions = ProtobufUtil.toPermissionActions(perm.getActionList());
            byte[] qualifier = null;
            byte[] family = null;
            TableName table = null;
            if (!perm.hasTableName()) {
                throw new IllegalStateException("TableName cannot be empty");
            }
            table = ProtobufUtil.toTableName(perm.getTableName());
            if (perm.hasFamily()) {
                family = perm.getFamily().toByteArray();
            }
            if (perm.hasQualifier()) {
                qualifier = perm.getQualifier().toByteArray();
            }
            return new TablePermission(table, family, qualifier, actions.toArray(new Permission.Action[actions.size()]));
        }
        throw new IllegalStateException("Unrecognize Perm Type: " + (Object)((Object)proto.getType()));
    }

    public static AccessControlProtos.Permission toPermission(Permission perm) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        if (perm instanceof TablePermission) {
            TablePermission tablePerm = (TablePermission)perm;
            if (tablePerm.hasNamespace()) {
                ret.setType(AccessControlProtos.Permission.Type.Namespace);
                AccessControlProtos.NamespacePermission.Builder builder = AccessControlProtos.NamespacePermission.newBuilder();
                builder.setNamespaceName(ByteString.copyFromUtf8((String)tablePerm.getNamespace()));
                Permission.Action[] actions = perm.getActions();
                if (actions != null) {
                    for (Permission.Action a : actions) {
                        builder.addAction(ProtobufUtil.toPermissionAction(a));
                    }
                }
                ret.setNamespacePermission(builder);
                return ret.build();
            }
            if (tablePerm.hasTable()) {
                Permission.Action[] actions;
                ret.setType(AccessControlProtos.Permission.Type.Table);
                AccessControlProtos.TablePermission.Builder builder = AccessControlProtos.TablePermission.newBuilder();
                builder.setTableName(ProtobufUtil.toProtoTableName(tablePerm.getTableName()));
                if (tablePerm.hasFamily()) {
                    builder.setFamily(ByteStringer.wrap(tablePerm.getFamily()));
                }
                if (tablePerm.hasQualifier()) {
                    builder.setQualifier(ByteStringer.wrap(tablePerm.getQualifier()));
                }
                if ((actions = perm.getActions()) != null) {
                    for (Permission.Action a : actions) {
                        builder.addAction(ProtobufUtil.toPermissionAction(a));
                    }
                }
                ret.setTablePermission(builder);
                return ret.build();
            }
        }
        ret.setType(AccessControlProtos.Permission.Type.Global);
        AccessControlProtos.GlobalPermission.Builder builder = AccessControlProtos.GlobalPermission.newBuilder();
        Permission.Action[] actions = perm.getActions();
        if (actions != null) {
            for (Permission.Action a : actions) {
                builder.addAction(ProtobufUtil.toPermissionAction(a));
            }
        }
        ret.setGlobalPermission(builder);
        return ret.build();
    }

    public static List<Permission.Action> toPermissionActions(List<AccessControlProtos.Permission.Action> protoActions) {
        ArrayList<Permission.Action> actions = new ArrayList<Permission.Action>(protoActions.size());
        for (AccessControlProtos.Permission.Action a : protoActions) {
            actions.add(ProtobufUtil.toPermissionAction(a));
        }
        return actions;
    }

    public static Permission.Action toPermissionAction(AccessControlProtos.Permission.Action action) {
        switch (action) {
            case READ: {
                return Permission.Action.READ;
            }
            case WRITE: {
                return Permission.Action.WRITE;
            }
            case EXEC: {
                return Permission.Action.EXEC;
            }
            case CREATE: {
                return Permission.Action.CREATE;
            }
            case ADMIN: {
                return Permission.Action.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unknown action value " + action.name());
    }

    public static AccessControlProtos.Permission.Action toPermissionAction(Permission.Action action) {
        switch (action) {
            case READ: {
                return AccessControlProtos.Permission.Action.READ;
            }
            case WRITE: {
                return AccessControlProtos.Permission.Action.WRITE;
            }
            case EXEC: {
                return AccessControlProtos.Permission.Action.EXEC;
            }
            case CREATE: {
                return AccessControlProtos.Permission.Action.CREATE;
            }
            case ADMIN: {
                return AccessControlProtos.Permission.Action.ADMIN;
            }
        }
        throw new IllegalArgumentException("Unknown action value " + action.name());
    }

    public static AccessControlProtos.UserPermission toUserPermission(UserPermission perm) {
        return AccessControlProtos.UserPermission.newBuilder().setUser(ByteStringer.wrap(perm.getUser())).setPermission(ProtobufUtil.toPermission(perm)).build();
    }

    public static UserPermission toUserPermission(AccessControlProtos.UserPermission proto) {
        return new UserPermission(proto.getUser().toByteArray(), ProtobufUtil.toTablePermission(proto.getPermission()));
    }

    public static AccessControlProtos.UsersAndPermissions toUserTablePermissions(ListMultimap<String, TablePermission> perm) {
        AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
        for (Map.Entry entry : perm.asMap().entrySet()) {
            AccessControlProtos.UsersAndPermissions.UserPermissions.Builder userPermBuilder = AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder();
            userPermBuilder.setUser(ByteString.copyFromUtf8((String)((String)entry.getKey())));
            for (TablePermission tablePerm : (Collection)entry.getValue()) {
                userPermBuilder.addPermissions(ProtobufUtil.toPermission(tablePerm));
            }
            builder.addUserPermissions(userPermBuilder.build());
        }
        return builder.build();
    }

    public static void grant(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(ProtobufUtil.toPermissionAction(a));
        }
        AccessControlProtos.GrantRequest request = RequestConverter.buildGrantRequest(userShortName, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.grant(controller, request);
    }

    public static void grant(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, TableName tableName, byte[] f, byte[] q, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(ProtobufUtil.toPermissionAction(a));
        }
        AccessControlProtos.GrantRequest request = RequestConverter.buildGrantRequest(userShortName, tableName, f, q, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.grant(controller, request);
    }

    public static void grant(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, String namespace, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(ProtobufUtil.toPermissionAction(a));
        }
        AccessControlProtos.GrantRequest request = RequestConverter.buildGrantRequest(userShortName, namespace, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.grant(controller, request);
    }

    public static void revoke(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(ProtobufUtil.toPermissionAction(a));
        }
        AccessControlProtos.RevokeRequest request = RequestConverter.buildRevokeRequest(userShortName, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.revoke(controller, request);
    }

    public static void revoke(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, TableName tableName, byte[] f, byte[] q, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(ProtobufUtil.toPermissionAction(a));
        }
        AccessControlProtos.RevokeRequest request = RequestConverter.buildRevokeRequest(userShortName, tableName, f, q, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.revoke(controller, request);
    }

    public static void revoke(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, String userShortName, String namespace, Permission.Action ... actions) throws ServiceException {
        ArrayList permActions = Lists.newArrayListWithCapacity((int)actions.length);
        for (Permission.Action a : actions) {
            permActions.add(ProtobufUtil.toPermissionAction(a));
        }
        AccessControlProtos.RevokeRequest request = RequestConverter.buildRevokeRequest(userShortName, namespace, permActions.toArray(new AccessControlProtos.Permission.Action[actions.length]));
        protocol.revoke(controller, request);
    }

    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol) throws ServiceException {
        AccessControlProtos.GetUserPermissionsRequest.Builder builder = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
        builder.setType(AccessControlProtos.Permission.Type.Global);
        AccessControlProtos.GetUserPermissionsRequest request = builder.build();
        AccessControlProtos.GetUserPermissionsResponse response = protocol.getUserPermissions(controller, request);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>(response.getUserPermissionCount());
        for (AccessControlProtos.UserPermission perm : response.getUserPermissionList()) {
            perms.add(ProtobufUtil.toUserPermission(perm));
        }
        return perms;
    }

    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, TableName t) throws ServiceException {
        AccessControlProtos.GetUserPermissionsRequest.Builder builder = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
        if (t != null) {
            builder.setTableName(ProtobufUtil.toProtoTableName(t));
        }
        builder.setType(AccessControlProtos.Permission.Type.Table);
        AccessControlProtos.GetUserPermissionsRequest request = builder.build();
        AccessControlProtos.GetUserPermissionsResponse response = protocol.getUserPermissions(controller, request);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>(response.getUserPermissionCount());
        for (AccessControlProtos.UserPermission perm : response.getUserPermissionList()) {
            perms.add(ProtobufUtil.toUserPermission(perm));
        }
        return perms;
    }

    public static List<UserPermission> getUserPermissions(RpcController controller, AccessControlProtos.AccessControlService.BlockingInterface protocol, byte[] namespace) throws ServiceException {
        AccessControlProtos.GetUserPermissionsRequest.Builder builder = AccessControlProtos.GetUserPermissionsRequest.newBuilder();
        if (namespace != null) {
            builder.setNamespaceName(ByteStringer.wrap(namespace));
        }
        builder.setType(AccessControlProtos.Permission.Type.Namespace);
        AccessControlProtos.GetUserPermissionsRequest request = builder.build();
        AccessControlProtos.GetUserPermissionsResponse response = protocol.getUserPermissions(controller, request);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>(response.getUserPermissionCount());
        for (AccessControlProtos.UserPermission perm : response.getUserPermissionList()) {
            perms.add(ProtobufUtil.toUserPermission(perm));
        }
        return perms;
    }

    public static ListMultimap<String, TablePermission> toUserTablePermissions(AccessControlProtos.UsersAndPermissions proto) {
        ArrayListMultimap perms = ArrayListMultimap.create();
        for (int i = 0; i < proto.getUserPermissionsCount(); ++i) {
            AccessControlProtos.UsersAndPermissions.UserPermissions userPerm = proto.getUserPermissions(i);
            for (int j = 0; j < userPerm.getPermissionsCount(); ++j) {
                TablePermission tablePerm = ProtobufUtil.toTablePermission(userPerm.getPermissions(j));
                perms.put((Object)userPerm.getUser().toStringUtf8(), (Object)tablePerm);
            }
        }
        return perms;
    }

    public static AuthenticationProtos.Token toToken(Token<AuthenticationTokenIdentifier> token) {
        AuthenticationProtos.Token.Builder builder = AuthenticationProtos.Token.newBuilder();
        builder.setIdentifier(ByteStringer.wrap(token.getIdentifier()));
        builder.setPassword(ByteStringer.wrap(token.getPassword()));
        if (token.getService() != null) {
            builder.setService(ByteString.copyFromUtf8((String)token.getService().toString()));
        }
        return builder.build();
    }

    public static Token<AuthenticationTokenIdentifier> toToken(AuthenticationProtos.Token proto) {
        return new Token(proto.hasIdentifier() ? proto.getIdentifier().toByteArray() : null, proto.hasPassword() ? proto.getPassword().toByteArray() : null, AuthenticationTokenIdentifier.AUTH_TOKEN_TYPE, proto.hasService() ? new Text(proto.getService().toStringUtf8()) : null);
    }

    public static String getRegionEncodedName(HBaseProtos.RegionSpecifier regionSpecifier) throws DoNotRetryIOException {
        byte[] value = regionSpecifier.getValue().toByteArray();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = regionSpecifier.getType();
        switch (type) {
            case REGION_NAME: {
                return HRegionInfo.encodeRegionName(value);
            }
            case ENCODED_REGION_NAME: {
                return Bytes.toString(value);
            }
        }
        throw new DoNotRetryIOException("Unsupported region specifier type: " + (Object)((Object)type));
    }

    public static ScanMetrics toScanMetrics(byte[] bytes) {
        Parser<MapReduceProtos.ScanMetrics> parser = MapReduceProtos.ScanMetrics.PARSER;
        MapReduceProtos.ScanMetrics pScanMetrics = null;
        try {
            pScanMetrics = (MapReduceProtos.ScanMetrics)parser.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            // empty catch block
        }
        ScanMetrics scanMetrics = new ScanMetrics();
        if (pScanMetrics != null) {
            for (HBaseProtos.NameInt64Pair pair : pScanMetrics.getMetricsList()) {
                if (!pair.hasName() || !pair.hasValue()) continue;
                scanMetrics.setCounter(pair.getName(), pair.getValue());
            }
        }
        return scanMetrics;
    }

    public static MapReduceProtos.ScanMetrics toScanMetrics(ScanMetrics scanMetrics) {
        MapReduceProtos.ScanMetrics.Builder builder = MapReduceProtos.ScanMetrics.newBuilder();
        Map<String, Long> metrics = scanMetrics.getMetricsMap();
        for (Map.Entry<String, Long> e : metrics.entrySet()) {
            HBaseProtos.NameInt64Pair nameInt64Pair = HBaseProtos.NameInt64Pair.newBuilder().setName(e.getKey()).setValue(e.getValue()).build();
            builder.addMetrics(nameInt64Pair);
        }
        return builder.build();
    }

    public static void toIOException(ServiceException se) throws IOException {
        if (se == null) {
            throw new NullPointerException("Null service exception passed!");
        }
        Throwable cause = se.getCause();
        if (cause != null && cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new IOException(se);
    }

    public static CellProtos.Cell toCell(Cell kv) {
        CellProtos.Cell.Builder kvbuilder = CellProtos.Cell.newBuilder();
        kvbuilder.setRow(ByteStringer.wrap(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength()));
        kvbuilder.setFamily(ByteStringer.wrap(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength()));
        kvbuilder.setQualifier(ByteStringer.wrap(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength()));
        kvbuilder.setCellType(CellProtos.CellType.valueOf(kv.getTypeByte()));
        kvbuilder.setTimestamp(kv.getTimestamp());
        kvbuilder.setValue(ByteStringer.wrap(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength()));
        return kvbuilder.build();
    }

    public static Cell toCell(CellProtos.Cell cell) {
        return CellUtil.createCell(cell.getRow().toByteArray(), cell.getFamily().toByteArray(), cell.getQualifier().toByteArray(), cell.getTimestamp(), (byte)cell.getCellType().getNumber(), cell.getValue().toByteArray());
    }

    public static HBaseProtos.NamespaceDescriptor toProtoNamespaceDescriptor(NamespaceDescriptor ns) {
        HBaseProtos.NamespaceDescriptor.Builder b = HBaseProtos.NamespaceDescriptor.newBuilder().setName(ByteString.copyFromUtf8((String)ns.getName()));
        for (Map.Entry<String, String> entry : ns.getConfiguration().entrySet()) {
            b.addConfiguration(HBaseProtos.NameStringPair.newBuilder().setName(entry.getKey()).setValue(entry.getValue()));
        }
        return b.build();
    }

    public static NamespaceDescriptor toNamespaceDescriptor(HBaseProtos.NamespaceDescriptor desc) throws IOException {
        NamespaceDescriptor.Builder b = NamespaceDescriptor.create(desc.getName().toStringUtf8());
        for (HBaseProtos.NameStringPair prop : desc.getConfigurationList()) {
            b.addConfiguration(prop.getName(), prop.getValue());
        }
        return b.build();
    }

    public static <T extends Message> T getParsedGenericInstance(Class<?> runtimeClass, int position, ByteString b) throws IOException {
        Type type = runtimeClass.getGenericSuperclass();
        Type argType = ((ParameterizedType)type).getActualTypeArguments()[position];
        Class classType = (Class)argType;
        try {
            Method m = classType.getMethod("parseFrom", ByteString.class);
            Message inst = (Message)m.invoke(null, b);
            return (T)inst;
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    public static WALProtos.CompactionDescriptor toCompactionDescriptor(HRegionInfo info, byte[] family, List<Path> inputPaths, List<Path> outputPaths, Path storeDir) {
        return ProtobufUtil.toCompactionDescriptor(info, null, family, inputPaths, outputPaths, storeDir);
    }

    public static WALProtos.CompactionDescriptor toCompactionDescriptor(HRegionInfo info, byte[] regionName, byte[] family, List<Path> inputPaths, List<Path> outputPaths, Path storeDir) {
        WALProtos.CompactionDescriptor.Builder builder = WALProtos.CompactionDescriptor.newBuilder().setTableName(ByteStringer.wrap(info.getTableName())).setEncodedRegionName(ByteStringer.wrap(regionName == null ? info.getEncodedNameAsBytes() : regionName)).setFamilyName(ByteStringer.wrap(family)).setStoreHomeDir(storeDir.getName());
        for (Path inputPath : inputPaths) {
            builder.addCompactionInput(inputPath.getName());
        }
        for (Path outputPath : outputPaths) {
            builder.addCompactionOutput(outputPath.getName());
        }
        builder.setRegionName(ByteStringer.wrap(info.getRegionName()));
        return builder.build();
    }

    public static WALProtos.FlushDescriptor toFlushDescriptor(WALProtos.FlushDescriptor.FlushAction action, HRegionInfo hri, long flushSeqId, Map<byte[], List<Path>> committedFiles) {
        WALProtos.FlushDescriptor.Builder desc = WALProtos.FlushDescriptor.newBuilder().setAction(action).setEncodedRegionName(ByteStringer.wrap(hri.getEncodedNameAsBytes())).setRegionName(ByteStringer.wrap(hri.getRegionName())).setFlushSequenceNumber(flushSeqId).setTableName(ByteStringer.wrap(hri.getTable().getName()));
        for (Map.Entry<byte[], List<Path>> entry : committedFiles.entrySet()) {
            WALProtos.FlushDescriptor.StoreFlushDescriptor.Builder builder = WALProtos.FlushDescriptor.StoreFlushDescriptor.newBuilder().setFamilyName(ByteStringer.wrap(entry.getKey())).setStoreHomeDir(Bytes.toString(entry.getKey()));
            if (entry.getValue() != null) {
                for (Path path : entry.getValue()) {
                    builder.addFlushOutput(path.getName());
                }
            }
            desc.addStoreFlushes(builder);
        }
        return desc.build();
    }

    public static WALProtos.RegionEventDescriptor toRegionEventDescriptor(WALProtos.RegionEventDescriptor.EventType eventType, HRegionInfo hri, long seqId, ServerName server, Map<byte[], List<Path>> storeFiles) {
        byte[] tableNameAsBytes = hri.getTable().getName();
        byte[] encodedNameAsBytes = hri.getEncodedNameAsBytes();
        byte[] regionNameAsBytes = hri.getRegionName();
        return ProtobufUtil.toRegionEventDescriptor(eventType, tableNameAsBytes, encodedNameAsBytes, regionNameAsBytes, seqId, server, storeFiles);
    }

    public static WALProtos.RegionEventDescriptor toRegionEventDescriptor(WALProtos.RegionEventDescriptor.EventType eventType, byte[] tableNameAsBytes, byte[] encodedNameAsBytes, byte[] regionNameAsBytes, long seqId, ServerName server, Map<byte[], List<Path>> storeFiles) {
        WALProtos.RegionEventDescriptor.Builder desc = WALProtos.RegionEventDescriptor.newBuilder().setEventType(eventType).setTableName(ByteStringer.wrap(tableNameAsBytes)).setEncodedRegionName(ByteStringer.wrap(encodedNameAsBytes)).setRegionName(ByteStringer.wrap(regionNameAsBytes)).setLogSequenceNumber(seqId).setServer(ProtobufUtil.toServerName(server));
        for (Map.Entry<byte[], List<Path>> entry : storeFiles.entrySet()) {
            WALProtos.StoreDescriptor.Builder builder = WALProtos.StoreDescriptor.newBuilder().setFamilyName(ByteStringer.wrap(entry.getKey())).setStoreHomeDir(Bytes.toString(entry.getKey()));
            for (Path path : entry.getValue()) {
                builder.addStoreFile(path.getName());
            }
            desc.addStores(builder);
        }
        return desc.build();
    }

    public static String getShortTextFormat(Message m) {
        if (m == null) {
            return "null";
        }
        if (m instanceof ClientProtos.ScanRequest) {
            return TextFormat.shortDebugString((MessageOrBuilder)m);
        }
        if (m instanceof RegionServerStatusProtos.RegionServerReportRequest) {
            RegionServerStatusProtos.RegionServerReportRequest r = (RegionServerStatusProtos.RegionServerReportRequest)m;
            return "server " + TextFormat.shortDebugString((MessageOrBuilder)r.getServer()) + " load { numberOfRequests: " + r.getLoad().getNumberOfRequests() + " }";
        }
        if (m instanceof RegionServerStatusProtos.RegionServerStartupRequest) {
            return TextFormat.shortDebugString((MessageOrBuilder)m);
        }
        if (m instanceof ClientProtos.MutationProto) {
            return ProtobufUtil.toShortString((ClientProtos.MutationProto)m);
        }
        if (m instanceof ClientProtos.GetRequest) {
            ClientProtos.GetRequest r = (ClientProtos.GetRequest)m;
            return "region= " + ProtobufUtil.getStringForByteString(r.getRegion().getValue()) + ", row=" + ProtobufUtil.getStringForByteString(r.getGet().getRow());
        }
        if (m instanceof ClientProtos.MultiRequest) {
            ClientProtos.MultiRequest r = (ClientProtos.MultiRequest)m;
            ClientProtos.RegionAction actions = r.getRegionActionList().get(0);
            String row = actions.getActionCount() <= 0 ? "" : ProtobufUtil.getStringForByteString(actions.getAction(0).hasGet() ? actions.getAction(0).getGet().getRow() : actions.getAction(0).getMutation().getRow());
            return "region= " + ProtobufUtil.getStringForByteString(actions.getRegion().getValue()) + ", for " + r.getRegionActionCount() + " actions and 1st row key=" + row;
        }
        if (m instanceof ClientProtos.MutateRequest) {
            ClientProtos.MutateRequest r = (ClientProtos.MutateRequest)m;
            return "region= " + ProtobufUtil.getStringForByteString(r.getRegion().getValue()) + ", row=" + ProtobufUtil.getStringForByteString(r.getMutation().getRow());
        }
        return "TODO: " + m.getClass().toString();
    }

    private static String getStringForByteString(ByteString bs) {
        return Bytes.toStringBinary(bs.toByteArray());
    }

    static String toShortString(ClientProtos.MutationProto proto) {
        return "row=" + Bytes.toString(proto.getRow().toByteArray()) + ", type=" + proto.getMutateType().toString();
    }

    public static TableName toTableName(HBaseProtos.TableName tableNamePB) {
        return TableName.valueOf(tableNamePB.getNamespace().asReadOnlyByteBuffer(), tableNamePB.getQualifier().asReadOnlyByteBuffer());
    }

    public static HBaseProtos.TableName toProtoTableName(TableName tableName) {
        return HBaseProtos.TableName.newBuilder().setNamespace(ByteStringer.wrap(tableName.getNamespace())).setQualifier(ByteStringer.wrap(tableName.getQualifier())).build();
    }

    public static TableName[] getTableNameArray(List<HBaseProtos.TableName> tableNamesList) {
        if (tableNamesList == null) {
            return new TableName[0];
        }
        TableName[] tableNames = new TableName[tableNamesList.size()];
        for (int i = 0; i < tableNamesList.size(); ++i) {
            tableNames[i] = ProtobufUtil.toTableName(tableNamesList.get(i));
        }
        return tableNames;
    }

    public static CellVisibility toCellVisibility(ClientProtos.CellVisibility proto) {
        if (proto == null) {
            return null;
        }
        return new CellVisibility(proto.getExpression());
    }

    public static CellVisibility toCellVisibility(byte[] protoBytes) throws DeserializationException {
        if (protoBytes == null) {
            return null;
        }
        ClientProtos.CellVisibility.Builder builder = ClientProtos.CellVisibility.newBuilder();
        ClientProtos.CellVisibility proto = null;
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, protoBytes);
            proto = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return ProtobufUtil.toCellVisibility(proto);
    }

    public static ClientProtos.CellVisibility toCellVisibility(CellVisibility cellVisibility) {
        ClientProtos.CellVisibility.Builder builder = ClientProtos.CellVisibility.newBuilder();
        builder.setExpression(cellVisibility.getExpression());
        return builder.build();
    }

    public static Authorizations toAuthorizations(ClientProtos.Authorizations proto) {
        if (proto == null) {
            return null;
        }
        return new Authorizations(proto.getLabelList());
    }

    public static Authorizations toAuthorizations(byte[] protoBytes) throws DeserializationException {
        if (protoBytes == null) {
            return null;
        }
        ClientProtos.Authorizations.Builder builder = ClientProtos.Authorizations.newBuilder();
        ClientProtos.Authorizations proto = null;
        try {
            ProtobufUtil.mergeFrom((Message.Builder)builder, protoBytes);
            proto = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return ProtobufUtil.toAuthorizations(proto);
    }

    public static ClientProtos.Authorizations toAuthorizations(Authorizations authorizations) {
        ClientProtos.Authorizations.Builder builder = ClientProtos.Authorizations.newBuilder();
        for (String label : authorizations.getLabels()) {
            builder.addLabel(label);
        }
        return builder.build();
    }

    public static AccessControlProtos.UsersAndPermissions toUsersAndPermissions(String user, Permission perms) {
        return AccessControlProtos.UsersAndPermissions.newBuilder().addUserPermissions(AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder().setUser(ByteString.copyFromUtf8((String)user)).addPermissions(ProtobufUtil.toPermission(perms)).build()).build();
    }

    public static AccessControlProtos.UsersAndPermissions toUsersAndPermissions(ListMultimap<String, Permission> perms) {
        AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
        for (Map.Entry entry : perms.asMap().entrySet()) {
            AccessControlProtos.UsersAndPermissions.UserPermissions.Builder userPermBuilder = AccessControlProtos.UsersAndPermissions.UserPermissions.newBuilder();
            userPermBuilder.setUser(ByteString.copyFromUtf8((String)((String)entry.getKey())));
            for (Permission perm : (Collection)entry.getValue()) {
                userPermBuilder.addPermissions(ProtobufUtil.toPermission(perm));
            }
            builder.addUserPermissions(userPermBuilder.build());
        }
        return builder.build();
    }

    public static ListMultimap<String, Permission> toUsersAndPermissions(AccessControlProtos.UsersAndPermissions proto) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (AccessControlProtos.UsersAndPermissions.UserPermissions userPerms : proto.getUserPermissionsList()) {
            String user = userPerms.getUser().toStringUtf8();
            for (AccessControlProtos.Permission perm : userPerms.getPermissionsList()) {
                result.put((Object)user, (Object)ProtobufUtil.toPermission(perm));
            }
        }
        return result;
    }

    public static TimeUnit toTimeUnit(HBaseProtos.TimeUnit proto) {
        switch (proto) {
            case NANOSECONDS: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROSECONDS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLISECONDS: {
                return TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case DAYS: {
                return TimeUnit.DAYS;
            }
        }
        throw new RuntimeException("Invalid TimeUnit " + (Object)((Object)proto));
    }

    public static HBaseProtos.TimeUnit toProtoTimeUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return HBaseProtos.TimeUnit.NANOSECONDS;
            }
            case MICROSECONDS: {
                return HBaseProtos.TimeUnit.MICROSECONDS;
            }
            case MILLISECONDS: {
                return HBaseProtos.TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return HBaseProtos.TimeUnit.SECONDS;
            }
            case MINUTES: {
                return HBaseProtos.TimeUnit.MINUTES;
            }
            case HOURS: {
                return HBaseProtos.TimeUnit.HOURS;
            }
            case DAYS: {
                return HBaseProtos.TimeUnit.DAYS;
            }
        }
        throw new RuntimeException("Invalid TimeUnit " + (Object)((Object)timeUnit));
    }

    public static ThrottleType toThrottleType(QuotaProtos.ThrottleType proto) {
        switch (proto) {
            case REQUEST_NUMBER: {
                return ThrottleType.REQUEST_NUMBER;
            }
            case REQUEST_SIZE: {
                return ThrottleType.REQUEST_SIZE;
            }
            case WRITE_NUMBER: {
                return ThrottleType.WRITE_NUMBER;
            }
            case WRITE_SIZE: {
                return ThrottleType.WRITE_SIZE;
            }
            case READ_NUMBER: {
                return ThrottleType.READ_NUMBER;
            }
            case READ_SIZE: {
                return ThrottleType.READ_SIZE;
            }
        }
        throw new RuntimeException("Invalid ThrottleType " + (Object)((Object)proto));
    }

    public static QuotaProtos.ThrottleType toProtoThrottleType(ThrottleType type) {
        switch (type) {
            case REQUEST_NUMBER: {
                return QuotaProtos.ThrottleType.REQUEST_NUMBER;
            }
            case REQUEST_SIZE: {
                return QuotaProtos.ThrottleType.REQUEST_SIZE;
            }
            case WRITE_NUMBER: {
                return QuotaProtos.ThrottleType.WRITE_NUMBER;
            }
            case WRITE_SIZE: {
                return QuotaProtos.ThrottleType.WRITE_SIZE;
            }
            case READ_NUMBER: {
                return QuotaProtos.ThrottleType.READ_NUMBER;
            }
            case READ_SIZE: {
                return QuotaProtos.ThrottleType.READ_SIZE;
            }
        }
        throw new RuntimeException("Invalid ThrottleType " + (Object)((Object)type));
    }

    public static QuotaScope toQuotaScope(QuotaProtos.QuotaScope proto) {
        switch (proto) {
            case CLUSTER: {
                return QuotaScope.CLUSTER;
            }
            case MACHINE: {
                return QuotaScope.MACHINE;
            }
        }
        throw new RuntimeException("Invalid QuotaScope " + (Object)((Object)proto));
    }

    public static QuotaProtos.QuotaScope toProtoQuotaScope(QuotaScope scope) {
        switch (scope) {
            case CLUSTER: {
                return QuotaProtos.QuotaScope.CLUSTER;
            }
            case MACHINE: {
                return QuotaProtos.QuotaScope.MACHINE;
            }
        }
        throw new RuntimeException("Invalid QuotaScope " + (Object)((Object)scope));
    }

    public static QuotaType toQuotaScope(QuotaProtos.QuotaType proto) {
        switch (proto) {
            case THROTTLE: {
                return QuotaType.THROTTLE;
            }
        }
        throw new RuntimeException("Invalid QuotaType " + (Object)((Object)proto));
    }

    public static QuotaProtos.QuotaType toProtoQuotaScope(QuotaType type) {
        switch (type) {
            case THROTTLE: {
                return QuotaProtos.QuotaType.THROTTLE;
            }
        }
        throw new RuntimeException("Invalid QuotaType " + (Object)((Object)type));
    }

    public static QuotaProtos.TimedQuota toTimedQuota(long limit, TimeUnit timeUnit, QuotaScope scope) {
        return QuotaProtos.TimedQuota.newBuilder().setSoftLimit(limit).setTimeUnit(ProtobufUtil.toProtoTimeUnit(timeUnit)).setScope(ProtobufUtil.toProtoQuotaScope(scope)).build();
    }

    public static WALProtos.BulkLoadDescriptor toBulkLoadDescriptor(TableName tableName, ByteString encodedRegionName, Map<byte[], List<Path>> storeFiles, long bulkloadSeqId) {
        WALProtos.BulkLoadDescriptor.Builder desc = WALProtos.BulkLoadDescriptor.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tableName)).setEncodedRegionName(encodedRegionName).setBulkloadSeqNum(bulkloadSeqId);
        for (Map.Entry<byte[], List<Path>> entry : storeFiles.entrySet()) {
            WALProtos.StoreDescriptor.Builder builder = WALProtos.StoreDescriptor.newBuilder().setFamilyName(ByteStringer.wrap(entry.getKey())).setStoreHomeDir(Bytes.toString(entry.getKey()));
            for (Path path : entry.getValue()) {
                builder.addStoreFile(path.getName());
            }
            desc.addStores(builder);
        }
        return desc.build();
    }

    public static void mergeDelimitedFrom(Message.Builder builder, InputStream in) throws IOException {
        int firstByte = in.read();
        if (firstByte != -1) {
            int size = CodedInputStream.readRawVarint32((int)firstByte, (InputStream)in);
            LimitInputStream limitedInput = new LimitInputStream(in, size);
            CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)limitedInput);
            codedInput.setSizeLimit(size);
            builder.mergeFrom(codedInput);
            codedInput.checkLastTagWas(0);
        }
    }

    public static void mergeFrom(Message.Builder builder, InputStream in, int size) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)in);
        codedInput.setSizeLimit(size);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, InputStream in) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)in);
        codedInput.setSizeLimit(Integer.MAX_VALUE);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, ByteString bs) throws IOException {
        CodedInputStream codedInput = bs.newCodedInput();
        codedInput.setSizeLimit(bs.size());
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, byte[] b) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((byte[])b);
        codedInput.setSizeLimit(b.length);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static void mergeFrom(Message.Builder builder, byte[] b, int offset, int length) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance((byte[])b, (int)offset, (int)length);
        codedInput.setSizeLimit(length);
        builder.mergeFrom(codedInput);
        codedInput.checkLastTagWas(0);
    }

    public static ReplicationLoadSink toReplicationLoadSink(ClusterStatusProtos.ReplicationLoadSink cls) {
        return new ReplicationLoadSink(cls.getAgeOfLastAppliedOp(), cls.getTimeStampsOfLastAppliedOp());
    }

    public static ReplicationLoadSource toReplicationLoadSource(ClusterStatusProtos.ReplicationLoadSource cls) {
        return new ReplicationLoadSource(cls.getPeerID(), cls.getAgeOfLastShippedOp(), cls.getSizeOfLogQueue(), cls.getTimeStampOfLastShippedOp(), cls.getReplicationLag());
    }

    public static List<ReplicationLoadSource> toReplicationLoadSourceList(List<ClusterStatusProtos.ReplicationLoadSource> clsList) {
        ArrayList<ReplicationLoadSource> rlsList = new ArrayList<ReplicationLoadSource>();
        for (ClusterStatusProtos.ReplicationLoadSource cls : clsList) {
            rlsList.add(ProtobufUtil.toReplicationLoadSource(cls));
        }
        return rlsList;
    }

    public static HBaseProtos.VersionInfo getVersionInfo() {
        HBaseProtos.VersionInfo.Builder builder = HBaseProtos.VersionInfo.newBuilder();
        builder.setVersion(VersionInfo.getVersion());
        builder.setUrl(VersionInfo.getUrl());
        builder.setRevision(VersionInfo.getRevision());
        builder.setUser(VersionInfo.getUser());
        builder.setDate(VersionInfo.getDate());
        builder.setSrcChecksum(VersionInfo.getSrcChecksum());
        return builder.build();
    }

    public static List<SecurityCapability> toSecurityCapabilityList(List<MasterProtos.SecurityCapabilitiesResponse.Capability> capabilities) {
        ArrayList<SecurityCapability> scList = new ArrayList<SecurityCapability>(capabilities.size());
        for (MasterProtos.SecurityCapabilitiesResponse.Capability c : capabilities) {
            try {
                scList.add(SecurityCapability.valueOf(c.getNumber()));
            }
            catch (IllegalArgumentException e) {}
        }
        return scList;
    }

    private static HBaseProtos.TimeRange.Builder timeRangeToProto(TimeRange timeRange) {
        HBaseProtos.TimeRange.Builder timeRangeBuilder = HBaseProtos.TimeRange.newBuilder();
        timeRangeBuilder.setFrom(timeRange.getMin());
        timeRangeBuilder.setTo(timeRange.getMax());
        return timeRangeBuilder;
    }

    private static TimeRange protoToTimeRange(HBaseProtos.TimeRange timeRange) throws IOException {
        long minStamp = 0L;
        long maxStamp = Long.MAX_VALUE;
        if (timeRange.hasFrom()) {
            minStamp = timeRange.getFrom();
        }
        if (timeRange.hasTo()) {
            maxStamp = timeRange.getTo();
        }
        return new TimeRange(minStamp, maxStamp);
    }

    static {
        ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
        builder.setExists(true);
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB_EXISTS_TRUE = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_EXISTS_TRUE_STALE = builder.build();
        builder.clear();
        builder.setExists(false);
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB_EXISTS_FALSE = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_EXISTS_FALSE_STALE = builder.build();
        builder.clear();
        builder.setAssociatedCellCount(0);
        EMPTY_RESULT_PB = builder.build();
        builder.setStale(true);
        EMPTY_RESULT_PB_STALE = builder.build();
        ClassLoader parent = ProtobufUtil.class.getClassLoader();
        Configuration conf = HBaseConfiguration.create();
        CLASS_LOADER = new DynamicClassLoader(conf, parent);
        PRIMITIVES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVES.put(Byte.TYPE.getName(), Byte.TYPE);
        PRIMITIVES.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVES.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVES.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVES.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVES.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVES.put(Double.TYPE.getName(), Double.TYPE);
        PRIMITIVES.put(Void.TYPE.getName(), Void.TYPE);
        PB_MAGIC = new byte[]{80, 66, 85, 70};
        PB_MAGIC_STR = Bytes.toString(PB_MAGIC);
    }
}

