/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.SplitTransactionCoordination;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class SplitTransactionImpl
implements SplitTransaction {
    private static final Log LOG = LogFactory.getLog(SplitTransaction.class);
    private final HRegion parent;
    private HRegionInfo hri_a;
    private HRegionInfo hri_b;
    private long fileSplitTimeout = 30000L;
    public SplitTransactionCoordination.SplitTransactionDetails std;
    boolean useZKForAssignment;
    private final byte[] splitrow;
    private SplitTransaction.SplitTransactionPhase currentPhase = SplitTransaction.SplitTransactionPhase.STARTED;
    private Server server;
    private RegionServerServices rsServices;
    private final List<SplitTransaction.JournalEntry> journal = new ArrayList<SplitTransaction.JournalEntry>();
    private final ArrayList<SplitTransaction.TransactionListener> listeners = new ArrayList();
    private static IOException closedByOtherException = new IOException("Failed to close region: already closed by another thread");

    public SplitTransactionImpl(Region r, byte[] splitrow) {
        this.parent = (HRegion)r;
        this.splitrow = splitrow;
        this.journal.add(new JournalEntryImpl(SplitTransaction.SplitTransactionPhase.STARTED));
        this.useZKForAssignment = ConfigUtil.useZKForAssignment(this.parent.getBaseConf());
    }

    private void transition(SplitTransaction.SplitTransactionPhase nextPhase) throws IOException {
        this.transition(nextPhase, false);
    }

    private void transition(SplitTransaction.SplitTransactionPhase nextPhase, boolean isRollback) throws IOException {
        if (!isRollback) {
            this.journal.add(new JournalEntryImpl(nextPhase));
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            SplitTransaction.TransactionListener listener = this.listeners.get(i);
            if (!isRollback) {
                listener.transition(this, this.currentPhase, nextPhase);
                continue;
            }
            listener.rollback(this, this.currentPhase, nextPhase);
        }
        this.currentPhase = nextPhase;
    }

    @Override
    public boolean prepare() throws IOException {
        if (!this.parent.isSplittable()) {
            return false;
        }
        if (this.splitrow == null) {
            return false;
        }
        HRegionInfo hri = this.parent.getRegionInfo();
        this.parent.prepareToSplit();
        byte[] startKey = hri.getStartKey();
        byte[] endKey = hri.getEndKey();
        if (Bytes.equals(startKey, this.splitrow) || !this.parent.getRegionInfo().containsRow(this.splitrow)) {
            LOG.info((Object)("Split row is not inside region key range or is equal to startkey: " + Bytes.toStringBinary(this.splitrow)));
            return false;
        }
        long rid = SplitTransactionImpl.getDaughterRegionIdTimestamp(hri);
        this.hri_a = new HRegionInfo(hri.getTable(), startKey, this.splitrow, false, rid);
        this.hri_b = new HRegionInfo(hri.getTable(), this.splitrow, endKey, false, rid);
        this.transition(SplitTransaction.SplitTransactionPhase.PREPARED);
        return true;
    }

    private static long getDaughterRegionIdTimestamp(HRegionInfo hri) {
        long rid = EnvironmentEdgeManager.currentTime();
        if (rid < hri.getRegionId()) {
            LOG.warn((Object)("Clock skew; parent regions id is " + hri.getRegionId() + " but current time here is " + rid));
            rid = hri.getRegionId() + 1L;
        }
        return rid;
    }

    PairOfSameType<Region> createDaughters(Server server, RegionServerServices services) throws IOException {
        return this.createDaughters(server, services, null);
    }

    PairOfSameType<Region> createDaughters(Server server, RegionServerServices services, User user) throws IOException {
        LOG.info((Object)("Starting split of region " + this.parent));
        if (server != null && server.isStopped() || services != null && services.isStopping()) {
            throw new IOException("Server is stopped or stopping");
        }
        assert (!this.parent.lock.writeLock().isHeldByCurrentThread()) : "Unsafe to hold write lock while performing RPCs";
        this.transition(SplitTransaction.SplitTransactionPhase.BEFORE_PRE_SPLIT_HOOK);
        if (this.parent.getCoprocessorHost() != null) {
            if (user == null) {
                this.parent.getCoprocessorHost().preSplit();
                this.parent.getCoprocessorHost().preSplit(this.splitrow);
            } else {
                try {
                    user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            SplitTransactionImpl.this.parent.getCoprocessorHost().preSplit();
                            SplitTransactionImpl.this.parent.getCoprocessorHost().preSplit(SplitTransactionImpl.this.splitrow);
                            return null;
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
        }
        this.transition(SplitTransaction.SplitTransactionPhase.AFTER_PRE_SPLIT_HOOK);
        boolean testing = server == null ? true : server.getConfiguration().getBoolean("hbase.testing.nocluster", false);
        this.fileSplitTimeout = testing ? this.fileSplitTimeout : server.getConfiguration().getLong("hbase.regionserver.fileSplitTimeout", this.fileSplitTimeout);
        PairOfSameType<Region> daughterRegions = this.stepsBeforePONR(server, services, testing);
        final ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
        boolean ret = false;
        if (this.parent.getCoprocessorHost() != null) {
            if (user == null) {
                ret = this.parent.getCoprocessorHost().preSplitBeforePONR(this.splitrow, metaEntries);
            } else {
                try {
                    ret = (Boolean)user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws Exception {
                            return SplitTransactionImpl.this.parent.getCoprocessorHost().preSplitBeforePONR(SplitTransactionImpl.this.splitrow, metaEntries);
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
            if (ret) {
                throw new IOException("Coprocessor bypassing region " + this.parent.getRegionInfo().getRegionNameAsString() + " split.");
            }
            try {
                for (Mutation p : metaEntries) {
                    HRegionInfo.parseRegionName(p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Row key of mutation from coprossor is not parsable as region name.Mutations from coprocessor should only for hbase:meta table.");
                throw e;
            }
        }
        this.transition(SplitTransaction.SplitTransactionPhase.PONR);
        if (!testing && this.useZKForAssignment) {
            if (metaEntries == null || metaEntries.isEmpty()) {
                MetaTableAccessor.splitRegion(server.getConnection(), this.parent.getRegionInfo(), daughterRegions.getFirst().getRegionInfo(), daughterRegions.getSecond().getRegionInfo(), server.getServerName(), this.parent.getTableDesc().getRegionReplication());
            } else {
                this.offlineParentInMetaAndputMetaEntries(server.getConnection(), this.parent.getRegionInfo(), daughterRegions.getFirst().getRegionInfo(), daughterRegions.getSecond().getRegionInfo(), server.getServerName(), metaEntries, this.parent.getTableDesc().getRegionReplication());
            }
        } else if (services != null && !this.useZKForAssignment && !services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.SPLIT_PONR, this.parent.getRegionInfo(), this.hri_a, this.hri_b)) {
            throw new IOException("Failed to notify master that split passed PONR: " + this.parent.getRegionInfo().getRegionNameAsString());
        }
        return daughterRegions;
    }

    public PairOfSameType<Region> stepsBeforePONR(Server server, RegionServerServices services, boolean testing) throws IOException {
        if (this.useCoordinatedStateManager(server)) {
            if (this.std == null) {
                this.std = ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getSplitTransactionCoordination().getDefaultDetails();
            }
            ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getSplitTransactionCoordination().startSplitTransaction(this.parent, server.getServerName(), this.hri_a, this.hri_b);
        } else if (services != null && !this.useZKForAssignment && !services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_SPLIT, this.parent.getRegionInfo(), this.hri_a, this.hri_b)) {
            throw new IOException("Failed to get ok from master to split " + this.parent.getRegionInfo().getRegionNameAsString());
        }
        this.transition(SplitTransaction.SplitTransactionPhase.SET_SPLITTING);
        if (this.useCoordinatedStateManager(server)) {
            ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getSplitTransactionCoordination().waitForSplitTransaction(services, this.parent, this.hri_a, this.hri_b, this.std);
        }
        this.parent.getRegionFileSystem().createSplitsDir();
        this.transition(SplitTransaction.SplitTransactionPhase.CREATE_SPLIT_DIR);
        Map<byte[], List<StoreFile>> hstoreFilesToSplit = null;
        Exception exceptionToThrow = null;
        try {
            hstoreFilesToSplit = this.parent.close(false);
        }
        catch (Exception e) {
            exceptionToThrow = e;
        }
        if (exceptionToThrow == null && hstoreFilesToSplit == null) {
            exceptionToThrow = closedByOtherException;
        }
        if (exceptionToThrow != closedByOtherException) {
            this.transition(SplitTransaction.SplitTransactionPhase.CLOSED_PARENT_REGION);
        }
        if (exceptionToThrow != null) {
            if (exceptionToThrow instanceof IOException) {
                throw (IOException)exceptionToThrow;
            }
            throw new IOException(exceptionToThrow);
        }
        if (!testing) {
            services.removeFromOnlineRegions(this.parent, null);
        }
        this.transition(SplitTransaction.SplitTransactionPhase.OFFLINED_PARENT);
        Pair<Integer, Integer> expectedReferences = this.splitStoreFiles(hstoreFilesToSplit);
        this.transition(SplitTransaction.SplitTransactionPhase.STARTED_REGION_A_CREATION);
        this.assertReferenceFileCount(expectedReferences.getFirst(), this.parent.getRegionFileSystem().getSplitsDir(this.hri_a));
        HRegion a = this.parent.createDaughterRegionFromSplits(this.hri_a);
        this.assertReferenceFileCount(expectedReferences.getFirst(), new Path(this.parent.getRegionFileSystem().getTableDir(), this.hri_a.getEncodedName()));
        this.transition(SplitTransaction.SplitTransactionPhase.STARTED_REGION_B_CREATION);
        this.assertReferenceFileCount(expectedReferences.getSecond(), this.parent.getRegionFileSystem().getSplitsDir(this.hri_b));
        HRegion b = this.parent.createDaughterRegionFromSplits(this.hri_b);
        this.assertReferenceFileCount(expectedReferences.getSecond(), new Path(this.parent.getRegionFileSystem().getTableDir(), this.hri_b.getEncodedName()));
        return new PairOfSameType<Region>(a, b);
    }

    void assertReferenceFileCount(int expectedReferenceFileCount, Path dir) throws IOException {
        if (expectedReferenceFileCount != 0 && expectedReferenceFileCount != FSUtils.getRegionReferenceFileCount(this.parent.getFilesystem(), dir)) {
            throw new IOException("Failing split. Expected reference file count isn't equal.");
        }
    }

    void openDaughters(Server server, RegionServerServices services, Region a, Region b) throws IOException {
        boolean stopping;
        boolean stopped = server != null && server.isStopped();
        boolean bl = stopping = services != null && services.isStopping();
        if (stopped || stopping) {
            LOG.info((Object)("Not opening daughters " + b.getRegionInfo().getRegionNameAsString() + " and " + a.getRegionInfo().getRegionNameAsString() + " because stopping=" + stopping + ", stopped=" + stopped));
        } else {
            DaughterOpener aOpener = new DaughterOpener(server, (HRegion)a);
            DaughterOpener bOpener = new DaughterOpener(server, (HRegion)b);
            aOpener.start();
            bOpener.start();
            try {
                aOpener.join();
                if (aOpener.getException() == null) {
                    this.transition(SplitTransaction.SplitTransactionPhase.OPENED_REGION_A);
                }
                bOpener.join();
                if (bOpener.getException() == null) {
                    this.transition(SplitTransaction.SplitTransactionPhase.OPENED_REGION_B);
                }
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            if (aOpener.getException() != null) {
                throw new IOException("Failed " + aOpener.getName(), aOpener.getException());
            }
            if (bOpener.getException() != null) {
                throw new IOException("Failed " + bOpener.getName(), bOpener.getException());
            }
            if (services != null) {
                try {
                    if (this.useZKForAssignment) {
                        services.postOpenDeployTasks(b);
                    } else if (!services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.SPLIT, this.parent.getRegionInfo(), this.hri_a, this.hri_b)) {
                        throw new IOException("Failed to report split region to master: " + this.parent.getRegionInfo().getShortNameToLog());
                    }
                    services.addToOnlineRegions(b);
                    if (this.useZKForAssignment) {
                        services.postOpenDeployTasks(a);
                    }
                    services.addToOnlineRegions(a);
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
            }
        }
    }

    @Override
    public PairOfSameType<Region> execute(Server server, RegionServerServices services) throws IOException {
        if (User.isHBaseSecurityEnabled(this.parent.getBaseConf())) {
            LOG.warn((Object)"Should use execute(Server, RegionServerServices, User)");
        }
        return this.execute(server, services, null);
    }

    @Override
    public PairOfSameType<Region> execute(Server server, RegionServerServices services, User user) throws IOException {
        this.server = server;
        this.rsServices = services;
        boolean bl = this.useZKForAssignment = server == null ? true : ConfigUtil.useZKForAssignment(server.getConfiguration());
        if (this.useCoordinatedStateManager(server)) {
            this.std = ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getSplitTransactionCoordination().getDefaultDetails();
        }
        PairOfSameType<Region> regions = this.createDaughters(server, services, user);
        if (this.parent.getCoprocessorHost() != null) {
            if (user == null) {
                this.parent.getCoprocessorHost().preSplitAfterPONR();
            } else {
                try {
                    user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            SplitTransactionImpl.this.parent.getCoprocessorHost().preSplitAfterPONR();
                            return null;
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
        }
        regions = this.stepsAfterPONR(server, services, regions, user);
        this.transition(SplitTransaction.SplitTransactionPhase.COMPLETED);
        return regions;
    }

    @Deprecated
    public PairOfSameType<Region> stepsAfterPONR(Server server, RegionServerServices services, PairOfSameType<Region> regions) throws IOException {
        return this.stepsAfterPONR(server, services, regions, null);
    }

    public PairOfSameType<Region> stepsAfterPONR(Server server, RegionServerServices services, final PairOfSameType<Region> regions, User user) throws IOException {
        this.openDaughters(server, services, regions.getFirst(), regions.getSecond());
        if (this.useCoordinatedStateManager(server)) {
            ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getSplitTransactionCoordination().completeSplitTransaction(services, regions.getFirst(), regions.getSecond(), this.std, this.parent);
        }
        this.transition(SplitTransaction.SplitTransactionPhase.BEFORE_POST_SPLIT_HOOK);
        if (this.parent.getCoprocessorHost() != null) {
            if (user == null) {
                this.parent.getCoprocessorHost().postSplit(regions.getFirst(), regions.getSecond());
            } else {
                try {
                    user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            SplitTransactionImpl.this.parent.getCoprocessorHost().postSplit((Region)regions.getFirst(), (Region)regions.getSecond());
                            return null;
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
        }
        this.transition(SplitTransaction.SplitTransactionPhase.AFTER_POST_SPLIT_HOOK);
        return regions;
    }

    private void offlineParentInMetaAndputMetaEntries(HConnection hConnection, HRegionInfo parent, HRegionInfo splitA, HRegionInfo splitB, ServerName serverName, List<Mutation> metaEntries, int regionReplication) throws IOException {
        List<Mutation> mutations = metaEntries;
        HRegionInfo copyOfParent = new HRegionInfo(parent);
        copyOfParent.setOffline(true);
        copyOfParent.setSplit(true);
        Put putParent = MetaTableAccessor.makePutFromRegionInfo(copyOfParent);
        MetaTableAccessor.addDaughtersToPut(putParent, splitA, splitB);
        mutations.add(putParent);
        Put putA = MetaTableAccessor.makePutFromRegionInfo(splitA);
        Put putB = MetaTableAccessor.makePutFromRegionInfo(splitB);
        this.addLocation(putA, serverName, 1L);
        this.addLocation(putB, serverName, 1L);
        mutations.add(putA);
        mutations.add(putB);
        for (int i = 1; i < regionReplication; ++i) {
            SplitTransactionImpl.addEmptyLocation(putA, i);
            SplitTransactionImpl.addEmptyLocation(putB, i);
        }
        MetaTableAccessor.mutateMetaTable(hConnection, mutations);
    }

    private static Put addEmptyLocation(Put p, int replicaId) {
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn(replicaId), null);
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn(replicaId), null);
        p.addImmutable(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn(replicaId), null);
        return p;
    }

    public Put addLocation(Put p, ServerName sn, long openSeqNum) {
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes(sn.getHostAndPort()));
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes(sn.getStartcode()));
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SEQNUM_QUALIFIER, Bytes.toBytes(openSeqNum));
        return p;
    }

    void openDaughterRegion(Server server, HRegion daughter) throws IOException, KeeperException {
        HRegionInfo hri = daughter.getRegionInfo();
        LoggingProgressable reporter = server == null ? null : new LoggingProgressable(hri, server.getConfiguration().getLong("hbase.regionserver.split.daughter.open.log.interval", 10000L));
        daughter.openHRegion(reporter);
    }

    private boolean useCoordinatedStateManager(Server server) {
        return server != null && this.useZKForAssignment && server.getCoordinatedStateManager() != null;
    }

    private Pair<Integer, Integer> splitStoreFiles(Map<byte[], List<StoreFile>> hstoreFilesToSplit) throws IOException {
        if (hstoreFilesToSplit == null) {
            throw new IOException("Close returned empty list of StoreFiles");
        }
        int nbFiles = 0;
        for (Map.Entry<byte[], List<StoreFile>> entry : hstoreFilesToSplit.entrySet()) {
            nbFiles += entry.getValue().size();
        }
        if (nbFiles == 0) {
            return new Pair<Integer, Integer>(0, 0);
        }
        int defMaxThreads = Math.min(this.parent.conf.getInt("hbase.hstore.blockingStoreFiles", 7), Runtime.getRuntime().availableProcessors());
        int maxThreads = Math.min(this.parent.conf.getInt("hbase.regionserver.region.split.threads.max", defMaxThreads), nbFiles);
        LOG.info((Object)("Preparing to split " + nbFiles + " storefiles for region " + this.parent + " using " + maxThreads + " threads"));
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setNameFormat("StoreFileSplitter-%1$d");
        ThreadFactory factory = builder.build();
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(maxThreads, factory);
        ArrayList<Future<Pair<Path, Path>>> futures = new ArrayList<Future<Pair<Path, Path>>>(nbFiles);
        for (Map.Entry<byte[], List<StoreFile>> entry : hstoreFilesToSplit.entrySet()) {
            for (StoreFile storeFile : entry.getValue()) {
                StoreFileSplitter sfs = new StoreFileSplitter(entry.getKey(), storeFile);
                futures.add(threadPool.submit(sfs));
            }
        }
        threadPool.shutdown();
        try {
            boolean stillRunning;
            boolean bl = stillRunning = !threadPool.awaitTermination(this.fileSplitTimeout, TimeUnit.MILLISECONDS);
            if (stillRunning) {
                threadPool.shutdownNow();
                while (!threadPool.isTerminated()) {
                    Thread.sleep(50L);
                }
                throw new IOException("Took too long to split the files and create the references, aborting split");
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        int created_a = 0;
        int created_b = 0;
        for (Future future : futures) {
            try {
                Pair p = (Pair)future.get();
                created_a += p.getFirst() != null ? 1 : 0;
                created_b += p.getSecond() != null ? 1 : 0;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Split storefiles for region " + this.parent + " Daughter A: " + created_a + " storefiles, Daughter B: " + created_b + " storefiles."));
        }
        return new Pair<Integer, Integer>(created_a, created_b);
    }

    private Pair<Path, Path> splitStoreFile(byte[] family, StoreFile sf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Splitting started for store file: " + sf.getPath() + " for region: " + this.parent));
        }
        HRegionFileSystem fs = this.parent.getRegionFileSystem();
        String familyName = Bytes.toString(family);
        Path path_a = fs.splitStoreFile(this.hri_a, familyName, sf, this.splitrow, false, this.parent.getSplitPolicy());
        Path path_b = fs.splitStoreFile(this.hri_b, familyName, sf, this.splitrow, true, this.parent.getSplitPolicy());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Splitting complete for store file: " + sf.getPath() + " for region: " + this.parent));
        }
        return new Pair<Path, Path>(path_a, path_b);
    }

    @Override
    public boolean rollback(Server server, RegionServerServices services) throws IOException {
        if (User.isHBaseSecurityEnabled(this.parent.getBaseConf())) {
            LOG.warn((Object)"Should use rollback(Server, RegionServerServices, User)");
        }
        return this.rollback(server, services, null);
    }

    @Override
    public boolean rollback(Server server, RegionServerServices services, User user) throws IOException {
        if (this.parent.getCoprocessorHost() != null) {
            if (user == null) {
                this.parent.getCoprocessorHost().preRollBackSplit();
            } else {
                try {
                    user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            SplitTransactionImpl.this.parent.getCoprocessorHost().preRollBackSplit();
                            return null;
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
        }
        boolean result = true;
        ListIterator<SplitTransaction.JournalEntry> iterator2 = this.journal.listIterator(this.journal.size());
        block16: while (iterator2.hasPrevious()) {
            SplitTransaction.JournalEntry je = iterator2.previous();
            this.transition(je.getPhase(), true);
            switch (je.getPhase()) {
                case SET_SPLITTING: {
                    if (this.useCoordinatedStateManager(server) && server instanceof HRegionServer) {
                        ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getSplitTransactionCoordination().clean(this.parent.getRegionInfo());
                        continue block16;
                    }
                    if (services == null || this.useZKForAssignment || services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.SPLIT_REVERTED, this.parent.getRegionInfo(), this.hri_a, this.hri_b)) continue block16;
                    return false;
                }
                case CREATE_SPLIT_DIR: {
                    this.parent.writestate.writesEnabled = true;
                    this.parent.getRegionFileSystem().cleanupSplitsDir();
                    continue block16;
                }
                case CLOSED_PARENT_REGION: {
                    try {
                        this.parent.initialize();
                        continue block16;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed rollbacking CLOSED_PARENT_REGION of region " + this.parent.getRegionInfo().getRegionNameAsString()), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                case STARTED_REGION_A_CREATION: {
                    this.parent.getRegionFileSystem().cleanupDaughterRegion(this.hri_a);
                    continue block16;
                }
                case STARTED_REGION_B_CREATION: {
                    this.parent.getRegionFileSystem().cleanupDaughterRegion(this.hri_b);
                    continue block16;
                }
                case OFFLINED_PARENT: {
                    if (services == null) continue block16;
                    services.addToOnlineRegions(this.parent);
                    continue block16;
                }
                case PONR: {
                    return false;
                }
                case STARTED: 
                case PREPARED: 
                case BEFORE_PRE_SPLIT_HOOK: 
                case AFTER_PRE_SPLIT_HOOK: 
                case BEFORE_POST_SPLIT_HOOK: 
                case AFTER_POST_SPLIT_HOOK: 
                case OPENED_REGION_A: 
                case OPENED_REGION_B: 
                case COMPLETED: {
                    continue block16;
                }
            }
            throw new RuntimeException("Unhandled journal entry: " + je);
        }
        if (this.parent.getCoprocessorHost() != null) {
            if (user == null) {
                this.parent.getCoprocessorHost().postRollBackSplit();
            } else {
                try {
                    user.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            SplitTransactionImpl.this.parent.getCoprocessorHost().postRollBackSplit();
                            return null;
                        }
                    });
                }
                catch (InterruptedException ie) {
                    InterruptedIOException iioe = new InterruptedIOException();
                    iioe.initCause(ie);
                    throw iioe;
                }
            }
        }
        return result;
    }

    HRegionInfo getFirstDaughter() {
        return this.hri_a;
    }

    HRegionInfo getSecondDaughter() {
        return this.hri_b;
    }

    @Override
    public List<SplitTransaction.JournalEntry> getJournal() {
        return this.journal;
    }

    @Override
    public SplitTransaction registerTransactionListener(SplitTransaction.TransactionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public RegionServerServices getRegionServerServices() {
        return this.rsServices;
    }

    class StoreFileSplitter
    implements Callable<Pair<Path, Path>> {
        private final byte[] family;
        private final StoreFile sf;

        public StoreFileSplitter(byte[] family, StoreFile sf) {
            this.sf = sf;
            this.family = family;
        }

        @Override
        public Pair<Path, Path> call() throws IOException {
            return SplitTransactionImpl.this.splitStoreFile(this.family, this.sf);
        }
    }

    static class LoggingProgressable
    implements CancelableProgressable {
        private final HRegionInfo hri;
        private long lastLog = -1L;
        private final long interval;

        LoggingProgressable(HRegionInfo hri, long interval) {
            this.hri = hri;
            this.interval = interval;
        }

        @Override
        public boolean progress() {
            long now = EnvironmentEdgeManager.currentTime();
            if (now - this.lastLog > this.interval) {
                LOG.info((Object)("Opening " + this.hri.getRegionNameAsString()));
                this.lastLog = now;
            }
            return true;
        }
    }

    class DaughterOpener
    extends HasThread {
        private final Server server;
        private final HRegion r;
        private Throwable t;

        DaughterOpener(Server s, HRegion r) {
            super((s == null ? "null-services" : s.getServerName()) + "-daughterOpener=" + r.getRegionInfo().getEncodedName());
            this.t = null;
            this.setDaemon(true);
            this.server = s;
            this.r = r;
        }

        Throwable getException() {
            return this.t;
        }

        @Override
        public void run() {
            try {
                SplitTransactionImpl.this.openDaughterRegion(this.server, this.r);
            }
            catch (Throwable t) {
                this.t = t;
            }
        }
    }

    public static class JournalEntryImpl
    implements SplitTransaction.JournalEntry {
        private SplitTransaction.SplitTransactionPhase type;
        private long timestamp;

        public JournalEntryImpl(SplitTransaction.SplitTransactionPhase type) {
            this(type, EnvironmentEdgeManager.currentTime());
        }

        public JournalEntryImpl(SplitTransaction.SplitTransactionPhase type, long timestamp) {
            this.type = type;
            this.timestamp = timestamp;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.type);
            sb.append(" at ");
            sb.append(this.timestamp);
            return sb.toString();
        }

        @Override
        public SplitTransaction.SplitTransactionPhase getPhase() {
            return this.type;
        }

        @Override
        public long getTimeStamp() {
            return this.timestamp;
        }
    }
}

