/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.HBaseZeroCopyByteString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ByteStringer {
    private static final Log LOG = LogFactory.getLog(ByteStringer.class);
    private static boolean USE_ZEROCOPYBYTESTRING = true;

    private ByteStringer() {
    }

    public static ByteString wrap(byte[] array2) {
        return USE_ZEROCOPYBYTESTRING ? HBaseZeroCopyByteString.wrap(array2) : ByteString.copyFrom((byte[])array2);
    }

    public static ByteString wrap(byte[] array2, int offset, int length) {
        return USE_ZEROCOPYBYTESTRING ? HBaseZeroCopyByteString.wrap(array2, offset, length) : ByteString.copyFrom((byte[])array2, (int)offset, (int)length);
    }

    static {
        try {
            HBaseZeroCopyByteString.wrap(new byte[0]);
        }
        catch (IllegalAccessError iae) {
            USE_ZEROCOPYBYTESTRING = false;
            LOG.debug((Object)("Failed to classload HBaseZeroCopyByteString: " + iae.toString()));
        }
    }
}

