/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.plan.strategy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkCopyOnWriteTable;
import org.apache.hudi.table.HoodieSparkMergeOnReadTable;
import org.apache.hudi.table.action.cluster.strategy.PartitionAwareClusteringPlanStrategy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;

public class SparkRecentDaysClusteringPlanStrategy<T extends HoodieRecordPayload<T>>
extends PartitionAwareClusteringPlanStrategy<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(SparkRecentDaysClusteringPlanStrategy.class);

    public SparkRecentDaysClusteringPlanStrategy(HoodieSparkCopyOnWriteTable<T> table, HoodieSparkEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    public SparkRecentDaysClusteringPlanStrategy(HoodieSparkMergeOnReadTable<T> table, HoodieSparkEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    protected Stream<HoodieClusteringGroup> buildClusteringGroupsForPartition(String partitionPath, List<FileSlice> fileSlices) {
        ArrayList fileSliceGroups = new ArrayList();
        ArrayList<FileSlice> currentGroup = new ArrayList<FileSlice>();
        int totalSizeSoFar = 0;
        for (FileSlice currentSlice : fileSlices) {
            if ((long)(totalSizeSoFar = (int)((long)totalSizeSoFar + (currentSlice.getBaseFile().isPresent() ? currentSlice.getBaseFile().get().getFileSize() : this.getWriteConfig().getParquetMaxFileSize()))) >= this.getWriteConfig().getClusteringMaxBytesInGroup() && !currentGroup.isEmpty()) {
                fileSliceGroups.add(Pair.of(currentGroup, this.getNumberOfOutputFileGroups(totalSizeSoFar, this.getWriteConfig().getClusteringTargetFileMaxBytes())));
                currentGroup = new ArrayList();
                totalSizeSoFar = 0;
            }
            currentGroup.add(currentSlice);
        }
        if (!currentGroup.isEmpty()) {
            fileSliceGroups.add(Pair.of(currentGroup, this.getNumberOfOutputFileGroups(totalSizeSoFar, this.getWriteConfig().getClusteringTargetFileMaxBytes())));
        }
        return fileSliceGroups.stream().map(fileSliceGroup -> HoodieClusteringGroup.newBuilder().setSlices(SparkRecentDaysClusteringPlanStrategy.getFileSliceInfo((List)fileSliceGroup.getLeft())).setNumOutputFileGroups((Integer)fileSliceGroup.getRight()).setMetrics(this.buildMetrics((List)fileSliceGroup.getLeft())).build());
    }

    @Override
    protected Map<String, String> getStrategyParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isNullOrEmpty(this.getWriteConfig().getClusteringSortColumns())) {
            params.put("hoodie.clustering.plan.strategy.sort.columns", this.getWriteConfig().getClusteringSortColumns());
        }
        return params;
    }

    @Override
    protected List<String> filterPartitionPaths(List<String> partitionPaths) {
        int targetPartitionsForClustering = this.getWriteConfig().getTargetPartitionsForClustering();
        return partitionPaths.stream().sorted(Comparator.reverseOrder()).limit(targetPartitionsForClustering > 0 ? (long)targetPartitionsForClustering : (long)partitionPaths.size()).collect(Collectors.toList());
    }

    @Override
    protected Stream<FileSlice> getFileSlicesEligibleForClustering(String partition) {
        return super.getFileSlicesEligibleForClustering(partition).filter(slice -> slice.getBaseFile().map(BaseFile::getFileSize).orElse(0L) < this.getWriteConfig().getClusteringSmallFileLimit());
    }

    private int getNumberOfOutputFileGroups(long groupSize, long targetFileSize) {
        return (int)Math.ceil((double)groupSize / (double)targetFileSize);
    }
}

