/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.BootstrapBaseFileSplit;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;

public class InputSplitUtils {
    public static void writeString(String str, DataOutput out) throws IOException {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static String readString(DataInput in) throws IOException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static Schema getBaseFileSchema(FileSplit split2, Configuration conf) {
        try {
            if (split2 instanceof BootstrapBaseFileSplit) {
                HoodieFileReader storageReader = HoodieFileReaderFactory.getFileReader(conf, ((BootstrapBaseFileSplit)split2).getBootstrapFileSplit().getPath());
                return HoodieAvroUtils.addMetadataFields(storageReader.getSchema());
            }
            return HoodieRealtimeRecordReaderUtils.readSchema(conf, split2.getPath());
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read footer for parquet " + split2.getPath(), e);
        }
    }
}

