/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import com.uber.hoodie.hadoop.HoodieInputFormat;
import com.uber.hoodie.hadoop.realtime.HoodieRealtimeInputFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hudi.com.beust.jcommander.JCommander;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.InvalidTableException;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveClient;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.NonPartitionedExtractor;
import org.apache.hudi.hive.SchemaDifference;
import org.apache.hudi.hive.util.HiveSchemaUtil;
import org.apache.hudi.sync.common.AbstractSyncHoodieClient;
import org.apache.hudi.sync.common.AbstractSyncTool;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;

public class HiveSyncTool
extends AbstractSyncTool {
    private static final Logger LOG = LogManager.getLogger(HiveSyncTool.class);
    public static final String SUFFIX_SNAPSHOT_TABLE = "_rt";
    public static final String SUFFIX_READ_OPTIMIZED_TABLE = "_ro";
    private final HiveSyncConfig cfg;
    private final HoodieHiveClient hoodieHiveClient;
    private final String snapshotTableName;
    private final Option<String> roTableTableName;

    public HiveSyncTool(HiveSyncConfig cfg, HiveConf configuration, FileSystem fs) {
        super(configuration.getAllProperties(), fs);
        this.hoodieHiveClient = new HoodieHiveClient(cfg, configuration, fs);
        this.cfg = cfg;
        if (NonPartitionedExtractor.class.getName().equals(cfg.partitionValueExtractorClass)) {
            LOG.warn((Object)"Set partitionFields to empty, since the NonPartitionedExtractor is used");
            cfg.partitionFields = new ArrayList<String>();
        }
        switch (this.hoodieHiveClient.getTableType()) {
            case COPY_ON_WRITE: {
                this.snapshotTableName = cfg.tableName;
                this.roTableTableName = Option.empty();
                break;
            }
            case MERGE_ON_READ: {
                this.snapshotTableName = cfg.tableName + SUFFIX_SNAPSHOT_TABLE;
                this.roTableTableName = cfg.skipROSuffix != false ? Option.of(cfg.tableName) : Option.of(cfg.tableName + SUFFIX_READ_OPTIMIZED_TABLE);
                break;
            }
            default: {
                LOG.error((Object)("Unknown table type " + (Object)((Object)this.hoodieHiveClient.getTableType())));
                throw new InvalidTableException(this.hoodieHiveClient.getBasePath());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void syncHoodieTable() {
        try {
            switch (this.hoodieHiveClient.getTableType()) {
                case COPY_ON_WRITE: {
                    this.syncHoodieTable(this.snapshotTableName, false);
                    return;
                }
                case MERGE_ON_READ: {
                    this.syncHoodieTable(this.roTableTableName.get(), false);
                    this.syncHoodieTable(this.snapshotTableName, true);
                    return;
                }
                default: {
                    LOG.error((Object)("Unknown table type " + (Object)((Object)this.hoodieHiveClient.getTableType())));
                    throw new InvalidTableException(this.hoodieHiveClient.getBasePath());
                }
            }
        }
        catch (RuntimeException re) {
            LOG.error((Object)"Got runtime exception when hive syncing", (Throwable)re);
            return;
        }
        finally {
            this.hoodieHiveClient.close();
        }
    }

    private void syncHoodieTable(String tableName, boolean useRealtimeInputFormat) {
        LOG.info((Object)("Trying to sync hoodie table " + tableName + " with base path " + this.hoodieHiveClient.getBasePath() + " of type " + (Object)((Object)this.hoodieHiveClient.getTableType())));
        boolean tableExists = this.hoodieHiveClient.doesTableExist(tableName);
        if (this.cfg.autoCreateDatabase.booleanValue()) {
            try {
                this.hoodieHiveClient.updateHiveSQL("create database if not exists " + this.cfg.databaseName);
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to create database", (Throwable)e);
            }
        } else if (!this.hoodieHiveClient.doesDataBaseExist(this.cfg.databaseName)) {
            throw new HoodieHiveSyncException("hive database does not exist " + this.cfg.databaseName);
        }
        MessageType schema = this.hoodieHiveClient.getDataSchema();
        this.syncSchema(tableName, tableExists, useRealtimeInputFormat, schema);
        LOG.info((Object)("Schema sync complete. Syncing partitions for " + tableName));
        Option<Object> lastCommitTimeSynced = Option.empty();
        if (tableExists) {
            lastCommitTimeSynced = this.hoodieHiveClient.getLastCommitTimeSynced(tableName);
        }
        LOG.info((Object)("Last commit time synced was found to be " + lastCommitTimeSynced.orElse("null")));
        List<String> writtenPartitionsSince = this.hoodieHiveClient.getPartitionsWrittenToSince(lastCommitTimeSynced);
        LOG.info((Object)("Storage partitions scan complete. Found " + writtenPartitionsSince.size()));
        this.syncPartitions(tableName, writtenPartitionsSince);
        this.hoodieHiveClient.updateLastCommitTimeSynced(tableName);
        LOG.info((Object)("Sync complete for " + tableName));
    }

    private void syncSchema(String tableName, boolean tableExists, boolean useRealTimeInputFormat, MessageType schema) {
        if (!tableExists) {
            LOG.info((Object)("Hive table " + tableName + " is not found. Creating it"));
            HoodieFileFormat baseFileFormat = HoodieFileFormat.valueOf(this.cfg.baseFileFormat.toUpperCase());
            String inputFormatClassName = HoodieInputFormatUtils.getInputFormatClassName(baseFileFormat, useRealTimeInputFormat);
            if (baseFileFormat.equals((Object)HoodieFileFormat.PARQUET) && this.cfg.usePreApacheInputFormat.booleanValue()) {
                inputFormatClassName = useRealTimeInputFormat ? HoodieRealtimeInputFormat.class.getName() : HoodieInputFormat.class.getName();
            }
            String outputFormatClassName = HoodieInputFormatUtils.getOutputFormatClassName(baseFileFormat);
            String serDeFormatClassName = HoodieInputFormatUtils.getSerDeClassName(baseFileFormat);
            this.hoodieHiveClient.createTable(tableName, schema, inputFormatClassName, outputFormatClassName, serDeFormatClassName);
        } else {
            Map<String, String> tableSchema = this.hoodieHiveClient.getTableSchema(tableName);
            SchemaDifference schemaDiff = HiveSchemaUtil.getSchemaDifference(schema, tableSchema, this.cfg.partitionFields, this.cfg.supportTimestamp);
            if (!schemaDiff.isEmpty()) {
                LOG.info((Object)("Schema difference found for " + tableName));
                this.hoodieHiveClient.updateTableDefinition(tableName, schema);
            } else {
                LOG.info((Object)("No Schema difference for " + tableName));
            }
        }
    }

    private void syncPartitions(String tableName, List<String> writtenPartitionsSince) {
        try {
            List<Partition> hivePartitions = this.hoodieHiveClient.scanTablePartitions(tableName);
            List<AbstractSyncHoodieClient.PartitionEvent> partitionEvents = this.hoodieHiveClient.getPartitionEvents(hivePartitions, writtenPartitionsSince);
            List<String> newPartitions = this.filterPartitions(partitionEvents, AbstractSyncHoodieClient.PartitionEvent.PartitionEventType.ADD);
            LOG.info((Object)("New Partitions " + newPartitions));
            this.hoodieHiveClient.addPartitionsToTable(tableName, newPartitions);
            List<String> updatePartitions = this.filterPartitions(partitionEvents, AbstractSyncHoodieClient.PartitionEvent.PartitionEventType.UPDATE);
            LOG.info((Object)("Changed Partitions " + updatePartitions));
            this.hoodieHiveClient.updatePartitionsToTable(tableName, updatePartitions);
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to sync partitions for table " + tableName, e);
        }
    }

    private List<String> filterPartitions(List<AbstractSyncHoodieClient.PartitionEvent> events, AbstractSyncHoodieClient.PartitionEvent.PartitionEventType eventType) {
        return events.stream().filter(s -> s.eventType == eventType).map(s -> s.storagePartition).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        HiveSyncConfig cfg = new HiveSyncConfig();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        FileSystem fs = FSUtils.getFs(cfg.basePath, new Configuration());
        HiveConf hiveConf = new HiveConf();
        hiveConf.addResource(fs.getConf());
        new HiveSyncTool(cfg, hiveConf, fs).syncHoodieTable();
    }
}

