/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.table.HoodieTable;

public class HoodieIndexUtils {
    public static List<Pair<String, HoodieBaseFile>> getLatestBaseFilesForAllPartitions(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        context.setJobStatus(HoodieIndexUtils.class.getSimpleName(), "Load latest base files from all partitions");
        return context.flatMap(partitions, partitionPath -> {
            Option<HoodieInstant> latestCommitTime = hoodieTable.getMetaClient().getCommitsTimeline().filterCompletedInstants().lastInstant();
            List<Object> filteredFiles = new ArrayList();
            if (latestCommitTime.isPresent()) {
                filteredFiles = hoodieTable.getBaseFileOnlyView().getLatestBaseFilesBeforeOrOn((String)partitionPath, latestCommitTime.get().getTimestamp()).map(f -> Pair.of(partitionPath, f)).collect(Collectors.toList());
            }
            return filteredFiles.stream();
        }, Math.max(partitions.size(), 1));
    }

    public static HoodieRecord getTaggedRecord(HoodieRecord inputRecord, Option<HoodieRecordLocation> location) {
        HoodieRecord record = inputRecord;
        if (location.isPresent()) {
            record = new HoodieRecord(inputRecord);
            record.unseal();
            record.setCurrentLocation(location.get());
            record.seal();
        }
        return record;
    }
}

