/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.simple;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.simple.SparkHoodieSimpleIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class SparkHoodieGlobalSimpleIndex<T extends HoodieRecordPayload>
extends SparkHoodieSimpleIndex<T> {
    public SparkHoodieGlobalSimpleIndex(HoodieWriteConfig config) {
        super(config);
    }

    @Override
    public JavaRDD<HoodieRecord<T>> tagLocation(JavaRDD<HoodieRecord<T>> recordRDD, HoodieEngineContext context, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> hoodieTable) {
        return this.tagLocationInternal(recordRDD, context, hoodieTable);
    }

    @Override
    protected JavaRDD<HoodieRecord<T>> tagLocationInternal(JavaRDD<HoodieRecord<T>> inputRecordRDD, HoodieEngineContext context, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> hoodieTable) {
        JavaPairRDD keyedInputRecordRDD = inputRecordRDD.mapToPair((PairFunction & Serializable)entry -> new Tuple2((Object)entry.getRecordKey(), entry));
        JavaPairRDD<HoodieKey, HoodieRecordLocation> allRecordLocationsInTable = this.fetchAllRecordLocations(context, hoodieTable, this.config.getGlobalSimpleIndexParallelism());
        return this.getTaggedRecords(keyedInputRecordRDD, allRecordLocationsInTable);
    }

    protected JavaPairRDD<HoodieKey, HoodieRecordLocation> fetchAllRecordLocations(HoodieEngineContext context, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> hoodieTable, int parallelism) {
        List<Pair<String, HoodieBaseFile>> latestBaseFiles = this.getAllBaseFilesInTable(context, hoodieTable);
        return this.fetchRecordLocations(context, hoodieTable, parallelism, latestBaseFiles);
    }

    protected List<Pair<String, HoodieBaseFile>> getAllBaseFilesInTable(HoodieEngineContext context, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> hoodieTable) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        List<String> allPartitionPaths = FSUtils.getAllPartitionPaths(context, this.config.getMetadataConfig(), metaClient.getBasePath());
        return HoodieIndexUtils.getLatestBaseFilesForAllPartitions(allPartitionPaths, context, hoodieTable);
    }

    private JavaRDD<HoodieRecord<T>> getTaggedRecords(JavaPairRDD<String, HoodieRecord<T>> incomingRecords, JavaPairRDD<HoodieKey, HoodieRecordLocation> existingRecords) {
        JavaPairRDD existingRecordByRecordKey = existingRecords.mapToPair((PairFunction & Serializable)entry -> new Tuple2((Object)((HoodieKey)entry._1).getRecordKey(), Pair.of(((HoodieKey)entry._1).getPartitionPath(), entry._2)));
        return incomingRecords.leftOuterJoin(existingRecordByRecordKey).values().flatMap((FlatMapFunction & Serializable)entry -> {
            List<HoodieRecord> taggedRecords;
            HoodieRecord inputRecord = (HoodieRecord)entry._1;
            Option<Object> partitionPathLocationPair = Option.ofNullable(((Optional)entry._2).orNull());
            if (partitionPathLocationPair.isPresent()) {
                String partitionPath = (String)((Pair)partitionPathLocationPair.get()).getKey();
                HoodieRecordLocation location = (HoodieRecordLocation)((Pair)partitionPathLocationPair.get()).getRight();
                if (this.config.getGlobalSimpleIndexUpdatePartitionPath() && !inputRecord.getPartitionPath().equals(partitionPath)) {
                    HoodieRecord<EmptyHoodieRecordPayload> deleteRecord = new HoodieRecord<EmptyHoodieRecordPayload>(new HoodieKey(inputRecord.getRecordKey(), partitionPath), new EmptyHoodieRecordPayload());
                    deleteRecord.setCurrentLocation(location);
                    deleteRecord.seal();
                    HoodieRecord insertRecord = HoodieIndexUtils.getTaggedRecord(inputRecord, Option.empty());
                    taggedRecords = Arrays.asList(deleteRecord, insertRecord);
                } else {
                    HoodieRecord newRecord = new HoodieRecord(new HoodieKey(inputRecord.getRecordKey(), partitionPath), inputRecord.getData());
                    taggedRecords = Collections.singletonList(HoodieIndexUtils.getTaggedRecord(newRecord, Option.ofNullable(location)));
                }
            } else {
                taggedRecords = Collections.singletonList(HoodieIndexUtils.getTaggedRecord(inputRecord, Option.empty()));
            }
            return taggedRecords.iterator();
        });
    }

    @Override
    public boolean isGlobal() {
        return true;
    }
}

