/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.HoodieInternalRowFileWriter;
import org.apache.hudi.io.storage.HoodieInternalRowParquetWriter;
import org.apache.hudi.io.storage.HoodieRowParquetConfig;
import org.apache.hudi.io.storage.HoodieRowParquetWriteSupport;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.sql.types.StructType;

public class HoodieInternalRowFileWriterFactory {
    public static HoodieInternalRowFileWriter getInternalRowFileWriter(Path path, HoodieTable hoodieTable, HoodieWriteConfig config, StructType schema) throws IOException {
        String extension = FSUtils.getFileExtension(path.getName());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return HoodieInternalRowFileWriterFactory.newParquetInternalRowFileWriter(path, config, schema, hoodieTable);
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    private static HoodieInternalRowFileWriter newParquetInternalRowFileWriter(Path path, HoodieWriteConfig writeConfig, StructType structType, HoodieTable table) throws IOException {
        BloomFilter filter = BloomFilterFactory.createBloomFilter(writeConfig.getBloomFilterNumEntries(), writeConfig.getBloomFilterFPP(), writeConfig.getDynamicBloomFilterMaxNumEntries(), writeConfig.getBloomFilterType());
        HoodieRowParquetWriteSupport writeSupport = new HoodieRowParquetWriteSupport(table.getHadoopConf(), structType, filter);
        return new HoodieInternalRowParquetWriter(path, new HoodieRowParquetConfig(writeSupport, writeConfig.getParquetCompressionCodec(), writeConfig.getParquetBlockSize(), writeConfig.getParquetPageSize(), writeConfig.getParquetMaxFileSize(), writeSupport.getHadoopConf(), writeConfig.getParquetCompressionRatio()));
    }
}

