/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.io.storage.HoodieAvroParquetConfig;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;

public class HoodieParquetWriter<T extends HoodieRecordPayload, R extends IndexedRecord>
extends ParquetWriter<IndexedRecord>
implements HoodieFileWriter<R> {
    private static AtomicLong recordIndex = new AtomicLong(1L);
    private final Path file;
    private final HoodieWrapperFileSystem fs;
    private final long maxFileSize;
    private final HoodieAvroWriteSupport writeSupport;
    private final String instantTime;
    private final TaskContextSupplier taskContextSupplier;

    public HoodieParquetWriter(String instantTime, Path file, HoodieAvroParquetConfig parquetConfig, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        super(HoodieWrapperFileSystem.convertToHoodiePath(file, parquetConfig.getHadoopConf()), ParquetFileWriter.Mode.CREATE, (WriteSupport)parquetConfig.getWriteSupport(), parquetConfig.getCompressionCodecName(), parquetConfig.getBlockSize(), parquetConfig.getPageSize(), parquetConfig.getPageSize(), true, false, DEFAULT_WRITER_VERSION, FSUtils.registerFileSystem(file, parquetConfig.getHadoopConf()));
        this.file = HoodieWrapperFileSystem.convertToHoodiePath(file, parquetConfig.getHadoopConf());
        this.fs = (HoodieWrapperFileSystem)this.file.getFileSystem(FSUtils.registerFileSystem(file, parquetConfig.getHadoopConf()));
        this.maxFileSize = parquetConfig.getMaxFileSize() + Math.round((double)parquetConfig.getMaxFileSize() * parquetConfig.getCompressionRatio());
        this.writeSupport = (HoodieAvroWriteSupport)((Object)parquetConfig.getWriteSupport());
        this.instantTime = instantTime;
        this.taskContextSupplier = taskContextSupplier;
    }

    @Override
    public void writeAvroWithMetadata(R avroRecord, HoodieRecord record) throws IOException {
        String seqId = HoodieRecord.generateSequenceId(this.instantTime, this.taskContextSupplier.getPartitionIdSupplier().get(), recordIndex.getAndIncrement());
        HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)avroRecord, record.getRecordKey(), record.getPartitionPath(), this.file.getName());
        HoodieAvroUtils.addCommitMetadataToRecord((GenericRecord)avroRecord, this.instantTime, seqId);
        super.write(avroRecord);
        this.writeSupport.add(record.getRecordKey());
    }

    @Override
    public boolean canWrite() {
        return this.fs.getBytesWritten(this.file) < this.maxFileSize;
    }

    @Override
    public void writeAvro(String key, IndexedRecord object) throws IOException {
        super.write((Object)object);
        this.writeSupport.add(key);
    }
}

