/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.AvroConversionHelper;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.RowKeyGeneratorHelper;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;

public abstract class BuiltinKeyGenerator
extends BaseKeyGenerator
implements SparkKeyGeneratorInterface {
    private static final String STRUCT_NAME = "hoodieRowTopLevelField";
    private static final String NAMESPACE = "hoodieRow";
    private transient Function1<Object, Object> converterFn = null;
    protected StructType structType;
    protected Map<String, List<Integer>> recordKeyPositions = new HashMap<String, List<Integer>>();
    protected Map<String, List<Integer>> partitionPathPositions = new HashMap<String, List<Integer>>();

    protected BuiltinKeyGenerator(TypedProperties config) {
        super(config);
    }

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public String getRecordKey(Row row) {
        if (null == this.converterFn) {
            this.converterFn = AvroConversionHelper.createConverterToAvro((DataType)row.schema(), STRUCT_NAME, NAMESPACE);
        }
        GenericRecord genericRecord = (GenericRecord)this.converterFn.apply((Object)row);
        return this.getKey(genericRecord).getRecordKey();
    }

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public String getPartitionPath(Row row) {
        if (null == this.converterFn) {
            this.converterFn = AvroConversionHelper.createConverterToAvro((DataType)row.schema(), STRUCT_NAME, NAMESPACE);
        }
        GenericRecord genericRecord = (GenericRecord)this.converterFn.apply((Object)row);
        return this.getKey(genericRecord).getPartitionPath();
    }

    void buildFieldPositionMapIfNeeded(StructType structType) {
        if (this.structType == null) {
            this.getRecordKeyFields().stream().filter(f -> !f.contains(".")).forEach(f -> {
                if (!structType.getFieldIndex(f).isDefined()) {
                    throw new HoodieKeyException("recordKey value not found for field: \"" + f + "\"");
                }
                this.recordKeyPositions.put((String)f, Collections.singletonList((Integer)structType.getFieldIndex(f).get()));
            });
            this.getRecordKeyFields().stream().filter(f -> f.contains(".")).forEach(f -> this.recordKeyPositions.put((String)f, RowKeyGeneratorHelper.getNestedFieldIndices(structType, f, true)));
            if (this.getPartitionPathFields() != null) {
                this.getPartitionPathFields().stream().filter(f -> !f.isEmpty()).filter(f -> !f.contains(".")).forEach(f -> {
                    if (structType.getFieldIndex(f).isDefined()) {
                        this.partitionPathPositions.put((String)f, Collections.singletonList((Integer)structType.getFieldIndex(f).get()));
                    } else {
                        this.partitionPathPositions.put((String)f, Collections.singletonList(-1));
                    }
                });
                this.getPartitionPathFields().stream().filter(f -> !f.isEmpty()).filter(f -> f.contains(".")).forEach(f -> this.partitionPathPositions.put((String)f, RowKeyGeneratorHelper.getNestedFieldIndices(structType, f, false)));
            }
            this.structType = structType;
        }
    }
}

