/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;

public class ComplexAvroKeyGenerator
extends BaseKeyGenerator {
    public static final String DEFAULT_RECORD_KEY_SEPARATOR = ":";

    public ComplexAvroKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.stream(props.getString("hoodie.datasource.write.recordkey.field").split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.partitionPathFields = Arrays.stream(props.getString("hoodie.datasource.write.partitionpath.field").split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return KeyGenUtils.getRecordKey(record, this.getRecordKeyFields());
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return KeyGenUtils.getRecordPartitionPath(record, this.getPartitionPathFields(), this.hiveStylePartitioning, this.encodePartitionPath);
    }
}

