/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.spark.sql.Row;

public class CustomKeyGenerator
extends BuiltinKeyGenerator {
    private final CustomAvroKeyGenerator customAvroKeyGenerator;

    public CustomKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.stream(props.getString("hoodie.datasource.write.recordkey.field").split(",")).map(String::trim).collect(Collectors.toList());
        this.partitionPathFields = Arrays.stream(props.getString("hoodie.datasource.write.partitionpath.field").split(",")).map(String::trim).collect(Collectors.toList());
        this.customAvroKeyGenerator = new CustomAvroKeyGenerator(props);
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return this.customAvroKeyGenerator.getRecordKey(record);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.customAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        this.validateRecordKeyFields();
        return this.getRecordKeyFields().size() == 1 ? new SimpleKeyGenerator(this.config).getRecordKey(row) : new ComplexKeyGenerator(this.config).getRecordKey(row);
    }

    @Override
    public String getPartitionPath(Row row) {
        return this.getPartitionPath(Option.empty(), Option.of(row));
    }

    private String getPartitionPath(Option<GenericRecord> record, Option<Row> row) {
        if (this.getPartitionPathFields() == null) {
            throw new HoodieKeyException("Unable to find field names for partition path in cfg");
        }
        StringBuilder partitionPath = new StringBuilder();
        if (this.getPartitionPathFields().size() == 1 && this.getPartitionPathFields().get(0).isEmpty()) {
            return "";
        }
        for (String field : this.getPartitionPathFields()) {
            String[] fieldWithType = field.split(this.customAvroKeyGenerator.getSplitRegex());
            if (fieldWithType.length != 2) {
                throw new HoodieKeyGeneratorException("Unable to find field names for partition path in proper format");
            }
            String partitionPathField = fieldWithType[0];
            CustomAvroKeyGenerator.PartitionKeyType keyType = CustomAvroKeyGenerator.PartitionKeyType.valueOf(fieldWithType[1].toUpperCase());
            switch (keyType) {
                case SIMPLE: {
                    if (record.isPresent()) {
                        partitionPath.append(new SimpleKeyGenerator(this.config, partitionPathField).getPartitionPath(record.get()));
                        break;
                    }
                    partitionPath.append(new SimpleKeyGenerator(this.config, partitionPathField).getPartitionPath(row.get()));
                    break;
                }
                case TIMESTAMP: {
                    try {
                        if (record.isPresent()) {
                            partitionPath.append(new TimestampBasedKeyGenerator(this.config, partitionPathField).getPartitionPath(record.get()));
                            break;
                        }
                        partitionPath.append(new TimestampBasedKeyGenerator(this.config, partitionPathField).getPartitionPath(row.get()));
                        break;
                    }
                    catch (IOException ioe) {
                        throw new HoodieKeyGeneratorException("Unable to initialise TimestampBasedKeyGenerator class", ioe);
                    }
                }
                default: {
                    throw new HoodieKeyGeneratorException("Please provide valid PartitionKeyType with fields! You provided: " + (Object)((Object)keyType));
                }
            }
            partitionPath.append(this.customAvroKeyGenerator.getDefaultPartitionPathSeparator());
        }
        partitionPath.deleteCharAt(partitionPath.length() - 1);
        return partitionPath.toString();
    }

    private void validateRecordKeyFields() {
        if (this.getRecordKeyFields() == null || this.getRecordKeyFields().isEmpty()) {
            throw new HoodieKeyException("Unable to find field names for record key in cfg");
        }
    }
}

