/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.metadata.BaseTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataMergedLogRecordScanner;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieBackedTableMetadata
extends BaseTableMetadata {
    private static final Logger LOG = LogManager.getLogger(HoodieBackedTableMetadata.class);
    private String metadataBasePath;
    private HoodieTableMetaClient metaClient;
    private List<FileSlice> latestFileSystemMetadataSlices;
    private transient HoodieFileReader<GenericRecord> baseFileReader;
    private transient HoodieMetadataMergedLogRecordScanner logRecordScanner;

    public HoodieBackedTableMetadata(Configuration conf, HoodieMetadataConfig metadataConfig, String datasetBasePath, String spillableMapDirectory) {
        this(new HoodieLocalEngineContext(conf), metadataConfig, datasetBasePath, spillableMapDirectory);
    }

    public HoodieBackedTableMetadata(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String datasetBasePath, String spillableMapDirectory) {
        super(engineContext, metadataConfig, datasetBasePath, spillableMapDirectory);
        this.initIfNeeded();
    }

    private void initIfNeeded() {
        if (this.enabled && this.metaClient == null) {
            this.metadataBasePath = HoodieTableMetadata.getMetadataTableBasePath(this.datasetBasePath);
            try {
                this.metaClient = new HoodieTableMetaClient(this.hadoopConf.get(), this.metadataBasePath);
                HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(this.metaClient, this.metaClient.getActiveTimeline());
                this.latestFileSystemMetadataSlices = fsView.getLatestFileSlices(MetadataPartitionType.FILES.partitionPath()).collect(Collectors.toList());
            }
            catch (TableNotFoundException e) {
                LOG.warn((Object)("Metadata table was not found at path " + this.metadataBasePath));
                this.enabled = false;
                this.metaClient = null;
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to initialize metadata table at path " + this.metadataBasePath), (Throwable)e);
                this.enabled = false;
                this.metaClient = null;
            }
        } else {
            LOG.info((Object)"Metadata table is disabled.");
        }
    }

    @Override
    protected Option<HoodieRecord<HoodieMetadataPayload>> getRecordByKeyFromMetadata(String key) {
        try {
            Option<HoodieRecord<HoodieMetadataPayload>> logHoodieRecord;
            ArrayList<Long> timings = new ArrayList<Long>();
            HoodieTimer timer = new HoodieTimer().startTimer();
            this.openFileSliceIfNeeded();
            timings.add(timer.endTimer());
            timer.startTimer();
            HoodieRecord<HoodieMetadataPayload> hoodieRecord = null;
            if (this.baseFileReader != null) {
                HoodieTimer readTimer = new HoodieTimer().startTimer();
                Option<GenericRecord> baseRecord = this.baseFileReader.getRecordByKey(key);
                if (baseRecord.isPresent()) {
                    hoodieRecord = (HoodieRecord<HoodieMetadataPayload>)SpillableMapUtils.convertToHoodieRecordPayload(baseRecord.get(), this.metaClient.getTableConfig().getPayloadClass());
                    this.metrics.ifPresent(m -> m.updateMetrics("basefile_read", readTimer.endTimer()));
                }
            }
            timings.add(timer.endTimer());
            timer.startTimer();
            if (this.logRecordScanner != null && (logHoodieRecord = this.logRecordScanner.getRecordByKey(key)).isPresent()) {
                if (hoodieRecord != null) {
                    HoodieMetadataPayload mergedPayload = logHoodieRecord.get().getData().preCombine(hoodieRecord.getData());
                    hoodieRecord = new HoodieRecord<HoodieMetadataPayload>(hoodieRecord.getKey(), mergedPayload);
                } else {
                    hoodieRecord = logHoodieRecord.get();
                }
            }
            timings.add(timer.endTimer());
            LOG.info((Object)String.format("Metadata read for key %s took [open, baseFileRead, logMerge] %s ms", key, timings));
            Option<HoodieRecord<HoodieMetadataPayload>> option2 = Option.ofNullable(hoodieRecord);
            return option2;
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error merging records from metadata table for key :" + key, ioe);
        }
        finally {
            this.closeIfNeeded();
        }
    }

    private synchronized void openFileSliceIfNeeded() throws IOException {
        if (this.metadataConfig.enableReuse() && this.baseFileReader != null) {
            return;
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        String latestInstantTime = this.getLatestDatasetInstantTime();
        ValidationUtils.checkArgument(this.latestFileSystemMetadataSlices.size() == 1, "must be at-least one validata metadata file slice");
        Option<HoodieBaseFile> basefile = this.latestFileSystemMetadataSlices.get(0).getBaseFile();
        if (basefile.isPresent()) {
            String basefilePath = basefile.get().getPath();
            this.baseFileReader = HoodieFileReaderFactory.getFileReader(this.hadoopConf.get(), new Path(basefilePath));
            LOG.info((Object)("Opened metadata base file from " + basefilePath + " at instant " + basefile.get().getCommitTime()));
        }
        List<String> logFilePaths = this.latestFileSystemMetadataSlices.get(0).getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).map(o -> o.getPath().toString()).collect(Collectors.toList());
        Option<HoodieInstant> lastInstant = this.metaClient.getActiveTimeline().filterCompletedInstants().lastInstant();
        String latestMetaInstantTimestamp = lastInstant.map(HoodieInstant::getTimestamp).orElse("0000000000000");
        Schema schema = HoodieAvroUtils.addMetadataFields(HoodieMetadataRecord.getClassSchema());
        this.logRecordScanner = new HoodieMetadataMergedLogRecordScanner(this.metaClient.getFs(), this.metadataBasePath, logFilePaths, schema, latestMetaInstantTimestamp, 0x40000000L, 0xA00000, this.spillableMapDirectory, null);
        LOG.info((Object)("Opened metadata log files from " + logFilePaths + " at instant " + latestInstantTime + "(dataset instant=" + latestInstantTime + ", metadata instant=" + latestMetaInstantTimestamp + ")"));
        this.metrics.ifPresent(metrics -> metrics.updateMetrics("scan", timer.endTimer()));
    }

    private void closeIfNeeded() {
        try {
            if (!this.metadataConfig.enableReuse()) {
                this.close();
            }
        }
        catch (Exception e) {
            throw new HoodieException("Error closing resources during metadata table merge", e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.baseFileReader != null) {
            this.baseFileReader.close();
            this.baseFileReader = null;
        }
        if (this.logRecordScanner != null) {
            this.logRecordScanner.close();
            this.logRecordScanner = null;
        }
    }

    @Override
    protected List<HoodieInstant> findInstantsToSync() {
        this.initIfNeeded();
        if (!this.enabled || !this.metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().isPresent()) {
            return Collections.EMPTY_LIST;
        }
        String latestMetadataInstantTime = this.metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().get().getTimestamp();
        HoodieDefaultTimeline candidateTimeline = this.datasetMetaClient.getActiveTimeline().findInstantsAfter(latestMetadataInstantTime, Integer.MAX_VALUE);
        Option<HoodieInstant> earliestIncompleteInstant = candidateTimeline.filterInflightsAndRequested().firstInstant();
        if (earliestIncompleteInstant.isPresent()) {
            return candidateTimeline.filterCompletedInstants().findInstantsBefore(earliestIncompleteInstant.get().getTimestamp()).getInstants().collect(Collectors.toList());
        }
        return candidateTimeline.filterCompletedInstants().getInstants().collect(Collectors.toList());
    }

    @Override
    public Option<String> getSyncedInstantTime() {
        if (!this.enabled) {
            return Option.empty();
        }
        HoodieActiveTimeline timeline = this.metaClient.reloadActiveTimeline();
        return timeline.getDeltaCommitTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::getTimestamp);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public SerializableConfiguration getHadoopConf() {
        return this.hadoopConf;
    }

    public HoodieTableMetaClient getMetaClient() {
        return this.metaClient;
    }

    public Map<String, String> stats() {
        return this.metrics.map(m -> m.getStats(true, this.metaClient, (HoodieTableMetadata)this)).orElse(new HashMap());
    }
}

