/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.bootstrap.FileStatusUtils;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.collection.Pair;

public class BootstrapUtils {
    public static List<Pair<String, List<HoodieFileStatus>>> getAllLeafFoldersWithFiles(HoodieTableMetaClient metaClient, FileSystem fs, String basePathStr, HoodieEngineContext context) throws IOException {
        Path basePath = new Path(basePathStr);
        String baseFileExtension = metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        HashMap levelToPartitions = new HashMap();
        HashMap partitionToFiles = new HashMap();
        PathFilter filePathFilter = BootstrapUtils.getFilePathFilter(baseFileExtension);
        PathFilter metaPathFilter = BootstrapUtils.getExcludeMetaPathFilter();
        FileStatus[] topLevelStatuses = fs.listStatus(basePath);
        ArrayList<String> subDirectories = new ArrayList<String>();
        ArrayList<Pair<HoodieFileStatus, Pair<Integer, String>>> result = new ArrayList<Pair<HoodieFileStatus, Pair<Integer, String>>>();
        for (FileStatus topLevelStatus : topLevelStatuses) {
            if (topLevelStatus.isFile() && filePathFilter.accept(topLevelStatus.getPath())) {
                String relativePath = FSUtils.getRelativePartitionPath(basePath, topLevelStatus.getPath().getParent());
                Integer level = (int)relativePath.chars().filter(ch -> ch == 47).count();
                HoodieFileStatus hoodieFileStatus = FileStatusUtils.fromFileStatus(topLevelStatus);
                result.add(Pair.of(hoodieFileStatus, Pair.of(level, relativePath)));
                continue;
            }
            if (!metaPathFilter.accept(topLevelStatus.getPath())) continue;
            subDirectories.add(topLevelStatus.getPath().toString());
        }
        if (subDirectories.size() > 0) {
            result.addAll(context.flatMap(subDirectories, directory -> {
                PathFilter pathFilter = BootstrapUtils.getFilePathFilter(baseFileExtension);
                Path path = new Path(directory);
                FileSystem fileSystem = path.getFileSystem(new Configuration());
                RemoteIterator itr = fileSystem.listFiles(path, true);
                ArrayList<Pair<HoodieFileStatus, Pair<Integer, String>>> res = new ArrayList<Pair<HoodieFileStatus, Pair<Integer, String>>>();
                while (itr.hasNext()) {
                    FileStatus status = (FileStatus)itr.next();
                    if (!pathFilter.accept(status.getPath())) continue;
                    String relativePath = FSUtils.getRelativePartitionPath(new Path(basePathStr), status.getPath().getParent());
                    Integer level = (int)relativePath.chars().filter(ch -> ch == 47).count();
                    HoodieFileStatus hoodieFileStatus = FileStatusUtils.fromFileStatus(status);
                    res.add(Pair.of(hoodieFileStatus, Pair.of(level, relativePath)));
                }
                return res.stream();
            }, subDirectories.size()));
        }
        result.forEach(val -> {
            String relativePath = (String)((Pair)val.getRight()).getRight();
            ArrayList statusList = (ArrayList)partitionToFiles.get(relativePath);
            if (null == statusList) {
                Integer level = (Integer)((Pair)val.getRight()).getLeft();
                ArrayList<String> dirs = (ArrayList<String>)levelToPartitions.get(level);
                if (null == dirs) {
                    dirs = new ArrayList<String>();
                    levelToPartitions.put(level, dirs);
                }
                dirs.add(relativePath);
                statusList = new ArrayList();
                partitionToFiles.put(relativePath, statusList);
            }
            statusList.add(val.getLeft());
        });
        OptionalInt maxLevelOpt = levelToPartitions.keySet().stream().mapToInt(x -> x).max();
        int maxLevel = maxLevelOpt.orElse(-1);
        return maxLevel >= 0 ? ((List)levelToPartitions.get(maxLevel)).stream().map(d -> Pair.of(d, partitionToFiles.get(d))).collect(Collectors.toList()) : new ArrayList<Pair<String, List<HoodieFileStatus>>>();
    }

    private static PathFilter getFilePathFilter(String baseFileExtension) {
        return path -> path.getName().endsWith(baseFileExtension);
    }

    private static PathFilter getExcludeMetaPathFilter() {
        return path -> !path.toString().contains(".hoodie");
    }
}

