/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseSparkCommitActionExecutor;
import org.apache.hudi.table.action.commit.SparkBulkInsertHelper;
import org.apache.spark.api.java.JavaRDD;

public class SparkBulkInsertCommitActionExecutor<T extends HoodieRecordPayload<T>>
extends BaseSparkCommitActionExecutor<T> {
    private final JavaRDD<HoodieRecord<T>> inputRecordsRDD;
    private final Option<BulkInsertPartitioner<T>> bulkInsertPartitioner;

    public SparkBulkInsertCommitActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, JavaRDD<HoodieRecord<T>> inputRecordsRDD, Option<BulkInsertPartitioner<T>> bulkInsertPartitioner) {
        this(context, config, table, instantTime, inputRecordsRDD, bulkInsertPartitioner, Option.empty());
    }

    public SparkBulkInsertCommitActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, JavaRDD<HoodieRecord<T>> inputRecordsRDD, Option<BulkInsertPartitioner<T>> bulkInsertPartitioner, Option<Map<String, String>> extraMetadata) {
        super((HoodieEngineContext)context, config, table, instantTime, WriteOperationType.BULK_INSERT, (Option)extraMetadata);
        this.inputRecordsRDD = inputRecordsRDD;
        this.bulkInsertPartitioner = bulkInsertPartitioner;
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> execute() {
        try {
            return SparkBulkInsertHelper.newInstance().bulkInsert(this.inputRecordsRDD, this.instantTime, this.table, this.config, this, true, this.bulkInsertPartitioner);
        }
        catch (HoodieInsertException ie) {
            throw ie;
        }
        catch (Throwable e) {
            throw new HoodieInsertException("Failed to bulk insert for commit time " + this.instantTime, e);
        }
    }
}

