/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;

public abstract class BaseScheduleCompactionActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieCompactionPlan>> {
    private final Option<Map<String, String>> extraMetadata;

    public BaseScheduleCompactionActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime);
        this.extraMetadata = extraMetadata;
    }

    protected abstract HoodieCompactionPlan scheduleCompaction();

    @Override
    public Option<HoodieCompactionPlan> execute() {
        this.table.getActiveTimeline().getCommitsTimeline().filterPendingExcludingCompaction().firstInstant().ifPresent(earliestInflight -> ValidationUtils.checkArgument(HoodieTimeline.compareTimestamps(earliestInflight.getTimestamp(), HoodieTimeline.GREATER_THAN, this.instantTime), "Earliest write inflight instant time must be later than compaction time. Earliest :" + earliestInflight + ", Compaction scheduled at " + this.instantTime));
        List conflictingInstants = this.table.getActiveTimeline().getCommitsAndCompactionTimeline().getInstants().filter(instant -> HoodieTimeline.compareTimestamps(instant.getTimestamp(), HoodieTimeline.GREATER_THAN_OR_EQUALS, this.instantTime)).collect(Collectors.toList());
        ValidationUtils.checkArgument(conflictingInstants.isEmpty(), "Following instants have timestamps >= compactionInstant (" + this.instantTime + ") Instants :" + conflictingInstants);
        HoodieCompactionPlan plan = this.scheduleCompaction();
        if (plan != null && plan.getOperations() != null && !plan.getOperations().isEmpty()) {
            this.extraMetadata.ifPresent(plan::setExtraMetadata);
            HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", this.instantTime);
            try {
                this.table.getActiveTimeline().saveToCompactionRequested(compactionInstant, TimelineMetadataUtils.serializeCompactionPlan(plan));
            }
            catch (IOException ioe) {
                throw new HoodieIOException("Exception scheduling compaction", ioe);
            }
            return Option.of(plan);
        }
        return Option.empty();
    }
}

