/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.util.List;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.AbstractCompactHelpers;
import org.apache.spark.api.java.JavaRDD;

public class SparkCompactHelpers<T extends HoodieRecordPayload>
extends AbstractCompactHelpers<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private SparkCompactHelpers() {
    }

    public static SparkCompactHelpers newInstance() {
        return CompactHelperHolder.SPARK_COMPACT_HELPERS;
    }

    @Override
    public HoodieCommitMetadata createCompactionMetadata(HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, String compactionInstantTime, JavaRDD<WriteStatus> writeStatuses, String schema) throws IOException {
        byte[] planBytes = table.getActiveTimeline().readCompactionPlanAsBytes(HoodieTimeline.getCompactionRequestedInstant(compactionInstantTime)).get();
        HoodieCompactionPlan compactionPlan = TimelineMetadataUtils.deserializeCompactionPlan(planBytes);
        List updateStatusMap = writeStatuses.map(WriteStatus::getStat).collect();
        HoodieCommitMetadata metadata = new HoodieCommitMetadata(true);
        for (HoodieWriteStat stat : updateStatusMap) {
            metadata.addWriteStat(stat.getPartitionPath(), stat);
        }
        metadata.addMetadata("schema", schema);
        if (compactionPlan.getExtraMetadata() != null) {
            compactionPlan.getExtraMetadata().forEach(metadata::addMetadata);
        }
        return metadata;
    }

    private static class CompactHelperHolder {
        private static final SparkCompactHelpers SPARK_COMPACT_HELPERS = new SparkCompactHelpers();

        private CompactHelperHolder() {
        }
    }
}

