/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;

public class DayBasedCompactionStrategy
extends CompactionStrategy {
    protected static final String DATE_PARTITION_FORMAT = "yyyy/MM/dd";
    protected static Comparator<String> comparator = (leftPartition, rightPartition) -> {
        try {
            leftPartition = DayBasedCompactionStrategy.getPartitionPathWithoutPartitionKeys(leftPartition);
            rightPartition = DayBasedCompactionStrategy.getPartitionPathWithoutPartitionKeys(rightPartition);
            Date left = new SimpleDateFormat(DATE_PARTITION_FORMAT, Locale.ENGLISH).parse((String)leftPartition);
            Date right = new SimpleDateFormat(DATE_PARTITION_FORMAT, Locale.ENGLISH).parse((String)rightPartition);
            return left.after(right) ? -1 : (right.after(left) ? 1 : 0);
        }
        catch (ParseException e) {
            throw new HoodieException("Invalid Partition Date Format", e);
        }
    };

    public Comparator<String> getComparator() {
        return comparator;
    }

    @Override
    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        return operations.stream().collect(Collectors.groupingBy(HoodieCompactionOperation::getPartitionPath)).entrySet().stream().sorted(Map.Entry.comparingByKey(comparator)).limit(writeConfig.getTargetPartitionsPerDayBasedCompaction()).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
    }

    @Override
    public List<String> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> allPartitionPaths) {
        return allPartitionPaths.stream().map(partition -> partition.replace("/", "-")).sorted(Comparator.reverseOrder()).map(partitionPath -> partitionPath.replace("-", "/")).collect(Collectors.toList()).subList(0, writeConfig.getTargetPartitionsPerDayBasedCompaction());
    }

    protected static String getPartitionPathWithoutPartitionKeys(String partitionPath) {
        if (partitionPath.contains("=")) {
            return partitionPath.replaceFirst(".*?=", "").replaceAll("/.*?=", "/");
        }
        return partitionPath;
    }
}

